/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.wpf.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TypedListener;

public class Sash
extends Control {
    boolean dragging;
    int startX;
    int startY;
    int lastX;
    int lastY;
    static final int INCREMENT = 1;
    static final int PAGE_INCREMENT = 9;

    public Sash(Composite parent, int style) {
        super(parent, Sash.checkStyle(style));
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int style) {
        return Sash.checkBits(style, 256, 512, 0, 0, 0, 0);
    }

    void createHandle() {
        this.state |= 0x100;
        this.handle = OS.gcnew_Canvas();
        if (this.handle == 0) {
            this.error(2);
        }
        OS.UIElement_Focusable(this.handle, true);
        int newCursor = (this.style & 0x200) != 0 ? OS.Cursors_SizeWE() : OS.Cursors_SizeNS();
        OS.FrameworkElement_Cursor(this.handle, newCursor);
        OS.GCHandle_Free(newCursor);
    }

    int defaultBackground() {
        return OS.SystemColors_ControlColor;
    }

    void HandlePreviewGotKeyboardFocus(int sender, int e) {
        super.HandlePreviewGotKeyboardFocus(sender, e);
        if (!this.checkEvent(e)) {
            return;
        }
        Point location = this.getLocation();
        this.lastX = location.x;
        this.lastY = location.y;
    }

    void HandlePreviewKeyDown(int sender, int e) {
        super.HandlePreviewKeyDown(sender, e);
        if (!this.checkEvent(e)) {
            return;
        }
        int key = OS.KeyEventArgs_Key(e);
        switch (key) {
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                int xChange = 0;
                int yChange = 0;
                int stepSize = 9;
                int keyboardDevice = OS.KeyboardEventArgs_KeyboardDevice(e);
                int modifiers = OS.KeyboardDevice_Modifiers(keyboardDevice);
                OS.GCHandle_Free(keyboardDevice);
                if ((modifiers & 2) != 0) {
                    stepSize = 1;
                }
                if ((this.style & 0x200) != 0) {
                    if (key == 24 || key == 26) break;
                    xChange = key == 23 ? -stepSize : stepSize;
                } else {
                    if (key == 23 || key == 25) break;
                    yChange = key == 24 ? -stepSize : stepSize;
                }
                Rectangle bounds = this.getBounds();
                int width = bounds.width;
                int height = bounds.height;
                Rectangle parentBounds = this.parent.getBounds();
                int parentWidth = parentBounds.width;
                int parentHeight = parentBounds.height;
                int newX = this.lastX;
                int newY = this.lastY;
                if ((this.style & 0x200) != 0) {
                    newX = Math.min(Math.max(0, this.lastX + xChange), parentWidth - width);
                } else {
                    newY = Math.min(Math.max(0, this.lastY + yChange), parentHeight - height);
                }
                if (newX == this.lastX && newY == this.lastY) {
                    return;
                }
                Event event = new Event();
                event.x = newX;
                event.y = newY;
                event.width = width;
                event.height = height;
                this.sendEvent(13, event);
                if (this.isDisposed()) break;
                if (event.doit) {
                    this.setBounds(event.x, event.y, width, height);
                    if (this.isDisposed()) break;
                    this.lastX = event.x;
                    this.lastY = event.y;
                    if (this.isDisposed()) {
                        return;
                    }
                    int cursorX = event.x;
                    int cursorY = event.y;
                    if ((this.style & 0x200) != 0) {
                        cursorY += height / 2;
                    } else {
                        cursorX += width / 2;
                    }
                    this.display.setCursorLocation(this.parent.toDisplay(cursorX, cursorY));
                }
                OS.RoutedEventArgs_Handled(e, true);
            }
        }
    }

    void HandlePreviewMouseDown(int sender, int e) {
        super.HandlePreviewMouseDown(sender, e);
        int eventPos = OS.MouseEventArgs_GetPosition(e, this.handle);
        this.startX = (int)OS.Point_X(eventPos);
        this.startY = (int)OS.Point_Y(eventPos);
        OS.GCHandle_Free(eventPos);
        Point location = this.parent.getLocation(this);
        int x = location.x;
        int y = location.y;
        int width = (int)OS.FrameworkElement_ActualWidth(this.handle);
        int height = (int)OS.FrameworkElement_ActualHeight(this.handle);
        this.lastX = x;
        this.lastY = y;
        Event event = new Event();
        event.x = this.lastX;
        event.y = this.lastY;
        event.width = width;
        event.height = height;
        this.sendEvent(13, event);
        if (event.doit) {
            this.dragging = true;
            this.lastX = event.x;
            this.lastY = event.y;
            OS.UIElement_CaptureMouse(this.handle);
        }
    }

    void HandlePreviewMouseUp(int sender, int e) {
        super.HandlePreviewMouseUp(sender, e);
        if (!this.dragging) {
            return;
        }
        OS.UIElement_ReleaseMouseCapture(this.handle);
        this.dragging = false;
        int width = (int)OS.FrameworkElement_ActualWidth(this.handle);
        int height = (int)OS.FrameworkElement_ActualHeight(this.handle);
        Event event = new Event();
        event.x = this.lastX;
        event.y = this.lastY;
        event.width = width;
        event.height = height;
        this.sendEvent(13, event);
    }

    void HandlePreviewMouseMove(int sender, int e) {
        super.HandlePreviewMouseMove(sender, e);
        if (!this.dragging) {
            return;
        }
        int eventPos = OS.MouseEventArgs_GetPosition(e, this.handle);
        int eventX = (int)OS.Point_X(eventPos);
        int eventY = (int)OS.Point_Y(eventPos);
        OS.GCHandle_Free(eventPos);
        Point location = this.parent.getLocation(this);
        int x = location.x;
        int y = location.y;
        int width = (int)OS.FrameworkElement_ActualWidth(this.handle);
        int height = (int)OS.FrameworkElement_ActualHeight(this.handle);
        int parentWidth = (int)OS.FrameworkElement_ActualWidth(this.parent.handle);
        int parentHeight = (int)OS.FrameworkElement_ActualHeight(this.parent.handle);
        int newX = this.lastX;
        int newY = this.lastY;
        if ((this.style & 0x200) != 0) {
            newX = Math.min(Math.max(0, eventX + x - this.startX), parentWidth - width);
        } else {
            newY = Math.min(Math.max(0, eventY + y - this.startY), parentHeight - height);
        }
        if (newX == this.lastX && newY == this.lastY) {
            return;
        }
        Event event = new Event();
        event.x = newX;
        event.y = newY;
        event.width = width;
        event.height = height;
        this.sendEvent(13, event);
        if (this.isDisposed()) {
            return;
        }
        if (event.doit) {
            this.lastX = event.x;
            this.lastY = event.y;
        }
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    int traversalCode(int key, int event) {
        return 0;
    }
}

