/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.wpf.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.CoolItem;

public class CoolBar
extends Composite {
    Control[] children;
    CoolItem[] items;
    int parentingHandle;
    int itemCount;
    int childCount;
    static boolean IsVertical;

    public CoolBar(Composite parent, int style) {
        super(parent, CoolBar.checkStyle(style));
        this.style = (style & 0x200) != 0 ? (this.style |= 0x200) : (this.style |= 0x100);
    }

    static int checkStyle(int style) {
        IsVertical = ((style |= 0x80000) & 0x200) != 0;
        return style & 0xFFFFFCFF;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    void addChild(Control widget) {
        super.addChild(widget);
        if (this.childCount == this.children.length) {
            Control[] newChildren = new Control[this.childCount + 4];
            System.arraycopy(this.children, 0, newChildren, 0, this.childCount);
            this.children = newChildren;
        }
        this.children[this.childCount++] = widget;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        return this.computeSize(this.handle, wHint, hHint, changed);
    }

    void createHandle() {
        this.parentingHandle = OS.gcnew_Canvas();
        if (this.parentingHandle == 0) {
            this.error(2);
        }
        this.handle = OS.gcnew_ToolBarTray();
        if (this.handle == 0) {
            this.error(2);
        }
        int children = OS.Panel_Children(this.parentingHandle);
        OS.UIElementCollection_Add(children, this.handle);
        OS.GCHandle_Free(children);
        if (IsVertical) {
            OS.ToolBarTray_Orientation(this.handle, 1);
        }
    }

    void createItem(CoolItem item, int index) {
        if (index < 0 || index > this.itemCount) {
            this.error(6);
        }
        item.createWidget();
        int toolbars = OS.ToolBarTray_ToolBars(this.handle);
        int itemHandle = item.topHandle();
        OS.IList_Insert(toolbars, index, item.topHandle());
        int count = OS.ICollection_Count(toolbars);
        if (this.itemCount == count) {
            this.error(14);
        }
        int band = 0;
        int bandIndex = 0;
        if (index != this.itemCount) {
            band = OS.ToolBar_Band(this.items[index].topHandle());
            bandIndex = OS.ToolBar_BandIndex(this.items[index].topHandle());
            int i = 0;
            while (i < count) {
                int current = OS.IList_default(toolbars, i);
                int currentBand = OS.ToolBar_Band(current);
                int currentIndex = OS.ToolBar_BandIndex(current);
                if (currentBand == band && currentIndex >= bandIndex) {
                    OS.ToolBar_BandIndex(current, currentIndex + 1);
                }
                OS.GCHandle_Free(current);
                ++i;
            }
        } else if (this.itemCount > 0) {
            int[] log2vis = this.logicalToVisualIndices();
            int lastItem = this.items[log2vis[this.itemCount - 1]].topHandle();
            band = OS.ToolBar_Band(lastItem);
            bandIndex = OS.ToolBar_BandIndex(lastItem) + 1;
        }
        OS.ToolBar_Band(itemHandle, band);
        OS.ToolBar_BandIndex(itemHandle, bandIndex);
        OS.GCHandle_Free(toolbars);
        if (this.itemCount == this.items.length) {
            CoolItem[] newItems = new CoolItem[this.items.length + 4];
            System.arraycopy(this.items, 0, newItems, 0, this.items.length);
            this.items = newItems;
        }
        System.arraycopy(this.items, index, this.items, index + 1, this.itemCount - index);
        this.items[index] = item;
        ++this.itemCount;
    }

    void createWidget() {
        super.createWidget();
        this.items = new CoolItem[4];
        this.children = new Control[4];
    }

    int defaultBackground() {
        return OS.Colors_Transparent;
    }

    void deregister() {
        super.deregister();
        this.display.removeWidget(this.parentingHandle);
    }

    void destroyItem(CoolItem item) {
        int toolbars = OS.ToolBarTray_ToolBars(this.handle);
        int itemHandle = item.topHandle();
        int band = OS.ToolBar_Band(itemHandle);
        int bandIndex = OS.ToolBar_BandIndex(itemHandle);
        OS.IList_Remove(toolbars, itemHandle);
        int count = OS.ICollection_Count(toolbars);
        if (this.itemCount == count) {
            this.error(15);
        }
        --this.itemCount;
        int i = 0;
        while (i < this.itemCount) {
            int current = OS.IList_default(toolbars, i);
            int currentBand = OS.ToolBar_Band(current);
            int currentIndex = OS.ToolBar_BandIndex(current);
            if (currentBand == band && currentIndex >= bandIndex) {
                OS.ToolBar_BandIndex(current, currentIndex - 1);
            }
            OS.GCHandle_Free(current);
            ++i;
        }
        OS.GCHandle_Free(toolbars);
        int index = 0;
        while (index < this.items.length) {
            if (this.items[index] == item) break;
            ++index;
        }
        System.arraycopy(this.items, index + 1, this.items, index, this.itemCount - index);
        this.items[this.itemCount] = null;
    }

    Control[] _getChildren() {
        Control[] result = new Control[this.childCount];
        int i = 0;
        while (i < this.childCount) {
            result[this.childCount - i - 1] = this.children[i];
            ++i;
        }
        return result;
    }

    int[] logicalToVisualIndices() {
        int[] bandLengths = new int[4];
        int i = 0;
        while (i < this.itemCount) {
            int topHandle = this.items[i].topHandle();
            int band = OS.ToolBar_Band(topHandle);
            int bandIndex = OS.ToolBar_BandIndex(topHandle);
            if (band >= bandLengths.length) {
                int[] newLengths = new int[band + 4];
                System.arraycopy(bandLengths, 0, newLengths, 0, bandLengths.length);
                bandLengths = newLengths;
            }
            if (bandIndex + 1 > bandLengths[band]) {
                bandLengths[band] = bandIndex + 1;
            }
            ++i;
        }
        int[] result = new int[this.itemCount];
        int i2 = 0;
        while (i2 < this.itemCount) {
            int bandIndex;
            int topHandle = this.items[i2].topHandle();
            int band = OS.ToolBar_Band(topHandle);
            int index = bandIndex = OS.ToolBar_BandIndex(topHandle);
            int j = 0;
            while (j < band) {
                index += bandLengths[j];
                ++j;
            }
            result[index] = i2++;
        }
        return result;
    }

    public CoolItem getItem(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.itemCount) {
            this.error(6);
        }
        int[] log2vis = this.logicalToVisualIndices();
        return this.items[log2vis[index]];
    }

    public int getItemCount() {
        this.checkWidget();
        return this.itemCount;
    }

    public int[] getItemOrder() {
        this.checkWidget();
        return this.logicalToVisualIndices();
    }

    public CoolItem[] getItems() {
        this.checkWidget();
        CoolItem[] result = new CoolItem[this.itemCount];
        int[] log2vis = this.logicalToVisualIndices();
        int i = 0;
        while (i < this.itemCount) {
            result[i] = this.items[log2vis[i]];
            ++i;
        }
        return result;
    }

    public Point[] getItemSizes() {
        this.checkWidget();
        int[] log2vis = this.logicalToVisualIndices();
        Point[] result = new Point[this.itemCount];
        int i = 0;
        while (i < this.itemCount) {
            result[i] = this.items[log2vis[i]].getSize();
            ++i;
        }
        return result;
    }

    Point getLocation(Control child) {
        int topHandle = child.topHandle();
        int point = OS.gcnew_Point(0.0, 0.0);
        if (point == 0) {
            this.error(2);
        }
        int location = OS.UIElement_TranslatePoint(topHandle, point, this.handle);
        int x = (int)OS.Point_X(location);
        int y = (int)OS.Point_Y(location);
        OS.GCHandle_Free(point);
        OS.GCHandle_Free(location);
        return new Point(x, y);
    }

    public boolean getLocked() {
        this.checkWidget();
        return OS.ToolBarTray_IsLocked(this.handle);
    }

    public int[] getWrapIndices() {
        this.checkWidget();
        int bands = 1;
        int[] bandLengths = new int[4];
        int i = 0;
        while (i < this.itemCount) {
            int topHandle = this.items[i].topHandle();
            int band = OS.ToolBar_Band(topHandle);
            int bandIndex = OS.ToolBar_BandIndex(topHandle);
            if (band >= bandLengths.length) {
                int[] newLengths = new int[band + 4];
                System.arraycopy(bandLengths, 0, newLengths, 0, bandLengths.length);
                bandLengths = newLengths;
            }
            if (band != 0 && bandLengths[band] == 0) {
                ++bands;
            }
            if (bandIndex + 1 > bandLengths[band]) {
                bandLengths[band] = bandIndex + 1;
            }
            ++i;
        }
        if (bands == 1) {
            return new int[0];
        }
        int[] result = new int[bands - 1];
        int sum = 0;
        int i2 = 0;
        while (i2 < result.length) {
            result[i2] = sum += bandLengths[i2];
            ++i2;
        }
        return result;
    }

    void HandleSizeChanged(int sender, int e) {
        this.postEvent(11);
    }

    void hookEvents() {
        super.hookEvents();
        int handler = OS.gcnew_SizeChangedEventHandler(this.jniRef, "HandleSizeChanged");
        OS.FrameworkElement_SizeChanged(this.handle, handler);
        OS.GCHandle_Free(handler);
    }

    public int indexOf(CoolItem item) {
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        if (item.isDisposed()) {
            this.error(5);
        }
        int i = 0;
        while (i < this.itemCount) {
            if (item.equals(this.items[i])) {
                int[] log2vis = this.logicalToVisualIndices();
                return log2vis[i];
            }
            ++i;
        }
        return -1;
    }

    int parentingHandle() {
        return this.parentingHandle;
    }

    void register() {
        super.register();
        this.display.addWidget(this.parentingHandle, this);
    }

    void releaseChildren(boolean destroy) {
        int i = 0;
        while (i < this.itemCount) {
            CoolItem item = this.items[i];
            if (item != null && !item.isDisposed()) {
                item.release(false);
            }
            ++i;
        }
        super.releaseChildren(destroy);
    }

    void releaseHandle() {
        super.releaseHandle();
        if (this.parentingHandle != 0) {
            OS.GCHandle_Free(this.parentingHandle);
        }
        this.parentingHandle = 0;
    }

    void removeChild(Control control) {
        super.removeChild(control);
        int index = 0;
        while (index < this.childCount) {
            if (this.children[index] == control) break;
            ++index;
        }
        if (index == this.childCount) {
            return;
        }
        System.arraycopy(this.children, index + 1, this.children, index, --this.childCount - index);
        this.children[this.childCount] = null;
    }

    void removeControl(Control control) {
        super.removeControl(control);
        int i = 0;
        while (i < this.itemCount) {
            CoolItem item = this.items[i];
            if (item.control == control) {
                item.setControl(null);
                break;
            }
            ++i;
        }
    }

    int setBounds(int x, int y, int width, int height, int flags) {
        int result = super.setBounds(x, y, width, height, flags);
        if ((result & 0x4000) != 0) {
            if ((this.style & 0x200) != 0) {
                OS.FrameworkElement_Height(this.handle, height);
            } else {
                OS.FrameworkElement_Width(this.handle, width);
            }
        }
        return result;
    }

    public void setItemLayout(int[] itemOrder, int[] wrapIndices, Point[] sizes) {
        this.checkWidget();
        this.setItemOrder(itemOrder);
        this.setWrapIndices(wrapIndices);
        this.setItemSizes(sizes);
    }

    void setItemOrder(int[] itemOrder) {
        this.checkWidget();
        if (itemOrder == null) {
            this.error(4);
        }
        if (itemOrder.length != this.itemCount) {
            this.error(5);
        }
        boolean[] set = new boolean[this.itemCount];
        int i = 0;
        while (i < itemOrder.length) {
            int index = itemOrder[i];
            if (index < 0 || index >= this.itemCount) {
                this.error(6);
            }
            if (set[index]) {
                this.error(5);
            }
            set[index] = true;
            ++i;
        }
        i = 0;
        while (i < this.itemCount) {
            CoolItem item = this.items[itemOrder[i]];
            int itemHandle = item.topHandle();
            OS.ToolBar_Band(itemHandle, 0);
            OS.ToolBar_BandIndex(itemHandle, i);
            ++i;
        }
    }

    void setItemSizes(Point[] sizes) {
        if (sizes == null) {
            this.error(4);
        }
        if (sizes.length != this.itemCount) {
            this.error(5);
        }
        int[] log2vis = this.logicalToVisualIndices();
        int i = 0;
        while (i < this.itemCount) {
            this.items[log2vis[i]].setSize(sizes[i].x, sizes[i].y);
            ++i;
        }
    }

    public void setLocked(boolean locked) {
        this.checkWidget();
        OS.ToolBarTray_IsLocked(this.handle, locked);
    }

    public void setWrapIndices(int[] indices) {
        this.checkWidget();
        if (indices == null) {
            indices = new int[]{};
        }
        int count = this.getItemCount();
        int i = 0;
        while (i < indices.length) {
            if (indices[i] < 0 || indices[i] >= count) {
                this.error(6);
            }
            ++i;
        }
        this.sortAscending(indices);
        int[] log2vis = this.logicalToVisualIndices();
        int band = 0;
        int bandIndex = 0;
        int wrapIndex = 0;
        int i2 = 0;
        while (i2 < this.itemCount) {
            int wrap;
            int n = wrap = indices.length > wrapIndex ? indices[wrapIndex] : this.itemCount;
            if (i2 == wrap) {
                if (wrap != 0) {
                    ++band;
                    bandIndex = 0;
                }
                ++wrapIndex;
            }
            int topHandle = this.items[log2vis[i2]].topHandle();
            OS.ToolBar_Band(topHandle, band);
            OS.ToolBar_BandIndex(topHandle, bandIndex);
            ++bandIndex;
            ++i2;
        }
    }

    int topHandle() {
        return this.parentingHandle;
    }
}

