/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.wpf.OS;
import org.eclipse.swt.widgets.Display;

public class Clipboard {
    private Display display;
    static /* synthetic */ Class class$0;

    public Clipboard(Display display) {
        this.checkSubclass();
        if (display == null && (display = Display.getCurrent()) == null) {
            display = Display.getDefault();
        }
        if (display.getThread() != Thread.currentThread()) {
            DND.error(22);
        }
        this.display = display;
    }

    protected void checkSubclass() {
        String validName;
        String name = this.getClass().getName();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.dnd.Clipboard");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!(validName = clazz.getName()).equals(name)) {
            DND.error(43);
        }
    }

    protected void checkWidget() {
        Display display = this.display;
        if (display == null) {
            DND.error(24);
        }
        if (display.getThread() != Thread.currentThread()) {
            DND.error(22);
        }
        if (display.isDisposed()) {
            DND.error(24);
        }
    }

    public void clearContents() {
        this.clearContents(1);
    }

    public void clearContents(int clipboards) {
        this.checkWidget();
        if ((clipboards & 1) != 0) {
            OS.Clipboard_Clear();
        }
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        if (this.display.getThread() != Thread.currentThread()) {
            DND.error(22);
        }
        this.display = null;
    }

    public String[] getAvailableTypeNames() {
        this.checkWidget();
        int pDataObject = OS.Clipboard_GetDataObject();
        int pFormats = OS.DataObject_GetFormats(pDataObject, true);
        int length = OS.Array_GetLength(pFormats, 0);
        String[] result = new String[length];
        int i = 0;
        while (i < length) {
            int pFormat = OS.Array_GetValue(pFormats, i);
            result[i] = Transfer.createJavaString(pFormat);
            OS.GCHandle_Free(pFormat);
            ++i;
        }
        OS.GCHandle_Free(pDataObject);
        OS.GCHandle_Free(pFormats);
        return result;
    }

    public TransferData[] getAvailableTypes() {
        return this.getAvailableTypes(1);
    }

    public TransferData[] getAvailableTypes(int clipboards) {
        this.checkWidget();
        if ((clipboards & 1) == 0) {
            return new TransferData[0];
        }
        String[] typeNames = this.getAvailableTypeNames();
        int length = typeNames.length;
        TransferData[] result = new TransferData[length];
        int i = 0;
        while (i < length) {
            int type = Transfer.registerType(typeNames[i]);
            TransferData transferData = new TransferData();
            transferData.type = type;
            result[i++] = transferData;
            ++i;
        }
        return result;
    }

    public Object getContents(Transfer transfer) {
        return this.getContents(transfer, 1);
    }

    public Object getContents(Transfer transfer, int clipboards) {
        this.checkWidget();
        if (transfer == null) {
            DND.error(4);
        }
        int[] types = transfer.getTypeIds();
        int i = 0;
        while (i < types.length) {
            int pValue = this.getData(types[i]);
            if (pValue != 0) {
                TransferData data = new TransferData();
                data.type = types[i];
                data.pValue = pValue;
                Object result = transfer.nativeToJava(data);
                OS.GCHandle_Free(pValue);
                return result;
            }
            ++i;
        }
        return null;
    }

    int getData(int type) {
        int pFormat = Transfer.getWPFFormat(type);
        int result = 0;
        if (OS.Clipboard_ContainsData(pFormat)) {
            result = OS.Clipboard_GetData(pFormat);
        }
        OS.GCHandle_Free(pFormat);
        return result;
    }

    public boolean isDisposed() {
        return this.display == null;
    }

    public void setContents(Object[] data, Transfer[] dataTypes) {
        this.setContents(data, dataTypes, 1);
    }

    public void setContents(Object[] data, Transfer[] dataTypes, int clipboards) {
        this.checkWidget();
        if (data == null || dataTypes == null || data.length != dataTypes.length) {
            DND.error(5);
        }
        int pDataObject = OS.gcnew_DataObject();
        int i = 0;
        while (i < dataTypes.length) {
            Transfer transfer = dataTypes[i];
            Object value = data[i];
            int[] types = transfer.getTypeIds();
            int j = 0;
            while (j < types.length) {
                TransferData transferData = new TransferData();
                transferData.type = types[j];
                transfer.javaToNative(value, transferData);
                if (transferData.pValue != 0) {
                    int pFormat = Transfer.getWPFFormat(transferData.type);
                    OS.DataObject_SetData(pDataObject, pFormat, transferData.pValue, true);
                    OS.GCHandle_Free(pFormat);
                    OS.GCHandle_Free(transferData.pValue);
                }
                ++j;
            }
            ++i;
        }
        OS.Clipboard_SetDataObject(pDataObject, false);
        OS.GCHandle_Free(pDataObject);
    }
}

