/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.DeviceData;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.motif.OS;
import org.eclipse.swt.internal.motif.XColor;

public abstract class Device
implements Drawable {
    public int xDisplay;
    public boolean setDPI;
    public static boolean DEBUG;
    boolean debug = DEBUG;
    boolean tracking = DEBUG;
    Error[] errors;
    Object[] objects;
    Object trackingLock;
    String display_name;
    String application_name;
    String application_class;
    XColor[] xcolors;
    int[] colorRefCount;
    Color COLOR_BLACK;
    Color COLOR_DARK_RED;
    Color COLOR_DARK_GREEN;
    Color COLOR_DARK_YELLOW;
    Color COLOR_DARK_BLUE;
    Color COLOR_DARK_MAGENTA;
    Color COLOR_DARK_CYAN;
    Color COLOR_GRAY;
    Color COLOR_DARK_GRAY;
    Color COLOR_RED;
    Color COLOR_GREEN;
    Color COLOR_YELLOW;
    Color COLOR_BLUE;
    Color COLOR_MAGENTA;
    Color COLOR_CYAN;
    Color COLOR_WHITE;
    Font systemFont;
    int shellHandle;
    boolean useXRender;
    static boolean CAIRO_LOADED;
    int tabPointer;
    int crPointer;
    public int tabMapping;
    public int crMapping;
    boolean warnings = true;
    Callback xtWarningCallback;
    Callback xtErrorCallback;
    int xtWarningProc;
    int xtErrorProc;
    int xtNullWarningProc;
    int xtNullErrorProc;
    static Callback XErrorCallback;
    static Callback XIOErrorCallback;
    static int XErrorProc;
    static int XIOErrorProc;
    static int XNullErrorProc;
    static int XNullIOErrorProc;
    static Device[] Devices;
    protected static Device CurrentDevice;
    protected static Runnable DeviceFinder;
    static /* synthetic */ Class class$0;

    static {
        Devices = new Device[4];
        OS.XtToolkitInitialize();
        try {
            Class.forName("org.eclipse.swt.widgets.Display");
        }
        catch (ClassNotFoundException classNotFoundException) {}
    }

    static synchronized Device getDevice() {
        if (DeviceFinder != null) {
            DeviceFinder.run();
        }
        Device device = CurrentDevice;
        CurrentDevice = null;
        return device;
    }

    public Device() {
        this(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Device(DeviceData data) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.graphics.Device");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (data != null) {
                this.display_name = data.display_name;
                this.application_name = data.application_name;
                this.application_class = data.application_class;
                this.tracking = data.tracking;
                this.debug = data.debug;
            }
            if (this.tracking) {
                this.errors = new Error[128];
                this.objects = new Object[128];
                this.trackingLock = new Object();
            }
            this.create(data);
            this.init();
            Device.register(this);
            this.systemFont = this.getSystemFont();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    void checkCairo() {
        if (CAIRO_LOADED) {
            return;
        }
        try {
            byte[] buffer = Converter.wcsToMbcs(null, "libcairo.so.2", true);
            int libcairo = OS.dlopen(buffer, 1);
            if (libcairo != 0) {
                OS.dlclose(libcairo);
            } else {
                try {
                    System.loadLibrary("cairo-swt");
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {}
            }
            Class.forName("org.eclipse.swt.internal.cairo.Cairo");
            CAIRO_LOADED = true;
        }
        catch (Throwable t) {
            SWT.error(16, t, " [Cairo required]");
        }
    }

    protected void checkDevice() {
        if (this.xDisplay == 0) {
            SWT.error(45);
        }
    }

    protected void create(DeviceData data) {
    }

    static synchronized void deregister(Device device) {
        int i = 0;
        while (i < Devices.length) {
            if (device == Devices[i]) {
                Device.Devices[i] = null;
            }
            ++i;
        }
    }

    protected void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.graphics.Device");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (this.isDisposed()) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            this.checkDevice();
            this.release();
            this.destroy();
            Device.deregister(this);
            this.xDisplay = 0;
            if (this.tracking) {
                Object object = this.trackingLock;
                synchronized (object) {
                    this.objects = null;
                    this.errors = null;
                    this.trackingLock = null;
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dispose_Object(Object object) {
        Object object2 = this.trackingLock;
        synchronized (object2) {
            int i = 0;
            while (i < this.objects.length) {
                if (this.objects[i] == object) {
                    this.objects[i] = null;
                    this.errors[i] = null;
                    return;
                }
                ++i;
            }
        }
    }

    static synchronized Device findDevice(int xDisplay) {
        int i = 0;
        while (i < Devices.length) {
            Device device = Devices[i];
            if (device != null && device.xDisplay == xDisplay) {
                return device;
            }
            ++i;
        }
        return null;
    }

    public Rectangle getBounds() {
        this.checkDevice();
        int screen = OS.XDefaultScreen(this.xDisplay);
        int width = OS.XDisplayWidth(this.xDisplay, screen);
        int height = OS.XDisplayHeight(this.xDisplay, screen);
        return new Rectangle(0, 0, width, height);
    }

    public Rectangle getClientArea() {
        return this.getBounds();
    }

    public int getDepth() {
        this.checkDevice();
        int xScreenPtr = OS.XDefaultScreenOfDisplay(this.xDisplay);
        return OS.XDefaultDepthOfScreen(xScreenPtr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeviceData getDeviceData() {
        this.checkDevice();
        DeviceData data = new DeviceData();
        data.display_name = this.display_name;
        data.application_name = this.application_name;
        data.application_class = this.application_class;
        data.debug = this.debug;
        data.tracking = this.tracking;
        if (this.tracking) {
            Object object = this.trackingLock;
            synchronized (object) {
                int count = 0;
                int length = this.objects.length;
                int i = 0;
                while (i < length) {
                    if (this.objects[i] != null) {
                        ++count;
                    }
                    ++i;
                }
                int index = 0;
                data.objects = new Object[count];
                data.errors = new Error[count];
                int i2 = 0;
                while (i2 < length) {
                    if (this.objects[i2] != null) {
                        data.objects[index] = this.objects[i2];
                        data.errors[index] = this.errors[i2];
                        ++index;
                    }
                    ++i2;
                }
            }
        } else {
            data.objects = new Object[0];
            data.errors = new Error[0];
        }
        return data;
    }

    public Point getDPI() {
        this.checkDevice();
        int xScreenNum = OS.XDefaultScreen(this.xDisplay);
        int width = OS.XDisplayWidth(this.xDisplay, xScreenNum);
        int height = OS.XDisplayHeight(this.xDisplay, xScreenNum);
        int mmX = OS.XDisplayWidthMM(this.xDisplay, xScreenNum);
        int mmY = OS.XDisplayHeightMM(this.xDisplay, xScreenNum);
        double inchesX = (double)mmX * 0.03937;
        double inchesY = (double)mmY * 0.03937;
        int x = (int)((double)width / inchesX + 0.5);
        int y = (int)((double)height / inchesY + 0.5);
        return new Point(x, y);
    }

    public FontData[] getFontList(String faceName, boolean scalable) {
        int listPtr;
        int dashIndex;
        this.checkDevice();
        String xlfd = faceName == null ? "-*-*-*-*-*-*-*-*-*-*-*-*-*-*" : ((dashIndex = faceName.indexOf(45)) < 0 ? "-*-" + faceName + "-*-*-*-*-*-*-*-*-*-*-*-*" : "-" + faceName + "-*-*-*-*-*-*-*-*-*-*-*-*");
        byte[] buffer1 = Converter.wcsToMbcs(null, xlfd, true);
        int[] ret = new int[1];
        int ptr = listPtr = OS.XListFonts(this.xDisplay, buffer1, 65535, ret);
        int[] intBuf = new int[1];
        FontData[] fd = new FontData[ret[0]];
        int fdIndex = 0;
        int i = 0;
        while (i < ret[0]) {
            OS.memmove(intBuf, ptr, 4);
            int charPtr = intBuf[0];
            int length = OS.strlen(charPtr);
            byte[] buffer2 = new byte[length];
            OS.memmove(buffer2, charPtr, length);
            char[] chars = Converter.mbcsToWcs(null, buffer2);
            try {
                boolean isScalable;
                FontData data = FontData.motif_new(new String(chars));
                boolean bl = isScalable = data.averageWidth == 0 && data.pixels == 0 && data.points == 0;
                if (isScalable == scalable) {
                    fd[fdIndex++] = data;
                }
            }
            catch (Exception exception) {}
            ptr += 4;
            ++i;
        }
        OS.XFreeFontNames(listPtr);
        if (fdIndex == ret[0]) {
            return fd;
        }
        FontData[] result = new FontData[fdIndex];
        System.arraycopy(fd, 0, result, 0, fdIndex);
        return result;
    }

    public Color getSystemColor(int id) {
        this.checkDevice();
        switch (id) {
            case 2: {
                return this.COLOR_BLACK;
            }
            case 4: {
                return this.COLOR_DARK_RED;
            }
            case 6: {
                return this.COLOR_DARK_GREEN;
            }
            case 8: {
                return this.COLOR_DARK_YELLOW;
            }
            case 10: {
                return this.COLOR_DARK_BLUE;
            }
            case 12: {
                return this.COLOR_DARK_MAGENTA;
            }
            case 14: {
                return this.COLOR_DARK_CYAN;
            }
            case 15: {
                return this.COLOR_GRAY;
            }
            case 16: {
                return this.COLOR_DARK_GRAY;
            }
            case 3: {
                return this.COLOR_RED;
            }
            case 5: {
                return this.COLOR_GREEN;
            }
            case 7: {
                return this.COLOR_YELLOW;
            }
            case 9: {
                return this.COLOR_BLUE;
            }
            case 11: {
                return this.COLOR_MAGENTA;
            }
            case 13: {
                return this.COLOR_CYAN;
            }
            case 1: {
                return this.COLOR_WHITE;
            }
        }
        return this.COLOR_BLACK;
    }

    public Font getSystemFont() {
        this.checkDevice();
        return this.systemFont;
    }

    public boolean getWarnings() {
        this.checkDevice();
        return this._getWarnings();
    }

    boolean _getWarnings() {
        return this.warnings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void init() {
        Class<?> clazz;
        Object minor_versionp;
        int[] error_basep;
        int[] event_basep;
        if (this.debug) {
            OS.XSynchronize(this.xDisplay, true);
        }
        if (OS.XRenderQueryExtension(this.xDisplay, event_basep = new int[1], error_basep = new int[1])) {
            int[] major_versionp = new int[1];
            minor_versionp = new int[1];
            OS.XRenderQueryVersion(this.xDisplay, major_versionp, minor_versionp);
            this.useXRender = major_versionp[0] > 0 || major_versionp[0] == 0 && minor_versionp[0] >= 8;
        }
        Class<?> clazz2 = clazz = this.getClass();
        minor_versionp = clazz2;
        synchronized (clazz2) {
            if (XErrorCallback == null) {
                XErrorCallback = new Callback(clazz, "XErrorProc", 2);
                XNullErrorProc = XErrorCallback.getAddress();
                if (XNullErrorProc == 0) {
                    SWT.error(3);
                }
                XErrorProc = OS.XSetErrorHandler(XNullErrorProc);
            }
            if (XIOErrorCallback == null) {
                XIOErrorCallback = new Callback(clazz, "XIOErrorProc", 1);
                XNullIOErrorProc = XIOErrorCallback.getAddress();
                if (XNullIOErrorProc == 0) {
                    SWT.error(3);
                }
                XIOErrorProc = OS.XSetIOErrorHandler(XNullIOErrorProc);
            }
            // ** MonitorExit[minor_versionp /* !! */ ] (shouldn't be in output)
            this.xtWarningCallback = new Callback(this, "xtWarningProc", 1);
            this.xtNullWarningProc = this.xtWarningCallback.getAddress();
            if (this.xtNullWarningProc == 0) {
                SWT.error(3);
            }
            this.xtErrorCallback = new Callback(this, "xtErrorProc", 1);
            this.xtNullErrorProc = this.xtErrorCallback.getAddress();
            if (this.xtNullErrorProc == 0) {
                SWT.error(3);
            }
            int xtContext = OS.XtDisplayToApplicationContext(this.xDisplay);
            this.xtWarningProc = OS.XtAppSetWarningHandler(xtContext, this.xtNullWarningProc);
            this.xtErrorProc = OS.XtAppSetErrorHandler(xtContext, this.xtNullErrorProc);
            int xScreenPtr = OS.XDefaultScreenOfDisplay(this.xDisplay);
            int defaultDepth = OS.XDefaultDepthOfScreen(xScreenPtr);
            if (defaultDepth <= 8) {
                int numColors = 1 << defaultDepth;
                this.colorRefCount = new int[numColors];
                this.xcolors = new XColor[numColors];
            }
            this.COLOR_BLACK = new Color(this, 0, 0, 0);
            this.COLOR_DARK_RED = new Color(this, 128, 0, 0);
            this.COLOR_DARK_GREEN = new Color(this, 0, 128, 0);
            this.COLOR_DARK_YELLOW = new Color(this, 128, 128, 0);
            this.COLOR_DARK_BLUE = new Color(this, 0, 0, 128);
            this.COLOR_DARK_MAGENTA = new Color(this, 128, 0, 128);
            this.COLOR_DARK_CYAN = new Color(this, 0, 128, 128);
            this.COLOR_GRAY = new Color(this, 192, 192, 192);
            this.COLOR_DARK_GRAY = new Color(this, 128, 128, 128);
            this.COLOR_RED = new Color(this, 255, 0, 0);
            this.COLOR_GREEN = new Color(this, 0, 255, 0);
            this.COLOR_YELLOW = new Color(this, 255, 255, 0);
            this.COLOR_BLUE = new Color(this, 0, 0, 255);
            this.COLOR_MAGENTA = new Color(this, 255, 0, 255);
            this.COLOR_CYAN = new Color(this, 0, 255, 255);
            this.COLOR_WHITE = new Color(this, 255, 255, 255);
            int widgetClass = OS.topLevelShellWidgetClass();
            this.shellHandle = OS.XtAppCreateShell(null, null, widgetClass, this.xDisplay, null, 0);
            if (this.shellHandle == 0) {
                SWT.error(2);
            }
            byte[] byArray = new byte[2];
            byArray[0] = 9;
            byte[] tabBuffer = byArray;
            this.tabPointer = OS.XtMalloc(tabBuffer.length);
            OS.memmove(this.tabPointer, tabBuffer, tabBuffer.length);
            int tabString = OS.XmStringComponentCreate(12, 0, null);
            int[] argList = new int[]{OS.XmNpattern, this.tabPointer, OS.XmNsubstitute, tabString};
            this.tabMapping = OS.XmParseMappingCreate(argList, argList.length / 2);
            OS.XmStringFree(tabString);
            byte[] byArray2 = new byte[2];
            byArray2[0] = 10;
            byte[] crBuffer = byArray2;
            this.crPointer = OS.XtMalloc(crBuffer.length);
            OS.memmove(this.crPointer, crBuffer, crBuffer.length);
            int crString = OS.XmStringComponentCreate(4, 0, null);
            argList = new int[]{OS.XmNpattern, this.crPointer, OS.XmNsubstitute, crString};
            this.crMapping = OS.XmParseMappingCreate(argList, argList.length / 2);
            OS.XmStringFree(crString);
            return;
        }
    }

    public abstract int internal_new_GC(GCData var1);

    public abstract void internal_dispose_GC(int var1, GCData var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDisposed() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.graphics.Device");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.xDisplay == 0;
        }
    }

    public boolean loadFont(String path) {
        this.checkDevice();
        if (path == null) {
            SWT.error(4);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void new_Object(Object object) {
        Object object2 = this.trackingLock;
        synchronized (object2) {
            int i = 0;
            while (i < this.objects.length) {
                if (this.objects[i] == null) {
                    this.objects[i] = object;
                    this.errors[i] = new Error();
                    return;
                }
                ++i;
            }
            Object[] newObjects = new Object[this.objects.length + 128];
            System.arraycopy(this.objects, 0, newObjects, 0, this.objects.length);
            newObjects[this.objects.length] = object;
            this.objects = newObjects;
            Error[] newErrors = new Error[this.errors.length + 128];
            System.arraycopy(this.errors, 0, newErrors, 0, this.errors.length);
            newErrors[this.errors.length] = new Error();
            this.errors = newErrors;
        }
    }

    static synchronized void register(Device device) {
        int i = 0;
        while (i < Devices.length) {
            if (Devices[i] == null) {
                Device.Devices[i] = device;
                return;
            }
            ++i;
        }
        Device[] newDevices = new Device[Devices.length + 4];
        System.arraycopy(Devices, 0, newDevices, 0, Devices.length);
        newDevices[Device.Devices.length] = device;
        Devices = newDevices;
    }

    protected void release() {
        OS.XtFree(this.tabPointer);
        OS.XtFree(this.crPointer);
        OS.XmParseMappingFree(this.tabMapping);
        OS.XmParseMappingFree(this.crMapping);
        this.crMapping = 0;
        this.tabMapping = 0;
        this.crPointer = 0;
        this.tabPointer = 0;
        if (this.shellHandle != 0) {
            OS.XtDestroyWidget(this.shellHandle);
        }
        this.shellHandle = 0;
        if (this.xcolors != null) {
            int xScreen = OS.XDefaultScreen(this.xDisplay);
            int xColormap = OS.XDefaultColormap(this.xDisplay, xScreen);
            int[] pixel = new int[1];
            int i = 0;
            while (i < this.xcolors.length) {
                XColor color = this.xcolors[i];
                if (color != null) {
                    pixel[0] = color.pixel;
                    while (this.colorRefCount[i] > 0) {
                        OS.XFreeColors(this.xDisplay, xColormap, pixel, 1, 0);
                        int n = i;
                        this.colorRefCount[n] = this.colorRefCount[n] - 1;
                    }
                }
                ++i;
            }
        }
        this.xcolors = null;
        this.colorRefCount = null;
        if (this.COLOR_BLACK != null) {
            this.COLOR_BLACK.dispose();
        }
        if (this.COLOR_DARK_RED != null) {
            this.COLOR_DARK_RED.dispose();
        }
        if (this.COLOR_DARK_GREEN != null) {
            this.COLOR_DARK_GREEN.dispose();
        }
        if (this.COLOR_DARK_YELLOW != null) {
            this.COLOR_DARK_YELLOW.dispose();
        }
        if (this.COLOR_DARK_BLUE != null) {
            this.COLOR_DARK_BLUE.dispose();
        }
        if (this.COLOR_DARK_MAGENTA != null) {
            this.COLOR_DARK_MAGENTA.dispose();
        }
        if (this.COLOR_DARK_CYAN != null) {
            this.COLOR_DARK_CYAN.dispose();
        }
        if (this.COLOR_GRAY != null) {
            this.COLOR_GRAY.dispose();
        }
        if (this.COLOR_DARK_GRAY != null) {
            this.COLOR_DARK_GRAY.dispose();
        }
        if (this.COLOR_RED != null) {
            this.COLOR_RED.dispose();
        }
        if (this.COLOR_GREEN != null) {
            this.COLOR_GREEN.dispose();
        }
        if (this.COLOR_YELLOW != null) {
            this.COLOR_YELLOW.dispose();
        }
        if (this.COLOR_BLUE != null) {
            this.COLOR_BLUE.dispose();
        }
        if (this.COLOR_MAGENTA != null) {
            this.COLOR_MAGENTA.dispose();
        }
        if (this.COLOR_CYAN != null) {
            this.COLOR_CYAN.dispose();
        }
        if (this.COLOR_WHITE != null) {
            this.COLOR_WHITE.dispose();
        }
        this.COLOR_WHITE = null;
        this.COLOR_CYAN = null;
        this.COLOR_MAGENTA = null;
        this.COLOR_BLUE = null;
        this.COLOR_YELLOW = null;
        this.COLOR_GREEN = null;
        this.COLOR_RED = null;
        this.COLOR_DARK_GRAY = null;
        this.COLOR_GRAY = null;
        this.COLOR_DARK_CYAN = null;
        this.COLOR_DARK_MAGENTA = null;
        this.COLOR_DARK_BLUE = null;
        this.COLOR_DARK_YELLOW = null;
        this.COLOR_DARK_GREEN = null;
        this.COLOR_DARK_RED = null;
        this.COLOR_BLACK = null;
        int xtContext = OS.XtDisplayToApplicationContext(this.xDisplay);
        OS.XtAppSetErrorHandler(xtContext, this.xtErrorProc);
        this.xtErrorCallback.dispose();
        this.xtErrorCallback = null;
        this.xtErrorProc = 0;
        this.xtNullErrorProc = 0;
        OS.XtAppSetWarningHandler(xtContext, this.xtWarningProc);
        this.xtWarningCallback.dispose();
        this.xtWarningCallback = null;
        this.xtWarningProc = 0;
        this.xtNullWarningProc = 0;
        int count = 0;
        int i = 0;
        while (i < Devices.length) {
            if (Devices[i] != null) {
                ++count;
            }
            ++i;
        }
        if (count == 1) {
            OS.XSetIOErrorHandler(XIOErrorProc);
            XIOErrorCallback.dispose();
            XIOErrorCallback = null;
            XIOErrorProc = 0;
            XNullIOErrorProc = 0;
            this.warnings = false;
        }
    }

    public void setWarnings(boolean warnings) {
        this.checkDevice();
        this._setWarnings(warnings);
    }

    void _setWarnings(boolean warnings) {
        this.warnings = warnings;
    }

    static int XErrorProc(int xDisplay, int xErrorEvent) {
        Device device = Device.findDevice(xDisplay);
        if (device != null) {
            if (device.warnings) {
                if (DEBUG || device.debug) {
                    new SWTError().printStackTrace();
                }
                OS.Call(XErrorProc, xDisplay, xErrorEvent);
            }
        } else {
            if (DEBUG) {
                new SWTError().printStackTrace();
            }
            OS.Call(XErrorProc, xDisplay, xErrorEvent);
        }
        return 0;
    }

    static int XIOErrorProc(int xDisplay) {
        Device device = Device.findDevice(xDisplay);
        if (device != null) {
            if (DEBUG || device.debug) {
                new SWTError().printStackTrace();
            }
        } else if (DEBUG) {
            new SWTError().printStackTrace();
        }
        OS.Call(XIOErrorProc, xDisplay, 0);
        return 0;
    }

    int xtErrorProc(int message) {
        if (DEBUG || this.debug) {
            new SWTError().printStackTrace();
        }
        OS.Call(this.xtErrorProc, message, 0);
        return 0;
    }

    int xtWarningProc(int message) {
        if (this.warnings) {
            if (DEBUG || this.debug) {
                new SWTError().printStackTrace();
            }
            OS.Call(this.xtWarningProc, message, 0);
        }
        return 0;
    }
}

