/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.apt.core.internal.declaration;

import com.sun.mirror.declaration.MethodDeclaration;
import com.sun.mirror.declaration.ParameterDeclaration;
import com.sun.mirror.type.TypeMirror;
import com.sun.mirror.util.DeclarationVisitor;
import org.eclipse.jdt.apt.core.internal.declaration.EclipseMirrorObject;
import org.eclipse.jdt.apt.core.internal.declaration.EclipseMirrorType;
import org.eclipse.jdt.apt.core.internal.declaration.ExecutableDeclarationImpl;
import org.eclipse.jdt.apt.core.internal.env.BaseProcessorEnv;
import org.eclipse.jdt.apt.core.internal.util.Factory;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;

public class MethodDeclarationImpl
extends ExecutableDeclarationImpl
implements MethodDeclaration {
    public MethodDeclarationImpl(IMethodBinding binding, BaseProcessorEnv env) {
        super(binding, env);
        assert (!binding.isConstructor()) : "binding does not represent a method.";
    }

    public TypeMirror getReturnType() {
        IMethodBinding methodBinding = this.getDeclarationBinding();
        ITypeBinding retType = methodBinding.getReturnType();
        EclipseMirrorType type = Factory.createTypeMirror(retType, this._env);
        if (type == null) {
            return Factory.createErrorClassType(retType);
        }
        return type;
    }

    public void accept(DeclarationVisitor visitor) {
        visitor.visitMethodDeclaration(this);
    }

    public EclipseMirrorObject.MirrorKind kind() {
        return EclipseMirrorObject.MirrorKind.METHOD;
    }

    public String toString() {
        int i;
        StringBuilder buffer = new StringBuilder();
        IMethodBinding methodBinding = this.getDeclarationBinding();
        ITypeBinding[] typeParams = methodBinding.getTypeParameters();
        if (typeParams != null && typeParams.length > 0) {
            buffer.append('<');
            i = 0;
            while (i < typeParams.length) {
                if (i != 0) {
                    buffer.append(", ");
                }
                buffer.append(typeParams[i]);
                ++i;
            }
            buffer.append('>');
        }
        if (methodBinding.getReturnType() != null) {
            buffer.append(methodBinding.getReturnType().getName());
        }
        buffer.append(' ');
        buffer.append(methodBinding.getName());
        buffer.append('(');
        i = 0;
        for (ParameterDeclaration param : this.getParameters()) {
            if (i++ != 0) {
                buffer.append(", ");
            }
            buffer.append(param);
        }
        buffer.append(')');
        return buffer.toString();
    }
}

