/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import java.io.InputStream;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.carbon.CGRect;
import org.eclipse.swt.internal.carbon.OS;

public final class Image
extends Resource
implements Drawable {
    public int type;
    public int handle;
    public int data;
    int transparentPixel = -1;
    GC memGC;
    byte[] alphaData;
    int alpha = -1;
    int width = -1;
    int height = -1;
    static final int DEFAULT_SCANLINE_PAD = 4;

    Image(Device device) {
        super(device);
    }

    public Image(Device device, int width, int height) {
        super(device);
        this.init(width, height);
        this.init();
    }

    public Image(Device device, Image srcImage, int flag) {
        super(device);
        int provider;
        if (srcImage == null) {
            SWT.error(4);
        }
        if (srcImage.isDisposed()) {
            SWT.error(5);
        }
        switch (flag) {
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        device = this.device;
        this.type = srcImage.type;
        int width = OS.CGImageGetWidth(srcImage.handle);
        int height = OS.CGImageGetHeight(srcImage.handle);
        int bpr = OS.CGImageGetBytesPerRow(srcImage.handle);
        int bpc = OS.CGImageGetBitsPerComponent(srcImage.handle);
        int bpp = OS.CGImageGetBitsPerPixel(srcImage.handle);
        int colorspace = OS.CGImageGetColorSpace(srcImage.handle);
        int alphaInfo = 6;
        alphaInfo = OS.CGImageGetAlphaInfo(srcImage.handle);
        this.transparentPixel = srcImage.transparentPixel;
        this.alpha = srcImage.alpha;
        if (srcImage.alphaData != null) {
            this.alphaData = new byte[srcImage.alphaData.length];
            System.arraycopy(srcImage.alphaData, 0, this.alphaData, 0, this.alphaData.length);
        }
        int dataSize = height * bpr;
        this.data = OS.NewPtr(dataSize);
        if (this.data == 0) {
            SWT.error(2);
        }
        if ((provider = OS.CGDataProviderCreateWithData(0, this.data, dataSize, device.releaseProc)) == 0) {
            OS.DisposePtr(this.data);
            SWT.error(2);
        }
        this.handle = OS.CGImageCreate(width, height, bpc, bpp, bpr, colorspace, alphaInfo, provider, null, true, 0);
        OS.CGDataProviderRelease(provider);
        if (this.handle == 0) {
            OS.DisposePtr(this.data);
            SWT.error(2);
        }
        OS.memmove(this.data, srcImage.data, dataSize);
        if (flag != 0) {
            switch (flag) {
                case 1: {
                    Color zeroColor = device.getSystemColor(18);
                    RGB zeroRGB = zeroColor.getRGB();
                    byte zeroRed = (byte)zeroRGB.red;
                    byte zeroGreen = (byte)zeroRGB.green;
                    byte zeroBlue = (byte)zeroRGB.blue;
                    Color oneColor = device.getSystemColor(22);
                    RGB oneRGB = oneColor.getRGB();
                    byte oneRed = (byte)oneRGB.red;
                    byte oneGreen = (byte)oneRGB.green;
                    byte oneBlue = (byte)oneRGB.blue;
                    byte[] line = new byte[bpr];
                    int y = 0;
                    while (y < height) {
                        OS.memmove(line, this.data + y * bpr, bpr);
                        int offset = 0;
                        int x = 0;
                        while (x < width) {
                            int red = line[offset + 1] & 0xFF;
                            int green = line[offset + 2] & 0xFF;
                            int blue = line[offset + 3] & 0xFF;
                            int intensity = red * red + green * green + blue * blue;
                            if (intensity < 98304) {
                                line[offset + 1] = zeroRed;
                                line[offset + 2] = zeroGreen;
                                line[offset + 3] = zeroBlue;
                            } else {
                                line[offset + 1] = oneRed;
                                line[offset + 2] = oneGreen;
                                line[offset + 3] = oneBlue;
                            }
                            offset += 4;
                            ++x;
                        }
                        OS.memmove(this.data + y * bpr, line, bpr);
                        ++y;
                    }
                    break;
                }
                case 2: {
                    byte[] line = new byte[bpr];
                    int y = 0;
                    while (y < height) {
                        OS.memmove(line, this.data + y * bpr, bpr);
                        int offset = 0;
                        int x = 0;
                        while (x < width) {
                            byte intensity;
                            int red = line[offset + 1] & 0xFF;
                            int green = line[offset + 2] & 0xFF;
                            int blue = line[offset + 3] & 0xFF;
                            byte by = intensity = (byte)(red + red + green + green + green + green + green + blue >> 3);
                            line[offset + 3] = by;
                            line[offset + 2] = by;
                            line[offset + 1] = by;
                            offset += 4;
                            ++x;
                        }
                        OS.memmove(this.data + y * bpr, line, bpr);
                        ++y;
                    }
                    break;
                }
            }
        }
        this.init();
    }

    public Image(Device device, Rectangle bounds) {
        super(device);
        if (bounds == null) {
            SWT.error(4);
        }
        this.init(bounds.width, bounds.height);
        this.init();
    }

    public Image(Device device, ImageData data) {
        super(device);
        this.init(data);
        this.init();
    }

    public Image(Device device, ImageData source, ImageData mask) {
        super(device);
        if (source == null) {
            SWT.error(4);
        }
        if (mask == null) {
            SWT.error(4);
        }
        if (source.width != mask.width || source.height != mask.height) {
            SWT.error(5);
        }
        mask = ImageData.convertMask(mask);
        ImageData image = new ImageData(source.width, source.height, source.depth, source.palette, source.scanlinePad, source.data);
        image.maskPad = mask.scanlinePad;
        image.maskData = mask.data;
        this.init(image);
        this.init();
    }

    public Image(Device device, InputStream stream) {
        super(device);
        this.init(new ImageData(stream));
        this.init();
    }

    public Image(Device device, String filename) {
        super(device);
        this.init(new ImageData(filename));
        this.init();
    }

    void createAlpha() {
        if (this.transparentPixel == -1 && this.alpha == -1 && this.alphaData == null) {
            return;
        }
        int height = OS.CGImageGetHeight(this.handle);
        int bpr = OS.CGImageGetBytesPerRow(this.handle);
        int dataSize = height * bpr;
        byte[] srcData = new byte[dataSize];
        OS.memmove(srcData, this.data, dataSize);
        if (this.transparentPixel != -1) {
            int i = 0;
            while (i < dataSize) {
                int pixel = (srcData[i + 1] & 0xFF) << 16 | (srcData[i + 2] & 0xFF) << 8 | srcData[i + 3] & 0xFF;
                srcData[i] = (byte)(pixel == this.transparentPixel ? 0 : 255);
                i += 4;
            }
        } else if (this.alpha != -1) {
            byte a = (byte)this.alpha;
            int i = 0;
            while (i < dataSize) {
                srcData[i] = a;
                i += 4;
            }
        } else {
            int width = OS.CGImageGetWidth(this.handle);
            int offset = 0;
            int alphaOffset = 0;
            int y = 0;
            while (y < height) {
                int x = 0;
                while (x < width) {
                    srcData[offset] = this.alphaData[alphaOffset];
                    offset += 4;
                    ++alphaOffset;
                    ++x;
                }
                ++y;
            }
        }
        OS.memmove(this.data, srcData, dataSize);
    }

    void destroy() {
        if (this.memGC != null) {
            this.memGC.dispose();
        }
        OS.CGImageRelease(this.handle);
        this.handle = 0;
        this.data = 0;
        this.memGC = null;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Image)) {
            return false;
        }
        Image image = (Image)object;
        return this.device == image.device && this.handle == image.handle && this.transparentPixel == image.transparentPixel;
    }

    public Color getBackground() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (this.transparentPixel == -1) {
            return null;
        }
        int red = this.transparentPixel >> 16 & 0xFF;
        int green = this.transparentPixel >> 8 & 0xFF;
        int blue = this.transparentPixel >> 0 & 0xFF;
        return Color.carbon_new(this.device, new float[]{(float)red / 255.0f, (float)green / 255.0f, (float)blue / 255.0f, 1.0f});
    }

    public Rectangle getBounds() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (this.width != -1 && this.height != -1) {
            return new Rectangle(0, 0, this.width, this.height);
        }
        this.width = OS.CGImageGetWidth(this.handle);
        this.height = OS.CGImageGetHeight(this.handle);
        return new Rectangle(0, 0, this.width, this.height);
    }

    public ImageData getImageData() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        int width = OS.CGImageGetWidth(this.handle);
        int height = OS.CGImageGetHeight(this.handle);
        int bpr = OS.CGImageGetBytesPerRow(this.handle);
        int bpp = OS.CGImageGetBitsPerPixel(this.handle);
        int dataSize = height * bpr;
        byte[] srcData = new byte[dataSize];
        OS.memmove(srcData, this.data, dataSize);
        PaletteData palette = new PaletteData(0xFF0000, 65280, 255);
        ImageData data = new ImageData(width, height, bpp, palette, 4, srcData);
        data.bytesPerLine = bpr;
        data.transparentPixel = this.transparentPixel;
        if (this.transparentPixel == -1 && this.type == 1) {
            int maskPad = 2;
            int maskBpl = ((width + 7) / 8 + (maskPad - 1)) / maskPad * maskPad;
            byte[] maskData = new byte[height * maskBpl];
            int offset = 0;
            int maskOffset = 0;
            int y = 0;
            while (y < height) {
                int x = 0;
                while (x < width) {
                    if (srcData[offset] != 0) {
                        int n = maskOffset + (x >> 3);
                        maskData[n] = (byte)(maskData[n] | 1 << 7 - (x & 7));
                    } else {
                        int n = maskOffset + (x >> 3);
                        maskData[n] = (byte)(maskData[n] & ~(1 << 7 - (x & 7)));
                    }
                    offset += 4;
                    ++x;
                }
                maskOffset += maskBpl;
                ++y;
            }
            data.maskData = maskData;
            data.maskPad = maskPad;
        }
        int i = 0;
        while (i < srcData.length) {
            srcData[i] = 0;
            i += 4;
        }
        data.alpha = this.alpha;
        if (this.alpha == -1 && this.alphaData != null) {
            data.alphaData = new byte[this.alphaData.length];
            System.arraycopy(this.alphaData, 0, data.alphaData, 0, this.alphaData.length);
        }
        return data;
    }

    public static Image carbon_new(Device device, int type, int handle, int data) {
        Image image = new Image(device);
        image.type = type;
        image.handle = handle;
        image.data = data;
        return image;
    }

    public int hashCode() {
        return this.handle;
    }

    void init(int width, int height) {
        int bpc;
        int context;
        int provider;
        if (width <= 0 || height <= 0) {
            SWT.error(5);
        }
        this.type = 0;
        int bpr = width * 4;
        int dataSize = height * bpr;
        this.data = OS.NewPtr(dataSize);
        if (this.data == 0) {
            SWT.error(2);
        }
        if ((provider = OS.CGDataProviderCreateWithData(0, this.data, dataSize, this.device.releaseProc)) == 0) {
            OS.DisposePtr(this.data);
            SWT.error(2);
        }
        int colorspace = this.device.colorspace;
        this.handle = OS.CGImageCreate(width, height, 8, 32, bpr, colorspace, 6, provider, null, true, 0);
        OS.CGDataProviderRelease(provider);
        if (this.handle == 0) {
            OS.DisposePtr(this.data);
            SWT.error(2);
        }
        if ((context = OS.CGBitmapContextCreate(this.data, width, height, bpc = OS.CGImageGetBitsPerComponent(this.handle), bpr, colorspace, 6)) == 0) {
            OS.CGImageRelease(this.handle);
            OS.DisposePtr(this.data);
            SWT.error(2);
        }
        CGRect rect = new CGRect();
        rect.width = width;
        rect.height = height;
        OS.CGContextSetRGBFillColor(context, 1.0f, 1.0f, 1.0f, 1.0f);
        OS.CGContextFillRect(context, rect);
        OS.CGContextRelease(context);
    }

    void init(ImageData image) {
        int provider;
        if (image == null) {
            SWT.error(4);
        }
        int width = image.width;
        int height = image.height;
        PaletteData palette = image.palette;
        if ((image.depth != 1 && image.depth != 2 && image.depth != 4 && image.depth != 8 || palette.isDirect) && image.depth != 8 && (image.depth != 16 && image.depth != 24 && image.depth != 32 || !palette.isDirect)) {
            SWT.error(38);
        }
        int dataSize = width * height * 4;
        this.data = OS.NewPtr(dataSize);
        if (this.data == 0) {
            SWT.error(2);
        }
        if ((provider = OS.CGDataProviderCreateWithData(0, this.data, dataSize, this.device.releaseProc)) == 0) {
            OS.DisposePtr(this.data);
            SWT.error(2);
        }
        int colorspace = this.device.colorspace;
        int transparency = image.getTransparencyType();
        int alphaInfo = transparency == 0 && image.alpha == -1 ? 6 : 4;
        this.handle = OS.CGImageCreate(width, height, 8, 32, width * 4, colorspace, alphaInfo, provider, null, true, 0);
        OS.CGDataProviderRelease(provider);
        if (this.handle == 0) {
            OS.DisposePtr(this.data);
            SWT.error(2);
        }
        int bpr = width * 4;
        byte[] buffer = new byte[dataSize];
        if (palette.isDirect) {
            ImageData.blit(1, image.data, image.depth, image.bytesPerLine, image.getByteOrder(), 0, 0, width, height, palette.redMask, palette.greenMask, palette.blueMask, 255, null, 0, 0, 0, buffer, 32, bpr, 1, 0, 0, width, height, 0xFF0000, 65280, 255, false, false);
        } else {
            RGB[] rgbs = palette.getRGBs();
            int length = rgbs.length;
            byte[] srcReds = new byte[length];
            byte[] srcGreens = new byte[length];
            byte[] srcBlues = new byte[length];
            int i = 0;
            while (i < rgbs.length) {
                RGB rgb = rgbs[i];
                if (rgb != null) {
                    srcReds[i] = (byte)rgb.red;
                    srcGreens[i] = (byte)rgb.green;
                    srcBlues[i] = (byte)rgb.blue;
                }
                ++i;
            }
            ImageData.blit(1, image.data, image.depth, image.bytesPerLine, image.getByteOrder(), 0, 0, width, height, srcReds, srcGreens, srcBlues, 255, null, 0, 0, 0, buffer, 32, bpr, 1, 0, 0, width, height, 0xFF0000, 65280, 255, false, false);
        }
        if (transparency == 2 || image.transparentPixel != -1) {
            int n = this.type = image.transparentPixel != -1 ? 0 : 1;
            if (image.transparentPixel != -1) {
                int transRed = 0;
                int transGreen = 0;
                int transBlue = 0;
                if (palette.isDirect) {
                    RGB rgb = palette.getRGB(image.transparentPixel);
                    transRed = rgb.red;
                    transGreen = rgb.green;
                    transBlue = rgb.blue;
                } else {
                    RGB[] rgbs = palette.getRGBs();
                    if (image.transparentPixel < rgbs.length) {
                        RGB rgb = rgbs[image.transparentPixel];
                        transRed = rgb.red;
                        transGreen = rgb.green;
                        transBlue = rgb.blue;
                    }
                }
                this.transparentPixel = transRed << 16 | transGreen << 8 | transBlue;
            }
            ImageData maskImage = image.getTransparencyMask();
            byte[] maskData = maskImage.data;
            int maskBpl = maskImage.bytesPerLine;
            int offset = 0;
            int maskOffset = 0;
            int y = 0;
            while (y < height) {
                int x = 0;
                while (x < width) {
                    buffer[offset] = (maskData[maskOffset + (x >> 3)] & 1 << 7 - (x & 7)) != 0 ? -1 : 0;
                    offset += 4;
                    ++x;
                }
                maskOffset += maskBpl;
                ++y;
            }
        } else {
            this.type = 0;
            if (image.alpha != -1) {
                this.alpha = image.alpha;
                byte a = (byte)this.alpha;
                int dataIndex = 0;
                while (dataIndex < buffer.length) {
                    buffer[dataIndex] = a;
                    dataIndex += 4;
                }
            } else if (image.alphaData != null) {
                this.alphaData = new byte[image.alphaData.length];
                System.arraycopy(image.alphaData, 0, this.alphaData, 0, this.alphaData.length);
                int offset = 0;
                int alphaOffset = 0;
                int y = 0;
                while (y < height) {
                    int x = 0;
                    while (x < width) {
                        buffer[offset] = this.alphaData[alphaOffset];
                        offset += 4;
                        ++alphaOffset;
                        ++x;
                    }
                    ++y;
                }
            }
        }
        OS.memmove(this.data, buffer, dataSize);
    }

    public int internal_new_GC(GCData data) {
        int colorspace;
        int bpr;
        int bpc;
        int height;
        int width;
        int context;
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.type != 0 || this.memGC != null) {
            SWT.error(5);
        }
        if ((context = OS.CGBitmapContextCreate(this.data, width = OS.CGImageGetWidth(this.handle), height = OS.CGImageGetHeight(this.handle), bpc = OS.CGImageGetBitsPerComponent(this.handle), bpr = OS.CGImageGetBytesPerRow(this.handle), colorspace = OS.CGImageGetColorSpace(this.handle), 6)) == 0) {
            SWT.error(2);
        }
        OS.CGContextScaleCTM(context, 1.0f, -1.0f);
        OS.CGContextTranslateCTM(context, 0.0f, -height);
        if (data != null) {
            int mask = 0x6000000;
            if ((data.style & mask) == 0) {
                data.style |= 0x2000000;
            }
            data.device = this.device;
            data.background = this.device.COLOR_WHITE.handle;
            data.foreground = this.device.COLOR_BLACK.handle;
            data.font = this.device.systemFont;
            data.image = this;
        }
        return context;
    }

    public void internal_dispose_GC(int context, GCData data) {
        OS.CGContextRelease(context);
    }

    public boolean isDisposed() {
        return this.handle == 0;
    }

    public void setBackground(Color color) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (color == null) {
            SWT.error(4);
        }
        if (color.isDisposed()) {
            SWT.error(5);
        }
        if (this.transparentPixel == -1) {
            return;
        }
        byte red = (byte)(this.transparentPixel >> 16 & 0xFF);
        byte green = (byte)(this.transparentPixel >> 8 & 0xFF);
        byte blue = (byte)(this.transparentPixel >> 0 & 0xFF);
        byte newRed = (byte)((int)(color.handle[0] * 255.0f) & 0xFF);
        byte newGreen = (byte)((int)(color.handle[1] * 255.0f) & 0xFF);
        byte newBlue = (byte)((int)(color.handle[2] * 255.0f) & 0xFF);
        int height = OS.CGImageGetHeight(this.handle);
        int bpl = OS.CGImageGetBytesPerRow(this.handle);
        byte[] line = new byte[bpl];
        int i = 0;
        int offset = 0;
        while (i < height) {
            OS.memmove(line, this.data + offset, bpl);
            int j = 0;
            while (j < line.length) {
                if (line[j + 1] == red && line[j + 2] == green && line[j + 3] == blue) {
                    line[j + 1] = newRed;
                    line[j + 2] = newGreen;
                    line[j + 3] = newBlue;
                }
                j += 4;
            }
            OS.memmove(this.data + offset, line, bpl);
            ++i;
            offset += bpl;
        }
        this.transparentPixel = (newRed & 0xFF) << 16 | (newGreen & 0xFF) << 8 | newBlue & 0xFF;
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Image {*DISPOSED*}";
        }
        return "Image {" + this.handle + "}";
    }
}

