/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.internal.photon.OS;
import org.eclipse.swt.internal.photon.PgAlpha_t;
import org.eclipse.swt.internal.photon.PhArea_t;
import org.eclipse.swt.internal.photon.PhCursorInfo_t;
import org.eclipse.swt.internal.photon.PhEvent_t;
import org.eclipse.swt.internal.photon.PhImage_t;
import org.eclipse.swt.internal.photon.PhKeyEvent_t;
import org.eclipse.swt.internal.photon.PhPoint_t;
import org.eclipse.swt.internal.photon.PhPointerEvent_t;
import org.eclipse.swt.internal.photon.PhRect_t;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.EventTable;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.WidgetTable;

public abstract class Widget {
    public int handle;
    int style;
    int state;
    Display display;
    EventTable eventTable;
    Object data;
    static final int DISPOSED = 1;
    static final int CANVAS = 2;
    static final int KEYED_DATA = 4;
    static final int HANDLE = 8;
    static final int DISABLED = 16;
    static final int MOVED = 32;
    static final int RESIZED = 64;
    static final int GRAB = 128;
    static final int LAYOUT_NEEDED = 256;
    static final int LAYOUT_CHANGED = 512;
    static final int LAYOUT_CHILD = 1024;
    static final int RELEASED = 2048;
    static final int DISPOSE_SENT = 4096;
    static final int DEFAULT_WIDTH = 64;
    static final int DEFAULT_HEIGHT = 64;

    Widget() {
    }

    public Widget(Widget parent, int style) {
        this.checkSubclass();
        this.checkParent(parent);
        this.style = style;
        this.display = parent.display;
    }

    static int checkBits(int style, int int0, int int1, int int2, int int3, int int4, int int5) {
        int mask = int0 | int1 | int2 | int3 | int4 | int5;
        if ((style & mask) == 0) {
            style |= int0;
        }
        if ((style & int0) != 0) {
            style = style & ~mask | int0;
        }
        if ((style & int1) != 0) {
            style = style & ~mask | int1;
        }
        if ((style & int2) != 0) {
            style = style & ~mask | int2;
        }
        if ((style & int3) != 0) {
            style = style & ~mask | int3;
        }
        if ((style & int4) != 0) {
            style = style & ~mask | int4;
        }
        if ((style & int5) != 0) {
            style = style & ~mask | int5;
        }
        return style;
    }

    void checkOrientation(Widget parent) {
        this.style &= 0xF7FFFFFF;
        if ((this.style & 0x6000000) == 0 && parent != null) {
            if ((parent.style & 0x2000000) != 0) {
                this.style |= 0x2000000;
            }
            if ((parent.style & 0x4000000) != 0) {
                this.style |= 0x4000000;
            }
        }
        this.style = Widget.checkBits(this.style, 0x2000000, 0x4000000, 0, 0, 0, 0);
    }

    void checkParent(Widget parent) {
        if (parent == null) {
            Widget.error(4);
        }
        if (parent.isDisposed()) {
            Widget.error(5);
        }
        parent.checkWidget();
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            Widget.error(43);
        }
    }

    protected void checkWidget() {
        Display display = this.display;
        if (display == null) {
            Widget.error(24);
        }
        if (display.thread != Thread.currentThread()) {
            Widget.error(22);
        }
        if ((this.state & 1) != 0) {
            Widget.error(24);
        }
    }

    int copyPhImage(int image) {
        int ptr;
        if (image == 0) {
            return 0;
        }
        int newImage = OS.PiDuplicateImage(image, 0);
        PhImage_t phImage = new PhImage_t();
        OS.memmove(phImage, image, 56);
        PhImage_t newPhImage = new PhImage_t();
        OS.memmove(newPhImage, newImage, 56);
        if (newPhImage.mask_bm != 0 && phImage.mask_bm == newPhImage.mask_bm) {
            int length = newPhImage.mask_bpl * newPhImage.size_h;
            ptr = OS.malloc(length);
            OS.memmove(ptr, newPhImage.mask_bm, length);
            newPhImage.mask_bm = ptr;
        }
        if (newPhImage.alpha != 0 && phImage.alpha == newPhImage.alpha) {
            PgAlpha_t alpha = new PgAlpha_t();
            OS.memmove(alpha, phImage.alpha, 104);
            if (alpha.src_alpha_map_map != 0) {
                int length = alpha.src_alpha_map_bpl * alpha.src_alpha_map_dim_h;
                int ptr2 = OS.malloc(length);
                OS.memmove(ptr2, alpha.src_alpha_map_map, length);
                alpha.src_alpha_map_map = ptr2;
            }
            ptr = OS.malloc(104);
            OS.memmove(ptr, alpha, 104);
            newPhImage.alpha = ptr;
        }
        OS.memmove(newImage, newPhImage, 56);
        return newImage;
    }

    public void addListener(int eventType, Listener handler) {
        this.checkWidget();
        if (handler == null) {
            Widget.error(4);
        }
        if (this.eventTable == null) {
            this.eventTable = new EventTable();
        }
        this.eventTable.hook(eventType, handler);
    }

    public void addDisposeListener(DisposeListener listener) {
        this.checkWidget();
        if (listener == null) {
            Widget.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(12, typedListener);
    }

    void click(int widget) {
        int rid = OS.PtWidgetRid(widget);
        if (rid == 0) {
            return;
        }
        PhEvent_t event = new PhEvent_t();
        event.emitter_rid = rid;
        event.emitter_handle = widget;
        event.collector_rid = rid;
        event.collector_handle = widget;
        event.flags = (short)16;
        event.processing_flags = 1;
        event.type = 2;
        event.num_rects = 1;
        PhPointerEvent_t pe = new PhPointerEvent_t();
        pe.click_count = 1;
        pe.buttons = (short)4;
        PhRect_t rect = new PhRect_t();
        int ptr = OS.malloc(68);
        OS.memmove(ptr, event, 40);
        OS.memmove(ptr + 40, rect, 8);
        OS.memmove(ptr + 40 + 8, pe, 20);
        OS.PtSendEventToWidget(widget, ptr);
        OS.PtFlush();
        event.type = 4;
        event.subtype = 0;
        OS.memmove(ptr, event, 40);
        OS.memmove(ptr + 40, rect, 8);
        OS.memmove(ptr + 40 + 8, pe, 20);
        OS.PtSendEventToWidget(widget, ptr);
        OS.free(ptr);
    }

    void createHandle(int index) {
    }

    int createToolTip(String string, int handle, byte[] font) {
        if (string == null || string.length() == 0 || handle == 0) {
            return 0;
        }
        int shellHandle = OS.PtFindDisjoint(handle);
        byte[] buffer = Converter.wcsToMbcs(null, string, true);
        int fill = this.display.INFO_BACKGROUND;
        int text_color = this.display.INFO_FOREGROUND;
        int toolTipHandle = OS.PtInflateBalloon(shellHandle, handle, 0, buffer, font, fill, text_color);
        int ig = OS.PhInputGroup(0);
        PhCursorInfo_t info = new PhCursorInfo_t();
        OS.PhQueryCursor((short)ig, info);
        short[] absX = new short[1];
        short[] absY = new short[1];
        OS.PtGetAbsPosition(shellHandle, absX, absY);
        int x = info.pos_x - absX[0] + 16;
        int y = info.pos_y - absY[0] + 16;
        PhArea_t shellArea = new PhArea_t();
        OS.PtWidgetArea(shellHandle, shellArea);
        PhArea_t toolTipArea = new PhArea_t();
        OS.PtWidgetArea(toolTipHandle, toolTipArea);
        x = Math.max(0, Math.min(x, shellArea.size_w - toolTipArea.size_w));
        y = Math.max(0, Math.min(y, shellArea.size_h - toolTipArea.size_h));
        PhPoint_t pt = new PhPoint_t();
        pt.x = (short)x;
        pt.y = (short)y;
        int ptr = OS.malloc(4);
        OS.memmove(ptr, pt, 4);
        OS.PtSetResource(toolTipHandle, 1007, ptr, 0);
        OS.free(ptr);
        return toolTipHandle;
    }

    void createWidget(int index) {
        this.createHandle(index);
        this.hookEvents();
        this.register();
    }

    void deregister() {
        if (this.handle == 0) {
            return;
        }
        WidgetTable.remove(this.handle);
    }

    void destroyToolTip(int toolTipHandle) {
        if (toolTipHandle != 0) {
            OS.PtDestroyWidget(toolTipHandle);
        }
    }

    void destroyWidget() {
        int topHandle = this.topHandle();
        this.releaseHandle();
        if (topHandle != 0) {
            OS.PtDestroyWidget(topHandle);
        }
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        if (!this.isValidThread()) {
            Widget.error(22);
        }
        this.release(true);
    }

    int drawProc(int widget, int damage) {
        return 0;
    }

    static void error(int code) {
        SWT.error(code);
    }

    boolean filters(int eventType) {
        return this.display.filters(eventType);
    }

    char fixMnemonic(char[] buffer) {
        int i = 0;
        int j = 0;
        char mnemonic = '\u0000';
        while (i < buffer.length) {
            if ((buffer[j++] = buffer[i++]) != '&' || i == buffer.length) continue;
            if (buffer[i] == '&') {
                ++i;
                continue;
            }
            if (mnemonic == '\u0000') {
                mnemonic = buffer[i];
            }
            --j;
        }
        while (j < buffer.length) {
            buffer[j++] = '\u0000';
        }
        return mnemonic;
    }

    public Object getData() {
        this.checkWidget();
        return (this.state & 4) != 0 ? ((Object[])this.data)[0] : this.data;
    }

    public Object getData(String key) {
        this.checkWidget();
        if (key == null) {
            Widget.error(4);
        }
        if ((this.state & 4) != 0) {
            Object[] table = (Object[])this.data;
            int i = 1;
            while (i < table.length) {
                if (key.equals(table[i])) {
                    return table[i + 1];
                }
                i += 2;
            }
        }
        return null;
    }

    public Display getDisplay() {
        Display display = this.display;
        if (display == null) {
            Widget.error(24);
        }
        return display;
    }

    public Listener[] getListeners(int eventType) {
        this.checkWidget();
        if (this.eventTable == null) {
            return new Listener[0];
        }
        return this.eventTable.getListeners(eventType);
    }

    String getName() {
        String string = this.getClass().getName();
        int index = string.length();
        while (--index > 0 && string.charAt(index) != '.') {
        }
        return string.substring(index + 1, string.length());
    }

    String getNameText() {
        return "";
    }

    public int getStyle() {
        this.checkWidget();
        return this.style;
    }

    boolean hooks(int eventType) {
        if (this.eventTable == null) {
            return false;
        }
        return this.eventTable.hooks(eventType);
    }

    int hotkeyProc(int widget, int data, int info) {
        return 0;
    }

    void hookEvents() {
    }

    public boolean isDisposed() {
        if (this.handle != 0) {
            return false;
        }
        if ((this.state & 8) != 0) {
            return true;
        }
        return (this.state & 1) != 0;
    }

    boolean isValidSubclass() {
        return Display.isValidClass(this.getClass());
    }

    public boolean isListening(int eventType) {
        this.checkWidget();
        return this.hooks(eventType);
    }

    boolean isValidThread() {
        return this.getDisplay().isValidThread();
    }

    public void notifyListeners(int eventType, Event event) {
        this.checkWidget();
        if (event == null) {
            event = new Event();
        }
        this.sendEvent(eventType, event);
    }

    void postEvent(int eventType) {
        this.sendEvent(eventType, null, false);
    }

    void postEvent(int eventType, Event event) {
        this.sendEvent(eventType, event, false);
    }

    int Ph_EV_BOUNDARY(int widget, int info) {
        return 0;
    }

    int Ph_EV_BUT_PRESS(int widget, int info) {
        return 0;
    }

    int Ph_EV_BUT_RELEASE(int widget, int info) {
        return 0;
    }

    int Ph_EV_DRAG(int widget, int info) {
        return 0;
    }

    int Ph_EV_KEY(int widget, int info) {
        return 0;
    }

    int Ph_EV_PTR_MOTION(int widget, int info) {
        return 0;
    }

    int Pt_CB_ACTIVATE(int widget, int info) {
        return 0;
    }

    int Pt_CB_ARM(int widget, int info) {
        return 0;
    }

    int Pt_CB_GOT_FOCUS(int widget, int info) {
        return 0;
    }

    int Pt_CB_LOST_FOCUS(int widget, int info) {
        return 0;
    }

    int Pt_CB_MODIFY_VERIFY(int widget, int info) {
        return 0;
    }

    int Pt_CB_NUMERIC_CHANGED(int widget, int info) {
        return 0;
    }

    int Pt_CB_OUTBOUND(int widget, int info) {
        return 0;
    }

    int Pt_CB_PG_PANEL_SWITCHING(int widget, int info) {
        return 0;
    }

    int Pt_CB_REALIZED(int widget, int info) {
        return 0;
    }

    int Pt_CB_RESIZE(int widget, int info) {
        return 0;
    }

    int Pt_CB_SCROLL_MOVE(int widget, int info) {
        return 0;
    }

    int Pt_CB_SLIDER_MOVE(int widget, int info) {
        return 0;
    }

    int Pt_CB_SELECTION(int widget, int info) {
        return 0;
    }

    int Pt_CB_TEXT_CHANGED(int widget, int info) {
        return 0;
    }

    int Pt_CB_TIMER_ACTIVATE(int widget, int info) {
        return 0;
    }

    int Pt_CB_UNREALIZED(int widget, int info) {
        return 0;
    }

    int Pt_CB_WINDOW(int widget, int info) {
        return 0;
    }

    void register() {
        if (this.handle == 0) {
            return;
        }
        WidgetTable.put(this.handle, this);
    }

    void release(boolean destroy) {
        if ((this.state & 0x1000) == 0) {
            this.state |= 0x1000;
            this.sendEvent(12);
        }
        if ((this.state & 1) == 0) {
            this.releaseChildren(destroy);
        }
        if ((this.state & 0x800) == 0) {
            this.state |= 0x800;
            if (destroy) {
                this.releaseParent();
                this.releaseWidget();
                this.destroyWidget();
            } else {
                this.releaseWidget();
                this.releaseHandle();
            }
        }
    }

    void releaseChildren(boolean destroy) {
    }

    void releaseHandle() {
        this.handle = 0;
        this.state |= 1;
        this.display = null;
    }

    void releaseParent() {
    }

    void releaseWidget() {
        this.deregister();
        this.eventTable = null;
        this.data = null;
    }

    public void removeListener(int eventType, Listener handler) {
        this.checkWidget();
        if (handler == null) {
            Widget.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(eventType, handler);
    }

    protected void removeListener(int eventType, SWTEventListener handler) {
        this.checkWidget();
        if (handler == null) {
            Widget.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(eventType, handler);
    }

    public void removeDisposeListener(DisposeListener listener) {
        this.checkWidget();
        if (listener == null) {
            Widget.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(12, listener);
    }

    void replaceMnemonic(int mnemonic, boolean normal, boolean alt) {
        int length;
        int[] nArray = new int[3];
        nArray[0] = 3018;
        int[] args = nArray;
        OS.PtGetResources(this.handle, args.length / 3, args);
        if (args[1] != 0 && (length = OS.strlen(args[1])) > 0) {
            byte[] buffer = new byte[length];
            OS.memmove(buffer, args[1], length);
            char[] accelText = Converter.mbcsToWcs(null, buffer);
            if (accelText.length > 0) {
                char key = Character.toLowerCase(accelText[0]);
                if (alt) {
                    OS.PtRemoveHotkeyHandler(this.handle, key, 4, (short)0, this.handle, this.display.hotkeyProc);
                }
            }
        }
        if (mnemonic == 0) {
            return;
        }
        char key = Character.toLowerCase((char)mnemonic);
        if (alt) {
            OS.PtAddHotkeyHandler(this.handle, key, 4, (short)0, this.handle, this.display.hotkeyProc);
        }
    }

    void sendEvent(Event event) {
        Display display = event.display;
        if (!display.filterEvent(event) && this.eventTable != null) {
            this.eventTable.sendEvent(event);
        }
    }

    void sendEvent(int eventType) {
        this.sendEvent(eventType, null, true);
    }

    void sendEvent(int eventType, Event event) {
        this.sendEvent(eventType, event, true);
    }

    void sendEvent(int eventType, Event event, boolean send) {
        if (this.eventTable == null && !this.display.filters(eventType)) {
            return;
        }
        if (event == null) {
            event = new Event();
        }
        event.type = eventType;
        event.display = this.display;
        event.widget = this;
        if (event.time == 0) {
            event.time = this.display.getLastEventTime();
        }
        if (send) {
            this.sendEvent(event);
        } else {
            this.display.postEvent(event);
        }
    }

    public void setData(Object data) {
        this.checkWidget();
        if ((this.state & 4) != 0) {
            ((Object[])this.data)[0] = data;
        } else {
            this.data = data;
        }
    }

    public void setData(String key, Object value) {
        this.checkWidget();
        if (key == null) {
            Widget.error(4);
        }
        int index = 1;
        Object[] table = null;
        if ((this.state & 4) != 0) {
            table = (Object[])this.data;
            while (index < table.length) {
                if (key.equals(table[index])) break;
                index += 2;
            }
        }
        if (value != null) {
            if ((this.state & 4) != 0) {
                if (index == table.length) {
                    Object[] newTable = new Object[table.length + 2];
                    System.arraycopy(table, 0, newTable, 0, table.length);
                    table = newTable;
                    this.data = newTable;
                }
            } else {
                table = new Object[3];
                table[0] = this.data;
                this.data = table;
                this.state |= 4;
            }
            table[index] = key;
            table[index + 1] = value;
        } else if ((this.state & 4) != 0 && index != table.length) {
            int length = table.length - 2;
            if (length == 1) {
                this.data = table[0];
                this.state &= 0xFFFFFFFB;
            } else {
                Object[] newTable = new Object[length];
                System.arraycopy(table, 0, newTable, 0, index);
                System.arraycopy(table, index + 2, newTable, index, length - index);
                this.data = newTable;
            }
        }
    }

    boolean setInputState(Event event, int type, int key_mods, int button_state) {
        if ((key_mods & 4) != 0) {
            event.stateMask |= 0x10000;
        }
        if ((key_mods & 1) != 0) {
            event.stateMask |= 0x20000;
        }
        if ((key_mods & 2) != 0) {
            event.stateMask |= 0x40000;
        }
        if ((button_state & 4) != 0) {
            event.stateMask |= 0x80000;
        }
        if ((button_state & 2) != 0) {
            event.stateMask |= 0x100000;
        }
        if ((button_state & 1) != 0) {
            event.stateMask |= 0x200000;
        }
        switch (type) {
            case 3: 
            case 8: {
                if (event.button == 1) {
                    event.stateMask &= 0xFFF7FFFF;
                }
                if (event.button == 2) {
                    event.stateMask &= 0xFFEFFFFF;
                }
                if (event.button != 3) break;
                event.stateMask &= 0xFFDFFFFF;
                break;
            }
            case 4: {
                if (event.button == 1) {
                    event.stateMask |= 0x80000;
                }
                if (event.button == 2) {
                    event.stateMask |= 0x100000;
                }
                if (event.button != 3) break;
                event.stateMask |= 0x200000;
                break;
            }
            case 1: 
            case 31: {
                if (event.keyCode == 65536) {
                    event.stateMask &= 0xFFFEFFFF;
                }
                if (event.keyCode == 131072) {
                    event.stateMask &= 0xFFFDFFFF;
                }
                if (event.keyCode != 262144) break;
                event.stateMask &= 0xFFFBFFFF;
                break;
            }
            case 2: {
                if (event.keyCode == 65536) {
                    event.stateMask |= 0x10000;
                }
                if (event.keyCode == 131072) {
                    event.stateMask |= 0x20000;
                }
                if (event.keyCode != 262144) break;
                event.stateMask |= 0x40000;
            }
        }
        return true;
    }

    boolean setKeyState(Event event, int type, PhKeyEvent_t ke) {
        int key = 0;
        boolean isNull = false;
        if ((ke.key_flags & 0x80) != 0) {
            key = ke.key_cap;
            if ((ke.key_mods & 0x20000) == 0) {
                switch (key) {
                    case 61616: {
                        key = 61539;
                        break;
                    }
                    case 61617: {
                        key = 61527;
                        break;
                    }
                    case 61618: {
                        key = 61524;
                        break;
                    }
                    case 61619: {
                        key = 61526;
                        break;
                    }
                    case 61620: {
                        key = 61521;
                        break;
                    }
                    case 61621: {
                        break;
                    }
                    case 61622: {
                        key = 61523;
                        break;
                    }
                    case 61623: {
                        key = 61520;
                        break;
                    }
                    case 61624: {
                        key = 61522;
                        break;
                    }
                    case 61625: {
                        key = 61525;
                        break;
                    }
                    case 61614: {
                        key = 61695;
                    }
                }
            }
            event.keyCode = Display.translateKey(key);
        }
        switch (key) {
            case 61448: {
                event.character = (char)8;
                break;
            }
            case 61450: {
                event.character = (char)10;
                break;
            }
            case 61453: 
            case 61581: {
                event.character = (char)13;
                break;
            }
            case 61695: {
                event.character = (char)127;
                break;
            }
            case 61467: {
                event.character = (char)27;
                break;
            }
            case 61449: 
            case 61577: {
                event.character = (char)9;
                break;
            }
            case 61451: 
            case 61543: 
            case 61677: 
            case 61678: {
                break;
            }
            default: {
                char[] unicode;
                if (event.keyCode == 0 && (ke.key_flags & 0x80) != 0) {
                    event.keyCode = ke.key_cap;
                }
                if ((ke.key_mods & 6) != 0) {
                    if (key < 0 || key > 127) break;
                    if ((ke.key_mods & 2) != 0) {
                        boolean bl = isNull = key == 64;
                        if (97 <= key && key <= 122) {
                            key -= 32;
                        }
                        if (64 <= key && key <= 95) {
                            key -= 64;
                        }
                        event.character = (char)key;
                        isNull &= key == 0;
                        break;
                    }
                    if ((ke.key_flags & 0x40) == 0) break;
                    event.character = (char)ke.key_sym;
                    break;
                }
                byte[] buffer = new byte[6];
                int length = OS.PhKeyToMb(buffer, ke);
                if (length <= 0 || (unicode = Converter.mbcsToWcs(null, buffer)).length <= 0) break;
                event.character = unicode[0];
            }
        }
        if (event.keyCode == 0 && event.character == '\u0000' && !isNull) {
            return false;
        }
        return this.setInputState(event, type, ke.key_mods, ke.button_state);
    }

    boolean setMouseState(Event event, int type, PhPointerEvent_t pe, PhEvent_t ev) {
        short buttons = pe.buttons;
        event.x = pe.pos_x + ev.translation_x;
        event.y = pe.pos_y + ev.translation_y;
        if (ev.type == 2 || ev.type == 4) {
            switch (buttons) {
                case 4: {
                    event.button = 1;
                    break;
                }
                case 2: {
                    event.button = 2;
                    break;
                }
                case 1: {
                    event.button = 3;
                }
            }
        }
        return this.setInputState(event, type, pe.key_mods, pe.button_state);
    }

    int topHandle() {
        return this.handle;
    }

    public String toString() {
        String string = "*Disposed*";
        if (!this.isDisposed()) {
            string = "*Wrong Thread*";
            if (this.isValidThread()) {
                string = this.getNameText();
            }
        }
        return String.valueOf(this.getName()) + " {" + string + "}";
    }

    int windowProc(int handle, int data, int info) {
        switch (data) {
            case 32: {
                return this.Ph_EV_BOUNDARY(handle, info);
            }
            case 2: {
                return this.Ph_EV_BUT_PRESS(handle, info);
            }
            case 4: {
                return this.Ph_EV_BUT_RELEASE(handle, info);
            }
            case 512: {
                return this.Ph_EV_DRAG(handle, info);
            }
            case 1: {
                return this.Ph_EV_KEY(handle, info);
            }
            case 24: {
                return this.Ph_EV_PTR_MOTION(handle, info);
            }
            case 2009: {
                return this.Pt_CB_ACTIVATE(handle, info);
            }
            case 2007: {
                return this.Pt_CB_ARM(handle, info);
            }
            case 2010: {
                return this.Pt_CB_GOT_FOCUS(handle, info);
            }
            case 2011: {
                return this.Pt_CB_LOST_FOCUS(handle, info);
            }
            case 4009: {
                return this.Pt_CB_MODIFY_VERIFY(handle, info);
            }
            case 53015: {
                return this.Pt_CB_NUMERIC_CHANGED(handle, info);
            }
            case 1022: {
                return this.Pt_CB_OUTBOUND(handle, info);
            }
            case 64010: {
                return this.Pt_CB_PG_PANEL_SWITCHING(handle, info);
            }
            case 1012: {
                return this.Pt_CB_REALIZED(handle, info);
            }
            case 10003: {
                return this.Pt_CB_RESIZE(handle, info);
            }
            case 29010: {
                return this.Pt_CB_SCROLL_MOVE(handle, info);
            }
            case 22017: {
                return this.Pt_CB_SLIDER_MOVE(handle, info);
            }
            case 23010: {
                return this.Pt_CB_SELECTION(handle, info);
            }
            case 4010: {
                return this.Pt_CB_TEXT_CHANGED(handle, info);
            }
            case 41002: {
                return this.Pt_CB_TIMER_ACTIVATE(handle, info);
            }
            case 1013: {
                return this.Pt_CB_UNREALIZED(handle, info);
            }
            case 18017: {
                return this.Pt_CB_WINDOW(handle, info);
            }
        }
        return 0;
    }
}

