/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.photon.OS;
import org.eclipse.swt.internal.photon.PhArea_t;
import org.eclipse.swt.internal.photon.PhDim_t;
import org.eclipse.swt.internal.photon.PhPoint_t;
import org.eclipse.swt.internal.photon.PhWindowEvent_t;
import org.eclipse.swt.internal.photon.PtCallbackInfo_t;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.swt.widgets.WidgetTable;

public class Shell
extends Decorations {
    int shellHandle;
    Menu activeMenu;
    int blockedList;
    Control lastActive;
    boolean modified;

    public Shell() {
        this((Display)null);
    }

    public Shell(int style) {
        this((Display)null, style);
    }

    public Shell(Display display) {
        this(display, 1264);
    }

    public Shell(Display display, int style) {
        this(display, null, style, 0);
    }

    Shell(Display display, Shell parent, int style, int handle) {
        if (display == null) {
            display = Display.getCurrent();
        }
        if (display == null) {
            display = Display.getDefault();
        }
        if (!display.isValidThread()) {
            Shell.error(22);
        }
        if (parent != null && parent.isDisposed()) {
            Shell.error(5);
        }
        this.style = Shell.checkStyle(style);
        this.parent = parent;
        this.display = display;
        this.handle = handle;
        this.createWidget(0);
    }

    public Shell(Shell parent) {
        this(parent, 2144);
    }

    public Shell(Shell parent, int style) {
        this(parent != null ? parent.display : null, parent, style, 0);
    }

    public static Shell photon_new(Display display, int handle) {
        return new Shell(display, null, 8, handle);
    }

    public void addShellListener(ShellListener listener) {
        this.checkWidget();
        if (listener == null) {
            Shell.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(21, typedListener);
        this.addListener(19, typedListener);
        this.addListener(20, typedListener);
        this.addListener(26, typedListener);
        this.addListener(27, typedListener);
    }

    void bringToTop(boolean force) {
        if (!force && this.display.getActiveShell() == null) {
            return;
        }
        OS.PtWindowToFront(this.shellHandle);
    }

    static int checkStyle(int style) {
        style = Decorations.checkStyle(style);
        int mask = 229376;
        int bits = (style &= 0xBFFFFFFF) & ~mask;
        if ((style & 0x20000) != 0) {
            return bits | 0x20000;
        }
        if ((style & 0x10000) != 0) {
            return bits | 0x10000;
        }
        if ((style & 0x8000) != 0) {
            return bits | 0x8000;
        }
        return bits;
    }

    void closeWidget() {
        Event event = new Event();
        event.time = (int)System.currentTimeMillis();
        this.sendEvent(21, event);
        if (event.doit && !this.isDisposed()) {
            this.dispose();
        }
    }

    public void close() {
        this.checkWidget();
        this.closeWidget();
    }

    public Rectangle computeTrim(int x, int y, int width, int height) {
        this.checkWidget();
        int[] nArray = new int[3];
        nArray[0] = 18013;
        int[] args = nArray;
        OS.PtGetResources(this.shellHandle, args.length / 3, args);
        int flags = args[1];
        int[] left = new int[1];
        int[] top = new int[1];
        int[] right = new int[1];
        int[] bottom = new int[1];
        OS.PtFrameSize(flags, 0, left, top, right, bottom);
        int trimX = x - left[0];
        int trimY = y - top[0];
        int trimWidth = width + left[0] + right[0];
        int trimHeight = height + top[0] + bottom[0];
        if (this.menuBar != null) {
            PhDim_t dim = new PhDim_t();
            int menuHandle = this.menuBar.handle;
            if (!OS.PtWidgetIsRealized(menuHandle)) {
                OS.PtExtentWidgetFamily(menuHandle);
            }
            OS.PtWidgetPreferredSize(menuHandle, dim);
            trimHeight += dim.h;
            trimY -= dim.h;
        }
        return new Rectangle(trimX, trimY, trimWidth, trimHeight);
    }

    void createHandle(int index) {
        int[] args;
        this.state |= 0x8A;
        if (this.handle != 0) {
            int clazz = this.display.PtContainer;
            int[] nArray = new int[9];
            nArray[0] = 2002;
            nArray[1] = -1;
            nArray[3] = 10005;
            nArray[4] = 128;
            nArray[5] = 128;
            nArray[6] = 1008;
            nArray[8] = 0x3F00000;
            args = nArray;
            this.shellHandle = OS.PtCreateWidget(clazz, this.handle, args.length / 3, args);
            if (this.shellHandle == 0) {
                Shell.error(2);
            }
        } else {
            int parentHandle = 0;
            if (this.parent != null) {
                parentHandle = this.parent.topHandle();
            }
            Monitor monitor = this.getMonitor();
            Rectangle rect = monitor.getClientArea();
            int width = rect.width * 5 / 8;
            int height = rect.height * 5 / 8;
            int decorations = 0;
            int flags = 12720;
            if ((this.style & 8) == 0) {
                if ((this.style & 0x80) != 0) {
                    decorations |= 0x1000;
                }
                if ((this.style & 0x400) != 0) {
                    decorations |= 0x2000;
                }
                if ((this.style & 0x10) != 0) {
                    decorations |= 0x30;
                }
                if ((this.style & 0x800) != 0) {
                    decorations |= 0x10;
                }
                if ((this.style & 0x40) != 0) {
                    decorations |= 0x100;
                }
                if ((this.style & 0x20) != 0) {
                    decorations |= 0x80;
                }
            }
            int notifyFlags = 1796;
            int windowState = 32768;
            if ((this.style & 0x4000) != 0) {
                windowState = 256;
            }
            int titlePtr = OS.malloc(1);
            OS.memset(titlePtr, 0, 1);
            int[] nArray = new int[33];
            nArray[0] = 1023;
            nArray[1] = width;
            nArray[3] = 1024;
            nArray[4] = height;
            nArray[6] = 18015;
            nArray[7] = titlePtr;
            nArray[9] = 18013;
            nArray[10] = decorations;
            nArray[11] = flags;
            nArray[12] = 18011;
            nArray[14] = 1;
            nArray[15] = 18012;
            nArray[16] = notifyFlags;
            nArray[17] = notifyFlags;
            nArray[18] = 18014;
            nArray[19] = windowState;
            nArray[20] = -1;
            nArray[21] = 1006;
            nArray[22] = 64;
            nArray[23] = 64;
            nArray[24] = 2002;
            nArray[25] = -1;
            nArray[27] = 10005;
            nArray[28] = 128;
            nArray[29] = 128;
            nArray[30] = 1008;
            nArray[32] = 0x3F00000;
            int[] args2 = nArray;
            OS.PtSetParentWidget(parentHandle);
            this.shellHandle = OS.PtCreateWidget(OS.PtWindow(), parentHandle, args2.length / 3, args2);
            OS.free(titlePtr);
            if (this.shellHandle == 0) {
                Shell.error(2);
            }
        }
        this.createScrolledHandle(this.shellHandle);
        if ((this.style & 0x818) == 0) {
            int[] args3 = new int[]{1006, 256, 256, 2015, 240, -1};
            OS.PtSetResources(this.scrolledHandle, args3.length / 3, args3);
        }
        int trim = 1248;
        if ((this.style & 8) != 0 || (this.style & trim) == 0) {
            OS.PtSetResource(this.shellHandle, 18007, 0, 0);
        }
        OS.PtSetResource(this.shellHandle, 18006, 0, 0);
        int[] nArray = new int[6];
        nArray[0] = 1023;
        nArray[3] = 1024;
        args = nArray;
        OS.PtGetResources(this.shellHandle, args.length / 3, args);
        this.resizeBounds(args[1], args[4]);
    }

    void deregister() {
        super.deregister();
        WidgetTable.remove(this.shellHandle);
    }

    Composite findDeferredControl() {
        return this.layoutCount > 0 ? this : null;
    }

    public void forceActive() {
        this.checkWidget();
        this.bringToTop(true);
    }

    public int getAlpha() {
        this.checkWidget();
        return 255;
    }

    public Rectangle getBounds() {
        this.checkWidget();
        PhArea_t area = new PhArea_t();
        OS.PtWidgetArea(this.shellHandle, area);
        int width = area.size_w;
        int height = area.size_h;
        int[] nArray = new int[3];
        nArray[0] = 18013;
        int[] args = nArray;
        OS.PtGetResources(this.shellHandle, args.length / 3, args);
        int flags = args[1];
        int[] left = new int[1];
        int[] top = new int[1];
        int[] right = new int[1];
        int[] bottom = new int[1];
        OS.PtFrameSize(flags, 0, left, top, right, bottom);
        return new Rectangle(area.pos_x, area.pos_y, width += left[0] + right[0], height += top[0] + bottom[0]);
    }

    public boolean getFullScreen() {
        this.checkWidget();
        return false;
    }

    public int getImeInputMode() {
        this.checkWidget();
        return 0;
    }

    public boolean isEnabled() {
        this.checkWidget();
        return this.getEnabled();
    }

    public Point getLocation() {
        this.checkWidget();
        return super.getLocation();
    }

    public boolean getMaximized() {
        this.checkWidget();
        int state = OS.PtWindowGetState(this.shellHandle);
        if (state != -1) {
            return (state & 0x4002) != 0;
        }
        int[] nArray = new int[3];
        nArray[0] = 18014;
        nArray[2] = 2;
        int[] args = nArray;
        OS.PtGetResources(this.shellHandle, args.length / 3, args);
        return (args[1] & 2) != 0;
    }

    public boolean getMinimized() {
        this.checkWidget();
        int state = OS.PtWindowGetState(this.shellHandle);
        if (state != -1) {
            return (state & 0x40) != 0;
        }
        int[] nArray = new int[3];
        nArray[0] = 18014;
        nArray[2] = 64;
        int[] args = nArray;
        OS.PtGetResources(this.shellHandle, args.length / 3, args);
        return (args[1] & 0x40) != 0;
    }

    public Point getMinimumSize() {
        this.checkWidget();
        int[] nArray = new int[3];
        nArray[0] = 18013;
        int[] args = nArray;
        OS.PtGetResources(this.shellHandle, args.length / 3, args);
        int flags = args[1];
        int[] left = new int[1];
        int[] top = new int[1];
        int[] right = new int[1];
        int[] bottom = new int[1];
        OS.PtFrameSize(flags, 0, left, top, right, bottom);
        int[] nArray2 = new int[6];
        nArray2[0] = 18007;
        nArray2[3] = 18006;
        args = nArray2;
        OS.PtGetResources(this.shellHandle, args.length / 3, args);
        return new Point(args[1] + left[0] + right[0], args[4] + top[0] + bottom[0]);
    }

    public boolean getModified() {
        this.checkWidget();
        return this.modified;
    }

    public Region getRegion() {
        this.checkWidget();
        return this.region;
    }

    public Shell getShell() {
        this.checkWidget();
        return this;
    }

    public Shell[] getShells() {
        this.checkWidget();
        int count = 0;
        Shell[] shells = this.display.getShells();
        int i = 0;
        while (i < shells.length) {
            Composite shell = shells[i];
            while ((shell = shell.parent) != null && shell != this) {
            }
            if (shell == this) {
                ++count;
            }
            ++i;
        }
        int index = 0;
        Shell[] result = new Shell[count];
        int i2 = 0;
        while (i2 < shells.length) {
            Composite shell = shells[i2];
            while ((shell = shell.parent) != null && shell != this) {
            }
            if (shell == this) {
                result[index++] = shells[i2];
            }
            ++i2;
        }
        return result;
    }

    public Point getSize() {
        this.checkWidget();
        int[] nArray = new int[9];
        nArray[0] = 18013;
        nArray[3] = 1023;
        nArray[6] = 1024;
        int[] args = nArray;
        OS.PtGetResources(this.shellHandle, args.length / 3, args);
        int flags = args[1];
        int[] left = new int[1];
        int[] top = new int[1];
        int[] right = new int[1];
        int[] bottom = new int[1];
        OS.PtFrameSize(flags, 0, left, top, right, bottom);
        int width = args[4] + left[0] + right[0];
        int height = args[7] + top[0] + bottom[0];
        return new Point(width, height);
    }

    void hookEvents() {
        super.hookEvents();
        int windowProc = this.display.windowProc;
        OS.PtAddCallback(this.shellHandle, 18017, windowProc, 18017);
        OS.PtAddCallback(this.shellHandle, 10003, windowProc, 10003);
    }

    int hotkeyProc(int w, int data, int info) {
        MenuItem item;
        Widget widget;
        if (data != 0 && (widget = WidgetTable.get(data)) instanceof MenuItem && (item = (MenuItem)widget).isEnabled()) {
            item.Pt_CB_ACTIVATE(data, info);
        }
        return 0;
    }

    public void open() {
        this.checkWidget();
        this.setVisible(true);
        if (this.isDisposed()) {
            return;
        }
        this.traverseGroup(true);
    }

    public boolean print(GC gc) {
        this.checkWidget();
        if (gc == null) {
            Shell.error(4);
        }
        if (gc.isDisposed()) {
            Shell.error(5);
        }
        return false;
    }

    int Pt_CB_RESIZE(int widget, int info) {
        if (info == 0) {
            return 0;
        }
        PtCallbackInfo_t cbinfo = new PtCallbackInfo_t();
        OS.memmove(cbinfo, info, 16);
        if (cbinfo.cbdata == 0) {
            return 0;
        }
        int[] nArray = new int[6];
        nArray[0] = 1023;
        nArray[3] = 1024;
        int[] args = nArray;
        OS.PtGetResources(this.shellHandle, args.length / 3, args);
        this.resizeBounds(args[1], args[4]);
        this.sendEvent(11);
        if (this.layout != null) {
            this.markLayout(false, false);
            this.updateLayout(false);
        }
        return 0;
    }

    int Pt_CB_WINDOW(int widget, int info) {
        if (info == 0) {
            return 0;
        }
        PtCallbackInfo_t cbinfo = new PtCallbackInfo_t();
        OS.memmove(cbinfo, info, 16);
        if (cbinfo.cbdata == 0) {
            return 0;
        }
        PhWindowEvent_t we = new PhWindowEvent_t();
        OS.memmove(we, cbinfo.cbdata, 40);
        switch (we.event_f) {
            case 1: {
                this.closeWidget();
                break;
            }
            case 1024: {
                if ((we.state_f & 0x40) != 0) {
                    this.sendEvent(19);
                    break;
                }
                this.sendEvent(20);
                break;
            }
            case 4: {
                switch (we.event_state) {
                    case 0: {
                        this.sendEvent(26);
                        break;
                    }
                    case 1: {
                        this.sendEvent(27);
                    }
                }
                break;
            }
            case 512: {
                this.sendEvent(10);
            }
        }
        return 0;
    }

    void register() {
        super.register();
        WidgetTable.put(this.shellHandle, this);
    }

    void realizeWidget() {
    }

    void releaseParent() {
    }

    void releaseHandle() {
        super.releaseHandle();
        this.shellHandle = 0;
    }

    void releaseChildren(boolean destroy) {
        Shell[] shells = this.getShells();
        int i = 0;
        while (i < shells.length) {
            Shell shell = shells[i];
            if (shell != null && !shell.isDisposed()) {
                if (shell.parent != null && OS.PtWidgetParent(shell.shellHandle) == 0) {
                    shell.dispose();
                } else {
                    shell.release(false);
                }
            }
            ++i;
        }
        super.releaseChildren(destroy);
    }

    void releaseWidget() {
        super.releaseWidget();
        if (this.blockedList != 0) {
            OS.PtUnblockWindows(this.blockedList);
        }
        this.blockedList = 0;
        this.lastActive = null;
    }

    public void removeShellListener(ShellListener listener) {
        this.checkWidget();
        if (listener == null) {
            Shell.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(21, listener);
        this.eventTable.unhook(19, listener);
        this.eventTable.unhook(20, listener);
        this.eventTable.unhook(26, listener);
        this.eventTable.unhook(27, listener);
    }

    public void setActive() {
        this.checkWidget();
        this.bringToTop(false);
    }

    void setActiveControl(Control control) {
        if (control != null && control.isDisposed()) {
            control = null;
        }
        if (this.lastActive != null && this.lastActive.isDisposed()) {
            this.lastActive = null;
        }
        if (this.lastActive == control) {
            return;
        }
        Control[] activate = control == null ? new Control[]{} : control.getPath();
        Control[] deactivate = this.lastActive == null ? new Control[]{} : this.lastActive.getPath();
        this.lastActive = control;
        int index = 0;
        int length = Math.min(activate.length, deactivate.length);
        while (index < length) {
            if (activate[index] != deactivate[index]) break;
            ++index;
        }
        int i = deactivate.length - 1;
        while (i >= index) {
            if (!deactivate[i].isDisposed()) {
                deactivate[i].sendEvent(27);
            }
            --i;
        }
        i = activate.length - 1;
        while (i >= index) {
            if (!activate[i].isDisposed()) {
                activate[i].sendEvent(26);
            }
            --i;
        }
    }

    public void setAlpha(int alpha) {
        this.checkWidget();
    }

    int setBounds(int x, int y, int width, int height, boolean move, boolean resize, boolean events) {
        boolean isFocus;
        this.checkWidget();
        if (OS.PtWidgetClass(this.shellHandle) != OS.PtWindow()) {
            int result = super.setBounds(x, y, width, height, move, resize, events);
            if ((result & 0x40) != 0) {
                this.resizeBounds(width, height);
            }
            return result;
        }
        boolean bl = isFocus = this.caret != null && this.caret.isFocusCaret();
        if (isFocus) {
            this.caret.killFocus();
        }
        if (resize) {
            int[] nArray = new int[3];
            nArray[0] = 18013;
            int[] args = nArray;
            OS.PtGetResources(this.shellHandle, args.length / 3, args);
            int flags = args[1];
            int[] left = new int[1];
            int[] top = new int[1];
            int[] right = new int[1];
            int[] bottom = new int[1];
            OS.PtFrameSize(flags, 0, left, top, right, bottom);
            width = Math.max(width - left[0] - right[0], 0);
            height = Math.max(height - top[0] - bottom[0], 0);
        }
        PhArea_t oldArea = new PhArea_t();
        OS.PtWidgetArea(this.shellHandle, oldArea);
        if (move && resize) {
            PhArea_t area = new PhArea_t();
            area.pos_x = (short)x;
            area.pos_y = (short)y;
            area.size_w = (short)width;
            area.size_h = (short)height;
            int ptr = OS.malloc(8);
            OS.memmove(ptr, area, 8);
            OS.PtSetResource(this.shellHandle, 1000, ptr, 0);
            OS.free(ptr);
        } else if (move) {
            PhPoint_t pt = new PhPoint_t();
            pt.x = (short)x;
            pt.y = (short)y;
            int ptr = OS.malloc(4);
            OS.memmove(ptr, pt, 4);
            OS.PtSetResource(this.shellHandle, 1007, ptr, 0);
            OS.free(ptr);
        } else if (resize) {
            int[] nArray = new int[6];
            nArray[0] = 1023;
            nArray[1] = width;
            nArray[3] = 1024;
            nArray[4] = height;
            int[] args = nArray;
            OS.PtSetResources(this.shellHandle, args.length / 3, args);
        }
        if (!OS.PtWidgetIsRealized(this.shellHandle)) {
            PhArea_t newArea = new PhArea_t();
            OS.PtWidgetArea(this.shellHandle, newArea);
            boolean sameOrigin = oldArea.pos_x == newArea.pos_x && oldArea.pos_y == newArea.pos_y;
            boolean sameExtent = oldArea.size_w == newArea.size_w && oldArea.size_h == newArea.size_h;
            if (!sameOrigin & move) {
                this.sendEvent(10);
            }
            if (!sameExtent & resize) {
                this.resizeBounds(newArea.size_w, newArea.size_h);
                this.sendEvent(11);
                if (this.layout != null) {
                    this.markLayout(false, false);
                    this.updateLayout(false);
                }
            }
        }
        if (isFocus) {
            this.caret.setFocus();
        }
        return 0;
    }

    public void setFullScreen(boolean fullScreen) {
        this.checkWidget();
    }

    public void setImeInputMode(int mode) {
        this.checkWidget();
    }

    public void setMaximized(boolean maximized) {
        this.checkWidget();
        int bits = 0;
        if (maximized) {
            bits = 2;
        }
        OS.PtSetResource(this.shellHandle, 18014, bits, 2);
        if (OS.PtWidgetIsRealized(this.shellHandle)) {
            PhWindowEvent_t event = new PhWindowEvent_t();
            event.rid = OS.PtWidgetRid(this.shellHandle);
            event.event_f = maximized ? 2048 : 32768;
            OS.PtForwardWindowEvent(event);
        }
    }

    public void setMenuBar(Menu menu) {
        this.checkWidget();
        if (this.menuBar == menu) {
            return;
        }
        if (menu != null) {
            if ((menu.style & 2) == 0) {
                Shell.error(33);
            }
            if (menu.parent != this) {
                Shell.error(32);
            }
        }
        if (this.menuBar != null) {
            int menuHandle = this.menuBar.handle;
            OS.PtSetResource(menuHandle, 1006, 64, 64);
            OS.PtUnrealizeWidget(this.menuBar.handle);
        }
        this.menuBar = menu;
        int[] nArray = new int[6];
        nArray[0] = 1023;
        nArray[3] = 1024;
        int[] args = nArray;
        OS.PtGetResources(this.shellHandle, args.length / 3, args);
        int width = args[1];
        int height = args[4];
        if (this.menuBar != null) {
            int menuHandle = menu.handle;
            int[] nArray2 = new int[6];
            nArray2[0] = 1023;
            nArray2[1] = width;
            nArray2[3] = 1006;
            nArray2[5] = 64;
            args = nArray2;
            OS.PtSetResources(menuHandle, args.length / 3, args);
            OS.PtRealizeWidget(menuHandle);
        }
        this.resizeBounds(width, height);
    }

    public void setMinimized(boolean minimized) {
        this.checkWidget();
        int bits = 0;
        if (minimized) {
            bits = 64;
        }
        OS.PtSetResource(this.shellHandle, 18014, bits, 64);
        if (OS.PtWidgetIsRealized(this.shellHandle)) {
            PhWindowEvent_t event = new PhWindowEvent_t();
            event.rid = OS.PtWidgetRid(this.shellHandle);
            event.event_f = 64;
            event.event_state = (short)(!minimized ? 1 : 0);
            OS.PtForwardWindowEvent(event);
        }
    }

    public void setModified(boolean modified) {
        this.checkWidget();
        this.modified = modified;
    }

    public void setRegion(Region region) {
        this.checkWidget();
        if ((this.style & 8) == 0) {
            return;
        }
        super.setRegion(region);
    }

    public void setMinimumSize(int width, int height) {
        this.checkWidget();
        int[] nArray = new int[3];
        nArray[0] = 18013;
        int[] args = nArray;
        OS.PtGetResources(this.shellHandle, args.length / 3, args);
        int flags = args[1];
        int[] left = new int[1];
        int[] top = new int[1];
        int[] right = new int[1];
        int[] bottom = new int[1];
        OS.PtFrameSize(flags, 0, left, top, right, bottom);
        width = Math.max(width - left[0] - right[0], 0);
        height = Math.max(height - top[0] - bottom[0], 0);
        int[] nArray2 = new int[6];
        nArray2[0] = 18007;
        nArray2[1] = width;
        nArray2[3] = 18006;
        nArray2[4] = height;
        args = nArray2;
        OS.PtSetResources(this.shellHandle, args.length / 3, args);
    }

    public void setMinimumSize(Point size) {
        this.checkWidget();
        if (size == null) {
            Shell.error(4);
        }
        this.setMinimumSize(size.x, size.y);
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            Shell.error(4);
        }
        this.text = string;
        byte[] buffer = Converter.wcsToMbcs(null, string, true);
        int ptr = OS.malloc(buffer.length);
        OS.memmove(ptr, buffer, buffer.length);
        OS.PtSetResource(this.shellHandle, 18015, ptr, 0);
        OS.free(ptr);
    }

    public void setVisible(boolean visible) {
        block17: {
            block16: {
                int parentHandle;
                this.checkWidget();
                if (visible == OS.PtWidgetIsRealized(this.shellHandle)) {
                    return;
                }
                if (this.parent != null) {
                    Shell shell = this.parent.getShell();
                    parentHandle = shell.shellHandle;
                    if (!OS.PtWidgetIsRealized(parentHandle)) {
                        OS.PtReParentWidget(this.shellHandle, visible ? 1 : parentHandle);
                    }
                }
                if (!visible) break block16;
                int mask = 229376;
                switch (this.style & mask) {
                    case 32768: {
                        if (this.parent != null) {
                            parentHandle = this.parent.getShell().shellHandle;
                            this.blockedList = OS.PtBlockWindow(parentHandle, (short)0, 0);
                            break;
                        }
                        break block17;
                    }
                    case 65536: 
                    case 131072: {
                        this.blockedList = OS.PtBlockAllWindows(this.shellHandle, (short)0, 0);
                    }
                }
                break block17;
            }
            if (this.blockedList != 0) {
                OS.PtUnblockWindows(this.blockedList);
            }
            this.blockedList = 0;
        }
        int flags = visible ? 0 : 64;
        OS.PtSetResource(this.shellHandle, 1006, flags, 64);
        if (visible) {
            this.sendEvent(22);
            if (this.isDisposed()) {
                return;
            }
            OS.PtRealizeWidget(this.shellHandle);
        } else {
            OS.PtUnrealizeWidget(this.shellHandle);
            this.sendEvent(23);
            if (this.isDisposed()) {
                return;
            }
        }
        if (visible) {
            Shell[] shells = this.getShells();
            int i = 0;
            while (i < shells.length) {
                int childHandle = shells[i].shellHandle;
                if (OS.PtWidgetParent(childHandle) == 0) {
                    OS.PtReParentWidget(childHandle, this.shellHandle);
                }
                ++i;
            }
        }
        OS.PtSyncWidget(this.shellHandle);
        OS.PtFlush();
    }

    int topHandle() {
        return this.shellHandle;
    }

    boolean traverseEscape() {
        if (this.parent == null) {
            return false;
        }
        if (!this.isVisible() || !this.isEnabled()) {
            return false;
        }
        this.close();
        return true;
    }
}

