/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.photon.OS;
import org.eclipse.swt.internal.photon.PhArea_t;
import org.eclipse.swt.internal.photon.PhRect_t;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.WidgetTable;

public abstract class Scrollable
extends Control {
    int scrolledHandle;
    ScrollBar horizontalBar;
    ScrollBar verticalBar;

    Scrollable() {
    }

    public Scrollable(Composite parent, int style) {
        super(parent, style);
    }

    void createStandardScrollBars() {
        int child = OS.PtWidgetChildFront(this.handle);
        while (child != 0) {
            if (OS.PtWidgetClass(child) == OS.PtScrollbar()) {
                int[] nArray = new int[3];
                nArray[0] = 21005;
                int[] args = nArray;
                OS.PtGetResources(child, args.length / 3, args);
                switch (args[1]) {
                    case 1: {
                        if ((this.style & 0x100) == 0) break;
                        this.horizontalBar = new ScrollBar(this, 256, child);
                        break;
                    }
                    case 0: {
                        if ((this.style & 0x200) == 0) break;
                        this.verticalBar = new ScrollBar(this, 512, child);
                    }
                }
            }
            child = OS.PtWidgetBrotherBehind(child);
        }
    }

    void deregister() {
        super.deregister();
        if (this.scrolledHandle != 0) {
            WidgetTable.remove(this.scrolledHandle);
        }
    }

    public Rectangle computeTrim(int x, int y, int width, int height) {
        Point size;
        this.checkWidget();
        PhRect_t rect = new PhRect_t();
        PhArea_t area = new PhArea_t();
        rect.ul_x = (short)x;
        rect.ul_y = (short)y;
        rect.lr_x = (short)(x + width - 1);
        rect.lr_y = (short)(y + height - 1);
        OS.PtSetAreaFromWidgetCanvas(this.scrolledHandle != 0 ? this.scrolledHandle : this.handle, rect, area);
        if (this.horizontalBar != null) {
            size = this.horizontalBar.getSize();
            area.size_h = (short)(area.size_h + size.y);
        }
        if (this.verticalBar != null) {
            size = this.verticalBar.getSize();
            area.size_w = (short)(area.size_w + size.x);
        }
        return new Rectangle(area.pos_x, area.pos_y, area.size_w, area.size_h);
    }

    public Rectangle getClientArea() {
        this.checkWidget();
        PhRect_t rect = new PhRect_t();
        int validParent = OS.PtValidParent(this.handle, OS.PtContainer());
        if (!OS.PtWidgetIsRealized(this.handle)) {
            OS.PtExtentWidgetFamily(this.handle);
        }
        OS.PtCalcCanvas(validParent, rect);
        int width = rect.lr_x - rect.ul_x + 1;
        int height = rect.lr_y - rect.ul_y + 1;
        return new Rectangle(0, 0, width, height);
    }

    public ScrollBar getHorizontalBar() {
        this.checkWidget();
        return this.horizontalBar;
    }

    public ScrollBar getVerticalBar() {
        this.checkWidget();
        return this.verticalBar;
    }

    boolean isTabGroup() {
        if ((this.state & 2) != 0) {
            return true;
        }
        return super.isTabGroup();
    }

    void releaseHandle() {
        super.releaseHandle();
        this.scrolledHandle = 0;
    }

    void resizeClientArea() {
    }

    void releaseChildren(boolean destroy) {
        if (this.horizontalBar != null) {
            this.horizontalBar.release(false);
            this.horizontalBar = null;
        }
        if (this.verticalBar != null) {
            this.verticalBar.release(false);
            this.verticalBar = null;
        }
        super.releaseChildren(destroy);
    }

    void register() {
        super.register();
        if (this.scrolledHandle != 0) {
            WidgetTable.put(this.scrolledHandle, this);
        }
    }

    int topHandle() {
        if (this.scrolledHandle == 0) {
            return this.handle;
        }
        return this.scrolledHandle;
    }
}

