/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DragDetectListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.internal.photon.OS;
import org.eclipse.swt.internal.photon.PhArea_t;
import org.eclipse.swt.internal.photon.PhEvent_t;
import org.eclipse.swt.internal.photon.PhKeyEvent_t;
import org.eclipse.swt.internal.photon.PhPoint_t;
import org.eclipse.swt.internal.photon.PhPointerEvent_t;
import org.eclipse.swt.internal.photon.PhRect_t;
import org.eclipse.swt.internal.photon.PhTile_t;
import org.eclipse.swt.internal.photon.PtCallbackInfo_t;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public abstract class Control
extends Widget
implements Drawable {
    Composite parent;
    Cursor cursor;
    Font font;
    Menu menu;
    Object layoutData;
    String toolTipText;
    Image backgroundImage;
    Region region;
    int toolTipHandle;
    Accessible accessible;

    Control() {
    }

    public Control(Composite parent, int style) {
        super(parent, style);
        this.parent = parent;
        this.createWidget(0);
    }

    public void addControlListener(ControlListener listener) {
        this.checkWidget();
        if (listener == null) {
            Control.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(11, typedListener);
        this.addListener(10, typedListener);
    }

    public void addDragDetectListener(DragDetectListener listener) {
        this.checkWidget();
        if (listener == null) {
            Control.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(29, typedListener);
    }

    public void addFocusListener(FocusListener listener) {
        this.checkWidget();
        if (listener == null) {
            Control.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(15, typedListener);
        this.addListener(16, typedListener);
    }

    public void addHelpListener(HelpListener listener) {
        this.checkWidget();
        if (listener == null) {
            Control.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(28, typedListener);
    }

    public void addKeyListener(KeyListener listener) {
        this.checkWidget();
        if (listener == null) {
            Control.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(2, typedListener);
        this.addListener(1, typedListener);
    }

    public void addMenuDetectListener(MenuDetectListener listener) {
        this.checkWidget();
        if (listener == null) {
            Control.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(35, typedListener);
    }

    public void addMouseListener(MouseListener listener) {
        this.checkWidget();
        if (listener == null) {
            Control.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(3, typedListener);
        this.addListener(4, typedListener);
        this.addListener(8, typedListener);
    }

    public void addMouseMoveListener(MouseMoveListener listener) {
        this.checkWidget();
        if (listener == null) {
            Control.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(5, typedListener);
    }

    public void addMouseTrackListener(MouseTrackListener listener) {
        this.checkWidget();
        if (listener == null) {
            Control.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(6, typedListener);
        this.addListener(7, typedListener);
        this.addListener(32, typedListener);
    }

    public void addMouseWheelListener(MouseWheelListener listener) {
        this.checkWidget();
        if (listener == null) {
            Control.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(37, typedListener);
    }

    public void addPaintListener(PaintListener listener) {
        this.checkWidget();
        if (listener == null) {
            Control.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(9, typedListener);
    }

    public void addTraverseListener(TraverseListener listener) {
        this.checkWidget();
        if (listener == null) {
            Control.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(31, typedListener);
    }

    public boolean forceFocus() {
        this.checkWidget();
        Shell shell = this.getShell();
        if (shell.activeMenu != null) {
            return false;
        }
        shell.bringToTop(false);
        OS.PtContainerGiveFocus(this.handle, null);
        return this.hasFocus();
    }

    void checkBuffered() {
        this.style &= 0xDFFFFFFF;
    }

    public Point computeSize(int wHint, int hHint) {
        return this.computeSize(wHint, hHint, true);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int width = 64;
        int height = 64;
        if (wHint != -1) {
            width = wHint;
        }
        if (hHint != -1) {
            height = hHint;
        }
        int border = this.getBorderWidth();
        return new Point(width += border * 2, height += border * 2);
    }

    Control computeTabGroup() {
        if (this.isTabGroup()) {
            return this;
        }
        return this.parent.computeTabGroup();
    }

    Control computeTabRoot() {
        Control[] tabList = this.parent._getTabList();
        if (tabList != null) {
            int index = 0;
            while (index < tabList.length) {
                if (tabList[index] == this) break;
                ++index;
            }
            if (index == tabList.length && this.isTabGroup()) {
                return this;
            }
        }
        return this.parent.computeTabRoot();
    }

    Control[] computeTabList() {
        if (this.isTabGroup() && this.getVisible() && this.getEnabled()) {
            return new Control[]{this};
        }
        return new Control[0];
    }

    void createWidget(int index) {
        this.checkOrientation(this.parent);
        super.createWidget(index);
        this.checkBuffered();
        this.setZOrder();
        this.realizeWidget();
        this.setDefaultFont();
    }

    int defaultBackground() {
        return this.display.WIDGET_BACKGROUND;
    }

    byte[] defaultFont() {
        return this.display.TEXT_FONT;
    }

    int defaultForeground() {
        return this.display.WIDGET_FOREGROUND;
    }

    boolean drawGripper(int x, int y, int width, int height, boolean vertical) {
        return false;
    }

    public boolean dragDetect(Event event) {
        this.checkWidget();
        if (event == null) {
            Control.error(4);
        }
        return this.dragDetect(event.button, event.count, event.stateMask, event.x, event.y);
    }

    public boolean dragDetect(MouseEvent event) {
        this.checkWidget();
        if (event == null) {
            Control.error(4);
        }
        return this.dragDetect(event.button, event.count, event.stateMask, event.x, event.y);
    }

    boolean dragDetect(int button, int count, int stateMask, int x, int y) {
        return false;
    }

    int drawProc(int widget, int damage) {
        boolean noMerge;
        if (widget <= 0) {
            return 0;
        }
        this.drawWidget(widget, damage);
        if (!this.hooks(9) && !this.filters(9)) {
            return 0;
        }
        PhPoint_t pt = new PhPoint_t();
        PhRect_t widRect = new PhRect_t();
        OS.PtWidgetExtent(widget, widRect);
        OS.PtWidgetOffset(widget, pt);
        pt.x = (short)(pt.x + widRect.ul_x);
        pt.y = (short)(pt.y + widRect.ul_y);
        damage = OS.PhCopyTiles(damage);
        PhTile_t tile = new PhTile_t();
        OS.memmove(tile, damage, 12);
        int transPoint = OS.malloc(4);
        OS.memmove(transPoint, pt, 4);
        OS.PhDeTranslateTiles(damage, transPoint);
        OS.free(transPoint);
        OS.memmove(tile, damage, 12);
        boolean bl = noMerge = (this.style & 0x200000) != 0 && (this.state & 2) != 0;
        if (tile.next != 0 && noMerge) {
            OS.memmove(tile, tile.next, 12);
            while (tile.next != 0) {
                Event event = new Event();
                event.width = tile.rect_lr_x - tile.rect_ul_x + 1;
                event.height = tile.rect_lr_y - tile.rect_ul_y + 1;
                event.x = tile.rect_ul_x;
                event.y = tile.rect_ul_y;
                GC gc = event.gc = new GC(this);
                gc.setClipping(event.x, event.y, event.width, event.height);
                this.sendEvent(9, event);
                if (!this.isDisposed()) {
                    gc.dispose();
                    event.gc = null;
                    if (tile.next == 0) continue;
                    OS.memmove(tile, tile.next, 12);
                    continue;
                }
                break;
            }
        } else {
            int rect1 = OS.malloc(8);
            int rect2 = OS.malloc(8);
            OS.memmove(rect1, tile, 8);
            OS.memmove(rect2, widRect, 8);
            int inter = OS.PhRectIntersect(rect1, rect2);
            if (inter == 1) {
                OS.memmove(widRect, rect1, 8);
                Event event = new Event();
                event.x = widRect.ul_x;
                event.y = widRect.ul_y;
                event.width = widRect.lr_x - widRect.ul_x + 1;
                event.height = widRect.lr_y - widRect.ul_y + 1;
                GC gc = event.gc = new GC(this);
                gc.setClipping(event.x, event.y, event.width, event.height);
                this.sendEvent(9, event);
                gc.dispose();
                event.gc = null;
            }
            OS.free(rect1);
            OS.free(rect2);
        }
        OS.PhFreeTiles(damage);
        return 0;
    }

    void drawWidget(int widget, int damage) {
        int widgetClass = this.widgetClass();
        if (widgetClass != 0) {
            OS.PtSuperClassDraw(widgetClass, this.handle, damage);
        }
    }

    void enableWidget(boolean enabled) {
        int topHandle = this.topHandle();
        int flags = enabled ? 0 : 0x1020000;
        OS.PtSetResource(topHandle, 1006, flags, 0x1020000);
    }

    public Accessible getAccessible() {
        this.checkWidget();
        if (this.accessible == null) {
            this.accessible = Accessible.internal_new_Accessible(this);
        }
        return this.accessible;
    }

    public Color getBackground() {
        this.checkWidget();
        int[] nArray = new int[3];
        nArray[0] = 2002;
        int[] args = nArray;
        OS.PtGetResources(this.handle, args.length / 3, args);
        return Color.photon_new(this.display, args[1]);
    }

    public Image getBackgroundImage() {
        this.checkWidget();
        return this.backgroundImage;
    }

    public Font getFont() {
        byte[] font;
        this.checkWidget();
        if (this.font != null) {
            return this.font;
        }
        int[] nArray = new int[12];
        nArray[0] = 3010;
        nArray[3] = 23003;
        nArray[6] = 10008;
        nArray[9] = 21001;
        int[] args = nArray;
        OS.PtGetResources(this.handle, args.length / 3, args);
        int ptr = args[1];
        if (ptr == 0) {
            ptr = args[4];
        }
        if (ptr == 0) {
            ptr = args[7];
        }
        if (ptr == 0) {
            ptr = args[11];
        }
        if (ptr == 0) {
            font = this.defaultFont();
        } else {
            int length = OS.strlen(ptr);
            font = new byte[length + 1];
            OS.memmove(font, ptr, length);
        }
        return Font.photon_new(this.display, font);
    }

    public Color getForeground() {
        this.checkWidget();
        int[] nArray = new int[3];
        nArray[0] = 2001;
        int[] args = nArray;
        OS.PtGetResources(this.handle, args.length / 3, args);
        return Color.photon_new(this.display, args[1]);
    }

    public int getBorderWidth() {
        this.checkWidget();
        int topHandle = this.topHandle();
        int[] nArray = new int[6];
        nArray[0] = 2015;
        nArray[3] = 1006;
        int[] args = nArray;
        OS.PtGetResources(topHandle, args.length / 3, args);
        if ((args[4] & 0x100) == 0) {
            return 0;
        }
        int border = 0;
        int flags = args[1];
        if ((flags & 0xF) != 0) {
            ++border;
        }
        if ((flags & 0xF0) != 0) {
            ++border;
        }
        if ((flags & 0xF000) != 0) {
            ++border;
        }
        return border;
    }

    public Rectangle getBounds() {
        this.checkWidget();
        int topHandle = this.topHandle();
        PhArea_t area = new PhArea_t();
        OS.PtWidgetArea(topHandle, area);
        return new Rectangle(area.pos_x, area.pos_y, area.size_w, area.size_h);
    }

    public Cursor getCursor() {
        this.checkWidget();
        return this.cursor;
    }

    public boolean getDragDetect() {
        this.checkWidget();
        return true;
    }

    public boolean getEnabled() {
        this.checkWidget();
        return (this.state & 0x10) == 0;
    }

    public Object getLayoutData() {
        this.checkWidget();
        return this.layoutData;
    }

    public Point getLocation() {
        this.checkWidget();
        int topHandle = this.topHandle();
        PhArea_t area = new PhArea_t();
        OS.PtWidgetArea(topHandle, area);
        return new Point(area.pos_x, area.pos_y);
    }

    public Menu getMenu() {
        this.checkWidget();
        return this.menu;
    }

    public Monitor getMonitor() {
        this.checkWidget();
        Monitor[] monitors = this.display.getMonitors();
        if (monitors.length == 1) {
            return monitors[0];
        }
        int index = -1;
        int value = -1;
        Rectangle bounds = this.getBounds();
        if (this != this.getShell()) {
            bounds = this.display.map((Control)this.parent, null, bounds);
        }
        int i = 0;
        while (i < monitors.length) {
            Rectangle rect = bounds.intersection(monitors[i].getBounds());
            int area = rect.width * rect.height;
            if (area > 0 && area > value) {
                index = i;
                value = area;
            }
            ++i;
        }
        if (index >= 0) {
            return monitors[index];
        }
        int centerX = bounds.x + bounds.width / 2;
        int centerY = bounds.y + bounds.height / 2;
        int i2 = 0;
        while (i2 < monitors.length) {
            int x;
            Rectangle rect = monitors[i2].getBounds();
            int n = centerX < rect.x ? rect.x - centerX : (x = centerX > rect.x + rect.width ? centerX - rect.x - rect.width : 0);
            int y = centerY < rect.y ? rect.y - centerY : (centerY > rect.y + rect.height ? centerY - rect.y - rect.height : 0);
            int distance = x * x + y * y;
            if (index == -1 || distance < value) {
                index = i2;
                value = distance;
            }
            ++i2;
        }
        return monitors[index];
    }

    public Composite getParent() {
        this.checkWidget();
        return this.parent;
    }

    Control[] getPath() {
        int count = 0;
        Shell shell = this.getShell();
        Control control = this;
        while (control != shell) {
            ++count;
            control = control.parent;
        }
        control = this;
        Control[] result = new Control[count];
        while (control != shell) {
            result[--count] = control;
            control = control.parent;
        }
        return result;
    }

    public Point getSize() {
        this.checkWidget();
        int topHandle = this.topHandle();
        PhArea_t area = new PhArea_t();
        OS.PtWidgetArea(topHandle, area);
        return new Point(area.size_w, area.size_h);
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.toolTipText;
    }

    public Region getRegion() {
        this.checkWidget();
        return this.region;
    }

    public Shell getShell() {
        this.checkWidget();
        return this.parent.getShell();
    }

    public boolean getVisible() {
        this.checkWidget();
        int topHandle = this.topHandle();
        return (OS.PtWidgetFlags(topHandle) & 0x40) == 0;
    }

    boolean hasFocus() {
        return OS.PtIsFocused(this.handle) != 0;
    }

    void hookEvents() {
        int windowProc = this.display.windowProc;
        int focusHandle = this.focusHandle();
        OS.PtAddFilterCallback(this.handle, 1, windowProc, 1);
        OS.PtAddEventHandler(this.handle, 2, windowProc, 2);
        OS.PtAddEventHandler(this.handle, 4, windowProc, 4);
        OS.PtAddEventHandler(this.handle, 24, windowProc, 24);
        OS.PtAddEventHandler(this.handle, 32, windowProc, 32);
        if ((this.state & 0x80) != 0) {
            OS.PtAddEventHandler(this.handle, 512, windowProc, 512);
            OS.PtAddCallback(this.handle, 1022, windowProc, 1022);
        }
        OS.PtAddCallback(focusHandle, 2010, windowProc, 2010);
        OS.PtAddCallback(focusHandle, 2011, windowProc, 2011);
    }

    int focusHandle() {
        return this.handle;
    }

    public int internal_new_GC(GCData data) {
        int mask;
        this.checkWidget();
        int phGC = OS.PgCreateGC(0);
        if (phGC == 0) {
            SWT.error(2);
        }
        if ((data.style & (mask = 0x6000000)) == 0) {
            data.style |= this.style & (mask | 0x8000000);
        }
        int[] nArray = new int[6];
        nArray[0] = 2001;
        nArray[3] = 2002;
        int[] args = nArray;
        OS.PtGetResources(this.handle, args.length / 3, args);
        data.device = this.display;
        data.widget = this.handle;
        int disjoint = OS.PtFindDisjoint(this.handle);
        if (disjoint != 0) {
            OS.PgSetRegion(OS.PtWidgetRid(disjoint));
        }
        data.topWidget = this.topHandle();
        data.foreground = args[1];
        data.background = args[4];
        data.font = this.getFont();
        return phGC;
    }

    public void internal_dispose_GC(int phGC, GCData data) {
        this.checkWidget();
        OS.PgDestroyGC(phGC);
    }

    public boolean isEnabled() {
        this.checkWidget();
        return this.getEnabled() && this.parent.isEnabled();
    }

    public boolean isFocusControl() {
        this.checkWidget();
        return this.hasFocus();
    }

    public boolean isReparentable() {
        this.checkWidget();
        return false;
    }

    boolean isShowing() {
        if (!this.isVisible()) {
            return false;
        }
        Control control = this;
        while (control != null) {
            Point size = control.getSize();
            if (size.x == 0 || size.y == 0) {
                return false;
            }
            control = control.parent;
        }
        return true;
    }

    boolean isTabGroup() {
        int code;
        Control[] tabList = this.parent._getTabList();
        if (tabList != null) {
            int i = 0;
            while (i < tabList.length) {
                if (tabList[i] == this) {
                    return true;
                }
                ++i;
            }
        }
        if (((code = this.traversalCode(0, null)) & 0x60) != 0) {
            return false;
        }
        return (code & 0x18) != 0;
    }

    boolean isTabItem() {
        int code;
        Control[] tabList = this.parent._getTabList();
        if (tabList != null) {
            int i = 0;
            while (i < tabList.length) {
                if (tabList[i] == this) {
                    return false;
                }
                ++i;
            }
        }
        return ((code = this.traversalCode(0, null)) & 0x60) != 0;
    }

    public boolean isVisible() {
        this.checkWidget();
        return OS.PtWidgetIsRealized(this.handle);
    }

    void markLayout(boolean changed, boolean all) {
    }

    Decorations menuShell() {
        return this.parent.menuShell();
    }

    public void moveAbove(Control control) {
        this.checkWidget();
        int topHandle1 = this.topHandle();
        if (control == null) {
            OS.PtWidgetToFront(topHandle1);
            OS.PtWindowToFront(topHandle1);
            return;
        }
        if (control.isDisposed()) {
            Control.error(5);
        }
        if (this.parent != control.parent) {
            return;
        }
        int topHandle2 = control.topHandle();
        OS.PtWidgetInsert(topHandle1, topHandle2, 0);
    }

    public void moveBelow(Control control) {
        this.checkWidget();
        int topHandle1 = this.topHandle();
        if (control == null) {
            if (this.parent != null) {
                this.parent.moveToBack(topHandle1);
            }
            OS.PtWindowToBack(topHandle1);
            return;
        }
        if (control.isDisposed()) {
            Control.error(5);
        }
        if (this.parent != control.parent) {
            return;
        }
        int topHandle2 = control.topHandle();
        OS.PtWidgetInsert(topHandle1, topHandle2, 1);
    }

    public void pack() {
        this.checkWidget();
        this.pack(true);
    }

    public void pack(boolean changed) {
        this.checkWidget();
        this.setSize(this.computeSize(-1, -1, changed));
    }

    public boolean print(GC gc) {
        this.checkWidget();
        if (gc == null) {
            Control.error(4);
        }
        if (gc.isDisposed()) {
            Control.error(5);
        }
        return false;
    }

    int Ph_EV_BOUNDARY(int widget, int info) {
        if (info == 0) {
            return 2;
        }
        PtCallbackInfo_t cbinfo = new PtCallbackInfo_t();
        OS.memmove(cbinfo, info, 16);
        if (cbinfo.event == 0) {
            return 2;
        }
        PhEvent_t ev = new PhEvent_t();
        OS.memmove(ev, cbinfo.event, 40);
        int data = OS.PhGetData(cbinfo.event);
        if (data == 0) {
            return 2;
        }
        PhPointerEvent_t pe = new PhPointerEvent_t();
        OS.memmove(pe, data, 20);
        switch (ev.subtype) {
            case 0: 
            case 4: {
                Event event = new Event();
                event.time = ev.timestamp;
                this.setMouseState(event, 6, pe, ev);
                this.sendEvent(6, event);
                break;
            }
            case 1: 
            case 5: {
                Event event = new Event();
                event.time = ev.timestamp;
                this.setMouseState(event, 7, pe, ev);
                this.sendEvent(7, event);
                break;
            }
            case 2: {
                Event event = new Event();
                event.time = ev.timestamp;
                this.setMouseState(event, 32, pe, ev);
                this.postEvent(32, event);
                this.destroyToolTip(this.toolTipHandle);
                this.toolTipHandle = this.createToolTip(this.toolTipText, this.handle, this.getFont().handle);
                break;
            }
            case 3: {
                this.destroyToolTip(this.toolTipHandle);
                this.toolTipHandle = 0;
            }
        }
        return 2;
    }

    int Ph_EV_BUT_PRESS(int widget, int info) {
        if (info == 0) {
            return 2;
        }
        PtCallbackInfo_t cbinfo = new PtCallbackInfo_t();
        OS.memmove(cbinfo, info, 16);
        if (cbinfo.event == 0) {
            return 2;
        }
        PhEvent_t ev = new PhEvent_t();
        OS.memmove(ev, cbinfo.event, 40);
        if ((ev.processing_flags & 1) != 0) {
            return 0;
        }
        ev.processing_flags = (short)(ev.processing_flags | 4);
        OS.memmove(cbinfo.event, ev, 40);
        int data = OS.PhGetData(cbinfo.event);
        if (data == 0) {
            return 2;
        }
        PhPointerEvent_t pe = new PhPointerEvent_t();
        OS.memmove(pe, data, 20);
        Event event = new Event();
        event.count = pe.click_count;
        event.time = ev.timestamp;
        this.setMouseState(event, 3, pe, ev);
        this.postEvent(3, event);
        if (pe.click_count == 2) {
            Event clickEvent = new Event();
            clickEvent.count = pe.click_count;
            clickEvent.time = ev.timestamp;
            this.setMouseState(clickEvent, 8, pe, ev);
            this.postEvent(8, clickEvent);
        }
        if (event.button == 3) {
            Event menuEvent = new Event();
            menuEvent.x = pe.pos_x;
            menuEvent.y = pe.pos_y;
            this.sendEvent(35, menuEvent);
            if (menuEvent.doit && this.menu != null && !this.menu.isDisposed()) {
                if (menuEvent.x != event.x || menuEvent.y != event.y) {
                    this.menu.setLocation(menuEvent.x, menuEvent.y);
                }
                this.menu.setVisible(true);
            }
        }
        this.display.dragStartX = pe.pos_x + ev.translation_x;
        this.display.dragStartY = pe.pos_y + ev.translation_y;
        Shell shell = this.getShell();
        if (!shell.isDisposed()) {
            shell.setActiveControl(this);
        }
        return 0;
    }

    int Ph_EV_BUT_RELEASE(int widget, int info) {
        if (info == 0) {
            return 2;
        }
        PtCallbackInfo_t cbinfo = new PtCallbackInfo_t();
        OS.memmove(cbinfo, info, 16);
        if (cbinfo.event == 0) {
            return 2;
        }
        PhEvent_t ev = new PhEvent_t();
        OS.memmove(ev, cbinfo.event, 40);
        if ((ev.processing_flags & 1) != 0) {
            return 0;
        }
        ev.processing_flags = (short)(ev.processing_flags | 4);
        OS.memmove(cbinfo.event, ev, 40);
        if (ev.subtype != 1) {
            return 0;
        }
        int data = OS.PhGetData(cbinfo.event);
        if (data == 0) {
            return 2;
        }
        PhPointerEvent_t pe = new PhPointerEvent_t();
        OS.memmove(pe, data, 20);
        Event event = new Event();
        event.count = pe.click_count;
        event.time = ev.timestamp;
        this.setMouseState(event, 4, pe, ev);
        this.postEvent(4, event);
        return 0;
    }

    int Ph_EV_DRAG(int widget, int info) {
        if (info == 0) {
            return 2;
        }
        PtCallbackInfo_t cbinfo = new PtCallbackInfo_t();
        OS.memmove(cbinfo, info, 16);
        if (cbinfo.event == 0) {
            return 2;
        }
        PhEvent_t ev = new PhEvent_t();
        OS.memmove(ev, cbinfo.event, 40);
        if ((ev.processing_flags & 1) != 0) {
            return 0;
        }
        if (ev.subtype != 4) {
            return 0;
        }
        int data = OS.PhGetData(cbinfo.event);
        if (data == 0) {
            return 2;
        }
        PhPointerEvent_t pe = new PhPointerEvent_t();
        OS.memmove(pe, data, 20);
        Event event = new Event();
        event.time = ev.timestamp;
        this.setMouseState(event, 5, pe, ev);
        this.postEvent(5, event);
        return 0;
    }

    int Ph_EV_KEY(int widget, int info) {
        if (!this.hasFocus()) {
            return 0;
        }
        if (info == 0) {
            return 0;
        }
        PtCallbackInfo_t cbinfo = new PtCallbackInfo_t();
        OS.memmove(cbinfo, info, 16);
        if (cbinfo.event == 0) {
            return 0;
        }
        PhEvent_t ev = new PhEvent_t();
        OS.memmove(ev, cbinfo.event, 40);
        if ((ev.processing_flags & 1) != 0) {
            return 0;
        }
        int data = OS.PhGetData(cbinfo.event);
        if (data == 0) {
            return 0;
        }
        PhKeyEvent_t ke = new PhKeyEvent_t();
        OS.memmove(ke, data, PhKeyEvent_t.sizeof);
        if (ke.key_flags == 32) {
            return 0;
        }
        if ((ke.key_flags & 2) != 0 && (ke.key_flags & 0x40) != 0) {
            switch (ke.key_sym) {
                case 61665: 
                case 61666: 
                case 61667: 
                case 61668: 
                case 61673: 
                case 61674: {
                    return 0;
                }
            }
        }
        int type = 2;
        if ((ke.key_flags & 3) != 0) {
            type = 1;
        }
        if (type == 1) {
            int key = ke.key_sym;
            if ((ke.key_flags & 0x40) == 0) {
                key = 0;
                if ((ke.key_flags & 0x80) != 0 && ke.key_cap == 61449 && (ke.key_mods & 2) != 0) {
                    key = 61449;
                }
            }
            switch (key) {
                case 61449: 
                case 61453: 
                case 61467: 
                case 61521: 
                case 61522: 
                case 61523: 
                case 61524: 
                case 61525: 
                case 61526: 
                case 61577: {
                    if (key != 61453) {
                        ev.processing_flags = (short)(ev.processing_flags | 0x10);
                        OS.memmove(cbinfo.event, ev, 40);
                    }
                    if (this.translateTraversal(key, ke)) {
                        ev.processing_flags = (short)(ev.processing_flags | 4);
                        OS.memmove(cbinfo.event, ev, 40);
                        return 0;
                    }
                    if (!this.isDisposed()) break;
                    return 2;
                }
            }
        }
        Event event = new Event();
        event.time = ev.timestamp;
        if (!this.setKeyState(event, type, ke)) {
            return 0;
        }
        if (type == 1) {
            this.display.lastKey = event.keyCode;
            this.display.lastAscii = event.character;
        } else {
            if (event.keyCode == 0) {
                event.keyCode = this.display.lastKey;
            }
            if (event.character == '\u0000') {
                event.character = (char)this.display.lastAscii;
            }
        }
        this.sendEvent(type, event);
        if (this.isDisposed()) {
            return 2;
        }
        return event.doit ? 0 : 2;
    }

    int Ph_EV_PTR_MOTION(int widget, int info) {
        if (info == 0) {
            return 2;
        }
        PtCallbackInfo_t cbinfo = new PtCallbackInfo_t();
        OS.memmove(cbinfo, info, 16);
        if (cbinfo.event == 0) {
            return 2;
        }
        PhEvent_t ev = new PhEvent_t();
        OS.memmove(ev, cbinfo.event, 40);
        if ((ev.processing_flags & 1) != 0) {
            return 0;
        }
        ev.processing_flags = (short)(ev.processing_flags | 4);
        OS.memmove(cbinfo.event, ev, 40);
        if (ev.type == 16 && (this.state & 2) != 0) {
            return 0;
        }
        int data = OS.PhGetData(cbinfo.event);
        if (data == 0) {
            return 2;
        }
        PhPointerEvent_t pe = new PhPointerEvent_t();
        OS.memmove(pe, data, 20);
        Event event = new Event();
        event.time = ev.timestamp;
        this.setMouseState(event, 5, pe, ev);
        this.postEvent(5, event);
        return 0;
    }

    int Pt_CB_GOT_FOCUS(int widget, int info) {
        Shell shell = this.getShell();
        this.sendEvent(15);
        if (this.isDisposed()) {
            return 0;
        }
        if (!shell.isDisposed()) {
            shell.setActiveControl(this);
        }
        return 0;
    }

    int Pt_CB_LOST_FOCUS(int widget, int info) {
        Display display;
        Control control;
        Shell shell = this.getShell();
        this.sendEvent(16);
        if (this.isDisposed()) {
            return 0;
        }
        if (!(shell.isDisposed() || (control = (display = shell.display).getFocusControl()) != null && shell == control.getShell())) {
            shell.setActiveControl(null);
        }
        return 0;
    }

    void realizeWidget() {
        int parentHandle = this.parent.handle;
        if (OS.PtWidgetIsRealized(parentHandle)) {
            OS.PtRealizeWidget(this.topHandle());
        }
    }

    void releaseHandle() {
        super.releaseHandle();
        this.parent = null;
    }

    void releaseParent() {
        super.releaseParent();
        this.parent.removeControl(this);
    }

    void releaseWidget() {
        super.releaseWidget();
        if (this.toolTipHandle != 0) {
            this.destroyToolTip(this.toolTipHandle);
        }
        this.toolTipHandle = 0;
        if (this.menu != null && !this.menu.isDisposed()) {
            this.menu.dispose();
        }
        this.menu = null;
        this.cursor = null;
        this.layoutData = null;
        this.region = null;
    }

    public void redraw() {
        this.checkWidget();
        OS.PtDamageWidget(this.handle);
    }

    public void redraw(int x, int y, int width, int height, boolean allChildren) {
        this.checkWidget();
        if (width <= 0 || height <= 0) {
            return;
        }
        PhRect_t rect = new PhRect_t();
        rect.ul_x = (short)x;
        rect.ul_y = (short)y;
        rect.lr_x = (short)(x + width - 1);
        rect.lr_y = (short)(y + height - 1);
        OS.PtDamageExtent(this.handle, rect);
    }

    public void removeControlListener(ControlListener listener) {
        this.checkWidget();
        if (listener == null) {
            Control.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(10, listener);
        this.eventTable.unhook(11, listener);
    }

    public void removeDragDetectListener(DragDetectListener listener) {
        this.checkWidget();
        if (listener == null) {
            Control.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(29, listener);
    }

    public void removeFocusListener(FocusListener listener) {
        this.checkWidget();
        if (listener == null) {
            Control.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(15, listener);
        this.eventTable.unhook(16, listener);
    }

    public void removeHelpListener(HelpListener listener) {
        this.checkWidget();
        if (listener == null) {
            Control.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(28, listener);
    }

    public void removeKeyListener(KeyListener listener) {
        this.checkWidget();
        if (listener == null) {
            Control.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(2, listener);
        this.eventTable.unhook(1, listener);
    }

    public void removeMenuDetectListener(MenuDetectListener listener) {
        this.checkWidget();
        if (listener == null) {
            Control.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(35, listener);
    }

    public void removeMouseListener(MouseListener listener) {
        this.checkWidget();
        if (listener == null) {
            Control.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(3, listener);
        this.eventTable.unhook(4, listener);
        this.eventTable.unhook(8, listener);
    }

    public void removeMouseMoveListener(MouseMoveListener listener) {
        this.checkWidget();
        if (listener == null) {
            Control.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(5, listener);
    }

    public void removeMouseTrackListener(MouseTrackListener listener) {
        this.checkWidget();
        if (listener == null) {
            Control.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(6, listener);
        this.eventTable.unhook(7, listener);
        this.eventTable.unhook(32, listener);
    }

    public void removeMouseWheelListener(MouseWheelListener listener) {
        this.checkWidget();
        if (listener == null) {
            Control.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(37, listener);
    }

    public void removePaintListener(PaintListener listener) {
        this.checkWidget();
        if (listener == null) {
            Control.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(9, listener);
    }

    public void removeTraverseListener(TraverseListener listener) {
        this.checkWidget();
        if (listener == null) {
            Control.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(31, listener);
    }

    int setBounds(int x, int y, int width, int height, boolean move, boolean resize, boolean events) {
        boolean sameExtent;
        int topHandle = this.topHandle();
        PhArea_t area = new PhArea_t();
        OS.PtWidgetArea(topHandle, area);
        width = Math.max(width, 0);
        height = Math.max(height, 0);
        boolean sameOrigin = x == area.pos_x && y == area.pos_y;
        boolean bl = sameExtent = width == area.size_w && height == area.size_h;
        if (move && resize) {
            if (sameOrigin && sameExtent) {
                return 0;
            }
            area.pos_x = (short)x;
            area.pos_y = (short)y;
            area.size_w = (short)width;
            area.size_h = (short)height;
            int ptr = OS.malloc(8);
            OS.memmove(ptr, area, 8);
            OS.PtSetResource(topHandle, 1000, ptr, 0);
            OS.free(ptr);
        } else if (move) {
            if (sameOrigin) {
                return 0;
            }
            PhPoint_t pt = new PhPoint_t();
            pt.x = (short)x;
            pt.y = (short)y;
            int ptr = OS.malloc(4);
            OS.memmove(ptr, pt, 4);
            OS.PtSetResource(topHandle, 1007, ptr, 0);
            OS.free(ptr);
        } else if (resize) {
            if (sameExtent) {
                return 0;
            }
            int[] nArray = new int[6];
            nArray[0] = 1023;
            nArray[1] = width;
            nArray[3] = 1024;
            nArray[4] = height;
            int[] args = nArray;
            OS.PtSetResources(topHandle, args.length / 3, args);
        }
        if (!OS.PtWidgetIsRealized(topHandle)) {
            OS.PtExtentWidgetFamily(topHandle);
        }
        int result = 0;
        if (move && !sameOrigin) {
            this.sendEvent(10);
            result |= 0x20;
        }
        if (resize && !sameExtent) {
            this.sendEvent(11);
            result |= 0x40;
        }
        return result;
    }

    public void setBounds(int x, int y, int width, int height) {
        this.checkWidget();
        this.setBounds(x, y, width, height, true, true, true);
    }

    public void setBounds(Rectangle rect) {
        if (rect == null) {
            Control.error(4);
        }
        this.setBounds(rect.x, rect.y, rect.width, rect.height);
    }

    public void setCapture(boolean capture) {
        this.checkWidget();
    }

    public void setCursor(Cursor cursor) {
        this.checkWidget();
        int type = 0;
        int bitmap = 0;
        if (cursor != null) {
            if (cursor.isDisposed()) {
                SWT.error(5);
            }
            type = cursor.type;
            bitmap = cursor.bitmap;
        }
        this.cursor = cursor;
        int[] nArray = new int[6];
        nArray[0] = 1002;
        nArray[1] = type;
        nArray[3] = 1017;
        nArray[4] = bitmap;
        int[] args = nArray;
        OS.PtSetResources(this.handle, args.length / 3, args);
        if (type == 251) {
            OS.PtSetResource(this.handle, 1002, type &= 0xFFFFFFFE, 0);
        }
    }

    public void setDragDetect(boolean dragDetect) {
        this.checkWidget();
    }

    public void setEnabled(boolean enabled) {
        this.checkWidget();
        if (enabled) {
            if ((this.state & 0x10) == 0) {
                return;
            }
            this.state &= 0xFFFFFFEF;
        } else {
            if ((this.state & 0x10) != 0) {
                return;
            }
            this.state |= 0x10;
        }
        this.enableWidget(enabled);
    }

    public boolean setFocus() {
        this.checkWidget();
        if ((this.style & 0x80000) != 0) {
            return false;
        }
        return this.forceFocus();
    }

    public void setBackground(Color color) {
        int pixel;
        this.checkWidget();
        if (color == null) {
            pixel = this.defaultBackground();
        } else {
            if (color.isDisposed()) {
                SWT.error(5);
            }
            pixel = color.handle;
        }
        this.setBackgroundPixel(pixel);
    }

    public void setBackgroundImage(Image image) {
        this.checkWidget();
        if (image != null) {
            if (image.isDisposed()) {
                Control.error(5);
            }
            if (image.type != 0) {
                Control.error(5);
            }
        }
        if (this.backgroundImage == image) {
            return;
        }
        this.backgroundImage = image;
    }

    void setBackgroundPixel(int pixel) {
        OS.PtSetResource(this.handle, 2002, pixel, 0);
    }

    void setDefaultFont() {
        if (this.display.defaultFont != null) {
            this.setFont(this.defaultFont());
        }
    }

    public void setFont(Font font) {
        byte[] buffer;
        this.checkWidget();
        if (font != null) {
            if (font.isDisposed()) {
                SWT.error(5);
            }
            buffer = font.handle;
        } else {
            buffer = this.defaultFont();
        }
        this.font = font;
        this.setFont(buffer);
    }

    void setFont(byte[] font) {
        int ptr = OS.malloc(font.length);
        OS.memmove(ptr, font, font.length);
        this.setFont(ptr);
        OS.free(ptr);
    }

    void setFont(int font) {
        int[] nArray = new int[12];
        nArray[0] = 3010;
        nArray[1] = font;
        nArray[3] = 23003;
        nArray[4] = font;
        nArray[6] = 10008;
        nArray[7] = font;
        nArray[9] = 21001;
        nArray[10] = font;
        int[] args = nArray;
        OS.PtSetResources(this.handle, args.length / 3, args);
    }

    public void setForeground(Color color) {
        int pixel;
        this.checkWidget();
        if (color == null) {
            pixel = this.defaultForeground();
        } else {
            if (color.isDisposed()) {
                SWT.error(5);
            }
            pixel = color.handle;
        }
        this.setForegroundPixel(pixel);
    }

    void setForegroundPixel(int pixel) {
        OS.PtSetResource(this.handle, 2001, pixel, 0);
    }

    public void setLayoutData(Object layoutData) {
        this.checkWidget();
        this.layoutData = layoutData;
    }

    public void setLocation(int x, int y) {
        this.checkWidget();
        this.setBounds(x, y, 0, 0, true, false, true);
    }

    public void setLocation(Point location) {
        this.checkWidget();
        if (location == null) {
            Control.error(4);
        }
        this.setLocation(location.x, location.y);
    }

    public void setMenu(Menu menu) {
        this.checkWidget();
        int flags = 0;
        if (menu != null) {
            if (menu.isDisposed()) {
                SWT.error(5);
            }
            flags = 0x8000000;
        }
        OS.PtSetResource(this.handle, 1006, flags, 0x8800000);
        this.menu = menu;
    }

    public boolean setParent(Composite parent) {
        this.checkWidget();
        if (parent.isDisposed()) {
            SWT.error(5);
        }
        return false;
    }

    public void setSize(Point size) {
        this.checkWidget();
        if (size == null) {
            Control.error(4);
        }
        this.setSize(size.x, size.y);
    }

    boolean setTabGroupFocus() {
        return this.setTabItemFocus();
    }

    boolean setTabItemFocus() {
        if (!this.isShowing()) {
            return false;
        }
        return this.forceFocus();
    }

    boolean setRadioSelection(boolean value) {
        return false;
    }

    public void setRedraw(boolean redraw) {
        this.checkWidget();
        if (redraw) {
            OS.PtContainerRelease(this.handle);
        } else {
            OS.PtContainerHold(this.handle);
        }
    }

    public void setRegion(Region region) {
        this.checkWidget();
        if (region != null && region.isDisposed()) {
            Control.error(5);
        }
        this.region = region;
    }

    public void setSize(int width, int height) {
        this.checkWidget();
        this.setBounds(0, 0, width, height, false, true, true);
    }

    public void setVisible(boolean visible) {
        this.checkWidget();
        int topHandle = this.topHandle();
        int oldFlags = OS.PtWidgetFlags(topHandle);
        int flags = visible ? 0 : 64;
        OS.PtSetResource(topHandle, 1006, flags, 64);
        if ((oldFlags & 0x40) == flags) {
            return;
        }
        if (visible) {
            this.sendEvent(22);
            if (this.isDisposed()) {
                return;
            }
            OS.PtRealizeWidget(topHandle);
        } else {
            OS.PtUnrealizeWidget(topHandle);
            if (this.isDisposed()) {
                return;
            }
            this.sendEvent(23);
        }
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        this.toolTipText = string;
    }

    void setZOrder() {
        if (this.parent != null) {
            this.parent.moveToBack(this.topHandle());
        }
    }

    void sort(int[] items) {
        int length = items.length;
        int gap = length / 2;
        while (gap > 0) {
            int i = gap;
            while (i < length) {
                int j = i - gap;
                while (j >= 0) {
                    if (items[j] <= items[j + gap]) {
                        int swap = items[j];
                        items[j] = items[j + gap];
                        items[j + gap] = swap;
                    }
                    j -= gap;
                }
                ++i;
            }
            gap /= 2;
        }
    }

    public Point toControl(int x, int y) {
        this.checkWidget();
        short[] position_x = new short[1];
        short[] position_y = new short[1];
        OS.PtGetAbsPosition(this.handle, position_x, position_y);
        return new Point(x - position_x[0], y - position_y[0]);
    }

    public Point toControl(Point point) {
        this.checkWidget();
        if (point == null) {
            Control.error(4);
        }
        return this.toControl(point.x, point.y);
    }

    public Point toDisplay(int x, int y) {
        this.checkWidget();
        short[] position_x = new short[1];
        short[] position_y = new short[1];
        OS.PtGetAbsPosition(this.handle, position_x, position_y);
        return new Point(x + position_x[0], y + position_y[0]);
    }

    public Point toDisplay(Point point) {
        this.checkWidget();
        if (point == null) {
            Control.error(4);
        }
        return this.toDisplay(point.x, point.y);
    }

    boolean translateTraversal(int key_sym, PhKeyEvent_t phEvent) {
        int detail = 0;
        int code = this.traversalCode(key_sym, phEvent);
        boolean all = false;
        switch (key_sym) {
            case 61467: {
                all = true;
                detail = 2;
                break;
            }
            case 61453: {
                all = true;
                detail = 4;
                break;
            }
            case 61449: 
            case 61577: {
                boolean next = (phEvent.key_mods & 1) == 0;
                detail = next ? 16 : 8;
                break;
            }
            case 61521: 
            case 61522: {
                detail = 32;
                break;
            }
            case 61523: 
            case 61524: {
                detail = 64;
                break;
            }
            case 61525: 
            case 61526: {
                all = true;
                if ((phEvent.key_mods & 2) == 0) {
                    return false;
                }
                detail = key_sym == 61526 ? 512 : 256;
                break;
            }
            default: {
                return false;
            }
        }
        Event event = new Event();
        event.doit = (code & detail) != 0;
        event.detail = detail;
        if (!this.setKeyState(event, 31, phEvent)) {
            return false;
        }
        Shell shell = this.getShell();
        Control control = this;
        do {
            if (control.traverse(event)) {
                return true;
            }
            if (!event.doit && control.hooks(31)) {
                return false;
            }
            if (control == shell) {
                return false;
            }
            control = control.parent;
        } while (all && control != null);
        return false;
    }

    int traversalCode(int key_sym, PhKeyEvent_t ke) {
        int code = 28;
        Shell shell = this.getShell();
        if (shell.parent != null) {
            code |= 2;
        }
        return code;
    }

    boolean traverse(Event event) {
        this.sendEvent(31, event);
        if (this.isDisposed()) {
            return true;
        }
        if (!event.doit) {
            return false;
        }
        switch (event.detail) {
            case 0: {
                return true;
            }
            case 2: {
                return this.traverseEscape();
            }
            case 4: {
                return this.traverseReturn();
            }
            case 16: {
                return this.traverseGroup(true);
            }
            case 8: {
                return this.traverseGroup(false);
            }
            case 64: {
                return this.traverseItem(true);
            }
            case 32: {
                return this.traverseItem(false);
            }
            case 128: {
                return this.traverseMnemonic(event.character);
            }
            case 512: {
                return this.traversePage(true);
            }
            case 256: {
                return this.traversePage(false);
            }
        }
        return false;
    }

    public boolean traverse(int traversal) {
        this.checkWidget();
        Event event = new Event();
        event.doit = true;
        event.detail = traversal;
        return this.traverse(event);
    }

    boolean traverseEscape() {
        return false;
    }

    boolean traverseGroup(boolean next) {
        Control root = this.computeTabRoot();
        Control group = this.computeTabGroup();
        Control[] list = root.computeTabList();
        int length = list.length;
        int index = 0;
        while (index < length) {
            if (list[index] == group) break;
            ++index;
        }
        if (index == length) {
            return false;
        }
        int start = index;
        int offset = next ? 1 : -1;
        while ((index = (index + offset + length) % length) != start) {
            Control control = list[index];
            if (control.isDisposed() || !control.setTabGroupFocus()) continue;
            return true;
        }
        if (group.isDisposed()) {
            return false;
        }
        return group.setTabGroupFocus();
    }

    boolean traverseItem(boolean next) {
        Control[] children = this.parent._getChildren();
        int length = children.length;
        int index = 0;
        while (index < length) {
            if (children[index] == this) break;
            ++index;
        }
        if (index == length) {
            return false;
        }
        int start = index;
        int offset = next ? 1 : -1;
        while ((index = (index + offset + length) % length) != start) {
            Control child = children[index];
            if (child.isDisposed() || !child.isTabItem() || !child.setTabItemFocus()) continue;
            return true;
        }
        return false;
    }

    boolean traversePage(boolean next) {
        return false;
    }

    boolean traverseMnemonic(char key) {
        return false;
    }

    boolean traverseReturn() {
        return false;
    }

    public void update() {
        this.checkWidget();
        OS.PtFlush();
    }

    void updateLayout(boolean all) {
    }

    int widgetClass() {
        return 0;
    }
}

