/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.photon.OS;
import org.eclipse.swt.internal.photon.PhArea_t;
import org.eclipse.swt.internal.photon.PhEvent_t;
import org.eclipse.swt.internal.photon.PhKeyEvent_t;
import org.eclipse.swt.internal.photon.PhPoint_t;
import org.eclipse.swt.internal.photon.PhPointerEvent_t;
import org.eclipse.swt.internal.photon.PhRect_t;
import org.eclipse.swt.internal.photon.PtCallbackInfo_t;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.swt.widgets.WidgetTable;

public class Composite
extends Scrollable {
    Layout layout;
    Control[] tabList;
    int cornerHandle;
    int layoutCount;
    int backgroundMode;

    Composite() {
    }

    public Composite(Composite parent, int style) {
        super(parent, style);
    }

    static int checkStyle(int style) {
        return style &= 0x40000000;
    }

    Control[] _getChildren() {
        int count = 0;
        int parentHandle = this.parentingHandle();
        int child = OS.PtWidgetChildFront(parentHandle);
        while (child != 0) {
            child = OS.PtWidgetBrotherBehind(child);
            ++count;
        }
        Control[] children = new Control[count];
        int i = 0;
        int j = 0;
        child = OS.PtWidgetChildFront(parentHandle);
        while (i < count) {
            Widget widget = WidgetTable.get(child);
            if (widget != null && widget != this && widget instanceof Control) {
                children[j++] = (Control)widget;
            }
            ++i;
            child = OS.PtWidgetBrotherBehind(child);
        }
        if (i == j) {
            return children;
        }
        Control[] newChildren = new Control[j];
        System.arraycopy(children, 0, newChildren, 0, j);
        return newChildren;
    }

    Control[] _getTabList() {
        if (this.tabList == null) {
            return this.tabList;
        }
        int count = 0;
        int i = 0;
        while (i < this.tabList.length) {
            if (!this.tabList[i].isDisposed()) {
                ++count;
            }
            ++i;
        }
        if (count == this.tabList.length) {
            return this.tabList;
        }
        Control[] newList = new Control[count];
        int index = 0;
        int i2 = 0;
        while (i2 < this.tabList.length) {
            if (!this.tabList[i2].isDisposed()) {
                newList[index++] = this.tabList[i2];
            }
            ++i2;
        }
        this.tabList = newList;
        return this.tabList;
    }

    public void changed(Control[] changed) {
        this.checkWidget();
        if (changed == null) {
            Composite.error(5);
        }
        int i = 0;
        while (i < changed.length) {
            Control control = changed[i];
            if (control == null) {
                Composite.error(5);
            }
            if (control.isDisposed()) {
                Composite.error(5);
            }
            boolean ancestor = false;
            Composite composite = control.parent;
            while (composite != null) {
                boolean bl = ancestor = composite == this;
                if (ancestor) break;
                composite = composite.parent;
            }
            if (!ancestor) {
                Composite.error(32);
            }
            ++i;
        }
        i = 0;
        while (i < changed.length) {
            Control child = changed[i];
            Composite composite = child.parent;
            while (child != this) {
                if (composite.layout == null || !composite.layout.flushCache(child)) {
                    composite.state |= 0x200;
                }
                child = composite;
                composite = child.parent;
            }
            ++i;
        }
    }

    protected void checkSubclass() {
    }

    Control[] computeTabList() {
        Control[] result = super.computeTabList();
        if (result.length == 0) {
            return result;
        }
        Control[] list = this.tabList != null ? this._getTabList() : this._getChildren();
        int i = 0;
        while (i < list.length) {
            Control child = list[i];
            Control[] childList = child.computeTabList();
            if (childList.length != 0) {
                Control[] newResult = new Control[result.length + childList.length];
                System.arraycopy(result, 0, newResult, 0, result.length);
                System.arraycopy(childList, 0, newResult, result.length, childList.length);
                result = newResult;
            }
            ++i;
        }
        return result;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        Point size;
        this.checkWidget();
        if (this.layout != null) {
            if (wHint == -1 || hHint == -1) {
                size = this.layout.computeSize(this, wHint, hHint, changed |= (this.state & 0x200) != 0);
                this.state &= 0xFFFFFDFF;
            } else {
                size = new Point(wHint, hHint);
            }
        } else {
            size = this.minimumSize();
        }
        if (size.x == 0) {
            size.x = 64;
        }
        if (size.y == 0) {
            size.y = 64;
        }
        if (wHint != -1) {
            size.x = wHint;
        }
        if (hHint != -1) {
            size.y = hHint;
        }
        Rectangle trim = this.computeTrim(0, 0, size.x, size.y);
        return new Point(trim.width, trim.height);
    }

    void createHandle(int index) {
        this.state |= 0x8A;
        int parentHandle = this.parent.parentingHandle();
        this.createScrolledHandle(parentHandle);
    }

    void createScrollBars() {
        if (this.scrolledHandle == 0) {
            return;
        }
        if ((this.style & 0x100) != 0) {
            this.horizontalBar = new ScrollBar(this, 256);
        }
        if ((this.style & 0x200) != 0) {
            this.verticalBar = new ScrollBar(this, 512);
        }
    }

    byte[] defaultFont() {
        return this.display.TITLE_FONT;
    }

    void createScrolledHandle(int parentHandle) {
        int etches = 255;
        int[] nArray = new int[15];
        nArray[0] = 1006;
        nArray[1] = this.hasBorder() ? 256 : 0;
        nArray[2] = 256;
        nArray[3] = 2015;
        nArray[4] = this.hasBorder() ? etches : 0;
        nArray[5] = etches;
        nArray[6] = 10005;
        nArray[8] = 48;
        nArray[9] = 2002;
        nArray[10] = -1;
        nArray[12] = 1008;
        nArray[14] = 0x3F00000;
        int[] args = nArray;
        this.scrolledHandle = OS.PtCreateWidget(OS.PtContainer(), parentHandle, args.length / 3, args);
        if (this.scrolledHandle == 0) {
            Composite.error(2);
        }
        if ((this.style & 0x100) != 0 && (this.style & 0x200) != 0) {
            etches = 80;
            int[] nArray2 = new int[15];
            nArray2[0] = 1006;
            nArray2[1] = 256;
            nArray2[2] = 256;
            nArray2[3] = 2015;
            nArray2[4] = etches;
            nArray2[5] = etches;
            nArray2[6] = 1023;
            nArray2[7] = this.display.SCROLLBAR_WIDTH;
            nArray2[9] = 1024;
            nArray2[10] = this.display.SCROLLBAR_HEIGHT;
            nArray2[12] = 1008;
            nArray2[14] = 0x3F00000;
            args = nArray2;
            this.cornerHandle = OS.PtCreateWidget(OS.PtContainer(), this.scrolledHandle, args.length / 3, args);
        }
        int clazz = this.display.PtContainer;
        int[] nArray3 = new int[9];
        nArray3[0] = 1006;
        nArray3[1] = 524416;
        nArray3[2] = 524416;
        nArray3[3] = 10005;
        nArray3[5] = 48;
        nArray3[6] = 1008;
        nArray3[8] = 0x3F00000;
        args = nArray3;
        this.handle = OS.PtCreateWidget(clazz, this.scrolledHandle, args.length / 3, args);
        if (this.handle == 0) {
            Composite.error(2);
        }
        this.createScrollBars();
    }

    void drawBackground(GC gc, int x, int y, int width, int height) {
        Color oldColor = gc.getBackground();
        gc.setBackground(this.getBackground());
        gc.fillRectangle(x, y, width, height);
        gc.setBackground(oldColor);
    }

    void drawWidget(int widget, int damage) {
        if ((this.state & 2) != 0) {
            if ((this.style & 0x40000) == 0) {
                if (OS.QNX_MAJOR <= 6 && (OS.QNX_MAJOR != 6 || OS.QNX_MINOR <= 2 && (OS.QNX_MINOR != 2 || OS.QNX_MICRO < 1))) {
                    int clip_tile = this.getClipping(this.handle, this.topHandle(), true, true);
                    if (clip_tile == 0) {
                        return;
                    }
                    short[] abs_x = new short[1];
                    short[] abs_y = new short[1];
                    OS.PtGetAbsPosition(this.handle, abs_x, abs_y);
                    short[] dis_abs_x = new short[1];
                    short[] dis_abs_y = new short[1];
                    OS.PtGetAbsPosition(OS.PtFindDisjoint(this.handle), dis_abs_x, dis_abs_y);
                    PhPoint_t delta = new PhPoint_t();
                    delta.x = (short)(abs_x[0] - dis_abs_x[0]);
                    delta.y = (short)(abs_y[0] - dis_abs_y[0]);
                    OS.PhTranslateTiles(clip_tile, delta);
                    int[] clip_rects_count = new int[1];
                    int clip_rects = OS.PhTilesToRects(clip_tile, clip_rects_count);
                    OS.PhFreeTiles(clip_tile);
                    if (clip_rects_count[0] == 0) {
                        clip_rects_count[0] = 1;
                        OS.free(clip_rects);
                        clip_rects = OS.malloc(8);
                        OS.memset(clip_rects, 0, 8);
                    }
                    OS.PgSetMultiClip(clip_rects_count[0], clip_rects);
                    OS.free(clip_rects);
                }
                super.drawWidget(widget, damage);
                if (OS.QNX_MAJOR <= 6 && (OS.QNX_MAJOR != 6 || OS.QNX_MINOR <= 2 && (OS.QNX_MINOR != 2 || OS.QNX_MICRO < 1))) {
                    OS.PgSetMultiClip(0, 0);
                }
            }
        } else {
            super.drawWidget(widget, damage);
        }
    }

    Composite findDeferredControl() {
        return this.layoutCount > 0 ? this : this.parent.findDeferredControl();
    }

    void fixTabList(Control control) {
        if (this.tabList == null) {
            return;
        }
        int count = 0;
        int i = 0;
        while (i < this.tabList.length) {
            if (this.tabList[i] == control) {
                ++count;
            }
            ++i;
        }
        if (count == 0) {
            return;
        }
        Control[] newList = null;
        int length = this.tabList.length - count;
        if (length != 0) {
            newList = new Control[length];
            int index = 0;
            int i2 = 0;
            while (i2 < this.tabList.length) {
                if (this.tabList[i2] != control) {
                    newList[index++] = this.tabList[i2];
                }
                ++i2;
            }
        }
        this.tabList = newList;
    }

    public boolean forceFocus() {
        this.checkWidget();
        if ((this.state & 2) == 0) {
            return super.forceFocus();
        }
        int flags = OS.PtWidgetFlags(this.handle);
        OS.PtSetResource(this.handle, 1006, 1024, 1024);
        boolean result = super.forceFocus();
        OS.PtSetResource(this.handle, 1006, flags, 1024);
        return result;
    }

    public Rectangle getClientArea() {
        this.checkWidget();
        if (this.scrolledHandle == 0) {
            return super.getClientArea();
        }
        PhArea_t area = new PhArea_t();
        OS.PtWidgetArea(this.handle, area);
        return new Rectangle(area.pos_x, area.pos_y, area.size_w, area.size_h);
    }

    int getClipping(int widget, int topWidget, boolean clipChildren, boolean clipSiblings) {
        int basic_flags;
        int tile;
        int temp_widget;
        int child_tile = 0;
        int widget_tile = OS.PhGetTile();
        PhRect_t rect = new PhRect_t();
        int[] nArray = new int[6];
        nArray[0] = 1006;
        nArray[3] = 2015;
        int[] args = nArray;
        if (clipSiblings && OS.PtWidgetClass(topWidget) != OS.PtWindow()) {
            temp_widget = topWidget;
            while ((temp_widget = OS.PtWidgetBrotherInFront(temp_widget)) != 0) {
                if (!OS.PtWidgetIsRealized(temp_widget)) continue;
                tile = OS.PhGetTile();
                child_tile = child_tile == 0 ? tile : OS.PhAddMergeTiles(tile, child_tile, null);
                OS.PtWidgetExtent(temp_widget, tile);
                args[4] = 0;
                args[1] = 0;
                OS.PtGetResources(temp_widget, args.length / 3, args);
                if ((args[1] & 0x100) == 0) continue;
                basic_flags = args[4];
                OS.memmove(rect, tile, 8);
                if ((basic_flags & 1) != 0) {
                    rect.ul_y = (short)(rect.ul_y + 1);
                }
                if ((basic_flags & 2) != 0) {
                    rect.lr_y = (short)(rect.lr_y - 1);
                }
                if ((basic_flags & 8) != 0) {
                    rect.ul_x = (short)(rect.ul_x + 1);
                }
                if ((basic_flags & 4) != 0) {
                    rect.lr_x = (short)(rect.lr_x - 1);
                }
                OS.memmove(tile, rect, 8);
            }
            OS.PtWidgetCanvas(topWidget, widget_tile);
            OS.PhDeTranslateTiles(child_tile, widget_tile);
        }
        if (clipChildren) {
            temp_widget = OS.PtWidgetChildBack(widget);
            while (temp_widget != 0) {
                if (OS.PtWidgetIsRealized(temp_widget)) {
                    tile = OS.PhGetTile();
                    child_tile = child_tile == 0 ? tile : OS.PhAddMergeTiles(tile, child_tile, null);
                    OS.PtWidgetExtent(temp_widget, tile);
                    args[4] = 0;
                    args[1] = 0;
                    OS.PtGetResources(temp_widget, args.length / 3, args);
                    if ((args[1] & 0x100) != 0) {
                        basic_flags = args[4];
                        OS.memmove(rect, tile, 8);
                        if ((basic_flags & 1) != 0) {
                            rect.ul_y = (short)(rect.ul_y + 1);
                        }
                        if ((basic_flags & 2) != 0) {
                            rect.lr_y = (short)(rect.lr_y - 1);
                        }
                        if ((basic_flags & 8) != 0) {
                            rect.ul_x = (short)(rect.ul_x + 1);
                        }
                        if ((basic_flags & 4) != 0) {
                            rect.lr_x = (short)(rect.lr_x - 1);
                        }
                        OS.memmove(tile, rect, 8);
                    }
                }
                temp_widget = OS.PtWidgetBrotherInFront(temp_widget);
            }
        }
        OS.PtWidgetCanvas(widget, widget_tile);
        OS.PhDeTranslateTiles(widget_tile, widget_tile);
        if (child_tile != 0) {
            int clip_tile = OS.PhClipTilings(widget_tile, child_tile, null);
            OS.PhFreeTiles(child_tile);
            return clip_tile;
        }
        return widget_tile;
    }

    public int getBackgroundMode() {
        this.checkWidget();
        return this.backgroundMode;
    }

    public Control[] getChildren() {
        this.checkWidget();
        return this._getChildren();
    }

    int getChildrenCount() {
        int count = 0;
        int parentHandle = this.parentingHandle();
        int child = OS.PtWidgetChildFront(parentHandle);
        while (child != 0) {
            child = OS.PtWidgetBrotherBehind(child);
            ++count;
        }
        return count;
    }

    public Layout getLayout() {
        this.checkWidget();
        return this.layout;
    }

    public boolean getLayoutDeferred() {
        this.checkWidget();
        return this.layoutCount > 0;
    }

    boolean hasBorder() {
        return (this.style & 0x800) != 0;
    }

    boolean hasFocus() {
        return OS.PtIsFocused(this.handle) == 2;
    }

    boolean hooksKeys() {
        return this.hooks(1) || this.hooks(2);
    }

    public boolean isLayoutDeferred() {
        this.checkWidget();
        return this.findDeferredControl() != null;
    }

    public Control[] getTabList() {
        this.checkWidget();
        Control[] tabList = this._getTabList();
        if (tabList == null) {
            int count = 0;
            Control[] list = this._getChildren();
            int i = 0;
            while (i < list.length) {
                if (list[i].isTabGroup()) {
                    ++count;
                }
                ++i;
            }
            tabList = new Control[count];
            int index = 0;
            int i2 = 0;
            while (i2 < list.length) {
                if (list[i2].isTabGroup()) {
                    tabList[index++] = list[i2];
                }
                ++i2;
            }
        }
        return tabList;
    }

    public void layout() {
        this.checkWidget();
        this.layout(true);
    }

    public void layout(boolean changed) {
        this.checkWidget();
        if (this.layout == null) {
            return;
        }
        this.layout(changed, false);
    }

    public void layout(boolean changed, boolean all) {
        this.checkWidget();
        if (this.layout == null && !all) {
            return;
        }
        this.markLayout(changed, all);
        this.updateLayout(all);
    }

    public void layout(Control[] changed) {
        this.checkWidget();
        if (changed == null) {
            Composite.error(5);
        }
        int i = 0;
        while (i < changed.length) {
            Control control = changed[i];
            if (control == null) {
                Composite.error(5);
            }
            if (control.isDisposed()) {
                Composite.error(5);
            }
            boolean ancestor = false;
            Composite composite = control.parent;
            while (composite != null) {
                boolean bl = ancestor = composite == this;
                if (ancestor) break;
                composite = composite.parent;
            }
            if (!ancestor) {
                Composite.error(32);
            }
            ++i;
        }
        int updateCount = 0;
        Composite[] update = new Composite[16];
        int i2 = 0;
        while (i2 < changed.length) {
            Control child = changed[i2];
            Composite composite = child.parent;
            while (child != this) {
                if (composite.layout != null) {
                    composite.state |= 0x100;
                    if (!composite.layout.flushCache(child)) {
                        composite.state |= 0x200;
                    }
                }
                if (updateCount == update.length) {
                    Composite[] newUpdate = new Composite[update.length + 16];
                    System.arraycopy(update, 0, newUpdate, 0, update.length);
                    update = newUpdate;
                }
                int n = updateCount++;
                Composite composite2 = composite;
                update[n] = composite2;
                child = composite2;
                composite = child.parent;
            }
            ++i2;
        }
        i2 = updateCount - 1;
        while (i2 >= 0) {
            update[i2].updateLayout(false);
            --i2;
        }
    }

    void markLayout(boolean changed, boolean all) {
        if (this.layout != null) {
            this.state |= 0x100;
            if (changed) {
                this.state |= 0x200;
            }
        }
        if (all) {
            Control[] children = this._getChildren();
            int i = 0;
            while (i < children.length) {
                children[i].markLayout(changed, all);
                ++i;
            }
        }
    }

    Point minimumSize() {
        Control[] children = this._getChildren();
        int width = 0;
        int height = 0;
        int i = 0;
        while (i < children.length) {
            Rectangle rect = children[i].getBounds();
            width = Math.max(width, rect.x + rect.width);
            height = Math.max(height, rect.y + rect.height);
            ++i;
        }
        return new Point(width, height);
    }

    void moveToBack(int child) {
        OS.PtWidgetToBack(child);
    }

    int parentingHandle() {
        return this.handle;
    }

    int Ph_EV_BUT_PRESS(int widget, int info) {
        int result = super.Ph_EV_BUT_PRESS(widget, info);
        if (result != 0) {
            return result;
        }
        if ((this.state & 2) != 0 && (this.style & 0x80000) == 0 && this.hooksKeys() && OS.PtWidgetChildFront(this.handle) == 0) {
            if (info == 0) {
                return 2;
            }
            PtCallbackInfo_t cbinfo = new PtCallbackInfo_t();
            OS.memmove(cbinfo, info, 16);
            if (cbinfo.event == 0) {
                return 2;
            }
            PhEvent_t ev = new PhEvent_t();
            OS.memmove(ev, cbinfo.event, 40);
            int data = OS.PhGetData(cbinfo.event);
            if (data == 0) {
                return 2;
            }
            PhPointerEvent_t pe = new PhPointerEvent_t();
            OS.memmove(pe, data, 20);
            if (pe.buttons == 4) {
                this.setFocus();
            }
        }
        return result;
    }

    int Pt_CB_OUTBOUND(int widget, int info) {
        if ((this.state & 2) != 0) {
            if (info == 0) {
                return 2;
            }
            PtCallbackInfo_t cbinfo = new PtCallbackInfo_t();
            OS.memmove(cbinfo, info, 16);
            if (cbinfo.event == 0) {
                return 2;
            }
            PhEvent_t ev = new PhEvent_t();
            OS.memmove(ev, cbinfo.event, 40);
            int data = OS.PhGetData(cbinfo.event);
            if (data == 0) {
                return 2;
            }
            PhPointerEvent_t pe = new PhPointerEvent_t();
            OS.memmove(pe, data, 20);
            PhRect_t rect = new PhRect_t();
            PhPoint_t pos = new PhPoint_t();
            pos.x = pe.pos_x;
            pos.y = pe.pos_y;
            rect.ul_x = rect.lr_x = (short)(pos.x + ev.translation_x);
            rect.ul_y = rect.lr_y = (short)(pos.y + ev.translation_y);
            int rid = OS.PtWidgetRid(this.handle);
            int input_group = OS.PhInputGroup(0);
            int flags = 63;
            OS.PhInitDrag(rid, flags, rect, null, input_group, null, null, null, pos, null);
            Event event = new Event();
            event.x = this.display.dragStartX;
            event.y = this.display.dragStartY;
            this.postEvent(29, event);
        }
        return 0;
    }

    void releaseChildren(boolean destroy) {
        Control[] children = this._getChildren();
        int i = 0;
        while (i < children.length) {
            Control child = children[i];
            if (child != null && !child.isDisposed()) {
                child.release(false);
            }
            ++i;
        }
        super.releaseChildren(destroy);
    }

    void releaseHandle() {
        super.releaseHandle();
        this.cornerHandle = 0;
    }

    void releaseWidget() {
        super.releaseWidget();
        this.layout = null;
        this.tabList = null;
    }

    void removeControl(Control control) {
        this.fixTabList(control);
    }

    void resizeClientArea() {
        int[] nArray = new int[6];
        nArray[0] = 1023;
        nArray[3] = 1024;
        int[] args = nArray;
        OS.PtGetResources(this.scrolledHandle, args.length / 3, args);
        this.resizeClientArea(args[1], args[4], true);
    }

    void resizeClientArea(int width, int height, boolean events) {
        boolean isVisibleVBar;
        if (this.scrolledHandle == 0) {
            return;
        }
        int[] nArray = new int[6];
        nArray[0] = 2015;
        nArray[3] = 1001;
        int[] args = nArray;
        OS.PtGetResources(this.scrolledHandle, args.length / 3, args);
        int flags = args[1];
        int bevel = args[4];
        int top = 0;
        int left = 0;
        int right = 0;
        int bottom = 0;
        if ((flags & 1) != 0) {
            ++top;
        }
        if ((flags & 0x10) != 0) {
            ++top;
        }
        if ((flags & 0x1000) != 0) {
            ++top;
        }
        if ((flags & 0x100) != 0) {
            top += bevel;
        }
        if ((flags & 2) != 0) {
            ++bottom;
        }
        if ((flags & 0x20) != 0) {
            ++bottom;
        }
        if ((flags & 0x2000) != 0) {
            ++bottom;
        }
        if ((flags & 0x200) != 0) {
            bottom += bevel;
        }
        if ((flags & 8) != 0) {
            ++right;
        }
        if ((flags & 0x80) != 0) {
            ++right;
        }
        if ((flags & 0x8000) != 0) {
            ++right;
        }
        if ((flags & 0x800) != 0) {
            right += bevel;
        }
        if ((flags & 4) != 0) {
            ++left;
        }
        if ((flags & 0x40) != 0) {
            ++left;
        }
        if ((flags & 0x4000) != 0) {
            ++left;
        }
        if ((flags & 0x400) != 0) {
            left += bevel;
        }
        int clientWidth = width - (left + right);
        int clientHeight = height - (top + bottom);
        int vBarWidth = 0;
        int hBarHeight = 0;
        boolean isVisibleHBar = this.horizontalBar != null && this.horizontalBar.getVisible();
        boolean bl = isVisibleVBar = this.verticalBar != null && this.verticalBar.getVisible();
        if (isVisibleHBar) {
            int[] nArray2 = new int[3];
            nArray2[0] = 1024;
            args = nArray2;
            OS.PtGetResources(this.horizontalBar.handle, args.length / 3, args);
            hBarHeight = args[1];
            clientHeight -= hBarHeight;
        }
        if (isVisibleVBar) {
            int[] nArray3 = new int[3];
            nArray3[0] = 1023;
            args = nArray3;
            OS.PtGetResources(this.verticalBar.handle, args.length / 3, args);
            vBarWidth = args[1];
            clientWidth -= vBarWidth;
        }
        if (isVisibleHBar) {
            this.horizontalBar.setBounds(0, clientHeight, clientWidth, hBarHeight);
        }
        if (isVisibleVBar) {
            this.verticalBar.setBounds(clientWidth, 0, vBarWidth, clientHeight);
        }
        int[] nArray4 = new int[6];
        nArray4[0] = 1023;
        nArray4[1] = Math.max(clientWidth, 0);
        nArray4[3] = 1024;
        nArray4[4] = Math.max(clientHeight, 0);
        args = nArray4;
        OS.PtSetResources(this.handle, args.length / 3, args);
        if (this.cornerHandle != 0) {
            PhPoint_t pt = new PhPoint_t();
            pt.x = (short)clientWidth;
            pt.y = (short)clientHeight;
            int ptr = OS.malloc(4);
            OS.memmove(ptr, pt, 4);
            OS.PtSetResource(this.cornerHandle, 1007, ptr, 0);
            OS.free(ptr);
        }
        if (events) {
            this.sendEvent(11);
        }
    }

    public void setBackgroundMode(int mode) {
        this.checkWidget();
        this.backgroundMode = mode;
    }

    int setBounds(int x, int y, int width, int height, boolean move, boolean resize, boolean events) {
        int result = super.setBounds(x, y, width, height, move, resize, false);
        if ((result & 0x20) != 0 && events) {
            this.sendEvent(10);
        }
        if ((result & 0x40) != 0) {
            this.resizeClientArea(width, height, false);
            if (events) {
                this.sendEvent(11);
            }
            if (this.layout != null) {
                this.markLayout(false, false);
                this.updateLayout(false);
            }
        }
        return result;
    }

    public boolean setFocus() {
        this.checkWidget();
        Control[] children = this._getChildren();
        int i = 0;
        while (i < children.length) {
            Control child = children[i];
            if (child.getVisible() && child.setFocus()) {
                return true;
            }
            ++i;
        }
        return super.setFocus();
    }

    public void setLayout(Layout layout) {
        this.checkWidget();
        this.layout = layout;
    }

    public void setLayoutDeferred(boolean defer) {
        if (!defer) {
            if (--this.layoutCount == 0 && ((this.state & 0x400) != 0 || (this.state & 0x100) != 0)) {
                this.updateLayout(true);
            }
        } else {
            ++this.layoutCount;
        }
    }

    boolean setTabGroupFocus() {
        boolean takeFocus;
        if (this.isTabItem()) {
            return this.setTabItemFocus();
        }
        boolean bl = takeFocus = (this.style & 0x80000) == 0;
        if ((this.state & 2) != 0) {
            takeFocus = this.hooksKeys();
        }
        if (takeFocus && this.setTabItemFocus()) {
            return true;
        }
        Control[] children = this._getChildren();
        int i = 0;
        while (i < children.length) {
            Control child = children[i];
            if (child.isTabItem() && child.setTabItemFocus()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void setTabList(Control[] tabList) {
        this.checkWidget();
        if (tabList == null) {
            Composite.error(4);
        }
        int i = 0;
        while (i < tabList.length) {
            Control control = tabList[i];
            if (control == null) {
                Composite.error(5);
            }
            if (control.isDisposed()) {
                Composite.error(5);
            }
            if (control.parent != this) {
                Composite.error(32);
            }
            ++i;
        }
        this.tabList = tabList;
    }

    int traversalCode(int key_sym, PhKeyEvent_t ke) {
        if ((this.state & 2) != 0) {
            if ((this.style & 0x80000) != 0) {
                return 0;
            }
            if (this.hooksKeys()) {
                return 0;
            }
        }
        return super.traversalCode(key_sym, ke);
    }

    void updateLayout(boolean all) {
        Composite parent = this.findDeferredControl();
        if (parent != null) {
            parent.state |= 0x400;
            return;
        }
        if ((this.state & 0x100) != 0) {
            boolean changed = (this.state & 0x200) != 0;
            this.state &= 0xFFFFFCFF;
            this.layout.layout(this, changed);
        }
        if (all) {
            this.state &= 0xFFFFFBFF;
            Control[] children = this._getChildren();
            int i = 0;
            while (i < children.length) {
                children[i].updateLayout(all);
                ++i;
            }
        }
    }

    int widgetClass() {
        if ((this.state & 2) != 0) {
            return OS.PtContainer();
        }
        return super.widgetClass();
    }
}

