/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.photon.OS;
import org.eclipse.swt.internal.photon.PhArea_t;
import org.eclipse.swt.internal.photon.PhDim_t;
import org.eclipse.swt.internal.photon.PhKeyEvent_t;
import org.eclipse.swt.internal.photon.PhRect_t;
import org.eclipse.swt.internal.photon.PtCallbackInfo_t;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.WidgetTable;

public class Combo
extends Composite {
    public static final int LIMIT = Integer.MAX_VALUE;

    public Combo(Composite parent, int style) {
        super(parent, Combo.checkStyle(style));
    }

    static int checkStyle(int style) {
        style &= 0xFFFFF7FF;
        style &= 0xFFFFFCFF;
        if (((style = Combo.checkBits(style, 4, 64, 0, 0, 0, 0)) & 0x40) != 0) {
            return style & 0xFFFFFFF7;
        }
        return style;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        int length;
        this.checkWidget();
        if ((this.style & 0x40) != 0) {
            return new Point(100, 100);
        }
        PhDim_t dim = new PhDim_t();
        if (!OS.PtWidgetIsRealized(this.handle)) {
            OS.PtExtentWidgetFamily(this.handle);
        }
        OS.PtWidgetPreferredSize(this.handle, dim);
        int width = dim.w;
        int height = dim.h;
        int textWidget = OS.PtWidgetChildBack(this.handle);
        OS.PtWidgetPreferredSize(textWidget, dim);
        height += dim.h;
        PhRect_t rect = new PhRect_t();
        PhArea_t area = new PhArea_t();
        OS.PtSetAreaFromWidgetCanvas(textWidget, rect, area);
        width += area.size_w;
        int[] nArray = new int[12];
        nArray[0] = 23014;
        nArray[3] = 23001;
        nArray[6] = 3010;
        nArray[9] = 3011;
        int[] args = nArray;
        OS.PtGetResources(this.handle, args.length / 3, args);
        int maxWidth = 0;
        rect = new PhRect_t();
        int str = args[10];
        int font = args[7];
        if (str != 0 && (length = OS.strlen(str)) > 0) {
            OS.PfExtentText(rect, null, font, str, length);
            maxWidth = Math.max(maxWidth, rect.lr_x - rect.ul_x + 1);
        }
        int count = args[1];
        int[] buffer = new int[1];
        int i = 0;
        while (i < count) {
            OS.memmove(buffer, args[4] + i * 4, 4);
            str = buffer[0];
            int length2 = OS.strlen(str);
            if (length2 > 0) {
                OS.PfExtentText(rect, null, font, str, length2);
                maxWidth = Math.max(maxWidth, rect.lr_x - rect.ul_x + 1);
            }
            ++i;
        }
        if (maxWidth == 0) {
            maxWidth = 64;
        }
        int[] nArray2 = new int[9];
        nArray2[0] = 2005;
        nArray2[3] = 3005;
        nArray2[6] = 3006;
        int[] args1 = nArray2;
        OS.PtGetResources(textWidget, args1.length / 3, args1);
        width += (maxWidth += args1[1] + args1[4] + args1[7]);
        if (wHint != -1 || hHint != -1) {
            rect = new PhRect_t();
            area = new PhArea_t();
            rect.lr_x = (short)(wHint - 1);
            rect.lr_y = (short)(hHint - 1);
            OS.PtSetAreaFromWidgetCanvas(this.handle, rect, area);
            if (wHint != -1) {
                width = area.size_w;
            }
            if (hHint != -1) {
                height = area.size_h;
            }
        }
        return new Point(width, height);
    }

    void createHandle(int index) {
        this.state |= 8;
        int clazz = this.display.PtComboBox;
        int parentHandle = this.parent.parentingHandle();
        int textFlags = (this.style & 8) != 0 ? 0 : 2;
        int[] nArray = new int[12];
        nArray[0] = 4008;
        nArray[1] = textFlags;
        nArray[2] = 2;
        nArray[3] = 31019;
        nArray[4] = 5;
        nArray[6] = 31000;
        nArray[7] = (this.style & 0x40) != 0 ? 32 : 0;
        nArray[8] = 32;
        nArray[9] = 1008;
        nArray[11] = 0x3F00000;
        int[] args = nArray;
        this.handle = OS.PtCreateWidget(clazz, parentHandle, args.length / 3, args);
        if (this.handle == 0) {
            Combo.error(2);
        }
    }

    public void deselect(int index) {
        this.checkWidget();
        int[] nArray = new int[3];
        nArray[0] = 31001;
        int[] args = nArray;
        OS.PtGetResources(this.handle, args.length / 3, args);
        if (args[1] == index) {
            int[] nArray2 = new int[6];
            nArray2[0] = 3011;
            nArray2[3] = 31001;
            args = nArray2;
            OS.PtSetResources(this.handle, args.length / 3, args);
        }
    }

    public void deselectAll() {
        this.checkWidget();
        int[] nArray = new int[6];
        nArray[0] = 3011;
        nArray[3] = 31001;
        int[] args = nArray;
        OS.PtSetResources(this.handle, args.length / 3, args);
    }

    public void add(String string) {
        this.checkWidget();
        if (string == null) {
            Combo.error(4);
        }
        byte[] buffer = Converter.wcsToMbcs(null, string, true);
        int ptr = OS.malloc(buffer.length);
        OS.memmove(ptr, buffer, buffer.length);
        OS.PtListAddItems(this.handle, new int[]{ptr}, 1, 0);
        OS.free(ptr);
    }

    public void add(String string, int index) {
        this.checkWidget();
        if (string == null) {
            Combo.error(4);
        }
        if (index == -1) {
            Combo.error(6);
        }
        byte[] buffer = Converter.wcsToMbcs(null, string, true);
        int ptr = OS.malloc(buffer.length);
        OS.memmove(ptr, buffer, buffer.length);
        int result = OS.PtListAddItems(this.handle, new int[]{ptr}, 1, index + 1);
        OS.free(ptr);
        if (result != 0) {
            int[] nArray = new int[3];
            nArray[0] = 23014;
            int[] args = nArray;
            OS.PtGetResources(this.handle, args.length / 3, args);
            if (index >= 0 && index <= args[1]) {
                Combo.error(14);
            }
            Combo.error(6);
        }
    }

    public void addModifyListener(ModifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            Combo.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(24, typedListener);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            Combo.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    public void addVerifyListener(VerifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            Combo.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(25, typedListener);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            Combo.error(43);
        }
    }

    public void clearSelection() {
        this.checkWidget();
        OS.PtTextSetSelection(this.handle, new int[1], new int[1]);
    }

    public void copy() {
        this.checkWidget();
        int[] start = new int[1];
        int[] end = new int[1];
        int length = OS.PtTextGetSelection(this.handle, start, end);
        if (length <= 0) {
            return;
        }
        int[] nArray = new int[3];
        nArray[0] = 3011;
        int[] args = nArray;
        OS.PtGetResources(this.handle, args.length / 3, args);
        byte[] buffer = new byte[length + 1];
        OS.memmove(buffer, args[1] + start[0], length);
        int ig = OS.PhInputGroup(0);
        OS.PhClipboardCopyString((short)ig, buffer);
    }

    public void cut() {
        this.checkWidget();
        int[] start = new int[1];
        int[] end = new int[1];
        int length = OS.PtTextGetSelection(this.handle, start, end);
        if (length <= 0) {
            return;
        }
        int[] nArray = new int[3];
        nArray[0] = 3011;
        int[] args = nArray;
        OS.PtGetResources(this.handle, args.length / 3, args);
        byte[] buffer = new byte[length + 1];
        OS.memmove(buffer, args[1] + start[0], length);
        int ig = OS.PhInputGroup(0);
        OS.PhClipboardCopyString((short)ig, buffer);
        buffer = new byte[]{};
        OS.PtTextModifyText(this.handle, start[0], end[0], start[0], buffer, buffer.length);
    }

    byte[] defaultFont() {
        return this.display.TEXT_FONT;
    }

    void deregister() {
        super.deregister();
        int child = OS.PtWidgetChildBack(this.handle);
        WidgetTable.remove(child);
    }

    int focusHandle() {
        return OS.PtWidgetChildBack(this.handle);
    }

    public String getItem(int index) {
        this.checkWidget();
        int[] nArray = new int[6];
        nArray[0] = 23014;
        nArray[3] = 23001;
        int[] args = nArray;
        OS.PtGetResources(this.handle, args.length / 3, args);
        if (index < 0 || index >= args[1]) {
            Combo.error(6);
        }
        int[] items = new int[1];
        OS.memmove(items, args[4] + index * 4, 4);
        int length = OS.strlen(items[0]);
        byte[] buffer = new byte[length];
        OS.memmove(buffer, items[0], length);
        char[] unicode = Converter.mbcsToWcs(null, buffer);
        return new String(unicode);
    }

    public int getItemCount() {
        this.checkWidget();
        int[] nArray = new int[3];
        nArray[0] = 23014;
        int[] args = nArray;
        OS.PtGetResources(this.handle, args.length / 3, args);
        return args[1];
    }

    public int getItemHeight() {
        this.checkWidget();
        return 0;
    }

    public String[] getItems() {
        this.checkWidget();
        int[] nArray = new int[6];
        nArray[0] = 23014;
        nArray[3] = 23001;
        int[] args = nArray;
        OS.PtGetResources(this.handle, args.length / 3, args);
        int[] items = new int[args[1]];
        OS.memmove(items, args[4], args[1] * 4);
        String[] result = new String[args[1]];
        int i = 0;
        while (i < args[1]) {
            int length = OS.strlen(items[i]);
            byte[] buffer = new byte[length];
            OS.memmove(buffer, items[i], length);
            char[] unicode = Converter.mbcsToWcs(null, buffer);
            result[i] = new String(unicode);
            ++i;
        }
        return result;
    }

    public boolean getListVisible() {
        this.checkWidget();
        return false;
    }

    String getNameText() {
        return this.getText();
    }

    public int getOrientation() {
        this.checkWidget();
        return this.style & 0x6000000;
    }

    public Point getSelection() {
        this.checkWidget();
        if ((this.style & 4) != 0 && (this.style & 8) != 0) {
            int[] nArray = new int[3];
            nArray[0] = 3011;
            int[] args = nArray;
            OS.PtGetResources(this.handle, args.length / 3, args);
            int length = 0;
            if (args[1] != 0) {
                length = OS.strlen(args[1]);
            }
            return new Point(0, length);
        }
        int[] start = new int[1];
        int[] end = new int[1];
        OS.PtTextGetSelection(this.handle, start, end);
        if (start[0] == -1) {
            int[] nArray = new int[3];
            nArray[0] = 4003;
            int[] args = nArray;
            OS.PtGetResources(this.handle, args.length / 3, args);
            start[0] = end[0] = args[1];
        }
        return new Point(start[0], end[0]);
    }

    public int getSelectionIndex() {
        this.checkWidget();
        int[] nArray = new int[6];
        nArray[0] = 23015;
        nArray[3] = 23006;
        int[] args = nArray;
        OS.PtGetResources(this.handle, args.length / 3, args);
        if (args[1] == 0) {
            return -1;
        }
        short[] buffer = new short[1];
        OS.memmove(buffer, args[4], 2);
        return buffer[0] - 1;
    }

    public String getText() {
        this.checkWidget();
        int[] nArray = new int[3];
        nArray[0] = 3011;
        int[] args = nArray;
        OS.PtGetResources(this.handle, args.length / 3, args);
        if (args[1] == 0) {
            return "";
        }
        int length = OS.strlen(args[1]);
        byte[] buffer = new byte[length];
        OS.memmove(buffer, args[1], length);
        char[] unicode = Converter.mbcsToWcs(null, buffer);
        return new String(unicode);
    }

    public int getTextHeight() {
        this.checkWidget();
        PhDim_t dim = new PhDim_t();
        if (!OS.PtWidgetIsRealized(this.handle)) {
            OS.PtExtentWidgetFamily(this.handle);
        }
        OS.PtWidgetPreferredSize(this.handle, dim);
        int height = dim.h;
        int text = OS.PtWidgetChildBack(this.handle);
        OS.PtWidgetPreferredSize(text, dim);
        return height += dim.h;
    }

    public int getTextLimit() {
        this.checkWidget();
        int[] nArray = new int[3];
        nArray[0] = 4005;
        int[] args = nArray;
        OS.PtGetResources(this.handle, args.length / 3, args);
        return args[1];
    }

    public int getVisibleItemCount() {
        this.checkWidget();
        int[] nArray = new int[3];
        nArray[0] = 31019;
        int[] args = nArray;
        OS.PtGetResources(this.handle, args.length / 3, args);
        return args[1];
    }

    boolean hasFocus() {
        return OS.PtIsFocused(this.handle) != 0;
    }

    void hookEvents() {
        super.hookEvents();
        int windowProc = this.display.windowProc;
        OS.PtAddCallback(this.handle, 23010, windowProc, 23010);
        OS.PtAddCallback(this.handle, 4010, windowProc, 4010);
    }

    public int indexOf(String string) {
        this.checkWidget();
        byte[] buffer = Converter.wcsToMbcs(null, string, true);
        return OS.PtListItemPos(this.handle, buffer) - 1;
    }

    public int indexOf(String string, int start) {
        this.checkWidget();
        if (string == null) {
            Combo.error(4);
        }
        if (start == 0) {
            return this.indexOf(string);
        }
        int[] nArray = new int[6];
        nArray[0] = 23014;
        nArray[3] = 23001;
        int[] args = nArray;
        OS.PtGetResources(this.handle, args.length / 3, args);
        int count = args[1];
        if (start < 0 || start >= count) {
            return -1;
        }
        int[] item = new int[1];
        int index = start;
        while (index < count) {
            OS.memmove(item, args[4] + index * 4, 4);
            int length = OS.strlen(item[0]);
            byte[] buffer = new byte[length];
            OS.memmove(buffer, item[0], length);
            if (string.equals(new String(Converter.mbcsToWcs(null, buffer)))) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public void paste() {
        this.checkWidget();
        int ig = OS.PhInputGroup(0);
        int ptr = OS.PhClipboardPasteString((short)ig);
        if (ptr == 0) {
            return;
        }
        int length = OS.strlen(ptr);
        int[] start = new int[1];
        int[] end = new int[1];
        OS.PtTextGetSelection(this.handle, start, end);
        if (start[0] == -1) {
            int[] nArray = new int[3];
            nArray[0] = 4003;
            int[] args = nArray;
            OS.PtGetResources(this.handle, args.length / 3, args);
            start[0] = end[0] = args[1];
        }
        OS.PtTextModifyText(this.handle, start[0], end[0], end[0], ptr, length);
        OS.free(ptr);
    }

    int Pt_CB_SELECTION(int widget, int info) {
        if (info == 0) {
            return 0;
        }
        PtCallbackInfo_t cbinfo = new PtCallbackInfo_t();
        OS.memmove(cbinfo, info, 16);
        if (cbinfo.reason_subtype == 0) {
            this.postEvent(13);
        }
        return 0;
    }

    int Pt_CB_TEXT_CHANGED(int widget, int info) {
        this.sendEvent(24);
        return 0;
    }

    void register() {
        super.register();
        int child = OS.PtWidgetChildBack(this.handle);
        WidgetTable.put(child, this);
    }

    public void remove(int start, int end) {
        int count;
        int result;
        this.checkWidget();
        if (start > end) {
            return;
        }
        int[] nArray = new int[3];
        nArray[0] = 23014;
        int[] args = nArray;
        OS.PtGetResources(this.handle, args.length / 3, args);
        if (start < 0 || start > end || end >= args[1]) {
            Combo.error(6);
        }
        if ((result = OS.PtListDeleteItemPos(this.handle, count = end - start + 1, start + 1)) != 0) {
            Combo.error(15);
        }
        if ((this.style & 8) != 0 && args[1] == count) {
            OS.PtSetResource(this.handle, 3011, 0, 0);
        }
    }

    public void remove(int index) {
        int result;
        this.checkWidget();
        int[] nArray = new int[3];
        nArray[0] = 23014;
        int[] args = nArray;
        OS.PtGetResources(this.handle, args.length / 3, args);
        if (index < 0 || index >= args[1]) {
            Combo.error(6);
        }
        if ((result = OS.PtListDeleteItemPos(this.handle, 1, index + 1)) != 0) {
            Combo.error(15);
        }
        if ((this.style & 8) != 0 && args[1] == 1) {
            OS.PtSetResource(this.handle, 3011, 0, 0);
        }
    }

    public void remove(String string) {
        this.checkWidget();
        int index = this.indexOf(string, 0);
        if (index == -1) {
            Combo.error(15);
        }
        this.remove(index);
    }

    public void removeAll() {
        this.checkWidget();
        OS.PtListDeleteAllItems(this.handle);
        OS.PtSetResource(this.handle, 3011, 0, 0);
        this.sendEvent(24);
    }

    public void removeModifyListener(ModifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            Combo.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(24, listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            Combo.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    public void removeVerifyListener(VerifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            Combo.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(25, listener);
    }

    public void select(int index) {
        this.checkWidget();
        if (index < 0) {
            return;
        }
        OS.PtSetResource(this.handle, 31001, index + 1, 0);
    }

    int setBounds(int x, int y, int width, int height, boolean move, boolean resize, boolean events) {
        this.checkWidget();
        int newHeight = resize && (this.style & 4) != 0 ? this.getTextHeight() : height;
        return super.setBounds(x, y, width, newHeight, move, resize, events);
    }

    public void setItem(int index, String string) {
        this.checkWidget();
        if (string == null) {
            Combo.error(4);
        }
        int[] nArray = new int[3];
        nArray[0] = 23014;
        int[] args = nArray;
        OS.PtGetResources(this.handle, args.length / 3, args);
        if (index < 0 || index >= args[1]) {
            Combo.error(6);
        }
        byte[] buffer = Converter.wcsToMbcs(null, string, true);
        int ptr = OS.malloc(buffer.length);
        OS.memmove(ptr, buffer, buffer.length);
        OS.PtListReplaceItemPos(this.handle, new int[]{ptr}, 1, index + 1);
        OS.free(ptr);
    }

    public void setItems(String[] items) {
        this.checkWidget();
        if (items == null) {
            Combo.error(4);
        }
        int i = 0;
        while (i < items.length) {
            if (items[i] == null) {
                Combo.error(5);
            }
            ++i;
        }
        OS.PtListDeleteAllItems(this.handle);
        int[] itemsPtr = new int[items.length];
        int i2 = 0;
        while (i2 < itemsPtr.length) {
            byte[] buffer = Converter.wcsToMbcs(null, items[i2], true);
            int ptr = OS.malloc(buffer.length);
            OS.memmove(ptr, buffer, buffer.length);
            itemsPtr[i2] = ptr;
            ++i2;
        }
        OS.PtListAddItems(this.handle, itemsPtr, itemsPtr.length, 0);
        i2 = 0;
        while (i2 < itemsPtr.length) {
            OS.free(itemsPtr[i2]);
            ++i2;
        }
        OS.PtSetResource(this.handle, 3011, 0, 0);
        this.sendEvent(24);
    }

    public void setListVisible(boolean visible) {
        this.checkWidget();
    }

    public void setOrientation(int orientation) {
        this.checkWidget();
    }

    public void setSelection(Point selection) {
        this.checkWidget();
        if (selection == null) {
            Combo.error(4);
        }
        OS.PtTextSetSelection(this.handle, new int[]{selection.x}, new int[]{selection.y});
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            Combo.error(4);
        }
        byte[] buffer = Converter.wcsToMbcs(null, string, true);
        if ((this.style & 8) != 0) {
            int index = OS.PtListItemPos(this.handle, buffer);
            if (index > 0) {
                OS.PtSetResource(this.handle, 31001, index, 0);
                this.sendEvent(24);
            }
            return;
        }
        int ptr = OS.malloc(buffer.length);
        OS.memmove(ptr, buffer, buffer.length);
        OS.PtSetResource(this.handle, 3011, ptr, 0);
        OS.free(ptr);
        this.sendEvent(24);
    }

    public void setTextLimit(int limit) {
        this.checkWidget();
        if (limit == 0) {
            Combo.error(7);
        }
        OS.PtSetResource(this.handle, 4005, limit, 0);
    }

    int traversalCode(int key_sym, PhKeyEvent_t ke) {
        int code = super.traversalCode(key_sym, ke);
        if ((this.style & 8) == 0 && (key_sym == 61522 || key_sym == 61524)) {
            code &= 0xFFFFFF9F;
        }
        return code;
    }

    public void setVisibleItemCount(int visibleCount) {
        this.checkWidget();
        if (visibleCount < 0) {
            return;
        }
        OS.PtSetResource(this.handle, 31019, visibleCount, 0);
    }

    boolean translateTraversal(int key_sym, PhKeyEvent_t phEvent) {
        boolean translated = super.translateTraversal(key_sym, phEvent);
        if (!translated && key_sym == 61453) {
            this.postEvent(14);
            return false;
        }
        return translated;
    }

    int widgetClass() {
        return OS.PtComboBox();
    }
}

