/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.tasks;

import com.ibm.icu.text.MessageFormat;
import org.apache.tools.ant.BuildException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiBaseline;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiElement;
import org.eclipse.pde.api.tools.internal.provisional.search.IApiSearchReporter;
import org.eclipse.pde.api.tools.internal.search.SkippedComponent;
import org.eclipse.pde.api.tools.internal.tasks.Messages;
import org.eclipse.pde.api.tools.internal.tasks.UseTask;

public class PluggableApiUseTask
extends UseTask {
    public void setReporterClass(String clazz) {
        this.reporterclazz = clazz;
    }

    public void setProceedOnError(String proceed) {
        this.proceedonerror = Boolean.valueOf(proceed);
    }

    public void setIncludeSystemLibraries(String include) {
        this.includesystemlibraries = Boolean.valueOf(include);
    }

    public void setDebug(String debugValue) {
        this.debug = Boolean.toString(true).equals(debugValue);
    }

    public void setExcludeList(String excludeListLocation) {
        this.excludeListLocation = excludeListLocation;
    }

    public void setEEFile(String eeFileLocation) {
        this.eeFileLocation = eeFileLocation;
    }

    public void setConsiderAPI(String considerapi) {
        this.considerapi = Boolean.toString(true).equals(considerapi);
    }

    public void setConsiderInternal(String considerinternal) {
        this.considerinternal = Boolean.toString(true).equals(considerinternal);
    }

    public void setBaseline(String baselineLocation) {
        this.currentBaselineLocation = baselineLocation;
    }

    public void setIncludeNonApiProjects(String includenonapi) {
        this.includenonapi = Boolean.valueOf(includenonapi);
    }

    protected void assertParameters() throws BuildException {
        super.assertParameters();
        if (this.reporterclazz == null) {
            throw new BuildException(Messages.ApiUseDBTask_must_provide_reporter_class);
        }
        Object clazz = null;
        try {
            clazz = Class.forName(this.reporterclazz).newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new BuildException(MessageFormat.format((String)Messages.ApiUseDBTask_class_could_not_be_loaded, (Object[])new String[]{this.reporterclazz, e.getMessage()}));
        }
        catch (InstantiationException e) {
            throw new BuildException(MessageFormat.format((String)Messages.ApiUseDBTask_class_could_not_be_instantaited, (Object[])new String[]{this.reporterclazz, e.getMessage()}));
        }
        catch (IllegalAccessException e) {
            throw new BuildException(MessageFormat.format((String)Messages.ApiUseDBTask_access_denied_to_class, (Object[])new String[]{this.reporterclazz, e.getMessage()}));
        }
        if (clazz instanceof IApiSearchReporter) {
            this.reporter = clazz;
        }
    }

    public void execute() throws BuildException {
        this.writeDebugHeader();
        this.assertParameters();
        IApiBaseline baseline = this.getBaseline("current_baseline", this.currentBaselineLocation);
        IApiBaseline scope = this.getBaseline("scope_baseline", this.scopeLocation);
        if (scope == null) {
            scope = baseline;
        }
        this.initializeExcludeSet(scope);
        try {
            try {
                this.doSearch(baseline, scope, this.reporter);
                this.reporter.reportNotSearched((IApiElement[])this.notsearched.toArray(new SkippedComponent[this.notsearched.size()]));
            }
            catch (CoreException ce) {
                throw new BuildException(Messages.ApiUseTask_search_engine_problem, (Throwable)ce);
            }
        }
        finally {
            if (baseline != null) {
                baseline.dispose();
                this.deleteBaseline(this.currentBaselineLocation, this.getBaselineInstallDir("current_baseline"));
            }
            if (scope != null && this.scopeLocation != null) {
                scope.dispose();
                this.deleteBaseline(this.scopeLocation, this.getBaselineInstallDir("scope_baseline"));
            }
        }
    }
}

