/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.tasks;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.Flags;
import org.eclipse.pde.api.tools.internal.comparator.DeltaXmlVisitor;
import org.eclipse.pde.api.tools.internal.provisional.RestrictionModifiers;
import org.eclipse.pde.api.tools.internal.provisional.comparator.DeltaProcessor;
import org.eclipse.pde.api.tools.internal.provisional.comparator.IDelta;
import org.eclipse.pde.api.tools.internal.tasks.CommonUtilsTask;
import org.eclipse.pde.api.tools.internal.util.Util;

public class ExcludeListDeltaVisitor
extends DeltaXmlVisitor {
    private Set excludedElement;
    private String excludeListLocation;
    private List nonExcludedElements;

    public ExcludeListDeltaVisitor(String excludeListLocation) throws CoreException {
        this.excludeListLocation = excludeListLocation;
        this.nonExcludedElements = new ArrayList();
    }

    private boolean checkExclude(IDelta delta) {
        if (this.excludedElement == null) {
            this.excludedElement = CommonUtilsTask.initializeExcludedElement(this.excludeListLocation);
        }
        return this.isExcluded(delta);
    }

    public String getPotentialExcludeList() {
        if (this.nonExcludedElements == null) {
            return "";
        }
        Collections.sort(this.nonExcludedElements);
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer = new PrintWriter(stringWriter);
        Iterator iterator = this.nonExcludedElements.iterator();
        while (iterator.hasNext()) {
            writer.println(iterator.next());
        }
        writer.close();
        return String.valueOf(stringWriter.getBuffer());
    }

    private boolean isExcluded(IDelta delta) {
        String typeName = delta.getTypeName();
        StringBuffer buffer = new StringBuffer();
        String componentId = delta.getComponentVersionId();
        if (componentId != null) {
            if (this.excludedElement.contains(componentId)) {
                return true;
            }
            buffer.append(componentId).append(':');
        }
        if (typeName != null) {
            buffer.append(typeName);
        }
        int flags = delta.getFlags();
        switch (flags) {
            case 48: {
                buffer.append('.').append(delta.getKey());
                break;
            }
            case 8: 
            case 12: 
            case 16: 
            case 25: 
            case 27: 
            case 28: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 70: 
            case 71: {
                buffer.append('#').append(delta.getKey());
                break;
            }
            case 59: 
            case 60: {
                buffer.append(Util.getDeltaFlagsName((int)flags)).append('_').append(Util.getDeltaKindName((int)delta.getKind()));
            }
        }
        String excludeListKey = String.valueOf(buffer);
        if (this.excludedElement.contains(excludeListKey)) {
            return true;
        }
        this.nonExcludedElements.add(excludeListKey);
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void processLeafDelta(IDelta delta) {
        if (DeltaProcessor.isCompatible((IDelta)delta)) {
            switch (delta.getKind()) {
                case 1: {
                    int modifiers = delta.getNewModifiers();
                    if (Flags.isPublic((int)modifiers)) {
                        switch (delta.getFlags()) {
                            case 8: 
                            case 12: 
                            case 16: 
                            case 25: 
                            case 27: 
                            case 28: 
                            case 46: 
                            case 48: 
                            case 56: 
                            case 61: 
                            case 62: 
                            case 63: 
                            case 64: 
                            case 70: {
                                if (this.checkExclude(delta)) return;
                                super.processLeafDelta(delta);
                            }
                        }
                        return;
                    }
                    if (!Flags.isProtected((int)modifiers)) return;
                    if (RestrictionModifiers.isExtendRestriction((int)delta.getRestrictions())) return;
                    switch (delta.getFlags()) {
                        case 8: 
                        case 12: 
                        case 16: 
                        case 25: 
                        case 46: 
                        case 48: 
                        case 56: 
                        case 61: 
                        case 62: 
                        case 63: 
                        case 64: 
                        case 70: {
                            if (this.checkExclude(delta)) return;
                            super.processLeafDelta(delta);
                        }
                    }
                    return;
                }
                case 2: {
                    switch (delta.getFlags()) {
                        case 59: 
                        case 60: {
                            if (this.checkExclude(delta)) return;
                            super.processLeafDelta(delta);
                        }
                    }
                }
            }
            return;
        }
        switch (delta.getKind()) {
            case 1: {
                switch (delta.getFlags()) {
                    case 8: 
                    case 12: 
                    case 16: 
                    case 25: 
                    case 27: 
                    case 28: 
                    case 46: 
                    case 48: 
                    case 56: 
                    case 61: 
                    case 62: 
                    case 63: 
                    case 64: 
                    case 70: {
                        if (!Util.isVisible((int)delta.getNewModifiers()) || this.checkExclude(delta)) break;
                        super.processLeafDelta(delta);
                        return;
                    }
                }
                return;
            }
            case 3: {
                switch (delta.getFlags()) {
                    case 8: 
                    case 12: 
                    case 16: 
                    case 25: 
                    case 27: 
                    case 28: 
                    case 46: 
                    case 48: 
                    case 56: 
                    case 61: 
                    case 62: 
                    case 63: 
                    case 64: 
                    case 70: 
                    case 71: {
                        if (!Util.isVisible((int)delta.getOldModifiers())) return;
                        if (this.checkExclude(delta)) return;
                        super.processLeafDelta(delta);
                    }
                }
                return;
            }
        }
    }
}

