/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.tasks;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Set;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.api.tools.internal.model.ApiModelFactory;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiBaseline;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiComponent;
import org.eclipse.pde.api.tools.internal.tasks.Messages;
import org.eclipse.pde.api.tools.internal.util.TarException;
import org.eclipse.pde.api.tools.internal.util.Util;

public abstract class CommonUtilsTask
extends Task {
    private static final String CVS_FOLDER_NAME = "CVS";
    private static final String ECLIPSE_FOLDER_NAME = "eclipse";
    private static final String PLUGINS_FOLDER_NAME = "plugins";
    protected static final String CURRENT = "currentBaseline";
    protected static final String CURRENT_BASELINE_NAME = "current_baseline";
    protected static final String REFERENCE = "referenceBaseline";
    protected static final String REFERENCE_PROFILE_NAME = "reference_baseline";
    protected boolean debug;
    protected String eeFileLocation;
    protected String currentBaselineLocation;
    protected String referenceBaselineLocation;
    protected String excludeListLocation;
    protected String reportLocation;

    protected IApiBaseline createBaseline(String baselineName, File dir, String eeFileLocation) {
        try {
            IApiBaseline baseline = null;
            baseline = ApiPlugin.isRunningInFramework() ? ApiModelFactory.newApiBaseline((String)baselineName) : (eeFileLocation != null ? ApiModelFactory.newApiBaseline((String)baselineName, (File)new File(eeFileLocation)) : ApiModelFactory.newApiBaseline((String)baselineName, (File)Util.getEEDescriptionFile()));
            File[] files = dir.listFiles();
            if (files == null) {
                throw new BuildException(Messages.bind((String)Messages.directoryIsEmpty, (Object)dir.getAbsolutePath()));
            }
            ArrayList<IApiComponent> components = new ArrayList<IApiComponent>();
            int i = 0;
            while (i < files.length) {
                IApiComponent component;
                File bundle = files[i];
                if (!bundle.getName().equals(CVS_FOLDER_NAME) && (component = ApiModelFactory.newApiComponent((IApiBaseline)baseline, (String)bundle.getAbsolutePath())) != null) {
                    components.add(component);
                }
                ++i;
            }
            baseline.addApiComponents(components.toArray(new IApiComponent[components.size()]));
            return baseline;
        }
        catch (CoreException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected void scrubReportLocation(File file) {
        if (file.exists() && file.isDirectory()) {
            File[] files = file.listFiles();
            int i = 0;
            while (i < files.length) {
                if (files[i].isDirectory()) {
                    this.scrubReportLocation(files[i]);
                } else {
                    files[i].delete();
                }
                ++i;
            }
            file.delete();
        }
    }

    protected void deleteBaseline(String referenceLocation, File folder) {
        if (this.isArchive(referenceLocation)) {
            Util.delete((File)folder.getParentFile());
        }
    }

    protected File extractSDK(String installDirName, String location) {
        File file = new File(location);
        File locationFile = file;
        if (!locationFile.exists()) {
            throw new BuildException(Messages.bind((String)Messages.fileDoesnotExist, (Object)location));
        }
        if (this.isArchive(location)) {
            File tempDir = new File(System.getProperty("java.io.tmpdir"));
            File installDir = new File(tempDir, installDirName);
            if (installDir.exists() && !Util.delete((File)installDir)) {
                throw new BuildException(Messages.bind((String)Messages.couldNotDelete, (Object)installDir.getAbsolutePath()));
            }
            if (!installDir.mkdirs()) {
                throw new BuildException(Messages.bind((String)Messages.couldNotCreate, (Object)installDir.getAbsolutePath()));
            }
            try {
                if (this.isZipJarFile(location)) {
                    Util.unzip((String)location, (String)installDir.getAbsolutePath());
                } else if (this.isTGZFile(location)) {
                    Util.guntar((String)location, (String)installDir.getAbsolutePath());
                }
            }
            catch (IOException iOException) {
                throw new BuildException(Messages.bind((String)Messages.couldNotUnzip, (Object[])new String[]{location, installDir.getAbsolutePath()}));
            }
            catch (TarException tarException) {
                throw new BuildException(Messages.bind((String)Messages.couldNotUntar, (Object[])new String[]{location, installDir.getAbsolutePath()}));
            }
            return new File(installDir, ECLIPSE_FOLDER_NAME);
        }
        return locationFile;
    }

    protected File getInstallDir(File dir) {
        return new File(dir, PLUGINS_FOLDER_NAME);
    }

    private boolean isArchive(String fileName) {
        return this.isZipJarFile(fileName) || this.isTGZFile(fileName);
    }

    private boolean isTGZFile(String fileName) {
        String normalizedFileName = fileName.toLowerCase();
        return normalizedFileName.endsWith(".tar.gz") || normalizedFileName.endsWith(".tgz");
    }

    private boolean isZipJarFile(String fileName) {
        String normalizedFileName = fileName.toLowerCase();
        return normalizedFileName.endsWith(".zip") || normalizedFileName.endsWith(".jar");
    }

    protected static Set initializeExcludedElement(String excludeListLocation) {
        return Util.initializeRegexExcludeList((String)excludeListLocation, null);
    }

    protected void saveReport(String componentID, String contents, String reportname) {
        block16: {
            File dir = new File(this.reportLocation);
            if (!dir.exists() && !dir.mkdirs()) {
                throw new BuildException(Messages.bind((String)Messages.errorCreatingReportDirectory, (Object)this.reportLocation));
            }
            File reportComponentIDDir = new File(dir, componentID);
            if (!reportComponentIDDir.exists() && !reportComponentIDDir.mkdirs()) {
                throw new BuildException(Messages.bind((String)Messages.errorCreatingReportDirectory, (Object)reportComponentIDDir));
            }
            File reportFile = new File(reportComponentIDDir, reportname);
            BufferedWriter writer = null;
            try {
                try {
                    writer = new BufferedWriter(new FileWriter(reportFile));
                    writer.write(contents);
                    writer.flush();
                }
                catch (IOException e) {
                    ApiPlugin.log((Throwable)e);
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block16;
                }
            }
            catch (Throwable throwable) {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

