/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.tasks;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.pde.api.tools.internal.ApiDescription;
import org.eclipse.pde.api.tools.internal.ApiDescriptionXmlCreator;
import org.eclipse.pde.api.tools.internal.CompilationUnit;
import org.eclipse.pde.api.tools.internal.model.ArchiveApiTypeContainer;
import org.eclipse.pde.api.tools.internal.model.CompositeApiTypeContainer;
import org.eclipse.pde.api.tools.internal.model.DirectoryApiTypeContainer;
import org.eclipse.pde.api.tools.internal.provisional.ApiDescriptionVisitor;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.IApiDescription;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiTypeContainer;
import org.eclipse.pde.api.tools.internal.provisional.scanner.TagScanner;
import org.eclipse.pde.api.tools.internal.tasks.Messages;
import org.eclipse.pde.api.tools.internal.util.Util;
import org.osgi.framework.BundleException;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class ApiFileGenerationTask
extends Task {
    boolean debug;
    String projectName;
    String projectLocation;
    String targetFolder;
    String binaryLocations;
    String manifests;
    String sourceLocations;
    Set apiPackages = new HashSet(0);

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public void setProject(String projectLocation) {
        this.projectLocation = projectLocation;
    }

    public void setTarget(String targetLocation) {
        this.targetFolder = targetLocation;
    }

    public void setBinary(String binaryLocations) {
        this.binaryLocations = binaryLocations;
    }

    public void setDebug(String debugValue) {
        this.debug = Boolean.toString(true).equals(debugValue);
    }

    public void setExtraManifests(String manifests) {
        this.manifests = manifests;
    }

    public void setExtraSourceLocations(String sourceLocations) {
        this.sourceLocations = sourceLocations;
    }

    /*
     * Unable to fully structure code
     */
    public void execute() throws BuildException {
        if (this.binaryLocations == null || this.projectName == null || this.projectLocation == null || this.targetFolder == null) {
            out = new StringWriter();
            writer = new PrintWriter(out);
            writer.println(Messages.bind((String)Messages.api_generation_printArguments, (Object[])new String[]{this.projectName, this.projectLocation, this.binaryLocations, this.targetFolder}));
            writer.flush();
            writer.close();
            throw new BuildException(String.valueOf(out.getBuffer()));
        }
        if (this.debug) {
            System.out.println("Project name : " + this.projectName);
            System.out.println("Project location : " + this.projectLocation);
            System.out.println("Binary locations : " + this.binaryLocations);
            System.out.println("Target folder : " + this.targetFolder);
            if (this.manifests != null) {
                System.out.println("Extra manifest entries : " + this.manifests);
            }
            if (this.sourceLocations != null) {
                System.out.println("Extra source locations entries : " + this.sourceLocations);
            }
        }
        if (!(root = new File(this.projectLocation)).exists() || !root.isDirectory()) {
            if (this.debug) {
                System.err.println("Must be a directory : " + this.projectLocation);
            }
            throw new BuildException(Messages.bind((String)Messages.api_generation_projectLocationNotADirectory, (Object)this.projectLocation));
        }
        dotProjectFile = new File(root, ".project");
        if (!this.isAPIToolsNature(dotProjectFile)) {
            return;
        }
        targetProjectFolder = new File(this.targetFolder);
        if (!targetProjectFolder.exists()) {
            targetProjectFolder.mkdirs();
        } else if (!targetProjectFolder.isDirectory()) {
            if (this.debug) {
                System.err.println("Must be a directory : " + this.targetFolder);
            }
            throw new BuildException(Messages.bind((String)Messages.api_generation_targetFolderNotADirectory, (Object)this.targetFolder));
        }
        apiDescriptionFile = new File(targetProjectFolder, ".api_description");
        if (apiDescriptionFile.exists()) {
            return;
        }
        allFiles = null;
        manifestMap = null;
        classFileContainer = null;
        if (!this.projectLocation.endsWith("org.eclipse.swt")) {
            block91: {
                allBinaryLocations = this.binaryLocations.split(File.pathSeparator);
                allContainers = new ArrayList<IApiTypeContainer>();
                container = null;
                i = 0;
                while (i < allBinaryLocations.length) {
                    container = this.getContainer(allBinaryLocations[i]);
                    if (container == null) {
                        throw new BuildException(Messages.bind((String)Messages.api_generation_invalidBinaryLocation, (Object)allBinaryLocations[i]));
                    }
                    allContainers.add(container);
                    ++i;
                }
                classFileContainer = new CompositeApiTypeContainer(null, allContainers);
                manifestFile = null;
                manifestDir = new File(root, "META-INF");
                if (manifestDir.exists() && manifestDir.isDirectory()) {
                    manifestFile = new File(manifestDir, "MANIFEST.MF");
                }
                if (manifestFile != null && manifestFile.exists()) {
                    inputStream = null;
                    try {
                        inputStream = new BufferedInputStream(new FileInputStream(manifestFile));
                        manifestMap = ManifestElement.parseBundleManifest((InputStream)inputStream, null);
                        this.apiPackages = this.collectApiPackageNames(manifestMap);
                    }
                    catch (FileNotFoundException e) {
                        ApiPlugin.log((Throwable)e);
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (IOException v0) {}
                        }
                        break block91;
                    }
                    catch (IOException e) {
                        ApiPlugin.log((Throwable)e);
                        ** if (inputStream == null) goto lbl-1000
lbl-1000:
                        // 1 sources

                        {
                            try {
                                inputStream.close();
                            }
                            catch (IOException v1) {}
                        }
lbl-1000:
                        // 2 sources

                        {
                            break block91;
                        }
                    }
                    catch (BundleException e) {
                        ApiPlugin.log((Throwable)e);
                        ** if (inputStream == null) goto lbl-1000
lbl-1000:
                        // 1 sources

                        {
                            try {
                                inputStream.close();
                            }
                            catch (IOException v2) {}
                        }
lbl-1000:
                        // 2 sources

                        {
                            break block91;
                        }
                        {
                            catch (Throwable var15_28) {
                                if (inputStream != null) {
                                    try {
                                        inputStream.close();
                                    }
                                    catch (IOException v3) {}
                                }
                                throw var15_28;
                            }
                        }
                    }
                    if (inputStream == null) break block91;
                    try {
                        inputStream.close();
                    }
                    catch (IOException v4) {}
                }
            }
            if (this.manifests != null) {
                allManifestFiles = this.manifests.split(File.pathSeparator);
                i = 0;
                max = allManifestFiles.length;
                while (i < max) {
                    block92: {
                        currentManifest = new File(allManifestFiles[i]);
                        currentApiPackages = null;
                        if (currentManifest.exists()) {
                            inputStream = null;
                            try {
                                inputStream = new BufferedInputStream(new FileInputStream(currentManifest));
                                manifestMap = ManifestElement.parseBundleManifest((InputStream)inputStream, null);
                                currentApiPackages = this.collectApiPackageNames(manifestMap);
                            }
                            catch (FileNotFoundException e) {
                                ApiPlugin.log((Throwable)e);
                                if (inputStream != null) {
                                    try {
                                        inputStream.close();
                                    }
                                    catch (IOException v5) {}
                                }
                                break block92;
                            }
                            catch (IOException e) {
                                ApiPlugin.log((Throwable)e);
                                ** if (inputStream == null) goto lbl-1000
lbl-1000:
                                // 1 sources

                                {
                                    try {
                                        inputStream.close();
                                    }
                                    catch (IOException v6) {}
                                }
lbl-1000:
                                // 2 sources

                                {
                                    break block92;
                                }
                            }
                            catch (BundleException e) {
                                ApiPlugin.log((Throwable)e);
                                ** if (inputStream == null) goto lbl-1000
lbl-1000:
                                // 1 sources

                                {
                                    try {
                                        inputStream.close();
                                    }
                                    catch (IOException v7) {}
                                }
lbl-1000:
                                // 2 sources

                                {
                                    break block92;
                                }
                                {
                                    catch (Throwable var20_40) {
                                        if (inputStream != null) {
                                            try {
                                                inputStream.close();
                                            }
                                            catch (IOException v8) {}
                                        }
                                        throw var20_40;
                                    }
                                }
                            }
                            if (inputStream == null) break block92;
                            try {
                                inputStream.close();
                            }
                            catch (IOException v9) {}
                        }
                    }
                    if (currentApiPackages != null) {
                        if (this.apiPackages == null) {
                            this.apiPackages = currentApiPackages;
                        } else {
                            this.apiPackages.addAll(currentApiPackages);
                        }
                    }
                    ++i;
                }
            }
            fileFilter = new FileFilter(){

                public boolean accept(File path) {
                    return path.isFile() && Util.isJavaFileName((String)path.getName()) && ApiFileGenerationTask.this.isApi(path.getParent()) || path.isDirectory();
                }
            };
            allFiles = Util.getAllFiles((File)root, (FileFilter)fileFilter);
            if (this.sourceLocations != null) {
                allSourceLocations = this.sourceLocations.split(File.pathSeparator);
                i = 0;
                max = allSourceLocations.length;
                while (i < max) {
                    currentSourceLocation = allSourceLocations[i];
                    allFiles2 = Util.getAllFiles((File)new File(currentSourceLocation), (FileFilter)fileFilter);
                    if (allFiles2 != null) {
                        if (allFiles == null) {
                            allFiles = allFiles2;
                        } else {
                            length = allFiles.length;
                            length2 = allFiles2.length;
                            v10 = allFiles;
                            allFiles = new File[length + length2];
                            System.arraycopy(v10, 0, allFiles, 0, length);
                            System.arraycopy(allFiles2, 0, allFiles, length, length2);
                        }
                    }
                    ++i;
                }
            }
        }
        apiDescription = new ApiDescription(this.projectName);
        tagScanner = TagScanner.newScanner();
        if (allFiles != null && allFiles.length != 0) {
            options = JavaCore.getOptions();
            options.put("org.eclipse.jdt.core.compiler.compliance", this.resolveCompliance(manifestMap));
            unit = null;
            i = 0;
            max = allFiles.length;
            while (i < max) {
                block94: {
                    unit = new CompilationUnit(allFiles[i].getAbsolutePath());
                    if (this.debug) {
                        System.out.println("Unit name[" + i + "] : " + unit.getName());
                    }
                    try {
                        try {
                            tagScanner.scan(unit, (IApiDescription)apiDescription, (IApiTypeContainer)classFileContainer, (Map)options);
                        }
                        catch (CoreException e) {
                            ApiPlugin.log((Throwable)e);
                            try {
                                if (classFileContainer != null) {
                                    classFileContainer.close();
                                }
                                break block94;
                            }
                            catch (CoreException v11) {}
                            break block94;
                        }
                    }
                    catch (Throwable var15_30) {
                        try {
                            if (classFileContainer != null) {
                                classFileContainer.close();
                            }
                        }
                        catch (CoreException v12) {}
                        throw var15_30;
                    }
                    try {
                        if (classFileContainer != null) {
                            classFileContainer.close();
                        }
                    }
                    catch (CoreException v13) {}
                }
                ++i;
            }
        }
        try {
            xmlVisitor = new ApiDescriptionXmlCreator(this.projectName, this.projectName);
            apiDescription.accept((ApiDescriptionVisitor)xmlVisitor);
            xml = xmlVisitor.getXML();
            Util.saveFile((File)apiDescriptionFile, (String)xml);
        }
        catch (CoreException e) {
            ApiPlugin.log((Throwable)e);
        }
        catch (IOException e) {
            ApiPlugin.log((Throwable)e);
        }
    }

    private boolean isApi(String path) {
        String pkg = null;
        Iterator iter = this.apiPackages.iterator();
        while (iter.hasNext()) {
            pkg = (String)iter.next();
            if (!path.endsWith(pkg.replace('.', File.separatorChar))) continue;
            return true;
        }
        return false;
    }

    private Set collectApiPackageNames(Map manifestmap) throws BundleException {
        HashSet<String> set = new HashSet<String>();
        ManifestElement[] packages = ManifestElement.parseHeader((String)"Export-Package", (String)((String)manifestmap.get("Export-Package")));
        if (packages != null) {
            int i = 0;
            while (i < packages.length) {
                ManifestElement packageName = packages[i];
                Enumeration directiveKeys = packageName.getDirectiveKeys();
                if (directiveKeys == null) {
                    set.add(packageName.getValue());
                } else {
                    boolean include = true;
                    while (directiveKeys.hasMoreElements()) {
                        String value;
                        Object directive = directiveKeys.nextElement();
                        if ("x-internal".equals(directive) && Boolean.valueOf(value = packageName.getDirective((String)directive)).booleanValue()) {
                            include = false;
                            break;
                        }
                        if (!"x-friends".equals(directive)) continue;
                        include = false;
                        break;
                    }
                    if (include) {
                        set.add(packageName.getValue());
                    }
                }
                ++i;
            }
        }
        return set;
    }

    private IApiTypeContainer getContainer(String location) {
        File f = new File(location);
        if (!f.exists()) {
            return null;
        }
        if (ApiFileGenerationTask.isZipJarFile(location)) {
            return new ArchiveApiTypeContainer(null, location);
        }
        return new DirectoryApiTypeContainer(null, location);
    }

    private String resolveCompliance(Map manifestmap) {
        String eename;
        if (manifestmap != null && (eename = (String)manifestmap.get("Bundle-RequiredExecutionEnvironment")) != null) {
            if ("J2SE-1.4".equals(eename)) {
                return "1.4";
            }
            if ("J2SE-1.5".equals(eename)) {
                return "1.5";
            }
            if ("JavaSE-1.6".equals(eename)) {
                return "1.6";
            }
        }
        return "1.3";
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isAPIToolsNature(File dotProjectFile) {
        if (!dotProjectFile.exists()) {
            return false;
        }
        BufferedInputStream stream = null;
        stream = new BufferedInputStream(new FileInputStream(dotProjectFile));
        String contents = new String(Util.getInputStreamAsCharArray((InputStream)stream, (int)-1, (String)"UTF-8"));
        boolean bl = this.containsAPIToolsNature(contents);
        if (stream == null) return bl;
        try {
            stream.close();
            return bl;
        }
        catch (IOException iOException) {}
        return bl;
        catch (FileNotFoundException e) {
            e.printStackTrace();
            if (stream == null) return false;
            try {
                stream.close();
                return false;
            }
            catch (IOException iOException) {}
            return false;
        }
        catch (IOException e2) {
            e2.printStackTrace();
            if (stream == null) return false;
            {
                catch (Throwable throwable) {
                    if (stream == null) throw throwable;
                    try {
                        stream.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
            }
            try {
                stream.close();
                return false;
            }
            catch (IOException iOException) {}
            return false;
        }
    }

    private static boolean isZipJarFile(String fileName) {
        String normalizedFileName = fileName.toLowerCase();
        return normalizedFileName.endsWith(".zip") || normalizedFileName.endsWith(".jar");
    }

    private boolean containsAPIToolsNature(String pluginXMLContents) {
        SAXParserFactory factory = null;
        try {
            factory = SAXParserFactory.newInstance();
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            return false;
        }
        SAXParser saxParser = null;
        try {
            saxParser = factory.newSAXParser();
        }
        catch (ParserConfigurationException parserConfigurationException) {
        }
        catch (SAXException sAXException) {}
        if (saxParser == null) {
            return false;
        }
        InputSource inputSource = new InputSource(new BufferedReader(new StringReader(pluginXMLContents)));
        try {
            APIToolsNatureDefaultHandler defaultHandler = new APIToolsNatureDefaultHandler();
            saxParser.parse(inputSource, (DefaultHandler)defaultHandler);
            return defaultHandler.isAPIToolsNature();
        }
        catch (SAXException sAXException) {
        }
        catch (IOException iOException) {}
        return false;
    }

    static class APIToolsNatureDefaultHandler
    extends DefaultHandler {
        private static final String NATURE_ELEMENT_NAME = "nature";
        boolean isAPIToolsNature = false;
        boolean insideNature = false;
        StringBuffer buffer;

        APIToolsNatureDefaultHandler() {
        }

        public void error(SAXParseException e) throws SAXException {
            e.printStackTrace();
        }

        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            if (this.isAPIToolsNature) {
                return;
            }
            this.insideNature = NATURE_ELEMENT_NAME.equals(name);
            if (this.insideNature) {
                this.buffer = new StringBuffer();
            }
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.insideNature) {
                this.buffer.append(ch, start, length);
            }
        }

        public void endElement(String uri, String localName, String name) throws SAXException {
            if (this.insideNature) {
                String natureName = String.valueOf(this.buffer).trim();
                this.isAPIToolsNature = "org.eclipse.pde.api.tools.apiAnalysisNature".equals(natureName);
            }
            this.insideNature = false;
        }

        public boolean isAPIToolsNature() {
            return this.isAPIToolsNature;
        }
    }
}

