/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.tasks;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.tools.ant.BuildException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.api.tools.internal.model.StubApiComponent;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.comparator.ApiComparator;
import org.eclipse.pde.api.tools.internal.provisional.comparator.DeltaVisitor;
import org.eclipse.pde.api.tools.internal.provisional.comparator.IDelta;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiBaseline;
import org.eclipse.pde.api.tools.internal.tasks.CommonUtilsTask;
import org.eclipse.pde.api.tools.internal.tasks.ExcludeListDeltaVisitor;
import org.eclipse.pde.api.tools.internal.tasks.Messages;

public class APIFreezeTask
extends CommonUtilsTask {
    private boolean debug;
    private String eeFileLocation;
    private String excludeListLocation;

    public void execute() throws BuildException {
        if (this.referenceBaselineLocation == null || this.currentBaselineLocation == null || this.reportLocation == null) {
            StringWriter out = new StringWriter();
            PrintWriter writer = new PrintWriter(out);
            writer.println(Messages.bind((String)Messages.printArguments, (Object[])new String[]{this.referenceBaselineLocation, this.currentBaselineLocation, this.reportLocation}));
            writer.flush();
            writer.close();
            throw new BuildException(String.valueOf(out.getBuffer()));
        }
        if (this.debug) {
            System.out.println("reference : " + this.referenceBaselineLocation);
            System.out.println("baseline to compare : " + this.currentBaselineLocation);
            System.out.println("report location : " + this.reportLocation);
            if (this.excludeListLocation != null) {
                System.out.println("exclude list location : " + this.excludeListLocation);
            } else {
                System.out.println("No exclude list location");
            }
        }
        long time = 0L;
        if (this.debug) {
            time = System.currentTimeMillis();
        }
        File referenceInstallDir = this.extractSDK("referenceBaseline", this.referenceBaselineLocation);
        File baselineInstallDir = this.extractSDK("currentBaseline", this.currentBaselineLocation);
        if (this.debug) {
            System.out.println("Extraction of both archives : " + (System.currentTimeMillis() - time) + "ms");
            time = System.currentTimeMillis();
        }
        IApiBaseline referenceBaseline = this.createBaseline("reference_baseline", this.getInstallDir(referenceInstallDir), this.eeFileLocation);
        IApiBaseline currentBaseline = this.createBaseline("current_baseline", this.getInstallDir(baselineInstallDir), this.eeFileLocation);
        IDelta delta = null;
        if (this.debug) {
            System.out.println("Creation of both baselines : " + (System.currentTimeMillis() - time) + "ms");
            time = System.currentTimeMillis();
        }
        try {
            delta = ApiComparator.compare((IApiBaseline)referenceBaseline, (IApiBaseline)currentBaseline, (int)1, (boolean)true);
        }
        finally {
            if (this.debug) {
                System.out.println("API freeze check : " + (System.currentTimeMillis() - time) + "ms");
                time = System.currentTimeMillis();
            }
            referenceBaseline.dispose();
            currentBaseline.dispose();
            StubApiComponent.disposeAllCaches();
            this.deleteBaseline(this.referenceBaselineLocation, referenceInstallDir);
            this.deleteBaseline(this.currentBaselineLocation, baselineInstallDir);
            if (this.debug) {
                System.out.println("Cleanup : " + (System.currentTimeMillis() - time) + "ms");
                time = System.currentTimeMillis();
            }
        }
        if (delta == null) {
            throw new BuildException(Messages.errorInComparison);
        }
        if (delta != ApiComparator.NO_DELTA) {
            block38: {
                BufferedWriter writer = null;
                File outputFile = new File(this.reportLocation);
                if (outputFile.exists()) {
                    outputFile.delete();
                } else {
                    File outputDir = outputFile.getParentFile();
                    if (!outputDir.exists() && !outputDir.mkdirs()) {
                        throw new BuildException(Messages.bind((String)Messages.errorCreatingParentReportFile, (Object)outputDir.getAbsolutePath()));
                    }
                }
                try {
                    String potentialExcludeList;
                    writer = new BufferedWriter(new FileWriter(outputFile));
                    ExcludeListDeltaVisitor visitor = new ExcludeListDeltaVisitor(this.excludeListLocation);
                    delta.accept((DeltaVisitor)visitor);
                    writer.write(visitor.getXML());
                    writer.flush();
                    if (this.debug && (potentialExcludeList = visitor.getPotentialExcludeList()).length() != 0) {
                        System.out.println("Potential exclude list:");
                        System.out.println(potentialExcludeList);
                    }
                }
                catch (IOException e) {
                    ApiPlugin.log((Throwable)e);
                    try {
                        if (writer != null) {
                            writer.close();
                        }
                        break block38;
                    }
                    catch (IOException iOException) {}
                    break block38;
                }
                catch (CoreException e) {
                    try {
                        ApiPlugin.log((Throwable)e);
                    }
                    catch (Throwable throwable) {
                        try {
                            if (writer != null) {
                                writer.close();
                            }
                        }
                        catch (IOException iOException) {}
                        throw throwable;
                    }
                    try {
                        if (writer != null) {
                            writer.close();
                        }
                        break block38;
                    }
                    catch (IOException iOException) {}
                    break block38;
                }
                try {
                    if (writer != null) {
                        writer.close();
                    }
                }
                catch (IOException iOException) {}
            }
            if (this.debug) {
                System.out.println("Report generation : " + (System.currentTimeMillis() - time) + "ms");
            }
        }
    }

    public void setDebug(String debugValue) {
        this.debug = Boolean.toString(true).equals(debugValue);
    }

    public void setEEFile(String eeFileLocation) {
        this.eeFileLocation = eeFileLocation;
    }

    public void setExcludeList(String excludeListLocation) {
        this.excludeListLocation = excludeListLocation;
    }

    public void setProfile(String baselineLocation) {
        this.currentBaselineLocation = baselineLocation;
    }

    public void setBaseline(String baselineLocation) {
        this.referenceBaselineLocation = baselineLocation;
    }

    public void setReport(String reportLocation) {
        this.reportLocation = reportLocation;
    }
}

