/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.exports;

import java.net.URI;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.internal.core.FeatureModelManager;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.wizards.exports.BaseExportWizardPage;
import org.eclipse.pde.internal.ui.wizards.exports.FeatureDestinationTab;
import org.eclipse.pde.internal.ui.wizards.exports.FeatureOptionsTab;
import org.eclipse.pde.internal.ui.wizards.exports.JNLPTab;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.PlatformUI;

public class FeatureExportWizardPage
extends BaseExportWizardPage {
    private JNLPTab fJNLPTab;
    static /* synthetic */ Class class$0;

    public FeatureExportWizardPage(IStructuredSelection selection) {
        super(selection, "featureExport", PDEUIMessages.ExportWizard_Feature_pageBlock);
        this.setTitle(PDEUIMessages.ExportWizard_Feature_pageTitle);
    }

    protected Object getInput() {
        return PDECore.getDefault().getFeatureModelManager();
    }

    public Object[] getListElements() {
        FeatureModelManager manager = PDECore.getDefault().getFeatureModelManager();
        return manager.getWorkspaceModels();
    }

    protected void hookHelpContext(Control control) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp(control, "org.eclipse.pde.doc.user.feature_export_wizard");
    }

    protected boolean isValidModel(IModel model) {
        return model instanceof IFeatureModel;
    }

    protected void createTabs(TabFolder folder, IDialogSettings settings) {
        super.createTabs(folder, settings);
        if (this.fDestinationTab.doExportToDirectory() && this.fOptionsTab.useJARFormat()) {
            this.createJNLPTab(folder);
            this.fJNLPTab.initialize(settings);
        }
    }

    protected void createDestinationTab(TabFolder folder) {
        this.fDestinationTab = new FeatureDestinationTab(this);
        TabItem item = new TabItem(folder, 0);
        item.setControl(this.fDestinationTab.createControl((Composite)folder));
        item.setText(PDEUIMessages.ExportWizard_destination);
    }

    protected void createOptionsTab(TabFolder folder) {
        this.fOptionsTab = new FeatureOptionsTab(this);
        TabItem item = new TabItem(folder, 0);
        item.setControl(this.fOptionsTab.createControl((Composite)folder));
        item.setText(PDEUIMessages.ExportWizard_options);
    }

    private void createJNLPTab(TabFolder folder) {
        this.fJNLPTab = new JNLPTab(this);
        TabItem item = new TabItem(folder, 0);
        item.setControl(this.fJNLPTab.createControl((Composite)folder));
        item.setText(PDEUIMessages.AdvancedFeatureExportPage_jnlp);
    }

    protected IModel findModelFor(IAdaptable object) {
        IProject project;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IProject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((project = (IProject)object.getAdapter((Class)clazz)) != null) {
            return PDECore.getDefault().getFeatureModelManager().getFeatureModel(project);
        }
        return null;
    }

    protected void saveSettings(IDialogSettings settings) {
        super.saveSettings(settings);
        if (this.fJNLPTab != null) {
            this.fJNLPTab.saveSettings(settings);
        }
    }

    protected String validateTabs() {
        String message = super.validateTabs();
        if (message == null && this.fTabFolder.getItemCount() > 3) {
            message = this.fJNLPTab.validate();
        }
        return message;
    }

    protected void adjustAdvancedTabsVisibility() {
        this.adjustJARSigningTabVisibility();
        this.adjustJNLPTabVisibility();
        this.pageChanged();
    }

    protected void adjustJNLPTabVisibility() {
        IDialogSettings settings = this.getDialogSettings();
        if (this.useJARFormat() && this.doExportToDirectory()) {
            if (this.fTabFolder.getItemCount() < 4) {
                this.createJNLPTab(this.fTabFolder);
                this.fJNLPTab.initialize(settings);
            }
        } else {
            int count = this.fTabFolder.getItemCount();
            if (count >= (this.useJARFormat() ? 4 : 3)) {
                this.fJNLPTab.saveSettings(settings);
                this.fTabFolder.getItem(count - 1).dispose();
            }
        }
    }

    protected boolean doMultiPlatform() {
        return ((FeatureOptionsTab)this.fOptionsTab).doMultiplePlatform();
    }

    protected String[] getJNLPInfo() {
        if (this.fJNLPTab == null || this.fTabFolder.getItemCount() < 4) {
            return null;
        }
        return this.fJNLPTab.getJNLPInfo();
    }

    protected boolean doExportMetadata() {
        if (this.fOptionsTab instanceof FeatureOptionsTab) {
            return ((FeatureOptionsTab)this.fOptionsTab).doExportMetadata();
        }
        return false;
    }

    protected URI getCategoryDefinition() {
        if (this.fOptionsTab instanceof FeatureOptionsTab) {
            return ((FeatureOptionsTab)this.fOptionsTab).getCategoryDefinition();
        }
        return null;
    }

    public IWizardPage getNextPage() {
        return this.doMultiPlatform() ? this.getWizard().getNextPage((IWizardPage)this) : null;
    }
}

