/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.util;

import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.fieldassist.IContentProposalListener;
import org.eclipse.jface.fieldassist.IContentProposalListener2;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.pde.internal.core.util.PDEJavaHelper;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.contentassist.TypeContentProposalListener;
import org.eclipse.pde.internal.ui.editor.contentassist.TypeContentProposalProvider;
import org.eclipse.pde.internal.ui.editor.contentassist.TypeFieldAssistDisposer;
import org.eclipse.pde.internal.ui.editor.contentassist.TypeProposalLabelProvider;
import org.eclipse.pde.internal.ui.editor.contentassist.display.JavaDocCommentReader;
import org.eclipse.pde.internal.ui.editor.plugin.JavaAttributeValue;
import org.eclipse.pde.internal.ui.editor.plugin.JavaAttributeWizard;
import org.eclipse.pde.internal.ui.editor.text.HTMLPrinter;
import org.eclipse.pde.internal.ui.util.SWTUtil;
import org.eclipse.pde.internal.ui.util.TextUtil;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.fieldassist.ContentAssistCommandAdapter;
import org.eclipse.ui.ide.IDE;

public class PDEJavaHelperUI {
    private static HashMap fDocMap = new HashMap();

    public static String selectType(IResource resource, int scope) {
        if (resource == null) {
            return null;
        }
        IProject project = resource.getProject();
        try {
            SelectionDialog dialog = JavaUI.createTypeDialog((Shell)PDEPlugin.getActiveWorkbenchShell(), (IRunnableContext)PlatformUI.getWorkbench().getProgressService(), (IJavaSearchScope)PDEJavaHelper.getSearchScope((IProject)project), (int)scope, (boolean)false, (String)"");
            dialog.setTitle(PDEUIMessages.ClassAttributeRow_dialogTitle);
            if (dialog.open() == 0) {
                IType type = (IType)dialog.getResult()[0];
                return type.getFullyQualifiedName('$');
            }
        }
        catch (JavaModelException javaModelException) {}
        return null;
    }

    public static String selectType(IResource resource, int scope, String filter, String superTypeName) {
        if (resource == null) {
            return null;
        }
        IProject project = resource.getProject();
        try {
            IJavaProject javaProject;
            IType superType;
            IJavaSearchScope searchScope = null;
            if (superTypeName != null && !superTypeName.equals("java.lang.Object") && (superType = (javaProject = JavaCore.create((IProject)project)).findType(superTypeName)) != null) {
                searchScope = SearchEngine.createHierarchyScope((IType)superType);
            }
            if (searchScope == null) {
                searchScope = PDEJavaHelper.getSearchScope((IProject)project);
            }
            SelectionDialog dialog = JavaUI.createTypeDialog((Shell)PDEPlugin.getActiveWorkbenchShell(), (IRunnableContext)PlatformUI.getWorkbench().getProgressService(), (IJavaSearchScope)searchScope, (int)scope, (boolean)false, (String)filter);
            dialog.setTitle(PDEUIMessages.ClassAttributeRow_dialogTitle);
            if (dialog.open() == 0) {
                IType type = (IType)dialog.getResult()[0];
                return type.getFullyQualifiedName('$');
            }
        }
        catch (JavaModelException javaModelException) {}
        return null;
    }

    public static String createClass(String name, IProject project, JavaAttributeValue value, boolean createIfNoNature) {
        name = TextUtil.trimNonAlphaChars(name).replace('$', '.');
        try {
            if (project.hasNature("org.eclipse.jdt.core.javanature")) {
                IJavaProject javaProject = JavaCore.create((IProject)project);
                IType result = null;
                if (name.length() > 0) {
                    result = javaProject.findType(name);
                }
                if (result != null) {
                    JavaUI.openInEditor((IJavaElement)result);
                } else {
                    JavaAttributeWizard wizard = new JavaAttributeWizard(value);
                    WizardDialog dialog = new WizardDialog(PDEPlugin.getActiveWorkbenchShell(), (IWizard)wizard);
                    dialog.create();
                    SWTUtil.setDialogSize((Dialog)dialog, 400, 500);
                    int dResult = dialog.open();
                    if (dResult == 0) {
                        return wizard.getQualifiedNameWithArgs();
                    }
                }
            } else if (createIfNoNature) {
                IResource resource = project.findMember((IPath)new Path(name));
                if (resource != null && resource instanceof IFile) {
                    IWorkbenchPage page = PDEPlugin.getActivePage();
                    IDE.openEditor((IWorkbenchPage)page, (IFile)((IFile)resource), (boolean)true);
                } else {
                    JavaAttributeWizard wizard = new JavaAttributeWizard(value);
                    WizardDialog dialog = new WizardDialog(PDEPlugin.getActiveWorkbenchShell(), (IWizard)wizard);
                    dialog.create();
                    SWTUtil.setDialogSize((Dialog)dialog, 400, 500);
                    int dResult = dialog.open();
                    if (dResult == 0) {
                        String newValue = wizard.getQualifiedName();
                        name = String.valueOf(newValue.replace('.', '/')) + ".java";
                        resource = project.findMember((IPath)new Path(name));
                        if (resource != null && resource instanceof IFile) {
                            IWorkbenchPage page = PDEPlugin.getActivePage();
                            IDE.openEditor((IWorkbenchPage)page, (IFile)((IFile)resource), (boolean)true);
                        }
                        return newValue;
                    }
                }
            }
        }
        catch (PartInitException e) {
            PDEPlugin.logException(e);
        }
        catch (JavaModelException javaModelException) {
            Display.getCurrent().beep();
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
        return null;
    }

    public static String getOSGIConstantJavaDoc(String constant, IJavaProject jp) {
        return PDEJavaHelperUI.getJavaDoc(constant, jp, "org.osgi.framework.Constants");
    }

    public static String getJavaDoc(String constant, IJavaProject jp, String className) {
        String javaDoc;
        block6: {
            HashMap<String, String> map = (HashMap<String, String>)fDocMap.get(className);
            if (map == null) {
                map = new HashMap<String, String>();
                fDocMap.put(className, map);
            }
            if ((javaDoc = (String)map.get(constant)) == null) {
                ISourceRange range;
                IType type;
                block7: {
                    try {
                        type = jp.findType(className);
                        if (type == null) break block6;
                        char[] chars = constant.toCharArray();
                        int i = 0;
                        while (i < chars.length) {
                            chars[i] = chars[i] == '-' ? 95 : (int)Character.toUpperCase(chars[i]);
                            ++i;
                        }
                        IField field = type.getField(new String(chars));
                        range = field.getJavadocRange();
                        if (range != null) break block7;
                        return null;
                    }
                    catch (JavaModelException javaModelException) {}
                }
                IBuffer buff = type.getOpenable().getBuffer();
                JavaDocCommentReader reader = new JavaDocCommentReader(buff, range.getOffset(), range.getOffset() + range.getLength() - 1);
                String text = PDEJavaHelperUI.getString(reader);
                javaDoc = PDEJavaHelperUI.formatJavaDoc(text);
                map.put(constant, javaDoc);
            }
        }
        return javaDoc;
    }

    private static String formatJavaDoc(String text) {
        StringBuffer buffer = new StringBuffer();
        HTMLPrinter.insertPageProlog(buffer, 0, TextUtil.getJavaDocStyleSheerURL());
        buffer.append(text);
        HTMLPrinter.addPageEpilog(buffer);
        return buffer.toString();
    }

    private static String getString(Reader reader) {
        StringBuffer buf = new StringBuffer();
        char[] buffer = new char[1024];
        try {
            int count;
            while ((count = reader.read(buffer)) != -1) {
                buf.append(buffer, 0, count);
            }
        }
        catch (IOException iOException) {
            return null;
        }
        return buf.toString();
    }

    public static TypeFieldAssistDisposer addTypeFieldAssistToText(Text text, IProject project, int searchScope) {
        int bits = 16512;
        ControlDecoration controlDecoration = new ControlDecoration((Control)text, bits);
        controlDecoration.setMarginWidth(0);
        controlDecoration.setDescriptionText(PDEUIMessages.PDEJavaHelper_msgContentAssistAvailable);
        controlDecoration.setShowHover(true);
        controlDecoration.setShowOnlyOnFocus(true);
        FieldDecoration contentProposalImage = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_CONTENT_PROPOSAL");
        controlDecoration.setImage(contentProposalImage.getImage());
        TypeContentProposalProvider proposalProvider = new TypeContentProposalProvider(project, searchScope);
        TextContentAdapter textContentAdapter = new TextContentAdapter();
        char[] autoActivationChars = new char[]{'.'};
        ContentAssistCommandAdapter adapter = new ContentAssistCommandAdapter((Control)text, (IControlContentAdapter)textContentAdapter, (IContentProposalProvider)proposalProvider, "org.eclipse.ui.edit.text.contentAssist.proposals", autoActivationChars);
        TypeProposalLabelProvider labelProvider = new TypeProposalLabelProvider();
        adapter.setLabelProvider((ILabelProvider)labelProvider);
        adapter.setProposalAcceptanceStyle(2);
        adapter.setFilterStyle(1);
        TypeContentProposalListener proposalListener = new TypeContentProposalListener();
        adapter.addContentProposalListener((IContentProposalListener)proposalListener);
        adapter.addContentProposalListener((IContentProposalListener2)proposalListener);
        return new TypeFieldAssistDisposer(adapter, proposalListener);
    }
}

