/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.preferences;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.SWTFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class MainPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Button fUseID;
    private Button fUseName;
    private Button fAutoManage;
    private Button fOverwriteBuildFiles;
    private Button fShowSourceBundles;
    private Button fPromptOnRemove;

    public MainPreferencePage() {
        this.setPreferenceStore(PDEPlugin.getDefault().getPreferenceStore());
        this.setDescription(PDEUIMessages.Preferences_MainPage_Description);
    }

    protected Control createContents(Composite parent) {
        IPreferenceStore store = PDEPlugin.getDefault().getPreferenceStore();
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 15;
        composite.setLayout((Layout)layout);
        Group group = SWTFactory.createGroup(composite, PDEUIMessages.Preferences_MainPage_showObjects, 1, 1, 768);
        this.fUseID = new Button((Composite)group, 16);
        this.fUseID.setText(PDEUIMessages.Preferences_MainPage_useIds);
        this.fUseName = new Button((Composite)group, 16);
        this.fUseName.setText(PDEUIMessages.Preferences_MainPage_useFullNames);
        if (store.getString("Preferences.MainPage.showObjects").equals("useIds")) {
            this.fUseID.setSelection(true);
        } else {
            this.fUseName.setSelection(true);
        }
        group = SWTFactory.createGroup(composite, PDEUIMessages.MainPreferencePage_group2, 1, 1, 768);
        this.fAutoManage = new Button((Composite)group, 32);
        this.fAutoManage.setText(PDEUIMessages.MainPreferencePage_updateStale);
        this.fAutoManage.setSelection(store.getBoolean("Preferences.MainPage.automanageDependencies"));
        group = SWTFactory.createGroup(composite, PDEUIMessages.MainPreferencePage_exportingGroup, 1, 1, 768);
        this.fOverwriteBuildFiles = new Button((Composite)group, 32);
        this.fOverwriteBuildFiles.setText(PDEUIMessages.MainPreferencePage_promptBeforeOverwrite);
        this.fOverwriteBuildFiles.setSelection(!"always".equals(store.getString("Preferences.MainPage.overwriteBuildFilesOnExport")));
        group = SWTFactory.createGroup(composite, PDEUIMessages.MainPreferencePage_sourceGroup, 1, 1, 768);
        this.fShowSourceBundles = new Button((Composite)group, 32);
        this.fShowSourceBundles.setText(PDEUIMessages.MainPreferencePage_showSourceBundles);
        this.fShowSourceBundles.setSelection(store.getBoolean("Preferences.MainPage.showSourceBundles"));
        group = SWTFactory.createGroup(composite, PDEUIMessages.MainPreferencePage_targetDefinitionsGroup, 1, 1, 768);
        this.fPromptOnRemove = new Button((Composite)group, 32);
        this.fPromptOnRemove.setText(PDEUIMessages.MainPreferencePage_promtBeforeRemove);
        this.fPromptOnRemove.setSelection(!"always".equals(store.getString("Preferences.MainPage.promptRemoveTarget")));
        this.fPromptOnRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PDEPlugin.getDefault().getPreferenceStore().setValue("Preferences.MainPage.promptRemoveTarget", MainPreferencePage.this.fPromptOnRemove.getSelection() ? "prompt" : "always");
            }
        });
        return composite;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        Dialog.applyDialogFont((Control)this.getControl());
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.pde.doc.user.main_preference_page");
    }

    public boolean performOk() {
        IPreferenceStore store = PDEPlugin.getDefault().getPreferenceStore();
        if (this.fUseID.getSelection()) {
            store.setValue("Preferences.MainPage.showObjects", "useIds");
        } else {
            store.setValue("Preferences.MainPage.showObjects", "useNames");
        }
        store.setValue("Preferences.MainPage.automanageDependencies", this.fAutoManage.getSelection());
        store.setValue("Preferences.MainPage.overwriteBuildFilesOnExport", this.fOverwriteBuildFiles.getSelection() ? "prompt" : "always");
        store.setValue("Preferences.MainPage.showSourceBundles", this.fShowSourceBundles.getSelection());
        PDEPlugin.getDefault().getPreferenceManager().savePluginPreferences();
        return super.performOk();
    }

    protected void performDefaults() {
        IPreferenceStore store = PDEPlugin.getDefault().getPreferenceStore();
        if (store.getDefaultString("Preferences.MainPage.showObjects").equals("useIds")) {
            this.fUseID.setSelection(true);
            this.fUseName.setSelection(false);
        } else {
            this.fUseID.setSelection(false);
            this.fUseName.setSelection(true);
        }
        this.fAutoManage.setSelection(false);
        this.fOverwriteBuildFiles.setSelection(true);
        this.fShowSourceBundles.setSelection(false);
        this.fPromptOnRemove.setSelection(true);
    }

    public void setVisible(boolean visible) {
        this.fPromptOnRemove.setSelection(!"always".equals(PDEPlugin.getDefault().getPreferenceManager().getString("Preferences.MainPage.promptRemoveTarget")));
        super.setVisible(visible);
    }

    public void init(IWorkbench workbench) {
    }
}

