/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.internal.repository.tools.tasks;

import java.io.File;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.equinox.internal.p2.artifact.mirror.IArtifactMirrorLog;
import org.eclipse.equinox.internal.p2.artifact.repository.ant.AntMirrorLog;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.p2.internal.repository.tools.Messages;
import org.eclipse.equinox.p2.internal.repository.tools.MirrorApplication;
import org.eclipse.equinox.p2.internal.repository.tools.tasks.AbstractRepositoryTask;
import org.eclipse.equinox.p2.internal.repository.tools.tasks.ComparatorDescription;
import org.eclipse.equinox.p2.internal.repository.tools.tasks.SlicingOption;
import org.eclipse.equinox.p2.internal.repository.tools.tasks.TaskHelper;

public class MirrorTask
extends AbstractRepositoryTask {
    private File mirrorLog;
    private ComparatorDescription comparator;

    public MirrorTask() {
        this.application = new MirrorApplication();
    }

    public void execute() throws BuildException {
        try {
            if (this.mirrorLog != null) {
                ((MirrorApplication)this.application).setLog(this.mirrorLog);
            } else {
                ((MirrorApplication)this.application).setLog((IArtifactMirrorLog)new AntMirrorLog((Object)this));
            }
            if (this.comparator != null) {
                ((MirrorApplication)this.application).setCompare(true);
                if (this.comparator.getBaseline() != null) {
                    ((MirrorApplication)this.application).setBaseline(this.comparator.getBaseline().getDescriptor().getRepoLocation());
                }
                if (this.comparator.getComparator() != null) {
                    ((MirrorApplication)this.application).setComparatorID(this.comparator.getComparator());
                }
                if (this.comparator.getComparatorLog() != null) {
                    ((MirrorApplication)this.application).setComparatorLog(this.comparator.getComparatorLog());
                }
            }
            this.prepareSourceRepos();
            this.application.initializeRepos(null);
            List ius = this.prepareIUs();
            this.application.setSourceIUs(ius);
            IStatus result = this.application.run(null);
            if (result.matches(4)) {
                throw new BuildException(TaskHelper.statusToString(result, null).toString());
            }
        }
        catch (ProvisionException e) {
            throw new BuildException((Throwable)e);
        }
        catch (NoSuchMethodException e) {
            throw new BuildException((Throwable)e);
        }
    }

    public SlicingOption createSlicingOptions() {
        SlicingOption options = new SlicingOption();
        ((MirrorApplication)this.application).setSlicingOptions(options.getOptions());
        return options;
    }

    public ComparatorDescription createComparator() {
        if (this.comparator != null) {
            throw new BuildException(Messages.exception_onlyOneComparator);
        }
        this.comparator = new ComparatorDescription();
        return this.comparator;
    }

    public void setLog(String value) {
        this.mirrorLog = new File(value);
    }

    public void setIgnoreErrors(boolean value) {
        ((MirrorApplication)this.application).setIgnoreErrors(value);
    }

    public void setRaw(boolean value) {
        ((MirrorApplication)this.application).setRaw(value);
    }

    public void setVerbose(boolean value) {
        ((MirrorApplication)this.application).setVerbose(value);
    }

    public void setValidate(boolean value) {
        ((MirrorApplication)this.application).setValidate(value);
    }
}

