/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.internal.repository.tools.tasks;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.internal.p2.artifact.repository.ant.AntMirrorLog;
import org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepository;
import org.eclipse.equinox.internal.provisional.p2.query.Collector;
import org.eclipse.equinox.internal.provisional.p2.query.Query;
import org.eclipse.equinox.p2.internal.repository.tools.AbstractApplication;
import org.eclipse.equinox.p2.internal.repository.tools.Messages;
import org.eclipse.equinox.p2.internal.repository.tools.RepositoryDescriptor;
import org.eclipse.equinox.p2.internal.repository.tools.tasks.DestinationRepository;
import org.eclipse.equinox.p2.internal.repository.tools.tasks.IUDescription;
import org.eclipse.equinox.p2.internal.repository.tools.tasks.RepositoryFileSet;
import org.eclipse.equinox.p2.internal.repository.tools.tasks.RepositoryList;
import org.eclipse.osgi.util.NLS;

public abstract class AbstractRepositoryTask
extends Task {
    protected static final String ANT_PREFIX = "${";
    protected AbstractApplication application;
    protected List iuTasks = new ArrayList();
    protected List sourceRepos = new ArrayList();
    protected List destinations = new ArrayList();

    protected void addMetadataSourceRepository(URI repoLocation) {
        RepositoryDescriptor source = new RepositoryDescriptor();
        source.setLocation(repoLocation);
        source.setKind("M");
        this.application.addSource(source);
    }

    protected void addArtifactSourceRepository(URI repoLocation) {
        RepositoryDescriptor source = new RepositoryDescriptor();
        source.setLocation(repoLocation);
        source.setKind("A");
        this.application.addSource(source);
    }

    public Object createIu() {
        IUDescription iu = new IUDescription();
        this.iuTasks.add(iu);
        return iu;
    }

    public void setSource(String location) {
        RepositoryDescriptor source = new RepositoryDescriptor();
        try {
            source.setLocation(URIUtil.fromString((String)location));
            this.application.addSource(source);
        }
        catch (URISyntaxException e) {
            throw new BuildException((Throwable)e);
        }
    }

    public void setDestination(String location) {
        DestinationRepository dest = new DestinationRepository();
        dest.setLocation(location);
        this.destinations.add(dest);
        this.application.addDestination(dest.getDescriptor());
    }

    public DestinationRepository createDestination() {
        DestinationRepository destination = new DestinationRepository();
        this.destinations.add(destination);
        this.application.addDestination(destination.getDescriptor());
        return destination;
    }

    public DestinationRepository createRepository() {
        DestinationRepository destination = new DestinationRepository();
        this.destinations.add(destination);
        this.application.addDestination(destination.getDescriptor());
        return destination;
    }

    public void addConfiguredSource(RepositoryList sourceList) {
        Iterator iter = sourceList.getRepositoryList().iterator();
        while (iter.hasNext()) {
            DestinationRepository repo = (DestinationRepository)((Object)iter.next());
            this.application.addSource(repo.getDescriptor());
        }
        iter = sourceList.getFileSetList().iterator();
        while (iter.hasNext()) {
            FileSet fileSet = (FileSet)iter.next();
            this.sourceRepos.add(fileSet);
        }
    }

    protected void prepareSourceRepos() {
        if (this.sourceRepos == null || this.sourceRepos.isEmpty()) {
            return;
        }
        Iterator iter = this.sourceRepos.iterator();
        while (iter.hasNext()) {
            RepositoryFileSet fileset = (RepositoryFileSet)((Object)iter.next());
            if (fileset.getRepoLocation() != null) {
                if (fileset.getRepoLocation().startsWith(ANT_PREFIX)) continue;
                this.addArtifactSourceRepository(fileset.getRepoLocationURI());
                this.addMetadataSourceRepository(fileset.getRepoLocationURI());
                continue;
            }
            if (fileset.getDir() == null) continue;
            DirectoryScanner scanner = fileset.getDirectoryScanner(this.getProject());
            String[][] elements = new String[][]{scanner.getIncludedDirectories(), scanner.getIncludedFiles()};
            int i = 0;
            while (i < 2) {
                int j = 0;
                while (j < elements[i].length) {
                    File file = new File(fileset.getDir(), elements[i][j]);
                    URI uri = file.toURI();
                    if (file.isFile() && file.getName().endsWith(".zip")) {
                        uri = URIUtil.toJarURI((URI)uri, null);
                    }
                    if (fileset.isBoth()) {
                        this.addArtifactSourceRepository(uri);
                        this.addMetadataSourceRepository(uri);
                    } else if (fileset.isArtifact()) {
                        this.addArtifactSourceRepository(uri);
                    } else if (fileset.isMetadata()) {
                        this.addMetadataSourceRepository(uri);
                    } else {
                        throw new BuildException(NLS.bind((String)Messages.unknown_repository_type, (Object)uri));
                    }
                    ++j;
                }
                ++i;
            }
        }
        this.sourceRepos.clear();
    }

    protected List prepareIUs() {
        if (this.iuTasks == null || this.iuTasks.isEmpty()) {
            return null;
        }
        IMetadataRepository repository = this.application.getCompositeMetadataRepository();
        ArrayList result = new ArrayList();
        Iterator iter = this.iuTasks.iterator();
        while (iter.hasNext()) {
            IUDescription iu = (IUDescription)((Object)iter.next());
            Query iuQuery = iu.createQuery();
            Collector collector = new Collector();
            repository.query(iuQuery, collector, null);
            if (iu.isRequired() && collector.isEmpty()) {
                throw new BuildException(NLS.bind((String)Messages.AbstractRepositoryTask_unableToFind, (Object)iu.toString()));
            }
            result.addAll(collector.toCollection());
        }
        return result;
    }

    protected void log(IStatus status) {
        try {
            new AntMirrorLog((Object)this).log(status);
        }
        catch (NoSuchMethodException noSuchMethodException) {}
    }
}

