/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.base.ant;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.help.search.HelpIndexBuilder;

public class BuildHelpIndex
extends Task {
    private String manifest;
    private String destination;
    private HelpIndexBuilder builder;

    public void execute() throws BuildException {
        File file = this.getFile(this.manifest);
        if (file == null) {
            throw new BuildException("Manifest not set.");
        }
        File target = this.getFile(this.destination);
        if (target == null) {
            throw new BuildException("Target directory not set.");
        }
        this.builder = new HelpIndexBuilder();
        this.builder.setManifest(file);
        this.builder.setDestination(target);
        IProgressMonitor monitor = (IProgressMonitor)this.getProject().getReferences().get("eclipse.progress.monitor");
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            this.builder.execute(monitor);
        }
        catch (CoreException e) {
            if (e.getStatus().getSeverity() == 4) {
                throw new BuildException(e.getMessage(), e.getCause());
            }
            this.printStatus(e);
        }
    }

    private void printStatus(CoreException e) {
        IStatus status = e.getStatus();
        System.out.println(e.getMessage());
        if (status.isMultiStatus()) {
            IStatus[] children = status.getChildren();
            int i = 0;
            while (i < children.length) {
                IStatus child = children[i];
                System.out.println("    " + child.getMessage());
                ++i;
            }
        }
    }

    private File getFile(String fileName) {
        if (fileName == null) {
            return null;
        }
        Path path = new Path(fileName);
        if (path.isAbsolute()) {
            return new File(fileName);
        }
        File root = this.getProject().getBaseDir();
        if (fileName.equals(".") || fileName.equals("./")) {
            return root;
        }
        if (fileName.equals("..") || fileName.equals("../")) {
            return root.getParentFile();
        }
        return new File(root, fileName);
    }

    public void setManifest(String manifest) {
        this.manifest = manifest;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }
}

