/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search.internal.ui;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.search.internal.ui.SearchMessages;
import org.eclipse.search.internal.ui.SearchPlugin;
import org.eclipse.search.internal.ui.SearchPluginImages;
import org.eclipse.search.internal.ui.SearchResultViewer;
import org.eclipse.search.internal.ui.SorterDescriptor;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.model.WorkbenchViewerSorter;

class SortDropDownAction
extends Action
implements IMenuCreator {
    private static final String TAG_SORTERS = "sorters";
    private static final String TAG_DEFAULT_SORTERS = "defaultSorters";
    private static final String TAG_ELEMENT = "element";
    private static final String TAG_PAGE_ID = "pageId";
    private static final String TAG_SORTER_ID = "sorterId";
    private static Map fgLastCheckedForType = new HashMap(5);
    private SearchResultViewer fViewer;
    private String fPageId;
    private Menu fMenu;
    private Map fLastCheckedForType;

    public SortDropDownAction(SearchResultViewer viewer) {
        super(SearchMessages.SortDropDownAction_label);
        SearchPluginImages.setImageDescriptors((IAction)this, "lcl16/", "org.eclipse.search.ui.search_sortmatch.gif");
        this.fViewer = viewer;
        this.setToolTipText(SearchMessages.SortDropDownAction_tooltip);
        this.setMenuCreator(this);
        this.fLastCheckedForType = new HashMap(5);
    }

    public void dispose() {
        if (this.fMenu != null && !this.fMenu.isDisposed()) {
            this.fMenu.dispose();
        }
        this.fMenu = null;
    }

    public Menu getMenu(Control parent) {
        return null;
    }

    void setPageId(String pageId) {
        this.fPageId = pageId;
        SorterDescriptor sorterDesc = (SorterDescriptor)this.fLastCheckedForType.get(pageId);
        if (sorterDesc == null) {
            sorterDesc = (SorterDescriptor)fgLastCheckedForType.get(pageId);
        }
        if (sorterDesc == null) {
            sorterDesc = this.findSorter(this.fPageId);
        }
        if (sorterDesc != null) {
            this.setChecked(sorterDesc);
            this.fViewer.setSorter(sorterDesc.createObject());
        } else {
            this.fViewer.setSorter((ViewerSorter)new WorkbenchViewerSorter());
        }
    }

    public Menu getMenu(final Menu parent) {
        this.dispose();
        this.fMenu = new Menu(parent);
        Iterator iter = SearchPlugin.getDefault().getSorterDescriptors().iterator();
        while (iter.hasNext()) {
            ViewerSorter sorter;
            Object value = this.fLastCheckedForType.get(this.fPageId);
            final String checkedId = value instanceof SorterDescriptor ? ((SorterDescriptor)value).getId() : "";
            final SorterDescriptor sorterDesc = (SorterDescriptor)iter.next();
            if (!sorterDesc.getPageId().equals(this.fPageId) && !sorterDesc.getPageId().equals("*") || (sorter = sorterDesc.createObject()) == null) continue;
            Action action = new Action(){

                public void run() {
                    if (!checkedId.equals(sorterDesc.getId())) {
                        SortDropDownAction.this.setChecked(sorterDesc);
                        BusyIndicator.showWhile((Display)parent.getDisplay(), (Runnable)new Runnable(this, sorter){
                            final /* synthetic */ 1 this$1;
                            private final /* synthetic */ ViewerSorter val$sorter;
                            {
                                this.this$1 = var1_1;
                                this.val$sorter = viewerSorter;
                            }

                            public void run() {
                                SortDropDownAction.access$1(1.access$0(this.this$1)).setSorter(this.val$sorter);
                            }
                        });
                    }
                }

                static /* synthetic */ SortDropDownAction access$0(1 var0) {
                    return var0.SortDropDownAction.this;
                }
            };
            action.setText(sorterDesc.getLabel());
            action.setImageDescriptor(sorterDesc.getImage());
            action.setToolTipText(sorterDesc.getToolTipText());
            action.setChecked(checkedId.equals(sorterDesc.getId()));
            this.addActionToMenu(this.fMenu, action);
        }
        return this.fMenu;
    }

    protected void addActionToMenu(Menu parent, Action action) {
        ActionContributionItem item = new ActionContributionItem((IAction)action);
        item.fill(parent, -1);
    }

    public void run() {
    }

    private SorterDescriptor findSorter(String pageId) {
        Iterator iter = SearchPlugin.getDefault().getSorterDescriptors().iterator();
        while (iter.hasNext()) {
            SorterDescriptor sorterDesc = (SorterDescriptor)iter.next();
            if (!sorterDesc.getPageId().equals(pageId) && !sorterDesc.getPageId().equals("*")) continue;
            return sorterDesc;
        }
        return null;
    }

    private SorterDescriptor getSorter(String sorterId) {
        Iterator iter = SearchPlugin.getDefault().getSorterDescriptors().iterator();
        while (iter.hasNext()) {
            SorterDescriptor sorterDesc = (SorterDescriptor)iter.next();
            if (!sorterDesc.getId().equals(sorterId)) continue;
            return sorterDesc;
        }
        return null;
    }

    private void setChecked(SorterDescriptor sorterDesc) {
        this.fLastCheckedForType.put(this.fPageId, sorterDesc);
        fgLastCheckedForType.put(this.fPageId, sorterDesc);
    }

    SortDropDownAction renew() {
        SortDropDownAction action = new SortDropDownAction(this.fViewer);
        action.fLastCheckedForType = this.fLastCheckedForType;
        action.fPageId = this.fPageId;
        this.dispose();
        return action;
    }

    void restoreState(IMemento memento) {
        if (this.fLastCheckedForType.isEmpty()) {
            this.restoreState(memento, this.fLastCheckedForType, TAG_SORTERS);
        }
        if (fgLastCheckedForType.isEmpty()) {
            this.restoreState(memento, fgLastCheckedForType, TAG_DEFAULT_SORTERS);
        }
    }

    private void restoreState(IMemento memento, Map map, String mapName) {
        if ((memento = memento.getChild(mapName)) == null) {
            return;
        }
        IMemento[] mementoElements = memento.getChildren(TAG_ELEMENT);
        int i = 0;
        while (i < mementoElements.length) {
            String pageId = mementoElements[i].getString(TAG_PAGE_ID);
            String sorterId = mementoElements[i].getString(TAG_SORTER_ID);
            SorterDescriptor sorterDesc = this.getSorter(sorterId);
            if (sorterDesc != null) {
                map.put(pageId, sorterDesc);
            }
            ++i;
        }
    }

    void saveState(IMemento memento) {
        this.saveState(memento, fgLastCheckedForType, TAG_DEFAULT_SORTERS);
        this.saveState(memento, this.fLastCheckedForType, TAG_SORTERS);
    }

    private void saveState(IMemento memento, Map map, String mapName) {
        Iterator iter = map.entrySet().iterator();
        memento = memento.createChild(mapName);
        while (iter.hasNext()) {
            IMemento mementoElement = memento.createChild(TAG_ELEMENT);
            Map.Entry entry = iter.next();
            mementoElement.putString(TAG_PAGE_ID, (String)entry.getKey());
            mementoElement.putString(TAG_SORTER_ID, ((SorterDescriptor)entry.getValue()).getId());
        }
    }

    int getSorterCount() {
        int count = 0;
        Iterator iter = SearchPlugin.getDefault().getSorterDescriptors().iterator();
        while (iter.hasNext()) {
            SorterDescriptor sorterDesc = (SorterDescriptor)iter.next();
            if (!sorterDesc.getPageId().equals(this.fPageId) && !sorterDesc.getPageId().equals("*")) continue;
            ++count;
        }
        return count;
    }

    static /* synthetic */ SearchResultViewer access$1(SortDropDownAction sortDropDownAction) {
        return sortDropDownAction.fViewer;
    }
}

