/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.fix;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.internal.corext.fix.UnusedCodeFix;
import org.eclipse.jdt.internal.ui.fix.AbstractMultiFix;
import org.eclipse.jdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.jdt.ui.cleanup.CleanUpRequirements;
import org.eclipse.jdt.ui.cleanup.ICleanUpFix;
import org.eclipse.jdt.ui.text.java.IProblemLocation;

public class UnnecessaryCodeCleanUp
extends AbstractMultiFix {
    public UnnecessaryCodeCleanUp(Map options) {
        super(options);
    }

    public UnnecessaryCodeCleanUp() {
    }

    public CleanUpRequirements getRequirements() {
        boolean requireAST = this.isEnabled("cleanup.remove_unnecessary_casts");
        Map requiredOptions = requireAST ? this.getRequiredOptions() : null;
        return new CleanUpRequirements(requireAST, false, false, requiredOptions);
    }

    protected ICleanUpFix createFix(CompilationUnit compilationUnit) throws CoreException {
        return UnusedCodeFix.createCleanUp(compilationUnit, false, false, false, false, false, false, this.isEnabled("cleanup.remove_unnecessary_casts"));
    }

    protected ICleanUpFix createFix(CompilationUnit compilationUnit, IProblemLocation[] problems) throws CoreException {
        return UnusedCodeFix.createCleanUp(compilationUnit, problems, false, false, false, false, false, false, this.isEnabled("cleanup.remove_unnecessary_casts"));
    }

    private Map getRequiredOptions() {
        Hashtable<String, String> result = new Hashtable<String, String>();
        if (this.isEnabled("cleanup.remove_unnecessary_casts")) {
            result.put("org.eclipse.jdt.core.compiler.problem.unnecessaryTypeCheck", "warning");
        }
        return result;
    }

    public String[] getStepDescriptions() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.isEnabled("cleanup.remove_unnecessary_casts")) {
            result.add(MultiFixMessages.UnusedCodeCleanUp_RemoveUnusedCasts_description);
        }
        return result.toArray(new String[result.size()]);
    }

    public String getPreview() {
        StringBuffer buf = new StringBuffer();
        if (this.isEnabled("cleanup.remove_unnecessary_casts")) {
            buf.append("Boolean b= Boolean.TRUE;\n");
        } else {
            buf.append("Boolean b= (Boolean) Boolean.TRUE;\n");
        }
        return buf.toString();
    }

    public boolean canFix(ICompilationUnit compilationUnit, IProblemLocation problem) {
        if (problem.getProblemId() == 553648309) {
            return this.isEnabled("cleanup.remove_unnecessary_casts");
        }
        return false;
    }

    public int computeNumberOfFixes(CompilationUnit compilationUnit) {
        int result = 0;
        IProblem[] problems = compilationUnit.getProblems();
        if (this.isEnabled("cleanup.remove_unnecessary_casts")) {
            result += UnnecessaryCodeCleanUp.getNumberOfProblems(problems, 553648309);
        }
        return result;
    }
}

