/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.typeconstraints.typesets;

import java.util.Iterator;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.types.ArrayType;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.types.TType;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.typesets.EnumeratedTypeSet;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.typesets.SingletonTypeSet;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.typesets.SubTypesOfSingleton;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.typesets.SubTypesSet;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.typesets.SuperTypesOfSingleton;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.typesets.TypeSet;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.typesets.TypeSetEnvironment;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.typesets.TypeSetIntersection;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints2.TTypes;

public class SuperTypesSet
extends TypeSet {
    private TypeSet fLowerBounds;
    private EnumeratedTypeSet fEnumCache = null;

    SuperTypesSet(TType subType, TypeSetEnvironment typeSetEnvironment) {
        super(typeSetEnvironment);
        this.fLowerBounds = new SingletonTypeSet(subType, typeSetEnvironment);
    }

    SuperTypesSet(TypeSet subTypes, TypeSetEnvironment typeSetEnvironment) {
        super(typeSetEnvironment);
        this.fLowerBounds = subTypes;
    }

    public boolean isUniverse() {
        return this.fLowerBounds.isUniverse();
    }

    public TypeSet makeClone() {
        return this;
    }

    public TypeSet upperBound() {
        return new SingletonTypeSet(this.getTypeSetEnvironment().getJavaLangObject(), this.getTypeSetEnvironment());
    }

    public TypeSet lowerBound() {
        return this.fLowerBounds.lowerBound();
    }

    protected TypeSet specialCasesIntersectedWith(TypeSet s2) {
        TypeSet myLowerSubTypes;
        TType t2;
        TType t1;
        TypeSet st2;
        if (this.fLowerBounds.equals(s2)) {
            return s2;
        }
        if (s2 instanceof SuperTypesSet) {
            st2 = (SuperTypesSet)s2;
            if (this.fLowerBounds.isSingleton() && ((SuperTypesSet)st2).fLowerBounds.isSingleton()) {
                t1 = this.fLowerBounds.anyMember();
                if (TTypes.canAssignTo(t1, t2 = ((SuperTypesSet)st2).fLowerBounds.anyMember())) {
                    return new SuperTypesSet(((SuperTypesSet)st2).fLowerBounds, this.getTypeSetEnvironment());
                }
            } else if (this.fLowerBounds instanceof SubTypesSet && ((SubTypesSet)(myLowerSubTypes = (SubTypesSet)this.fLowerBounds)).upperBound().equals(((SuperTypesSet)st2).upperBound())) {
                return st2;
            }
        }
        if (s2 instanceof SuperTypesOfSingleton) {
            st2 = (SuperTypesOfSingleton)s2;
            if (this.fLowerBounds.isSingleton()) {
                t1 = this.fLowerBounds.anyMember();
                if (TTypes.canAssignTo(t1, t2 = ((SuperTypesOfSingleton)st2).uniqueLowerBound())) {
                    return this.getTypeSetEnvironment().createSuperTypesOfSingleton(t2);
                }
            } else if (this.fLowerBounds instanceof SubTypesOfSingleton && ((SubTypesOfSingleton)(myLowerSubTypes = (SubTypesOfSingleton)this.fLowerBounds)).uniqueUpperBound().equals(((SuperTypesOfSingleton)st2).uniqueUpperBound())) {
                return st2;
            }
        }
        if (s2 instanceof SubTypesSet) {
            st2 = (SubTypesSet)s2;
            if (this.fLowerBounds.equals(((SubTypesSet)st2).upperBound())) {
                return this.fLowerBounds;
            }
            if (this.fLowerBounds instanceof TypeSetIntersection) {
                TypeSetIntersection lbXSect = (TypeSetIntersection)this.fLowerBounds;
                TypeSet xsectLeft = lbXSect.getLHS();
                TypeSet xsectRight = lbXSect.getRHS();
                if (xsectLeft.equals(((SubTypesSet)st2).upperBound())) {
                    return new TypeSetIntersection(s2, new SuperTypesSet(xsectRight, this.getTypeSetEnvironment()));
                }
            }
        }
        return null;
    }

    public TypeSet superTypes() {
        return this;
    }

    public boolean isEmpty() {
        return this.fLowerBounds.isEmpty();
    }

    public boolean contains(TType t) {
        if (this.fEnumCache != null) {
            return this.fEnumCache.contains(t);
        }
        if (t.equals(this.getJavaLangObject())) {
            return true;
        }
        if (this.fLowerBounds.contains(t)) {
            return true;
        }
        Iterator lbIter = this.fLowerBounds.iterator();
        while (lbIter.hasNext()) {
            TType lb = (TType)lbIter.next();
            if (!TTypes.canAssignTo(lb, t)) continue;
            return true;
        }
        return false;
    }

    public boolean containsAll(TypeSet s) {
        if (this.fEnumCache != null) {
            return this.fEnumCache.containsAll(s);
        }
        if (!this.isUniverse() && s.isUniverse()) {
            return false;
        }
        if (this.equals(s)) {
            return true;
        }
        if (this.fLowerBounds.containsAll(s)) {
            return true;
        }
        Iterator sIter = s.iterator();
        while (sIter.hasNext()) {
            TType t = (TType)sIter.next();
            boolean found = false;
            Iterator lbIter = this.fLowerBounds.iterator();
            while (lbIter.hasNext()) {
                TType lb = (TType)lbIter.next();
                if (!TTypes.canAssignTo(lb, t)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public boolean isSingleton() {
        if (this.fEnumCache != null) {
            return this.fEnumCache.isSingleton();
        }
        return this.fLowerBounds.isSingleton() && this.fLowerBounds.anyMember() == this.getJavaLangObject();
    }

    public TType anyMember() {
        return this.fLowerBounds.anyMember();
    }

    public boolean equals(Object o) {
        if (o instanceof SuperTypesSet) {
            SuperTypesSet other = (SuperTypesSet)o;
            return other.fLowerBounds.equals(this.fLowerBounds);
        }
        return false;
    }

    public int hashCode() {
        return this.fLowerBounds.hashCode();
    }

    public Iterator iterator() {
        return this.enumerate().iterator();
    }

    public String toString() {
        return "<" + this.fID + ": superTypes(" + this.fLowerBounds + ")>";
    }

    public boolean hasUniqueLowerBound() {
        return this.fLowerBounds.isSingleton();
    }

    public boolean hasUniqueUpperBound() {
        return false;
    }

    public TType uniqueLowerBound() {
        return this.fLowerBounds.isSingleton() ? this.fLowerBounds.anyMember() : null;
    }

    public TType uniqueUpperBound() {
        return null;
    }

    public EnumeratedTypeSet enumerate() {
        if (this.fEnumCache == null) {
            this.fEnumCache = new EnumeratedTypeSet(this.getTypeSetEnvironment());
            boolean anyLBIsIntfOrArray = false;
            Iterator iter = this.fLowerBounds.iterator();
            while (iter.hasNext()) {
                TType lb = (TType)iter.next();
                if (lb instanceof ArrayType) {
                    ArrayType at = (ArrayType)lb;
                    int numDims = at.getDimensions();
                    Iterator elemSuperIter = TTypes.getAllSuperTypesIterator(at.getElementType());
                    while (elemSuperIter.hasNext()) {
                        this.fEnumCache.add(TTypes.createArrayType((TType)elemSuperIter.next(), numDims));
                    }
                    anyLBIsIntfOrArray = true;
                } else {
                    Iterator iterator = TTypes.getAllSuperTypesIterator(lb);
                    while (iterator.hasNext()) {
                        this.fEnumCache.fMembers.add(iterator.next());
                    }
                }
                this.fEnumCache.add(lb);
            }
            if (anyLBIsIntfOrArray) {
                this.fEnumCache.add(this.getJavaLangObject());
            }
        }
        return this.fEnumCache;
    }
}

