/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.carbon.CFRange;
import org.eclipse.swt.internal.carbon.OS;

public class RTFTransfer
extends ByteArrayTransfer {
    static RTFTransfer _instance = new RTFTransfer();
    static final String RTF = "RTF ";
    static final int RTFID = RTFTransfer.registerType("RTF ");

    RTFTransfer() {
    }

    public static RTFTransfer getInstance() {
        return _instance;
    }

    public void javaToNative(Object object, TransferData transferData) {
        if (!this.checkRTF(object) || !this.isSupportedType(transferData)) {
            DND.error(2003);
        }
        transferData.result = -1;
        String string = (String)object;
        int count = string.length();
        char[] chars = new char[count];
        string.getChars(0, count, chars, 0);
        int cfstring = OS.CFStringCreateWithCharacters(0, chars, count);
        if (cfstring == 0) {
            return;
        }
        try {
            CFRange range = new CFRange();
            range.length = chars.length;
            int encoding = OS.CFStringGetSystemEncoding();
            int[] size = new int[1];
            int numChars = OS.CFStringGetBytes(cfstring, range, encoding, (byte)63, true, null, 0, size);
            if (numChars == 0 || size[0] == 0) {
                return;
            }
            byte[] buffer = new byte[size[0]];
            numChars = OS.CFStringGetBytes(cfstring, range, encoding, (byte)63, true, buffer, size[0], size);
            if (numChars == 0) {
                return;
            }
            transferData.data = new byte[1][];
            transferData.data[0] = buffer;
            transferData.result = 0;
        }
        finally {
            OS.CFRelease(cfstring);
        }
    }

    public Object nativeToJava(TransferData transferData) {
        if (!this.isSupportedType(transferData) || transferData.data == null) {
            return null;
        }
        if (transferData.data.length == 0 || transferData.data[0].length == 0) {
            return null;
        }
        byte[] buffer = transferData.data[0];
        int encoding = OS.CFStringGetSystemEncoding();
        int cfstring = OS.CFStringCreateWithBytes(0, buffer, buffer.length, encoding, true);
        if (cfstring == 0) {
            return null;
        }
        try {
            int length = OS.CFStringGetLength(cfstring);
            if (length == 0) {
                return null;
            }
            char[] chars = new char[length];
            CFRange range = new CFRange();
            range.length = length;
            OS.CFStringGetCharacters(cfstring, range, chars);
            String string = new String(chars);
            return string;
        }
        finally {
            OS.CFRelease(cfstring);
        }
    }

    protected int[] getTypeIds() {
        return new int[]{RTFID};
    }

    protected String[] getTypeNames() {
        return new String[]{RTF};
    }

    boolean checkRTF(Object object) {
        return object != null && object instanceof String && ((String)object).length() > 0;
    }

    protected boolean validate(Object object) {
        return this.checkRTF(object);
    }
}

