/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.touchpoint.eclipse.actions;

import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.equinox.internal.p2.touchpoint.eclipse.PlatformConfigurationWrapper;
import org.eclipse.equinox.internal.p2.touchpoint.eclipse.Util;
import org.eclipse.equinox.internal.p2.touchpoint.eclipse.actions.InstallFeatureAction;
import org.eclipse.equinox.internal.p2.touchpoint.eclipse.actions.Messages;
import org.eclipse.equinox.internal.provisional.p2.engine.ProvisioningAction;
import org.eclipse.equinox.internal.provisional.p2.metadata.IArtifactKey;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.osgi.util.NLS;

public class UninstallFeatureAction
extends ProvisioningAction {
    public static final String ID = "uninstallFeature";

    public IStatus execute(Map parameters) {
        return UninstallFeatureAction.uninstallFeature(parameters);
    }

    public IStatus undo(Map parameters) {
        return InstallFeatureAction.installFeature(parameters);
    }

    public static IStatus uninstallFeature(Map parameters) {
        IInstallableUnit iu = (IInstallableUnit)parameters.get("iu");
        PlatformConfigurationWrapper configuration = (PlatformConfigurationWrapper)parameters.get("platformConfiguration");
        String feature = (String)parameters.get("feature");
        String featureId = (String)parameters.get("featureId");
        String featureVersion = (String)parameters.get("featureVersion");
        IArtifactKey[] artifacts = iu.getArtifacts();
        if (artifacts == null || artifacts.length == 0) {
            return Util.createError(NLS.bind((String)Messages.iu_contains_no_arifacts, (Object)iu));
        }
        IArtifactKey artifactKey = null;
        int i = 0;
        while (i < artifacts.length) {
            if (artifacts[i].toString().equals(feature)) {
                artifactKey = artifacts[i];
                break;
            }
            ++i;
        }
        if (featureId == null) {
            return Util.createError(NLS.bind((String)Messages.parameter_not_set, (Object)"featureId", (Object)ID));
        }
        if ("default".equals(featureId)) {
            featureId = artifactKey.getId();
        }
        if (featureVersion == null) {
            return Util.createError(NLS.bind((String)Messages.parameter_not_set, (Object)"featureVersion", (Object)ID));
        }
        if ("default".equals(featureVersion)) {
            featureVersion = artifactKey.getVersion().toString();
        }
        return configuration.removeFeatureEntry(featureId, featureVersion);
    }
}

