/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.DeviceData;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.wpf.OS;

public abstract class Device
implements Drawable {
    public static boolean DEBUG;
    public static boolean TRACK;
    boolean debug = DEBUG;
    boolean tracking = DEBUG || TRACK;
    Error[] errors;
    Object[] objects;
    Object trackingLock;
    Color[] colors;
    Font systemFont;
    boolean disposed;
    protected static Device CurrentDevice;
    protected static Runnable DeviceFinder;
    static /* synthetic */ Class class$0;

    static {
        try {
            Class.forName("org.eclipse.swt.widgets.Display");
        }
        catch (ClassNotFoundException classNotFoundException) {}
    }

    static synchronized Device getDevice() {
        if (DeviceFinder != null) {
            DeviceFinder.run();
        }
        Device device = CurrentDevice;
        CurrentDevice = null;
        return device;
    }

    public Device() {
        this(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Device(DeviceData data) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.graphics.Device");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (data != null) {
                this.debug = data.debug;
                this.tracking = data.tracking;
            }
            if (this.tracking) {
                this.errors = new Error[128];
                this.objects = new Object[128];
                this.trackingLock = new Object();
            }
            this.create(data);
            this.init();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    protected void checkDevice() {
        if (this.disposed) {
            SWT.error(45);
        }
    }

    protected void create(DeviceData data) {
    }

    protected void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.graphics.Device");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (this.isDisposed()) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            this.checkDevice();
            this.release();
            this.destroy();
            this.disposed = true;
            if (this.tracking) {
                Object object = this.trackingLock;
                synchronized (object) {
                    this.objects = null;
                    this.errors = null;
                    this.trackingLock = null;
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dispose_Object(Object object) {
        Object object2 = this.trackingLock;
        synchronized (object2) {
            int i = 0;
            while (i < this.objects.length) {
                if (this.objects[i] == object) {
                    this.objects[i] = null;
                    this.errors[i] = null;
                    return;
                }
                ++i;
            }
        }
    }

    public Rectangle getBounds() {
        this.checkDevice();
        int width = (int)OS.SystemParameters_PrimaryScreenWidth();
        int height = (int)OS.SystemParameters_PrimaryScreenHeight();
        return new Rectangle(0, 0, width, height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeviceData getDeviceData() {
        this.checkDevice();
        DeviceData data = new DeviceData();
        data.debug = this.debug;
        data.tracking = this.tracking;
        if (this.tracking) {
            Object object = this.trackingLock;
            synchronized (object) {
                int count = 0;
                int length = this.objects.length;
                int i = 0;
                while (i < length) {
                    if (this.objects[i] != null) {
                        ++count;
                    }
                    ++i;
                }
                int index = 0;
                data.objects = new Object[count];
                data.errors = new Error[count];
                int i2 = 0;
                while (i2 < length) {
                    if (this.objects[i2] != null) {
                        data.objects[index] = this.objects[i2];
                        data.errors[index] = this.errors[i2];
                        ++index;
                    }
                    ++i2;
                }
            }
        } else {
            data.objects = new Object[0];
            data.errors = new Error[0];
        }
        return data;
    }

    public Rectangle getClientArea() {
        return this.getBounds();
    }

    public int getDepth() {
        this.checkDevice();
        return 32;
    }

    public Point getDPI() {
        this.checkDevice();
        return new Point(96, 96);
    }

    public FontData[] getFontList(String faceName, boolean scalable) {
        int typefaces;
        this.checkDevice();
        if (!scalable) {
            return new FontData[0];
        }
        if (faceName != null) {
            int length = faceName.length();
            char[] chars = new char[length + 1];
            faceName.getChars(0, length, chars, 0);
            int str = OS.gcnew_String(chars);
            int fontFamily = OS.gcnew_FontFamily(str);
            typefaces = OS.FontFamily_GetTypefaces(fontFamily);
            OS.GCHandle_Free(fontFamily);
            OS.GCHandle_Free(str);
        } else {
            typefaces = OS.Fonts_SystemTypefaces();
        }
        int count = OS.TypefaceCollection_Count(typefaces);
        int index = 0;
        FontData[] result = new FontData[count];
        int enumerator = OS.TypefaceCollection_GetEnumerator(typefaces);
        while (OS.IEnumerator_MoveNext(enumerator)) {
            int typeface = OS.TypefaceCollection_Current(enumerator);
            int fontFamily = OS.Typeface_FontFamily(typeface);
            int style = OS.Typeface_Style(typeface);
            int weight = OS.Typeface_Weight(typeface);
            int stretch = OS.Typeface_Stretch(typeface);
            int str = OS.FontFamily_Source(fontFamily);
            int charArray = OS.String_ToCharArray(str);
            char[] chars = new char[OS.String_Length(str)];
            OS.memcpy(chars, charArray, chars.length * 2);
            int fontStyle = OS.FontStyles_Normal;
            if (OS.Object_Equals(style, OS.FontStyles_Italic)) {
                fontStyle = OS.FontStyles_Italic;
            }
            if (OS.Object_Equals(style, OS.FontStyles_Oblique)) {
                fontStyle = OS.FontStyles_Oblique;
            }
            FontData data = FontData.wpf_new(new String(chars), fontStyle, OS.FontWeight_ToOpenTypeWeight(weight), OS.FontStretch_ToOpenTypeStretch(stretch), 0);
            OS.GCHandle_Free(charArray);
            OS.GCHandle_Free(str);
            OS.GCHandle_Free(fontFamily);
            OS.GCHandle_Free(style);
            OS.GCHandle_Free(weight);
            OS.GCHandle_Free(stretch);
            OS.GCHandle_Free(typeface);
            result[index++] = data;
        }
        OS.GCHandle_Free(enumerator);
        OS.GCHandle_Free(typefaces);
        return result;
    }

    public Color getSystemColor(int id) {
        this.checkDevice();
        if (id >= 0 && id < this.colors.length) {
            return this.colors[id];
        }
        return this.colors[0];
    }

    public Font getSystemFont() {
        this.checkDevice();
        return this.systemFont;
    }

    public boolean getWarnings() {
        this.checkDevice();
        return false;
    }

    protected void init() {
        this.colors = new Color[17];
        this.colors[2] = this.colors[0] = Color.wpf_new(this, OS.Colors_Black());
        this.colors[4] = Color.wpf_new(this, OS.Colors_Maroon());
        this.colors[6] = Color.wpf_new(this, OS.Colors_Green());
        this.colors[8] = Color.wpf_new(this, OS.Colors_Olive());
        this.colors[10] = Color.wpf_new(this, OS.Colors_Navy());
        this.colors[12] = Color.wpf_new(this, OS.Colors_Purple());
        this.colors[14] = Color.wpf_new(this, OS.Colors_Teal());
        this.colors[15] = Color.wpf_new(this, OS.Colors_Silver());
        this.colors[16] = Color.wpf_new(this, OS.Colors_Silver());
        this.colors[3] = Color.wpf_new(this, OS.Colors_Red());
        this.colors[5] = Color.wpf_new(this, OS.Colors_Lime());
        this.colors[7] = Color.wpf_new(this, OS.Colors_Yellow());
        this.colors[9] = Color.wpf_new(this, OS.Colors_Blue());
        this.colors[11] = Color.wpf_new(this, OS.Colors_Magenta());
        this.colors[13] = Color.wpf_new(this, OS.Colors_Cyan());
        this.colors[1] = Color.wpf_new(this, OS.Colors_White());
        int fontFamily = OS.SystemFonts_MessageFontFamily();
        int style = OS.SystemFonts_MessageFontStyle();
        int weight = OS.SystemFonts_MessageFontWeight();
        double size = OS.SystemFonts_MessageFontSize();
        int typeface = OS.gcnew_Typeface(fontFamily, style, weight, OS.FontStretches_Normal);
        OS.GCHandle_Free(fontFamily);
        OS.GCHandle_Free(style);
        OS.GCHandle_Free(weight);
        this.systemFont = Font.wpf_new(this, typeface, size);
    }

    public abstract int internal_new_GC(GCData var1);

    public abstract void internal_dispose_GC(int var1, GCData var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDisposed() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.graphics.Device");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.disposed;
        }
    }

    public boolean loadFont(String path) {
        this.checkDevice();
        if (path == null) {
            SWT.error(4);
        }
        int length = path.length();
        char[] buffer = new char[length + 1];
        path.getChars(0, length, buffer, 0);
        int str = OS.gcnew_String(buffer);
        int uri = OS.gcnew_Uri(str, 0);
        int list = OS.Fonts_GetTypefaces(uri);
        int count = OS.TypefaceCollection_Count(list);
        OS.GCHandle_Free(list);
        OS.GCHandle_Free(uri);
        OS.GCHandle_Free(str);
        return count != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void new_Object(Object object) {
        Object object2 = this.trackingLock;
        synchronized (object2) {
            int i = 0;
            while (i < this.objects.length) {
                if (this.objects[i] == null) {
                    this.objects[i] = object;
                    this.errors[i] = new Error();
                    return;
                }
                ++i;
            }
            Object[] newObjects = new Object[this.objects.length + 128];
            System.arraycopy(this.objects, 0, newObjects, 0, this.objects.length);
            newObjects[this.objects.length] = object;
            this.objects = newObjects;
            Error[] newErrors = new Error[this.errors.length + 128];
            System.arraycopy(this.errors, 0, newErrors, 0, this.errors.length);
            newErrors[this.errors.length] = new Error();
            this.errors = newErrors;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void release() {
        int i = 0;
        while (i < this.colors.length) {
            if (this.colors[i] != null) {
                this.colors[i].dispose();
            }
            ++i;
        }
        this.colors = null;
        if (this.systemFont != null) {
            this.systemFont.dispose();
        }
        this.systemFont = null;
        if (this.tracking) {
            Object object = this.trackingLock;
            synchronized (object) {
                if (TRACK & this.objects != null) {
                    int i2 = 0;
                    while (i2 < this.objects.length) {
                        if (this.objects[i2] != null) {
                            System.err.println(this.objects[i2]);
                            this.errors[i2].printStackTrace();
                        }
                        ++i2;
                    }
                }
            }
        }
    }

    public void setWarnings(boolean warnings) {
        this.checkDevice();
    }
}

