/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.viewers.model;

import com.ibm.icu.text.MessageFormat;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.actions.ActionMessages;
import org.eclipse.debug.internal.ui.viewers.FindElementDialog;
import org.eclipse.debug.internal.ui.viewers.model.InternalTreeModelViewer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.IUpdate;

public class VirtualFindAction
extends Action
implements IUpdate {
    private InternalTreeModelViewer fViewer;

    public VirtualFindAction(InternalTreeModelViewer viewer) {
        this.setText(ActionMessages.FindAction_0);
        this.setId(String.valueOf(DebugUIPlugin.getUniqueIdentifier()) + ".FindElementAction");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.debug.ui.find_element_context");
        this.setActionDefinitionId("org.eclipse.ui.edit.findReplace");
        this.fViewer = viewer;
    }

    public void run() {
        final InternalTreeModelViewer.VirtualModel model = this.fViewer.buildVirtualModel(null, null);
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(this.fViewer.getControl().getShell());
        IProgressMonitor monitor = dialog.getProgressMonitor();
        dialog.setCancelable(true);
        String[] columns = this.fViewer.getPresentationContext().getColumns();
        String[] temp = null;
        temp = columns == null || columns.length == 0 ? (String[])null : new String[]{columns[0]};
        final String[] IDs = temp;
        final Object[] result = new Object[1];
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor m) throws InvocationTargetException, InterruptedException {
                result[0] = model.populate(m, DebugUIPlugin.removeAccelerators(VirtualFindAction.this.getText()), IDs);
            }
        };
        try {
            dialog.run(true, true, runnable);
        }
        catch (InvocationTargetException e) {
            DebugUIPlugin.log(e);
            return;
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        InternalTreeModelViewer.VirtualElement root = (InternalTreeModelViewer.VirtualElement)result[0];
        if (!monitor.isCanceled()) {
            ArrayList list = new ArrayList();
            this.collectAllChildren(root, list);
            this.performFind(list.toArray());
        }
    }

    private void collectAllChildren(InternalTreeModelViewer.VirtualElement element, List collect) {
        InternalTreeModelViewer.VirtualElement[] children = element.getChildren();
        if (children != null) {
            int i = 0;
            while (i < children.length) {
                if (!children[i].isFiltered()) {
                    collect.add(children[i]);
                    this.collectAllChildren(children[i], collect);
                }
                ++i;
            }
        }
    }

    protected void performFind(Object[] items) {
        Object[] elements;
        FindElementDialog dialog = new FindElementDialog(this.fViewer.getControl().getShell(), (ILabelProvider)new FindLabelProvider(), items);
        dialog.setTitle(ActionMessages.FindDialog_3);
        dialog.setMessage(ActionMessages.FindDialog_1);
        if (dialog.open() == 0 && (elements = dialog.getResult()).length == 1) {
            InternalTreeModelViewer.VirtualElement element = (InternalTreeModelViewer.VirtualElement)elements[0];
            TreePath path = element.realize();
            if (path != null) {
                this.fViewer.setSelection((ISelection)new TreeSelection(path), true, true);
            } else {
                DebugUIPlugin.errorDialog(this.fViewer.getControl().getShell(), ActionMessages.VirtualFindAction_0, MessageFormat.format((String)ActionMessages.VirtualFindAction_1, (Object[])new String[]{element.getLabel()[0]}), null);
            }
        }
    }

    public void update() {
        this.setEnabled(this.fViewer.getInput() != null);
    }

    class FindLabelProvider
    extends LabelProvider {
        public Image getImage(Object element) {
            return ((InternalTreeModelViewer.VirtualElement)element).getImage();
        }

        public String getText(Object element) {
            return ((InternalTreeModelViewer.VirtualElement)element).getLabel()[0];
        }
    }
}

