/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.metadata.repository;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.ecf.filetransfer.UserCancelledException;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.internal.p2.core.helpers.URLUtil;
import org.eclipse.equinox.internal.p2.metadata.repository.Messages;
import org.eclipse.equinox.internal.p2.repository.Activator;
import org.eclipse.equinox.internal.p2.repository.AuthenticationFailedException;
import org.eclipse.equinox.internal.p2.repository.DownloadStatus;
import org.eclipse.equinox.internal.p2.repository.RepositoryTransport;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.p2.core.eventbus.IProvisioningEventBus;
import org.eclipse.equinox.internal.provisional.p2.core.eventbus.ProvisioningListener;
import org.eclipse.equinox.internal.provisional.p2.core.eventbus.SynchronousProvisioningListener;
import org.eclipse.equinox.internal.provisional.p2.core.location.AgentLocation;
import org.eclipse.equinox.internal.provisional.p2.repository.IStateful;
import org.eclipse.equinox.internal.provisional.p2.repository.RepositoryEvent;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleContext;

public class CacheManager {
    private static SynchronousProvisioningListener busListener;
    private static final String DOWNLOADING = "downloading";
    private static final String JAR_EXTENSION = ".jar";
    private static final String PROP_RESUMABLE = "org.eclipse.equinox.p2.metadata.repository.resumable";
    private static final String RESUME_DEFAULT = "true";
    private static final String XML_EXTENSION = ".xml";
    private final HashSet knownPrefixes = new HashSet(5);
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    private int computeHash(URI repositoryLocation) {
        return repositoryLocation.hashCode();
    }

    public File createCache(URI repositoryLocation, String prefix, IProgressMonitor monitor) throws IOException, ProvisionException {
        SubMonitor submonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)1000);
        try {
            boolean useJar;
            long lastModifiedRemote;
            URI remoteFile;
            String useExtension;
            String name;
            long lastModified;
            boolean stale;
            int hashCode;
            URI xmlLocation;
            URI jarLocation;
            File cacheFile;
            block27: {
                this.knownPrefixes.add(prefix);
                cacheFile = this.getCache(repositoryLocation, prefix);
                jarLocation = URIUtil.append((URI)repositoryLocation, (String)(String.valueOf(prefix) + JAR_EXTENSION));
                xmlLocation = URIUtil.append((URI)repositoryLocation, (String)(String.valueOf(prefix) + XML_EXTENSION));
                hashCode = this.computeHash(repositoryLocation);
                stale = true;
                lastModified = 0L;
                name = null;
                useExtension = JAR_EXTENSION;
                remoteFile = jarLocation;
                if (cacheFile != null) {
                    lastModified = cacheFile.lastModified();
                    name = cacheFile.getName();
                }
                lastModifiedRemote = 0L;
                useJar = true;
                try {
                    lastModifiedRemote = this.getTransport().getLastModified(jarLocation, (IProgressMonitor)submonitor.newChild(1));
                    if (lastModifiedRemote <= 0L) {
                        LogHelper.log((IStatus)new Status(2, "org.eclipse.equinox.p2.repository", "Server returned lastModified <= 0 for " + jarLocation));
                    }
                }
                catch (AuthenticationFailedException authenticationFailedException) {
                    throw new ProvisionException((IStatus)new Status(4, "org.eclipse.equinox.p2.repository", 1007, NLS.bind((String)Messages.CacheManager_AuthenticationFaileFor_0, (Object)repositoryLocation), null));
                }
                catch (CoreException e) {
                    useJar = false;
                    if (e.getStatus() == null || e.getStatus().getException() == null) break block27;
                    Throwable ex = e.getStatus().getException();
                    Class<?> clazz = ex.getClass();
                    Class<?> clazz2 = class$0;
                    if (clazz2 == null) {
                        try {
                            clazz2 = class$0 = Class.forName("java.net.SocketTimeoutException");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (clazz == clazz2) {
                        throw new ProvisionException((IStatus)new Status(4, "org.eclipse.equinox.p2.repository", 1002, NLS.bind((String)Messages.CacheManager_FailedCommunicationWithRepo_0, (Object)repositoryLocation), ex));
                    }
                }
                catch (OperationCanceledException e) {
                    throw e;
                }
                catch (Exception exception) {
                    useJar = false;
                }
            }
            if (submonitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            if (useJar) {
                stale = lastModifiedRemote > lastModified || name != null && name.endsWith(XML_EXTENSION) || lastModifiedRemote <= 0L;
            } else {
                try {
                    lastModifiedRemote = this.getTransport().getLastModified(xmlLocation, (IProgressMonitor)submonitor.newChild(1));
                    if (lastModifiedRemote <= 0L) {
                        LogHelper.log((IStatus)new Status(2, "org.eclipse.equinox.p2.repository", "Server returned lastModified <= 0 for " + xmlLocation));
                    }
                }
                catch (UserCancelledException userCancelledException) {
                    throw new OperationCanceledException();
                }
                catch (FileNotFoundException fileNotFoundException) {
                    throw new FileNotFoundException(NLS.bind((String)Messages.CacheManager_Neither_0_nor_1_found, (Object)jarLocation, (Object)xmlLocation));
                }
                catch (AuthenticationFailedException authenticationFailedException) {
                    throw new ProvisionException((IStatus)new Status(4, "org.eclipse.equinox.p2.repository", 1007, NLS.bind((String)Messages.CacheManager_AuthenticationFaileFor_0, (Object)repositoryLocation), null));
                }
                catch (CoreException e) {
                    IStatus status = e.getStatus();
                    if (status == null) {
                        throw new ProvisionException((IStatus)new Status(4, "org.eclipse.equinox.p2.repository", 1000, NLS.bind((String)Messages.CacheManager_FailedCommunicationWithRepo_0, (Object)repositoryLocation), (Throwable)e));
                    }
                    if (status.getException() instanceof FileNotFoundException) {
                        throw new ProvisionException((IStatus)new Status(4, "org.eclipse.equinox.p2.repository", 1000, status.getMessage(), null));
                    }
                    throw new ProvisionException(status);
                }
                stale = lastModifiedRemote > lastModified || name != null && name.endsWith(JAR_EXTENSION) || lastModifiedRemote <= 0L;
                useExtension = XML_EXTENSION;
                remoteFile = xmlLocation;
            }
            if (!stale) {
                File file = cacheFile;
                return file;
            }
            cacheFile = new File(this.getCacheDirectory(), String.valueOf(prefix) + hashCode + useExtension);
            this.updateCache(cacheFile, remoteFile, lastModifiedRemote, submonitor);
            File file = cacheFile;
            return file;
        }
        finally {
            submonitor.done();
        }
    }

    void deleteCache(URI repositoryLocation) {
        Iterator it = this.knownPrefixes.iterator();
        while (it.hasNext()) {
            String prefix = (String)it.next();
            File[] cacheFiles = this.getCacheFiles(repositoryLocation, prefix);
            int i = 0;
            while (i < cacheFiles.length) {
                this.safeDelete(cacheFiles[i]);
                this.safeDelete(new File(new File(cacheFiles[i].getParentFile(), DOWNLOADING), cacheFiles[i].getName()));
                ++i;
            }
        }
    }

    private File getCache(URI repositoryLocation, String prefix) {
        File[] files = this.getCacheFiles(repositoryLocation, prefix);
        if (files[0].exists()) {
            return files[0];
        }
        return files[1].exists() ? files[1] : null;
    }

    private File getCacheDirectory() {
        BundleContext bundleContext = Activator.getContext();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.equinox.internal.provisional.p2.core.location.AgentLocation");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        AgentLocation agentLocation = (AgentLocation)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName());
        URL dataArea = agentLocation.getDataArea("org.eclipse.equinox.p2.repository/cache/");
        return URLUtil.toFile((URL)dataArea);
    }

    private File[] getCacheFiles(URI repositoryLocation, String prefix) {
        File[] files = new File[2];
        File dataAreaFile = this.getCacheDirectory();
        int hashCode = this.computeHash(repositoryLocation);
        files[0] = new File(dataAreaFile, String.valueOf(prefix) + hashCode + JAR_EXTENSION);
        files[1] = new File(dataAreaFile, String.valueOf(prefix) + hashCode + XML_EXTENSION);
        return files;
    }

    private RepositoryTransport getTransport() {
        return RepositoryTransport.getInstance();
    }

    public boolean isResumeEnabled() {
        String resumeProp = System.getProperty(PROP_RESUMABLE, RESUME_DEFAULT);
        return Boolean.valueOf(resumeProp);
    }

    private boolean makeResumeable(File cacheFile, URI remoteFile, IStatus status) {
        if (status == null || status.isOK() || cacheFile == null || !(status instanceof DownloadStatus)) {
            return false;
        }
        if (!this.isResumeEnabled()) {
            return false;
        }
        DownloadStatus downloadStatus = (DownloadStatus)status;
        long currentLength = cacheFile.length();
        if (currentLength == 0L) {
            return false;
        }
        long reportedSize = downloadStatus.getFileSize();
        long reportedModified = downloadStatus.getLastModified();
        if (reportedSize == -1L || reportedSize == 0L) {
            LogHelper.log((IStatus)new Status(2, "org.eclipse.equinox.p2.repository", NLS.bind((String)"Download of {0} not resumable because filesize not reported.", (Object)remoteFile)));
            return false;
        }
        if (reportedModified <= 0L) {
            LogHelper.log((IStatus)new Status(2, "org.eclipse.equinox.p2.repository", NLS.bind((String)"Download of {0} not resumable because last-modified not reported.", (Object)remoteFile)));
            return false;
        }
        if (reportedSize < currentLength) {
            LogHelper.log((IStatus)new Status(2, "org.eclipse.equinox.p2.repository", NLS.bind((String)"Download of {0} not resumable because more was read then reported size.", (Object)remoteFile)));
            return false;
        }
        File resumeDir = new File(cacheFile.getParentFile(), DOWNLOADING);
        if (!resumeDir.mkdir()) {
            LogHelper.log((IStatus)new Status(4, "org.eclipse.equinox.p2.repository", NLS.bind((String)"Could not create directory {0} for resumable download of {1}", (Object)resumeDir, (Object)remoteFile)));
            return false;
        }
        File resumeFile = new File(resumeDir, cacheFile.getName());
        if (!cacheFile.renameTo(resumeFile)) {
            LogHelper.log((IStatus)new Status(4, "org.eclipse.equinox.p2.repository", NLS.bind((String)"Could not move {0} to {1} for resumed download", (Object)cacheFile, (Object)resumeFile)));
            return false;
        }
        if (!resumeFile.setLastModified(reportedModified)) {
            LogHelper.log((IStatus)new Status(4, "org.eclipse.equinox.p2.repository", NLS.bind((String)"Could not set last modified time on {0} for resumed download", (Object)resumeFile)));
            return false;
        }
        return true;
    }

    public void registerRepoEventListener() {
        IProvisioningEventBus eventBus = (IProvisioningEventBus)ServiceHelper.getService((BundleContext)Activator.getContext(), (String)IProvisioningEventBus.SERVICE_NAME);
        if (eventBus == null) {
            LogHelper.log((IStatus)new Status(4, "org.eclipse.equinox.p2.repository", "ProvisioningEventBus could not be obtained. Metadata caches may not be cleaned up properly."));
            return;
        }
        if (busListener == null) {
            busListener = new SynchronousProvisioningListener(){

                public void notify(EventObject o) {
                    RepositoryEvent event;
                    if (o instanceof RepositoryEvent && 1 == (event = (RepositoryEvent)o).getKind() && event.getRepositoryType() == 0) {
                        CacheManager.this.deleteCache(event.getRepositoryLocation());
                    }
                }
            };
        }
        eventBus.addListener((ProvisioningListener)busListener);
    }

    private boolean safeDelete(File file) {
        if (file.exists() && !file.delete()) {
            file.deleteOnExit();
            return true;
        }
        return false;
    }

    public void unregisterRepoEventListener() {
        IProvisioningEventBus eventBus = (IProvisioningEventBus)ServiceHelper.getService((BundleContext)Activator.getContext(), (String)IProvisioningEventBus.SERVICE_NAME);
        if (eventBus != null && busListener != null) {
            eventBus.removeListener((ProvisioningListener)busListener);
            busListener = null;
        }
    }

    private void updateCache(File cacheFile, URI remoteFile, long lastModifiedRemote, SubMonitor submonitor) throws FileNotFoundException, IOException, ProvisionException {
        IStatus result;
        block16: {
            cacheFile.getParentFile().mkdirs();
            File resumeFile = new File(new File(cacheFile.getParentFile(), DOWNLOADING), cacheFile.getName());
            boolean append = false;
            if (resumeFile.exists()) {
                if (lastModifiedRemote != resumeFile.lastModified() || lastModifiedRemote <= 0L) {
                    this.safeDelete(resumeFile);
                } else if (resumeFile.renameTo(cacheFile)) {
                    append = true;
                } else {
                    LogHelper.log((IStatus)new Status(4, "org.eclipse.equinox.p2.repository", NLS.bind((String)"Could not move resumable file {0} into cache", (Object)resumeFile)));
                }
            }
            StatefulStream metadata = new StatefulStream(new FileOutputStream(cacheFile, append));
            result = null;
            try {
                try {
                    submonitor.setWorkRemaining(1000);
                    result = this.getTransport().download(remoteFile, (OutputStream)metadata, append ? cacheFile.length() : -1L, (IProgressMonitor)submonitor.newChild(1000));
                }
                catch (OperationCanceledException operationCanceledException) {
                    result = metadata.getStatus();
                    metadata.close();
                    if (result == null) {
                        cacheFile.delete();
                    }
                    break block16;
                }
            }
            catch (Throwable throwable) {
                metadata.close();
                if (result == null) {
                    cacheFile.delete();
                }
                throw throwable;
            }
            metadata.close();
            if (result == null) {
                cacheFile.delete();
            }
        }
        if (result.isOK()) {
            return;
        }
        if (!this.makeResumeable(cacheFile, remoteFile, result)) {
            cacheFile.delete();
        }
        if (result.getSeverity() == 8 || submonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        throw new ProvisionException(result);
    }

    private static class StatefulStream
    extends BufferedOutputStream
    implements IStateful {
        private IStatus status;

        public StatefulStream(OutputStream stream) {
            super(stream);
        }

        public IStatus getStatus() {
            return this.status;
        }

        public void setStatus(IStatus aStatus) {
            this.status = aStatus;
        }
    }
}

