/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.databinding.observable.masterdetail;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.DisposeEvent;
import org.eclipse.core.databinding.observable.IDisposeListener;
import org.eclipse.core.databinding.observable.IObserving;
import org.eclipse.core.databinding.observable.ObservableTracker;
import org.eclipse.core.databinding.observable.masterdetail.IObservableFactory;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.ISetChangeListener;
import org.eclipse.core.databinding.observable.set.ObservableSet;
import org.eclipse.core.databinding.observable.set.SetChangeEvent;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.core.internal.databinding.observable.masterdetail.DetailObservableHelper;
import org.eclipse.core.runtime.Assert;

public class DetailObservableSet
extends ObservableSet
implements IObserving {
    private boolean updating = false;
    private ISetChangeListener innerChangeListener = new ISetChangeListener(){

        public void handleSetChange(SetChangeEvent event) {
            if (!DetailObservableSet.this.updating) {
                DetailObservableSet.this.fireSetChange(event.diff);
            }
        }
    };
    private Object currentOuterValue;
    private IObservableSet innerObservableSet;
    private IObservableValue outerObservableValue;
    private IObservableFactory factory;
    IValueChangeListener outerChangeListener = new IValueChangeListener(){

        public void handleValueChange(ValueChangeEvent event) {
            ObservableTracker.runAndIgnore(new Runnable(this){
                final /* synthetic */ 2 this$1;
                {
                    this.this$1 = var1_1;
                }

                public void run() {
                    HashSet<E> oldSet = new HashSet<E>(DetailObservableSet.access$2(2.access$0(this.this$1)));
                    DetailObservableSet.access$3(2.access$0(this.this$1));
                    DetailObservableSet.access$1(2.access$0(this.this$1), Diffs.computeSetDiff(oldSet, DetailObservableSet.access$2(2.access$0(this.this$1))));
                }
            });
        }

        static /* synthetic */ DetailObservableSet access$0(2 var0) {
            return var0.DetailObservableSet.this;
        }
    };

    public DetailObservableSet(IObservableFactory factory, IObservableValue outerObservableValue, Object detailType) {
        super(outerObservableValue.getRealm(), Collections.EMPTY_SET, detailType);
        Assert.isTrue((!outerObservableValue.isDisposed() ? 1 : 0) != 0, (String)"Master observable is disposed");
        this.factory = factory;
        this.outerObservableValue = outerObservableValue;
        outerObservableValue.addDisposeListener(new IDisposeListener(){

            public void handleDispose(DisposeEvent staleEvent) {
                DetailObservableSet.this.dispose();
            }
        });
        ObservableTracker.runAndIgnore(new Runnable(){

            public void run() {
                DetailObservableSet.this.updateInnerObservableSet();
            }
        });
        outerObservableValue.addValueChangeListener(this.outerChangeListener);
    }

    private void updateInnerObservableSet() {
        this.currentOuterValue = this.outerObservableValue.getValue();
        if (this.innerObservableSet != null) {
            this.innerObservableSet.removeSetChangeListener(this.innerChangeListener);
            this.innerObservableSet.dispose();
        }
        if (this.currentOuterValue == null) {
            this.innerObservableSet = null;
            this.wrappedSet = Collections.EMPTY_SET;
        } else {
            ObservableTracker.runAndIgnore(new Runnable(){

                public void run() {
                    DetailObservableSet.this.innerObservableSet = (IObservableSet)DetailObservableSet.this.factory.createObservable(DetailObservableSet.this.currentOuterValue);
                }
            });
            DetailObservableHelper.warnIfDifferentRealms(this.getRealm(), this.innerObservableSet.getRealm());
            this.wrappedSet = this.innerObservableSet;
            if (this.elementType != null) {
                Object innerValueType = this.innerObservableSet.getElementType();
                Assert.isTrue((boolean)this.elementType.equals(innerValueType), (String)"Cannot change value type in a nested observable set");
            }
            this.innerObservableSet.addSetChangeListener(this.innerChangeListener);
        }
    }

    public boolean add(final Object o) {
        this.getterCalled();
        final boolean[] result = new boolean[1];
        ObservableTracker.runAndIgnore(new Runnable(){

            public void run() {
                result[0] = DetailObservableSet.this.wrappedSet.add(o);
            }
        });
        return result[0];
    }

    public boolean remove(final Object o) {
        this.getterCalled();
        final boolean[] result = new boolean[1];
        ObservableTracker.runAndIgnore(new Runnable(){

            public void run() {
                result[0] = DetailObservableSet.this.wrappedSet.remove(o);
            }
        });
        return result[0];
    }

    public boolean addAll(final Collection c) {
        this.getterCalled();
        final boolean[] result = new boolean[1];
        ObservableTracker.runAndIgnore(new Runnable(){

            public void run() {
                result[0] = DetailObservableSet.this.wrappedSet.addAll(c);
            }
        });
        return result[0];
    }

    public boolean removeAll(final Collection c) {
        this.getterCalled();
        final boolean[] result = new boolean[1];
        ObservableTracker.runAndIgnore(new Runnable(){

            public void run() {
                result[0] = DetailObservableSet.this.wrappedSet.removeAll(c);
            }
        });
        return result[0];
    }

    public boolean retainAll(final Collection c) {
        this.getterCalled();
        final boolean[] result = new boolean[1];
        ObservableTracker.runAndIgnore(new Runnable(){

            public void run() {
                result[0] = DetailObservableSet.this.wrappedSet.retainAll(c);
            }
        });
        return result[0];
    }

    public void clear() {
        this.getterCalled();
        ObservableTracker.runAndIgnore(new Runnable(){

            public void run() {
                DetailObservableSet.this.wrappedSet.clear();
            }
        });
    }

    public synchronized void dispose() {
        super.dispose();
        if (this.outerObservableValue != null) {
            this.outerObservableValue.removeValueChangeListener(this.outerChangeListener);
        }
        if (this.innerObservableSet != null) {
            this.innerObservableSet.removeSetChangeListener(this.innerChangeListener);
            this.innerObservableSet.dispose();
        }
        this.outerObservableValue = null;
        this.outerChangeListener = null;
        this.currentOuterValue = null;
        this.factory = null;
        this.innerObservableSet = null;
        this.innerChangeListener = null;
    }

    public Object getObserved() {
        if (this.innerObservableSet instanceof IObserving) {
            return ((IObserving)((Object)this.innerObservableSet)).getObserved();
        }
        return null;
    }
}

