/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.internal.repository.comparator;

import org.eclipse.equinox.p2.internal.repository.comparator.ClassFileAttribute;
import org.eclipse.equinox.p2.internal.repository.comparator.ClassFormatException;
import org.eclipse.equinox.p2.internal.repository.comparator.ConstantPool;
import org.eclipse.equinox.p2.internal.repository.comparator.ConstantPoolEntry;

public class SourceFileAttribute
extends ClassFileAttribute {
    private int sourceFileIndex;
    private char[] sourceFileName;

    public SourceFileAttribute(byte[] classFileBytes, ConstantPool constantPool, int offset) throws ClassFormatException {
        super(classFileBytes, constantPool, offset);
        this.sourceFileIndex = this.u2At(classFileBytes, 6, offset);
        ConstantPoolEntry constantPoolEntry = constantPool.decodeEntry(this.sourceFileIndex);
        if (constantPoolEntry.getKind() != 1) {
            throw new ClassFormatException(3);
        }
        this.sourceFileName = constantPoolEntry.getUtf8Value();
    }

    public int getSourceFileIndex() {
        return this.sourceFileIndex;
    }

    public char[] getSourceFileName() {
        return this.sourceFileName;
    }
}

