/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.internal.repository.comparator;

import java.util.Arrays;
import org.eclipse.equinox.p2.internal.repository.comparator.AnnotationDefaultAttribute;
import org.eclipse.equinox.p2.internal.repository.comparator.AttributeNamesConstants;
import org.eclipse.equinox.p2.internal.repository.comparator.ClassFileAttribute;
import org.eclipse.equinox.p2.internal.repository.comparator.ClassFileStruct;
import org.eclipse.equinox.p2.internal.repository.comparator.ClassFormatException;
import org.eclipse.equinox.p2.internal.repository.comparator.CodeAttribute;
import org.eclipse.equinox.p2.internal.repository.comparator.ConstantPool;
import org.eclipse.equinox.p2.internal.repository.comparator.ConstantPoolEntry;
import org.eclipse.equinox.p2.internal.repository.comparator.ExceptionAttribute;
import org.eclipse.equinox.p2.internal.repository.comparator.RuntimeInvisibleAnnotationsAttribute;
import org.eclipse.equinox.p2.internal.repository.comparator.RuntimeInvisibleParameterAnnotationsAttribute;
import org.eclipse.equinox.p2.internal.repository.comparator.RuntimeVisibleAnnotationsAttribute;
import org.eclipse.equinox.p2.internal.repository.comparator.RuntimeVisibleParameterAnnotationsAttribute;
import org.eclipse.equinox.p2.internal.repository.comparator.SignatureAttribute;

public class MethodInfo
extends ClassFileStruct {
    private int accessFlags;
    private int attributeBytes;
    private ClassFileAttribute[] attributes;
    private int attributesCount;
    private CodeAttribute codeAttribute;
    private char[] descriptor;
    private int descriptorIndex;
    private ExceptionAttribute exceptionAttribute;
    private boolean isDeprecated;
    private boolean isSynthetic;
    private char[] name;
    private int nameIndex;

    public MethodInfo(byte[] classFileBytes, ConstantPool constantPool, int offset, int decodingFlags) throws ClassFormatException {
        int flags;
        boolean no_code_attribute = (decodingFlags & 0x20) == 0;
        this.accessFlags = flags = this.u2At(classFileBytes, 0, offset);
        if ((flags & 0x1000) != 0) {
            this.isSynthetic = true;
        }
        this.nameIndex = this.u2At(classFileBytes, 2, offset);
        ConstantPoolEntry constantPoolEntry = constantPool.decodeEntry(this.nameIndex);
        if (constantPoolEntry.getKind() != 1) {
            throw new ClassFormatException(3);
        }
        this.name = constantPoolEntry.getUtf8Value();
        this.descriptorIndex = this.u2At(classFileBytes, 4, offset);
        constantPoolEntry = constantPool.decodeEntry(this.descriptorIndex);
        if (constantPoolEntry.getKind() != 1) {
            throw new ClassFormatException(3);
        }
        this.descriptor = constantPoolEntry.getUtf8Value();
        this.attributesCount = this.u2At(classFileBytes, 6, offset);
        this.attributes = ClassFileAttribute.NO_ATTRIBUTES;
        if (this.attributesCount != 0) {
            if (no_code_attribute && !this.isAbstract() && !this.isNative()) {
                if (this.attributesCount != 1) {
                    this.attributes = new ClassFileAttribute[this.attributesCount - 1];
                }
            } else {
                this.attributes = new ClassFileAttribute[this.attributesCount];
            }
        }
        int attributesIndex = 0;
        int readOffset = 8;
        int i = 0;
        while (i < this.attributesCount) {
            constantPoolEntry = constantPool.decodeEntry(this.u2At(classFileBytes, readOffset, offset));
            if (constantPoolEntry.getKind() != 1) {
                throw new ClassFormatException(3);
            }
            char[] attributeName = constantPoolEntry.getUtf8Value();
            if (Arrays.equals(attributeName, AttributeNamesConstants.DEPRECATED)) {
                this.isDeprecated = true;
                this.attributes[attributesIndex++] = new ClassFileAttribute(classFileBytes, constantPool, offset + readOffset);
            } else if (Arrays.equals(attributeName, AttributeNamesConstants.SYNTHETIC)) {
                this.isSynthetic = true;
                this.attributes[attributesIndex++] = new ClassFileAttribute(classFileBytes, constantPool, offset + readOffset);
            } else if (Arrays.equals(attributeName, AttributeNamesConstants.CODE)) {
                if (!no_code_attribute) {
                    this.codeAttribute = new CodeAttribute(classFileBytes, constantPool, offset + readOffset);
                    this.attributes[attributesIndex++] = this.codeAttribute;
                }
            } else if (Arrays.equals(attributeName, AttributeNamesConstants.EXCEPTIONS)) {
                this.exceptionAttribute = new ExceptionAttribute(classFileBytes, constantPool, offset + readOffset);
                this.attributes[attributesIndex++] = this.exceptionAttribute;
            } else {
                this.attributes[attributesIndex++] = Arrays.equals(attributeName, AttributeNamesConstants.SIGNATURE) ? new SignatureAttribute(classFileBytes, constantPool, offset + readOffset) : (Arrays.equals(attributeName, AttributeNamesConstants.RUNTIME_VISIBLE_ANNOTATIONS) ? new RuntimeVisibleAnnotationsAttribute(classFileBytes, constantPool, offset + readOffset) : (Arrays.equals(attributeName, AttributeNamesConstants.RUNTIME_INVISIBLE_ANNOTATIONS) ? new RuntimeInvisibleAnnotationsAttribute(classFileBytes, constantPool, offset + readOffset) : (Arrays.equals(attributeName, AttributeNamesConstants.RUNTIME_VISIBLE_PARAMETER_ANNOTATIONS) ? new RuntimeVisibleParameterAnnotationsAttribute(classFileBytes, constantPool, offset + readOffset) : (Arrays.equals(attributeName, AttributeNamesConstants.RUNTIME_INVISIBLE_PARAMETER_ANNOTATIONS) ? new RuntimeInvisibleParameterAnnotationsAttribute(classFileBytes, constantPool, offset + readOffset) : (Arrays.equals(attributeName, AttributeNamesConstants.ANNOTATION_DEFAULT) ? new AnnotationDefaultAttribute(classFileBytes, constantPool, offset + readOffset) : new ClassFileAttribute(classFileBytes, constantPool, offset + readOffset))))));
            }
            readOffset = (int)((long)readOffset + (6L + this.u4At(classFileBytes, readOffset + 2, offset)));
            ++i;
        }
        this.attributeBytes = readOffset;
    }

    public int getAccessFlags() {
        return this.accessFlags;
    }

    public int getAttributeCount() {
        return this.attributesCount;
    }

    public ClassFileAttribute[] getAttributes() {
        return this.attributes;
    }

    public CodeAttribute getCodeAttribute() {
        return this.codeAttribute;
    }

    public char[] getDescriptor() {
        return this.descriptor;
    }

    public int getDescriptorIndex() {
        return this.descriptorIndex;
    }

    public ExceptionAttribute getExceptionAttribute() {
        return this.exceptionAttribute;
    }

    public char[] getName() {
        return this.name;
    }

    public int getNameIndex() {
        return this.nameIndex;
    }

    private boolean isAbstract() {
        return (this.accessFlags & 0x400) != 0;
    }

    public boolean isClinit() {
        return this.name[0] == '<' && this.name.length == 8;
    }

    public boolean isConstructor() {
        return this.name[0] == '<' && this.name.length == 6;
    }

    public boolean isDeprecated() {
        return this.isDeprecated;
    }

    private boolean isNative() {
        return (this.accessFlags & 0x100) != 0;
    }

    public boolean isSynthetic() {
        return this.isSynthetic;
    }

    int sizeInBytes() {
        return this.attributeBytes;
    }
}

