/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.accessibility;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.accessibility.AccessibleTextEvent;
import org.eclipse.swt.accessibility.AccessibleTextListener;
import org.eclipse.swt.accessibility.SWTAccessibleDelegate;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.cocoa.NSArray;
import org.eclipse.swt.internal.cocoa.NSMutableArray;
import org.eclipse.swt.internal.cocoa.NSNumber;
import org.eclipse.swt.internal.cocoa.NSObject;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSRange;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSValue;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.id;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;

public class Accessible {
    static NSString[] baseAttributes = new NSString[]{OS.NSAccessibilityRoleAttribute, OS.NSAccessibilityRoleDescriptionAttribute, OS.NSAccessibilityHelpAttribute, OS.NSAccessibilityFocusedAttribute, OS.NSAccessibilityParentAttribute, OS.NSAccessibilityChildrenAttribute, OS.NSAccessibilityPositionAttribute, OS.NSAccessibilitySizeAttribute, OS.NSAccessibilityWindowAttribute, OS.NSAccessibilityTopLevelUIElementAttribute};
    static NSString[] baseTextAttributes = new NSString[]{OS.NSAccessibilityNumberOfCharactersAttribute, OS.NSAccessibilitySelectedTextAttribute, OS.NSAccessibilitySelectedTextRangeAttribute, OS.NSAccessibilityInsertionPointLineNumberAttribute, OS.NSAccessibilitySelectedTextRangesAttribute, OS.NSAccessibilityVisibleCharacterRangeAttribute, OS.NSAccessibilityValueAttribute};
    static NSString[] baseParameterizedAttributes = new NSString[]{OS.NSAccessibilityStringForRangeParameterizedAttribute, OS.NSAccessibilityRangeForLineParameterizedAttribute};
    NSMutableArray attributeNames = null;
    NSMutableArray parameterizedAttributeNames = null;
    NSMutableArray actionNames = null;
    Vector accessibleListeners = new Vector();
    Vector accessibleControlListeners = new Vector();
    Vector accessibleTextListeners = new Vector();
    Control control;
    Map children = new HashMap();

    protected Accessible() {
    }

    Accessible(Control control) {
        this.control = control;
    }

    public static Accessible internal_new_Accessible(Control control) {
        return new Accessible(control);
    }

    public void addAccessibleListener(AccessibleListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        this.accessibleListeners.addElement(listener);
    }

    public void addAccessibleControlListener(AccessibleControlListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        this.accessibleControlListeners.addElement(listener);
    }

    public void addAccessibleTextListener(AccessibleTextListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        this.accessibleTextListeners.addElement(listener);
    }

    public id internal_accessibilityActionDescription(NSString action, int childID) {
        return NSString.stringWith("");
    }

    public NSArray internal_accessibilityActionNames(int childID) {
        AccessibleControlEvent event = new AccessibleControlEvent(this);
        event.childID = childID;
        event.detail = -1;
        int i = 0;
        while (i < this.accessibleControlListeners.size()) {
            AccessibleControlListener listener = (AccessibleControlListener)this.accessibleControlListeners.elementAt(i);
            listener.getRole(event);
            ++i;
        }
        if (event.detail == -1) {
            return null;
        }
        if (childID == -1 && this.actionNames != null) {
            return Accessible.retainedAutoreleased(this.actionNames);
        }
        NSMutableArray returnValue = NSMutableArray.arrayWithCapacity(5L);
        switch (event.detail) {
            case 37: 
            case 43: 
            case 44: 
            case 45: {
                returnValue.addObject(OS.NSAccessibilityPressAction);
            }
        }
        switch (event.detail) {
            case 46: {
                returnValue.addObject(OS.NSAccessibilityConfirmAction);
            }
        }
        if (childID == -1) {
            this.actionNames = returnValue;
            this.actionNames.retain();
            return Accessible.retainedAutoreleased(this.actionNames);
        }
        return returnValue;
    }

    public NSArray internal_accessibilityAttributeNames(int childID) {
        String osRole;
        AccessibleControlEvent event = new AccessibleControlEvent(this);
        event.childID = childID;
        event.detail = -1;
        int i = 0;
        while (i < this.accessibleControlListeners.size()) {
            AccessibleControlListener listener = (AccessibleControlListener)this.accessibleControlListeners.elementAt(i);
            listener.getRole(event);
            ++i;
        }
        if (event.detail == -1) {
            return null;
        }
        if (childID == -1 && this.attributeNames != null) {
            return Accessible.retainedAutoreleased(this.attributeNames);
        }
        NSMutableArray returnValue = NSMutableArray.arrayWithCapacity(baseAttributes.length);
        int i2 = 0;
        while (i2 < baseAttributes.length) {
            if (!returnValue.containsObject(baseAttributes[i2])) {
                returnValue.addObject(baseAttributes[i2]);
            }
            ++i2;
        }
        if (this.accessibleTextListeners.size() > 0) {
            i2 = 0;
            while (i2 < baseTextAttributes.length) {
                if (!returnValue.containsObject(baseTextAttributes[i2])) {
                    returnValue.addObject(baseTextAttributes[i2]);
                }
                ++i2;
            }
        }
        switch (event.detail) {
            case 37: 
            case 41: 
            case 44: 
            case 45: 
            case 60: {
                returnValue.addObject(OS.NSAccessibilityValueAttribute);
            }
        }
        switch (event.detail) {
            case 37: 
            case 41: 
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                returnValue.addObject(OS.NSAccessibilityEnabledAttribute);
            }
        }
        switch (event.detail) {
            case 37: 
            case 43: 
            case 44: 
            case 45: {
                returnValue.addObject(OS.NSAccessibilityTitleAttribute);
            }
        }
        if (event.detail == 46) {
            returnValue.addObject(OS.NSAccessibilityExpandedAttribute);
        }
        if (event.detail == 60) {
            returnValue.addObject(OS.NSAccessibilityContentsAttribute);
            returnValue.addObject(OS.NSAccessibilityTabsAttribute);
        }
        if (event.detail != -1 && (osRole = this.roleToOs(event.detail)).indexOf(58) == -1) {
            returnValue.removeObject(OS.NSAccessibilitySubroleAttribute);
        }
        if (childID != -1) {
            returnValue.removeObject(OS.NSAccessibilityChildrenAttribute);
        }
        if (childID == -1) {
            this.attributeNames = returnValue;
            this.attributeNames.retain();
            return Accessible.retainedAutoreleased(this.attributeNames);
        }
        return returnValue;
    }

    public id internal_accessibilityAttributeValue(NSString attribute, int childID) {
        if (attribute.isEqualToString(OS.NSAccessibilityRoleAttribute)) {
            return this.getRoleAttribute(childID);
        }
        if (attribute.isEqualToString(OS.NSAccessibilitySubroleAttribute)) {
            return this.getSubroleAttribute(childID);
        }
        if (attribute.isEqualToString(OS.NSAccessibilityRoleDescriptionAttribute)) {
            return this.getRoleDescriptionAttribute(childID);
        }
        if (attribute.isEqualToString(OS.NSAccessibilityExpandedAttribute)) {
            return this.getExpandedAttribute(childID);
        }
        if (attribute.isEqualToString(OS.NSAccessibilityHelpAttribute)) {
            return this.getHelpAttribute(childID);
        }
        if (attribute.isEqualToString(OS.NSAccessibilityTitleAttribute)) {
            return this.getTitleAttribute(childID);
        }
        if (attribute.isEqualToString(OS.NSAccessibilityValueAttribute)) {
            return this.getValueAttribute(childID);
        }
        if (attribute.isEqualToString(OS.NSAccessibilityEnabledAttribute)) {
            return this.getEnabledAttribute(childID);
        }
        if (attribute.isEqualToString(OS.NSAccessibilityFocusedAttribute)) {
            return this.getFocusedAttribute(childID);
        }
        if (attribute.isEqualToString(OS.NSAccessibilityParentAttribute)) {
            return this.getParentAttribute(childID);
        }
        if (attribute.isEqualToString(OS.NSAccessibilityChildrenAttribute)) {
            return this.getChildrenAttribute(childID);
        }
        if (attribute.isEqualToString(OS.NSAccessibilityContentsAttribute)) {
            return this.getChildrenAttribute(childID);
        }
        if (attribute.isEqualToString(OS.NSAccessibilityTabsAttribute)) {
            return this.getTabsAttribute(childID);
        }
        if (attribute.isEqualToString(OS.NSAccessibilityWindowAttribute)) {
            return this.getWindowAttribute(childID);
        }
        if (attribute.isEqualToString(OS.NSAccessibilityTopLevelUIElementAttribute)) {
            return this.getTopLevelUIElementAttribute(childID);
        }
        if (attribute.isEqualToString(OS.NSAccessibilityPositionAttribute)) {
            return this.getPositionAttribute(childID);
        }
        if (attribute.isEqualToString(OS.NSAccessibilitySizeAttribute)) {
            return this.getSizeAttribute(childID);
        }
        if (attribute.isEqualToString(OS.NSAccessibilityDescriptionAttribute)) {
            return this.getDescriptionAttribute(childID);
        }
        if (attribute.isEqualToString(OS.NSAccessibilityNumberOfCharactersAttribute)) {
            return this.getNumberOfCharactersAttribute(childID);
        }
        if (attribute.isEqualToString(OS.NSAccessibilitySelectedTextAttribute)) {
            return this.getSelectedTextAttribute(childID);
        }
        if (attribute.isEqualToString(OS.NSAccessibilitySelectedTextRangeAttribute)) {
            return this.getSelectedTextRangeAttribute(childID);
        }
        if (attribute.isEqualToString(OS.NSAccessibilityInsertionPointLineNumberAttribute)) {
            return this.getInsertionPointLineNumberAttribute(childID);
        }
        if (attribute.isEqualToString(OS.NSAccessibilitySelectedTextRangesAttribute)) {
            return this.getSelectedTextRangesAttribute(childID);
        }
        if (attribute.isEqualToString(OS.NSAccessibilityVisibleCharacterRangeAttribute)) {
            return this.getVisibleCharacterRangeAttribute(childID);
        }
        return null;
    }

    public id internal_accessibilityAttributeValue_forParameter(NSString attribute, id parameter, int childID) {
        if (attribute.isEqualToString(OS.NSAccessibilityStringForRangeParameterizedAttribute)) {
            return this.getStringForRangeAttribute(parameter, childID);
        }
        if (attribute.isEqualToString(OS.NSAccessibilityRangeForLineParameterizedAttribute)) {
            return this.getRangeForLineParameterizedAttribute(parameter, childID);
        }
        return null;
    }

    public id internal_accessibilityFocusedUIElement(int childID) {
        AccessibleControlEvent event = new AccessibleControlEvent(this);
        event.childID = -3;
        event.accessible = null;
        int i = 0;
        while (i < this.accessibleControlListeners.size()) {
            AccessibleControlListener listener = (AccessibleControlListener)this.accessibleControlListeners.elementAt(i);
            listener.getFocus(event);
            ++i;
        }
        if (event.childID == -3) {
            return null;
        }
        if (event.accessible != null) {
            return new id(OS.NSAccessibilityUnignoredAncestor(event.accessible.control.view.id));
        }
        if (event.childID == -1 || event.childID == -2) {
            return new id(OS.NSAccessibilityUnignoredAncestor(this.control.view.id));
        }
        return new id(OS.NSAccessibilityUnignoredAncestor(this.childIDToOs((int)event.childID).id));
    }

    public id internal_accessibilityHitTest(NSPoint point, int childID) {
        AccessibleControlEvent event = new AccessibleControlEvent(this);
        event.x = (int)point.x;
        Monitor primaryMonitor = Display.getCurrent().getPrimaryMonitor();
        event.y = (int)((double)primaryMonitor.getBounds().height - point.y);
        event.childID = -3;
        int i = 0;
        while (i < this.accessibleControlListeners.size()) {
            AccessibleControlListener listener = (AccessibleControlListener)this.accessibleControlListeners.elementAt(i);
            listener.getChildAtPoint(event);
            ++i;
        }
        if (event.childID == -3) {
            return null;
        }
        if (event.accessible != null) {
            return new id(OS.NSAccessibilityUnignoredAncestor(event.accessible.control.view.id));
        }
        if (event.childID == -1 || event.childID == -2) {
            return new id(OS.NSAccessibilityUnignoredAncestor(this.control.view.id));
        }
        return new id(OS.NSAccessibilityUnignoredAncestor(this.childIDToOs((int)event.childID).id));
    }

    public boolean internal_accessibilityIsIgnored(int childID) {
        return false;
    }

    public NSArray internal_accessibilityParameterizedAttributeNames(int childID) {
        if (childID == -1 && this.parameterizedAttributeNames != null) {
            return Accessible.retainedAutoreleased(this.parameterizedAttributeNames);
        }
        NSMutableArray returnValue = NSMutableArray.arrayWithCapacity(4L);
        if (this.accessibleTextListeners.size() > 0) {
            int i = 0;
            while (i < baseParameterizedAttributes.length) {
                if (!returnValue.containsObject(baseParameterizedAttributes[i])) {
                    returnValue.addObject(baseParameterizedAttributes[i]);
                }
                ++i;
            }
        }
        if (childID == -1) {
            this.parameterizedAttributeNames = returnValue;
            this.parameterizedAttributeNames.retain();
            return Accessible.retainedAutoreleased(this.parameterizedAttributeNames);
        }
        return returnValue;
    }

    public void internal_accessibilityPerformAction(NSString action, int childID) {
    }

    public Control getControl() {
        return this.control;
    }

    public void internal_dispose_Accessible() {
        if (this.actionNames != null) {
            this.actionNames.release();
        }
        this.actionNames = null;
        if (this.attributeNames != null) {
            this.attributeNames.release();
        }
        this.attributeNames = null;
        if (this.parameterizedAttributeNames != null) {
            this.parameterizedAttributeNames.release();
        }
        this.parameterizedAttributeNames = null;
        Collection delegates = this.children.values();
        Iterator iter = delegates.iterator();
        while (iter.hasNext()) {
            SWTAccessibleDelegate childDelegate = (SWTAccessibleDelegate)iter.next();
            childDelegate.internal_dispose_SWTAccessibleDelegate();
        }
        this.children.clear();
    }

    id getExpandedAttribute(int childID) {
        return NSNumber.numberWithBool(false);
    }

    id getHelpAttribute(int childID) {
        NSString returnValue = null;
        AccessibleEvent event = new AccessibleEvent(this);
        event.childID = childID;
        int i = 0;
        while (i < this.accessibleListeners.size()) {
            AccessibleListener listener = (AccessibleListener)this.accessibleListeners.elementAt(i);
            listener.getHelp(event);
            ++i;
        }
        if (event.result != null) {
            returnValue = NSString.stringWith(event.result);
        }
        return returnValue;
    }

    NSString getRoleAttribute(int childID) {
        NSString returnValue = null;
        AccessibleControlEvent event = new AccessibleControlEvent(this);
        event.childID = childID;
        event.detail = -1;
        int i = 0;
        while (i < this.accessibleControlListeners.size()) {
            AccessibleControlListener listener = (AccessibleControlListener)this.accessibleControlListeners.elementAt(i);
            listener.getRole(event);
            ++i;
        }
        if (event.detail != -1) {
            String appRole = this.roleToOs(event.detail);
            int index = appRole.indexOf(58);
            if (index != -1) {
                appRole = appRole.substring(0, index);
            }
            returnValue = NSString.stringWith(appRole);
        }
        return returnValue;
    }

    id getSubroleAttribute(int childID) {
        String appRole;
        int index;
        NSString returnValue = null;
        AccessibleControlEvent event = new AccessibleControlEvent(this);
        event.childID = childID;
        event.detail = -1;
        int i = 0;
        while (i < this.accessibleControlListeners.size()) {
            AccessibleControlListener listener = (AccessibleControlListener)this.accessibleControlListeners.elementAt(i);
            listener.getRole(event);
            ++i;
        }
        if (event.detail != -1 && (index = (appRole = this.roleToOs(event.detail)).indexOf(58)) != -1) {
            appRole = appRole.substring(index + 1);
            returnValue = NSString.stringWith(appRole);
        }
        return returnValue;
    }

    id getRoleDescriptionAttribute(int childID) {
        NSString returnValue = null;
        AccessibleControlEvent event = new AccessibleControlEvent(this);
        event.childID = childID;
        event.detail = -1;
        int i = 0;
        while (i < this.accessibleControlListeners.size()) {
            AccessibleControlListener listener = (AccessibleControlListener)this.accessibleControlListeners.elementAt(i);
            listener.getRole(event);
            ++i;
        }
        if (event.detail != -1) {
            String appRole = this.roleToOs(event.detail);
            String appSubrole = null;
            int index = appRole.indexOf(58);
            if (index != -1) {
                appSubrole = appRole.substring(index + 1);
                appRole = appRole.substring(0, index);
            }
            NSString nsAppRole = NSString.stringWith(appRole);
            NSString nsAppSubrole = null;
            if (appSubrole != null) {
                nsAppSubrole = NSString.stringWith(appSubrole);
            }
            returnValue = new NSString(OS.NSAccessibilityRoleDescription(nsAppRole != null ? nsAppRole.id : 0L, nsAppSubrole != null ? nsAppSubrole.id : 0L));
        }
        return returnValue;
    }

    id getTitleAttribute(int childID) {
        NSString returnValue = null;
        AccessibleControlEvent roleEvent = new AccessibleControlEvent(this);
        roleEvent.childID = childID;
        roleEvent.detail = -1;
        int i = 0;
        while (i < this.accessibleControlListeners.size()) {
            AccessibleControlListener listener = (AccessibleControlListener)this.accessibleControlListeners.elementAt(i);
            listener.getRole(roleEvent);
            ++i;
        }
        if (roleEvent.detail != 41) {
            AccessibleEvent event = new AccessibleEvent(this);
            event.childID = childID;
            event.result = null;
            int i2 = 0;
            while (i2 < this.accessibleListeners.size()) {
                AccessibleListener listener = (AccessibleListener)this.accessibleListeners.elementAt(i2);
                listener.getName(event);
                ++i2;
            }
            if (event.result != null) {
                returnValue = NSString.stringWith(event.result);
            }
        }
        return returnValue;
    }

    id getValueAttribute(int childID) {
        id returnValue = null;
        AccessibleControlEvent event = new AccessibleControlEvent(this);
        event.childID = childID;
        event.detail = -1;
        event.result = null;
        int i = 0;
        while (i < this.accessibleControlListeners.size()) {
            AccessibleControlListener listener = (AccessibleControlListener)this.accessibleControlListeners.elementAt(i);
            listener.getRole(event);
            listener.getValue(event);
            ++i;
        }
        int role = event.detail;
        String value = event.result;
        switch (role) {
            case 3: 
            case 44: 
            case 45: 
            case 48: 
            case 51: {
                if (value != null) {
                    try {
                        int number = Integer.parseInt(value);
                        returnValue = NSNumber.numberWithInt(number);
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (value.equalsIgnoreCase("true")) {
                            returnValue = NSNumber.numberWithBool(true);
                            break;
                        }
                        if (!value.equalsIgnoreCase("false")) break;
                        returnValue = NSNumber.numberWithBool(false);
                    }
                    break;
                }
                returnValue = NSNumber.numberWithBool(false);
                break;
            }
            case 37: 
            case 60: {
                AccessibleControlEvent ace = new AccessibleControlEvent(this);
                ace.childID = -4;
                int i2 = 0;
                while (i2 < this.accessibleControlListeners.size()) {
                    AccessibleControlListener listener = (AccessibleControlListener)this.accessibleControlListeners.elementAt(i2);
                    listener.getSelection(ace);
                    ++i2;
                }
                if (ace.childID >= -1) {
                    if (role == 37) {
                        returnValue = NSNumber.numberWithBool(ace.childID == childID);
                        break;
                    }
                    returnValue = new id(OS.NSAccessibilityUnignoredAncestor(this.childIDToOs((int)ace.childID).id));
                    break;
                }
                returnValue = NSNumber.numberWithBool(false);
                break;
            }
            case 42: 
            case 46: {
                if (value == null) break;
                returnValue = NSString.stringWith(value);
                break;
            }
            case 41: {
                AccessibleEvent e = new AccessibleEvent(this);
                e.childID = childID;
                e.result = null;
                int i3 = 0;
                while (i3 < this.accessibleListeners.size()) {
                    AccessibleListener listener = (AccessibleListener)this.accessibleListeners.elementAt(i3);
                    listener.getName(e);
                    ++i3;
                }
                if (e.result != null) {
                    returnValue = NSString.stringWith(e.result);
                    break;
                }
                if (value == null) break;
                returnValue = NSString.stringWith(value);
            }
        }
        return returnValue;
    }

    id getEnabledAttribute(int childID) {
        AccessibleControlEvent event = new AccessibleControlEvent(this);
        event.detail = -1;
        int i = 0;
        while (i < this.accessibleControlListeners.size()) {
            AccessibleControlListener listener = (AccessibleControlListener)this.accessibleControlListeners.elementAt(i);
            listener.getState(event);
            ++i;
        }
        return NSNumber.numberWithBool(this.control.isEnabled());
    }

    id getFocusedAttribute(int childID) {
        boolean hasFocus;
        AccessibleControlEvent event = new AccessibleControlEvent(this);
        event.childID = -3;
        event.accessible = null;
        int i = 0;
        while (i < this.accessibleControlListeners.size()) {
            AccessibleControlListener listener = (AccessibleControlListener)this.accessibleControlListeners.elementAt(i);
            listener.getFocus(event);
            ++i;
        }
        if (event.childID == -1) {
            hasFocus = event.childID == childID;
            return NSNumber.numberWithBool(hasFocus);
        }
        if (event.childID == -2) {
            return NSNumber.numberWithBool(false);
        }
        if (event.childID != -3) {
            return NSNumber.numberWithBool(event.childID == childID);
        }
        hasFocus = this.control.view.window().firstResponder() == this.control.view;
        return NSNumber.numberWithBool(hasFocus);
    }

    id getParentAttribute(int childID) {
        if (childID == -1) {
            return null;
        }
        return new id(OS.NSAccessibilityUnignoredAncestor(this.control.view.id));
    }

    id getChildrenAttribute(int childID) {
        id returnValue = null;
        if (childID == -1) {
            AccessibleControlListener listener;
            AccessibleControlEvent event = new AccessibleControlEvent(this);
            event.childID = childID;
            event.detail = -1;
            int i = 0;
            while (i < this.accessibleControlListeners.size()) {
                listener = (AccessibleControlListener)this.accessibleControlListeners.elementAt(i);
                listener.getChildCount(event);
                ++i;
            }
            if (event.detail > 0) {
                i = 0;
                while (i < this.accessibleControlListeners.size()) {
                    listener = (AccessibleControlListener)this.accessibleControlListeners.elementAt(i);
                    listener.getChildren(event);
                    ++i;
                }
                Object[] appChildren = event.children;
                if (appChildren != null && appChildren.length > 0) {
                    NSMutableArray childArray = NSMutableArray.arrayWithCapacity(appChildren.length);
                    int i2 = 0;
                    while (i2 < appChildren.length) {
                        Object child = appChildren[i2];
                        if (child instanceof Integer) {
                            id accChild = this.childIDToOs((Integer)child);
                            childArray.addObject(accChild);
                        } else {
                            childArray.addObject(((Accessible)child).control.view);
                        }
                        ++i2;
                    }
                    returnValue = new id(OS.NSAccessibilityUnignoredChildren(childArray.id));
                }
            }
        } else {
            returnValue = NSArray.array();
        }
        return returnValue;
    }

    id getTabsAttribute(int childID) {
        id returnValue = null;
        if (childID == -1) {
            AccessibleControlListener listener;
            AccessibleControlEvent event = new AccessibleControlEvent(this);
            event.childID = childID;
            event.detail = -1;
            int i = 0;
            while (i < this.accessibleControlListeners.size()) {
                listener = (AccessibleControlListener)this.accessibleControlListeners.elementAt(i);
                listener.getChildCount(event);
                ++i;
            }
            if (event.detail > 0) {
                i = 0;
                while (i < this.accessibleControlListeners.size()) {
                    listener = (AccessibleControlListener)this.accessibleControlListeners.elementAt(i);
                    listener.getChildren(event);
                    ++i;
                }
                Object[] appChildren = event.children;
                if (appChildren != null && appChildren.length > 0) {
                    NSMutableArray childArray = NSMutableArray.arrayWithCapacity(appChildren.length);
                    int i2 = 0;
                    while (i2 < appChildren.length) {
                        Object child = appChildren[i2];
                        if (child instanceof Integer) {
                            int subChildID;
                            event.childID = subChildID = ((Integer)child).intValue();
                            event.detail = -1;
                            int j = 0;
                            while (j < this.accessibleControlListeners.size()) {
                                AccessibleControlListener listener2 = (AccessibleControlListener)this.accessibleControlListeners.elementAt(j);
                                listener2.getRole(event);
                                ++j;
                            }
                            if (event.detail == 37) {
                                id accChild = this.childIDToOs((Integer)child);
                                childArray.addObject(accChild);
                            }
                        } else {
                            childArray.addObject(((Accessible)child).control.view);
                        }
                        ++i2;
                    }
                    returnValue = new id(OS.NSAccessibilityUnignoredChildren(childArray.id));
                }
            }
        } else {
            returnValue = NSArray.array();
        }
        return returnValue;
    }

    id getWindowAttribute(int childID) {
        return this.control.view.window();
    }

    id getTopLevelUIElementAttribute(int childID) {
        return this.control.view.window();
    }

    id getPositionAttribute(int childID) {
        NSValue returnValue = null;
        AccessibleControlEvent event = new AccessibleControlEvent(this);
        event.childID = childID;
        event.width = -1;
        int i = 0;
        while (i < this.accessibleControlListeners.size()) {
            AccessibleControlListener listener = (AccessibleControlListener)this.accessibleControlListeners.elementAt(i);
            listener.getLocation(event);
            ++i;
        }
        Monitor primaryMonitor = Display.getCurrent().getPrimaryMonitor();
        NSPoint osPositionAttribute = new NSPoint();
        if (event.width != -1) {
            osPositionAttribute.x = event.x;
            osPositionAttribute.y = primaryMonitor.getBounds().height - event.y - event.height;
            returnValue = NSValue.valueWithPoint(osPositionAttribute);
        } else if (childID != -1) {
            Point pt = null;
            Rectangle location = this.control.getBounds();
            pt = this.control.getParent() != null ? this.control.getParent().toDisplay(location.x, location.y) : ((Shell)this.control).toDisplay(location.x, location.y);
            osPositionAttribute.x = pt.x;
            osPositionAttribute.y = pt.y;
            returnValue = NSValue.valueWithPoint(osPositionAttribute);
        }
        return returnValue;
    }

    id getSizeAttribute(int childID) {
        NSValue returnValue = null;
        AccessibleControlEvent event = new AccessibleControlEvent(this);
        event.childID = childID;
        event.width = -1;
        int i = 0;
        while (i < this.accessibleControlListeners.size()) {
            AccessibleControlListener listener = (AccessibleControlListener)this.accessibleControlListeners.elementAt(i);
            listener.getLocation(event);
            ++i;
        }
        NSSize controlSize = new NSSize();
        if (event.width != -1) {
            controlSize.width = event.width;
            controlSize.height = event.height;
            returnValue = NSValue.valueWithSize(controlSize);
        } else if (childID != -1) {
            controlSize.height = 0.0;
            controlSize.width = 0.0;
            returnValue = NSValue.valueWithSize(controlSize);
        }
        return returnValue;
    }

    id getDescriptionAttribute(int childID) {
        AccessibleEvent event = new AccessibleEvent(this);
        event.childID = childID;
        event.result = null;
        NSString returnValue = null;
        int i = 0;
        while (i < this.accessibleListeners.size()) {
            AccessibleListener listener = (AccessibleListener)this.accessibleListeners.elementAt(i);
            listener.getDescription(event);
            ++i;
        }
        NSString nSString = returnValue = event.result != null ? NSString.stringWith(event.result) : null;
        if (returnValue == null && this.control instanceof Composite) {
            returnValue = NSString.stringWith("");
        }
        return returnValue;
    }

    id getInsertionPointLineNumberAttribute(int childID) {
        NSNumber returnValue = null;
        AccessibleControlEvent controlEvent = new AccessibleControlEvent(this);
        controlEvent.childID = childID;
        controlEvent.result = null;
        int i = 0;
        while (i < this.accessibleControlListeners.size()) {
            AccessibleControlListener listener = (AccessibleControlListener)this.accessibleControlListeners.elementAt(i);
            listener.getValue(controlEvent);
            ++i;
        }
        AccessibleTextEvent textEvent = new AccessibleTextEvent(this);
        textEvent.childID = childID;
        textEvent.offset = -1;
        int i2 = 0;
        while (i2 < this.accessibleTextListeners.size()) {
            AccessibleTextListener listener = (AccessibleTextListener)this.accessibleTextListeners.elementAt(i2);
            listener.getCaretOffset(textEvent);
            ++i2;
        }
        if (controlEvent.result != null && textEvent.offset != -1) {
            int lineNumber = this.lineNumberForOffset(controlEvent.result, textEvent.offset);
            returnValue = NSNumber.numberWithInt(lineNumber);
        }
        return returnValue;
    }

    id getNumberOfCharactersAttribute(int childID) {
        NSNumber returnValue = null;
        AccessibleControlEvent event = new AccessibleControlEvent(this);
        event.childID = childID;
        event.result = null;
        int i = 0;
        while (i < this.accessibleControlListeners.size()) {
            AccessibleControlListener listener = (AccessibleControlListener)this.accessibleControlListeners.elementAt(i);
            listener.getValue(event);
            ++i;
        }
        String appValue = event.result;
        if (appValue != null) {
            returnValue = NSNumber.numberWithInt(appValue.length());
        }
        return returnValue;
    }

    id getRangeForLineParameterizedAttribute(id parameter, int childID) {
        NSValue returnValue = null;
        NSNumber lineNumberObj = new NSNumber(parameter.id);
        int lineNumber = lineNumberObj.intValue();
        AccessibleControlEvent event = new AccessibleControlEvent(this);
        event.childID = childID;
        event.result = null;
        int i = 0;
        while (i < this.accessibleControlListeners.size()) {
            AccessibleControlListener listener = (AccessibleControlListener)this.accessibleControlListeners.elementAt(i);
            listener.getValue(event);
            ++i;
        }
        if (event.result != null) {
            NSRange range = this.rangeForLineNumber(lineNumber, event.result);
            if (range.location != -1L) {
                returnValue = NSValue.valueWithRange(range);
            }
        }
        return returnValue;
    }

    id getSelectedTextAttribute(int childID) {
        NSString returnValue = NSString.stringWith("");
        AccessibleTextEvent event = new AccessibleTextEvent(this);
        event.childID = childID;
        event.offset = -1;
        event.length = -1;
        int i = 0;
        while (i < this.accessibleTextListeners.size()) {
            AccessibleTextListener listener = (AccessibleTextListener)this.accessibleTextListeners.elementAt(i);
            listener.getSelectionRange(event);
            ++i;
        }
        int offset = event.offset;
        int length = event.length;
        if (offset != -1 && length != -1 && length != 0) {
            AccessibleControlEvent event2 = new AccessibleControlEvent(this);
            event2.childID = event.childID;
            event2.result = null;
            int i2 = 0;
            while (i2 < this.accessibleControlListeners.size()) {
                AccessibleControlListener listener = (AccessibleControlListener)this.accessibleControlListeners.elementAt(i2);
                listener.getValue(event2);
                ++i2;
            }
            String appValue = event2.result;
            if (appValue != null) {
                returnValue = NSString.stringWith(appValue.substring(offset, offset + length));
            }
        }
        return returnValue;
    }

    id getSelectedTextRangeAttribute(int childID) {
        NSValue returnValue = null;
        AccessibleTextEvent event = new AccessibleTextEvent(this);
        event.childID = childID;
        event.offset = -1;
        event.length = 0;
        int i = 0;
        while (i < this.accessibleTextListeners.size()) {
            AccessibleTextListener listener = (AccessibleTextListener)this.accessibleTextListeners.elementAt(i);
            listener.getSelectionRange(event);
            ++i;
        }
        if (event.offset != -1) {
            NSRange range = new NSRange();
            range.location = event.offset;
            range.length = event.length;
            returnValue = NSValue.valueWithRange(range);
        }
        return returnValue;
    }

    id getStringForRangeAttribute(id parameter, int childID) {
        NSString returnValue = null;
        NSValue parameterObject = new NSValue(parameter.id);
        NSRange range = parameterObject.rangeValue();
        AccessibleControlEvent event = new AccessibleControlEvent(this);
        event.childID = childID;
        event.result = null;
        int i = 0;
        while (i < this.accessibleControlListeners.size()) {
            AccessibleControlListener listener = (AccessibleControlListener)this.accessibleControlListeners.elementAt(i);
            listener.getValue(event);
            ++i;
        }
        String appValue = event.result;
        if (appValue != null) {
            returnValue = NSString.stringWith(appValue.substring((int)range.location, (int)(range.location + range.length)));
        }
        return returnValue;
    }

    id getSelectedTextRangesAttribute(int childID) {
        NSMutableArray returnValue = null;
        AccessibleTextEvent event = new AccessibleTextEvent(this);
        event.childID = childID;
        event.offset = -1;
        event.length = 0;
        int i = 0;
        while (i < this.accessibleTextListeners.size()) {
            AccessibleTextListener listener = (AccessibleTextListener)this.accessibleTextListeners.elementAt(i);
            listener.getSelectionRange(event);
            ++i;
        }
        if (event.offset != -1) {
            returnValue = NSMutableArray.arrayWithCapacity(1L);
            NSRange range = new NSRange();
            range.location = event.offset;
            range.length = event.length;
            returnValue.addObject(NSValue.valueWithRange(range));
        }
        return returnValue;
    }

    id getVisibleCharacterRangeAttribute(int childID) {
        AccessibleControlEvent event = new AccessibleControlEvent(this);
        event.childID = childID;
        event.result = null;
        int i = 0;
        while (i < this.accessibleControlListeners.size()) {
            AccessibleControlListener listener = (AccessibleControlListener)this.accessibleControlListeners.elementAt(i);
            listener.getValue(event);
            ++i;
        }
        NSRange range = new NSRange();
        if (event.result == null) {
            return null;
        }
        range.location = 0L;
        range.length = event.result.length();
        return NSValue.valueWithRange(range);
    }

    int lineNumberForOffset(String text, int offset) {
        int lineNumber = 1;
        int length = text.length();
        int i = 0;
        while (i < offset) {
            switch (text.charAt(i)) {
                case '\r': {
                    if (i + 1 < length && text.charAt(i + 1) == '\n') {
                        ++i;
                    }
                }
                case '\n': {
                    ++lineNumber;
                }
            }
            ++i;
        }
        return lineNumber;
    }

    NSRange rangeForLineNumber(int lineNumber, String text) {
        NSRange range = new NSRange();
        range.location = -1L;
        int line = 1;
        int count = 0;
        int length = text.length();
        int i = 0;
        while (i < length) {
            if (line == lineNumber) {
                if (count == 0) {
                    range.location = i;
                }
                ++count;
            }
            if (line > lineNumber) break;
            switch (text.charAt(i)) {
                case '\r': {
                    if (i + 1 < length && text.charAt(i + 1) == '\n') {
                        ++i;
                    }
                }
                case '\n': {
                    ++line;
                }
            }
            ++i;
        }
        range.length = count;
        return range;
    }

    public void removeAccessibleListener(AccessibleListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        this.accessibleListeners.removeElement(listener);
    }

    public void removeAccessibleControlListener(AccessibleControlListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        this.accessibleControlListeners.removeElement(listener);
    }

    public void removeAccessibleTextListener(AccessibleTextListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        this.accessibleTextListeners.removeElement(listener);
    }

    static NSArray retainedAutoreleased(NSArray inObject) {
        id temp = inObject.retain();
        NSObject temp2 = new NSObject(temp.id).autorelease();
        return new NSArray(temp2.id);
    }

    public void selectionChanged() {
        this.checkWidget();
        OS.NSAccessibilityPostNotification(this.control.view.id, OS.NSAccessibilitySelectedChildrenChangedNotification.id);
    }

    public void setFocus(int childID) {
        this.checkWidget();
        OS.NSAccessibilityPostNotification(this.control.view.id, OS.NSAccessibilityFocusedUIElementChangedNotification.id);
    }

    public void textCaretMoved(int index) {
        this.checkWidget();
        OS.NSAccessibilityPostNotification(this.control.view.id, OS.NSAccessibilitySelectedTextChangedNotification.id);
    }

    public void textChanged(int type, int startIndex, int length) {
        this.checkWidget();
        OS.NSAccessibilityPostNotification(this.control.view.id, OS.NSAccessibilityValueChangedNotification.id);
    }

    public void textSelectionChanged() {
        this.checkWidget();
        OS.NSAccessibilityPostNotification(this.control.view.id, OS.NSAccessibilitySelectedTextChangedNotification.id);
    }

    id childIDToOs(int childID) {
        if (childID == -1) {
            return this.control.view;
        }
        SWTAccessibleDelegate childRef = (SWTAccessibleDelegate)this.children.get(new Integer(childID));
        if (childRef == null) {
            childRef = new SWTAccessibleDelegate(this, childID);
            this.children.put(new Integer(childID), childRef);
        }
        return childRef;
    }

    NSString concatStringsAsRole(NSString str1, NSString str2) {
        NSString returnValue = str1;
        returnValue = returnValue.stringByAppendingString(NSString.stringWith(":"));
        returnValue = returnValue.stringByAppendingString(str2);
        return returnValue;
    }

    String roleToOs(int role) {
        NSString nsReturnValue = null;
        switch (role) {
            case 10: {
                nsReturnValue = OS.NSAccessibilityGroupRole;
                break;
            }
            case 9: {
                nsReturnValue = OS.NSAccessibilityWindowRole;
                break;
            }
            case 2: {
                nsReturnValue = OS.NSAccessibilityMenuBarRole;
                break;
            }
            case 11: {
                nsReturnValue = OS.NSAccessibilityMenuRole;
                break;
            }
            case 12: {
                nsReturnValue = OS.NSAccessibilityMenuItemRole;
                break;
            }
            case 21: {
                nsReturnValue = OS.NSAccessibilitySplitterRole;
                break;
            }
            case 13: {
                nsReturnValue = OS.NSAccessibilityHelpTagRole;
                break;
            }
            case 3: {
                nsReturnValue = OS.NSAccessibilityScrollBarRole;
                break;
            }
            case 18: {
                nsReturnValue = this.concatStringsAsRole(OS.NSAccessibilityWindowRole, OS.NSAccessibilityDialogSubrole);
                break;
            }
            case 41: {
                nsReturnValue = OS.NSAccessibilityStaticTextRole;
                break;
            }
            case 43: {
                nsReturnValue = OS.NSAccessibilityButtonRole;
                break;
            }
            case 44: {
                nsReturnValue = OS.NSAccessibilityCheckBoxRole;
                break;
            }
            case 45: {
                nsReturnValue = OS.NSAccessibilityRadioButtonRole;
                break;
            }
            case 62: {
                nsReturnValue = OS.NSAccessibilityMenuButtonRole;
                break;
            }
            case 46: {
                nsReturnValue = OS.NSAccessibilityComboBoxRole;
                break;
            }
            case 42: {
                int style = this.control.getStyle();
                if ((style & 2) != 0) {
                    nsReturnValue = OS.NSAccessibilityTextAreaRole;
                    break;
                }
                nsReturnValue = OS.NSAccessibilityTextFieldRole;
                break;
            }
            case 22: {
                nsReturnValue = OS.NSAccessibilityToolbarRole;
                break;
            }
            case 33: {
                nsReturnValue = OS.NSAccessibilityOutlineRole;
                break;
            }
            case 34: {
                nsReturnValue = OS.NSAccessibilityStaticTextRole;
                break;
            }
            case 24: {
                nsReturnValue = OS.NSAccessibilityTableRole;
                break;
            }
            case 29: {
                nsReturnValue = this.concatStringsAsRole(OS.NSAccessibilityRowRole, OS.NSAccessibilityTableRowSubrole);
                break;
            }
            case 25: {
                nsReturnValue = OS.NSAccessibilitySortButtonRole;
                break;
            }
            case 26: {
                nsReturnValue = this.concatStringsAsRole(OS.NSAccessibilityRowRole, OS.NSAccessibilityTableRowSubrole);
                break;
            }
            case 35: {
                nsReturnValue = OS.NSAccessibilityOutlineRole;
                break;
            }
            case 36: {
                nsReturnValue = this.concatStringsAsRole(OS.NSAccessibilityOutlineRole, OS.NSAccessibilityOutlineRowSubrole);
                break;
            }
            case 60: {
                nsReturnValue = OS.NSAccessibilityTabGroupRole;
                break;
            }
            case 37: {
                nsReturnValue = OS.NSAccessibilityRadioButtonRole;
                break;
            }
            case 48: {
                nsReturnValue = OS.NSAccessibilityProgressIndicatorRole;
                break;
            }
            case 51: {
                nsReturnValue = OS.NSAccessibilitySliderRole;
                break;
            }
            case 30: {
                nsReturnValue = OS.NSAccessibilityLinkRole;
            }
        }
        return nsReturnValue.getString();
    }

    int osToRole(NSString osRole) {
        if (osRole == null) {
            return 0;
        }
        if (osRole.isEqualToString(OS.NSAccessibilityWindowRole)) {
            return 9;
        }
        if (osRole.isEqualToString(OS.NSAccessibilityMenuBarRole)) {
            return 2;
        }
        if (osRole.isEqualToString(OS.NSAccessibilityMenuRole)) {
            return 11;
        }
        if (osRole.isEqualToString(OS.NSAccessibilityMenuItemRole)) {
            return 12;
        }
        if (osRole.isEqualToString(OS.NSAccessibilitySplitterRole)) {
            return 21;
        }
        if (osRole.isEqualToString(OS.NSAccessibilityHelpTagRole)) {
            return 13;
        }
        if (osRole.isEqualToString(OS.NSAccessibilityScrollBarRole)) {
            return 3;
        }
        if (osRole.isEqualToString(OS.NSAccessibilityScrollAreaRole)) {
            return 33;
        }
        if (osRole.isEqualToString(this.concatStringsAsRole(OS.NSAccessibilityWindowRole, OS.NSAccessibilityDialogSubrole))) {
            return 18;
        }
        if (osRole.isEqualToString(this.concatStringsAsRole(OS.NSAccessibilityWindowRole, OS.NSAccessibilitySystemDialogSubrole))) {
            return 18;
        }
        if (osRole.isEqualToString(OS.NSAccessibilityStaticTextRole)) {
            return 41;
        }
        if (osRole.isEqualToString(OS.NSAccessibilityButtonRole)) {
            return 43;
        }
        if (osRole.isEqualToString(OS.NSAccessibilityCheckBoxRole)) {
            return 44;
        }
        if (osRole.isEqualToString(OS.NSAccessibilityRadioButtonRole)) {
            return 45;
        }
        if (osRole.isEqualToString(OS.NSAccessibilityMenuButtonRole)) {
            return 62;
        }
        if (osRole.isEqualToString(OS.NSAccessibilityComboBoxRole)) {
            return 46;
        }
        if (osRole.isEqualToString(OS.NSAccessibilityTextFieldRole)) {
            return 42;
        }
        if (osRole.isEqualToString(OS.NSAccessibilityTextAreaRole)) {
            return 42;
        }
        if (osRole.isEqualToString(OS.NSAccessibilityToolbarRole)) {
            return 22;
        }
        if (osRole.isEqualToString(OS.NSAccessibilityListRole)) {
            return 33;
        }
        if (osRole.isEqualToString(OS.NSAccessibilityTableRole)) {
            return 24;
        }
        if (osRole.isEqualToString(OS.NSAccessibilityColumnRole)) {
            return 25;
        }
        if (osRole.isEqualToString(this.concatStringsAsRole(OS.NSAccessibilityButtonRole, OS.NSAccessibilitySortButtonRole))) {
            return 25;
        }
        if (osRole.isEqualToString(this.concatStringsAsRole(OS.NSAccessibilityRowRole, OS.NSAccessibilityTableRowSubrole))) {
            return 26;
        }
        if (osRole.isEqualToString(OS.NSAccessibilityOutlineRole)) {
            return 35;
        }
        if (osRole.isEqualToString(this.concatStringsAsRole(OS.NSAccessibilityOutlineRole, OS.NSAccessibilityOutlineRowSubrole))) {
            return 36;
        }
        if (osRole.isEqualToString(OS.NSAccessibilityTabGroupRole)) {
            return 60;
        }
        if (osRole.isEqualToString(OS.NSAccessibilityProgressIndicatorRole)) {
            return 48;
        }
        if (osRole.isEqualToString(OS.NSAccessibilitySliderRole)) {
            return 51;
        }
        if (osRole.isEqualToString(OS.NSAccessibilityLinkRole)) {
            return 30;
        }
        return 10;
    }

    void checkWidget() {
        if (!this.isValidThread()) {
            SWT.error(22);
        }
        if (this.control.isDisposed()) {
            SWT.error(24);
        }
    }

    boolean isValidThread() {
        return this.control.getDisplay().getThread() == Thread.currentThread();
    }
}

