/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.photon.OS;
import org.eclipse.swt.internal.photon.PhArea_t;
import org.eclipse.swt.internal.photon.PhDim_t;
import org.eclipse.swt.internal.photon.PtCallbackInfo_t;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.swt.widgets.WidgetTable;

public class TabFolder
extends Composite {
    int parentingHandle;
    TabItem[] items;
    int itemCount;
    int currentIndex = 65535;

    public TabFolder(Composite parent, int style) {
        super(parent, TabFolder.checkStyle(style));
    }

    static int checkStyle(int style) {
        style = TabFolder.checkBits(style, 128, 1024, 0, 0, 0, 0);
        return style & 0xFFFFFCFF;
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            TabFolder.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            TabFolder.error(43);
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        Point size;
        this.checkWidget();
        PhDim_t dim = new PhDim_t();
        if (!OS.PtWidgetIsRealized(this.handle)) {
            OS.PtExtentWidget(this.handle);
        }
        OS.PtWidgetPreferredSize(this.handle, dim);
        int width = dim.w;
        int height = dim.h;
        if (this.layout != null) {
            size = this.layout.computeSize(this, wHint, hHint, changed |= (this.state & 0x200) != 0);
            this.state &= 0xFFFFFDFF;
        } else {
            size = this.minimumSize(wHint, hHint, changed);
        }
        if (size.x == 0) {
            size.x = 64;
        }
        if (size.y == 0) {
            size.y = 64;
        }
        if (wHint != -1) {
            size.x = wHint;
        }
        if (hHint != -1) {
            size.y = hHint;
        }
        width = Math.max(width, size.x);
        height = Math.max(height, size.y);
        Rectangle trim = this.computeTrim(0, 0, width, height);
        width = trim.width;
        height = trim.height;
        return new Point(width, height);
    }

    public Rectangle computeTrim(int x, int y, int width, int height) {
        this.checkWidget();
        PhDim_t dim = new PhDim_t();
        if (!OS.PtWidgetIsRealized(this.handle)) {
            OS.PtExtentWidget(this.handle);
        }
        OS.PtWidgetPreferredSize(this.handle, dim);
        int[] nArray = new int[12];
        nArray[0] = 3004;
        nArray[3] = 3007;
        nArray[6] = 3006;
        nArray[9] = 3005;
        int[] args = nArray;
        OS.PtGetResources(this.handle, args.length / 3, args);
        int trimX = x - args[10];
        int trimY = (this.style & 0x400) != 0 ? y - args[4] : y - (dim.h - args[1]);
        int trimWidth = width + args[7] + args[10];
        int trimHeight = height + dim.h;
        return new Rectangle(trimX, trimY, trimWidth, trimHeight);
    }

    void createHandle(int index) {
        this.state |= 8;
        int parentHandle = this.parent.parentingHandle();
        int[] nArray = new int[3];
        nArray[0] = 1008;
        nArray[2] = 0x3F00000;
        int[] args = nArray;
        this.parentingHandle = OS.PtCreateWidget(OS.PtContainer(), parentHandle, args.length / 3, args);
        if (this.parentingHandle == 0) {
            TabFolder.error(2);
        }
        int clazz = this.display.PtPanelGroup;
        int[] nArray2 = new int[6];
        nArray2[0] = 1008;
        nArray2[2] = 0x3F00000;
        nArray2[3] = 64000;
        nArray2[4] = (this.style & 0x400) != 0 ? 1 : 0;
        nArray2[5] = 1;
        args = nArray2;
        this.handle = OS.PtCreateWidget(clazz, this.parentingHandle, args.length / 3, args);
        if (this.handle == 0) {
            TabFolder.error(2);
        }
    }

    void createWidget(int index) {
        super.createWidget(index);
        this.items = new TabItem[4];
    }

    void createItem(TabItem item, int index) {
        int count = this.itemCount;
        if (index < 0 || index > count) {
            TabFolder.error(6);
        }
        if (count == this.items.length) {
            TabItem[] newItems = new TabItem[this.items.length + 4];
            System.arraycopy(this.items, 0, newItems, 0, this.items.length);
            this.items = newItems;
        }
        int[] nArray = new int[3];
        nArray[0] = 64002;
        int[] args = nArray;
        OS.PtGetResources(this.handle, args.length / 3, args);
        int oldPtr = args[1];
        int newPtr = OS.malloc((count + 1) * 4);
        if (newPtr == 0) {
            TabFolder.error(14);
        }
        int j = 0;
        int[] str = new int[1];
        int[] address = new int[1];
        int i = 0;
        while (i <= count) {
            if (i == index) {
                str[0] = OS.malloc(1);
                OS.memset(str[0], 0, 1);
            } else {
                OS.memmove(address, oldPtr + j++ * 4, 4);
                str[0] = OS.strdup(address[0]);
            }
            if (str[0] == 0) {
                TabFolder.error(14);
            }
            OS.memmove(newPtr + i * 4, str, 4);
            ++i;
        }
        OS.PtSetResource(this.handle, 64002, newPtr, count + 1);
        i = 0;
        while (i <= count) {
            OS.memmove(address, newPtr + i * 4, 4);
            OS.free(address[0]);
            ++i;
        }
        OS.free(newPtr);
        System.arraycopy(this.items, index, this.items, index + 1, count - index);
        this.items[index] = item;
        ++this.itemCount;
    }

    void deregister() {
        super.deregister();
        if (this.parentingHandle != 0) {
            WidgetTable.remove(this.parentingHandle);
        }
    }

    void destroyItem(TabItem item) {
        int count = this.itemCount;
        int index = 0;
        while (index < count) {
            if (this.items[index] == item) break;
            ++index;
        }
        int[] nArray = new int[3];
        nArray[0] = 64002;
        int[] args = nArray;
        OS.PtGetResources(this.handle, args.length / 3, args);
        int oldPtr = args[1];
        int newPtr = OS.malloc((count - 1) * 4);
        if (newPtr == 0) {
            TabFolder.error(14);
        }
        int j = 0;
        int[] str = new int[1];
        int[] address = new int[1];
        int i = 0;
        while (i < count) {
            if (i != index) {
                OS.memmove(address, oldPtr + i * 4, 4);
                str[0] = OS.strdup(address[0]);
                if (str[0] == 0) {
                    TabFolder.error(14);
                }
                OS.memmove(newPtr + j++ * 4, str, 4);
            }
            ++i;
        }
        OS.PtSetResource(this.handle, 64002, newPtr, count - 1);
        i = 0;
        while (i < count - 1) {
            OS.memmove(address, newPtr + i * 4, 4);
            OS.free(address[0]);
            ++i;
        }
        OS.free(newPtr);
        if (index != count) {
            System.arraycopy(this.items, index + 1, this.items, index, --count - index);
        }
        this.items[count] = null;
        --this.itemCount;
    }

    public Rectangle getClientArea() {
        this.checkWidget();
        PhArea_t area = new PhArea_t();
        if (!OS.PtWidgetIsRealized(this.handle)) {
            OS.PtExtentWidgetFamily(this.handle);
        }
        int clientHandle = OS.PtWidgetChildBack(this.handle);
        OS.PtWidgetArea(clientHandle, area);
        int[] nArray = new int[6];
        nArray[0] = 3006;
        nArray[3] = 3004;
        int[] args = nArray;
        OS.PtGetResources(this.handle, args.length / 3, args);
        PhArea_t parentArea = new PhArea_t();
        OS.PtWidgetArea(this.handle, parentArea);
        int deltaX = area.pos_x - parentArea.pos_x;
        int deltaY = area.pos_y - parentArea.pos_y;
        area.size_w = (short)(parentArea.size_w - (deltaX + args[1]));
        area.size_h = (short)(parentArea.size_h - (deltaY + args[4]));
        return new Rectangle(area.pos_x, area.pos_y, area.size_w, area.size_h);
    }

    public TabItem getItem(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.itemCount) {
            TabFolder.error(6);
        }
        return this.items[index];
    }

    public TabItem getItem(Point point) {
        this.checkWidget();
        if (point == null) {
            TabFolder.error(4);
        }
        int index = 0;
        while (index < this.itemCount) {
            TabItem item = this.items[index];
            Rectangle bounds = item.getBounds();
            if (bounds.contains(point)) {
                return item;
            }
            ++index;
        }
        return null;
    }

    public TabItem[] getItems() {
        this.checkWidget();
        TabItem[] result = new TabItem[this.itemCount];
        System.arraycopy(this.items, 0, result, 0, result.length);
        return result;
    }

    public int getItemCount() {
        this.checkWidget();
        return this.itemCount;
    }

    public TabItem[] getSelection() {
        this.checkWidget();
        int index = this.getSelectionIndex();
        if (index == -1) {
            return new TabItem[0];
        }
        return new TabItem[]{this.items[index]};
    }

    public int getSelectionIndex() {
        int index;
        this.checkWidget();
        if (this.currentIndex != 65535 && !OS.PtWidgetIsRealized(this.handle)) {
            index = this.currentIndex;
        } else {
            int[] nArray = new int[3];
            nArray[0] = 64005;
            int[] args = nArray;
            OS.PtGetResources(this.handle, args.length / 3, args);
            index = args[1];
        }
        return index == 65535 ? -1 : index;
    }

    void hookEvents() {
        super.hookEvents();
        int windowProc = this.display.windowProc;
        OS.PtAddCallback(this.handle, 64010, windowProc, 64010);
        OS.PtAddCallback(this.handle, 1012, windowProc, 1012);
    }

    public int indexOf(TabItem item) {
        this.checkWidget();
        if (item == null) {
            TabFolder.error(4);
        }
        int i = 0;
        while (i < this.itemCount) {
            if (this.items[i] == item) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    Point minimumSize(int wHint, int hHint, boolean flushCache) {
        Control[] children = this._getChildren();
        int width = 0;
        int height = 0;
        int i = 0;
        while (i < children.length) {
            Control child = children[i];
            int index = 0;
            while (index < this.itemCount) {
                if (this.items[index].control == child) break;
                ++index;
            }
            if (index == this.itemCount) {
                Rectangle rect = child.getBounds();
                width = Math.max(width, rect.x + rect.width);
                height = Math.max(height, rect.y + rect.height);
            } else {
                Point size = child.computeSize(wHint, hHint, flushCache);
                width = Math.max(width, size.x);
                height = Math.max(height, size.y);
            }
            ++i;
        }
        return new Point(width, height);
    }

    void moveToBack(int child) {
        OS.PtWidgetInsert(child, this.handle, 0);
    }

    int parentingHandle() {
        return this.parentingHandle;
    }

    int Pt_CB_PG_PANEL_SWITCHING(int widget, int info) {
        if (info == 0) {
            return 0;
        }
        PtCallbackInfo_t cbinfo = new PtCallbackInfo_t();
        OS.memmove(cbinfo, info, 16);
        short[] oldIndex = new short[1];
        short[] newIndex = new short[1];
        OS.memmove(oldIndex, cbinfo.cbdata + 8, 2);
        OS.memmove(newIndex, cbinfo.cbdata + 10, 2);
        Control oldControl = null;
        short index = oldIndex[0];
        TabItem oldItem = this.items[index];
        if (index >= 0 && index < this.itemCount) {
            oldControl = oldItem.control;
        }
        Widget newControl = null;
        index = newIndex[0];
        TabItem newItem = this.items[index];
        if (index >= 0 && index < this.itemCount) {
            newControl = newItem.control;
        }
        if (oldControl != null && !oldControl.isDisposed()) {
            oldControl.setVisible(false);
        }
        if (newControl != null && !newControl.isDisposed()) {
            ((Control)newControl).setBounds(this.getClientArea());
            ((Control)newControl).setVisible(true);
        }
        Event event = new Event();
        event.item = newItem;
        this.postEvent(13, event);
        return 0;
    }

    int Pt_CB_REALIZED(int widget, int info) {
        int result = super.Pt_CB_REALIZED(widget, info);
        if (this.currentIndex != 65535) {
            if (info == 0) {
                return 2;
            }
            PtCallbackInfo_t cbinfo = new PtCallbackInfo_t();
            OS.memmove(cbinfo, info, 16);
            if (cbinfo.reason == 1012) {
                this.setSelection(this.currentIndex, false);
                this.currentIndex = 65535;
            }
        }
        return result;
    }

    void register() {
        super.register();
        if (this.parentingHandle != 0) {
            WidgetTable.put(this.parentingHandle, this);
        }
    }

    void releaseHandle() {
        super.releaseHandle();
        this.parentingHandle = 0;
    }

    void releaseChildren(boolean destroy) {
        if (this.items != null) {
            int i = 0;
            while (i < this.itemCount) {
                TabItem item = this.items[i];
                if (item != null && !item.isDisposed()) {
                    item.release(false);
                }
                ++i;
            }
            this.itemCount = 0;
            this.items = null;
        }
        super.releaseChildren(destroy);
    }

    void removeControl(Control control) {
        super.removeControl(control);
        int i = 0;
        while (i < this.itemCount) {
            TabItem item = this.items[i];
            if (item.control == control) {
                item.setControl(null);
            }
            ++i;
        }
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            TabFolder.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    int setBounds(int x, int y, int width, int height, boolean move, boolean resize, boolean events) {
        int result = super.setBounds(x, y, width, height, move, resize, events);
        if ((result & 0x40) != 0) {
            int[] nArray = new int[6];
            nArray[0] = 1023;
            nArray[3] = 1024;
            int[] args = nArray;
            OS.PtGetResources(this.parentingHandle, args.length / 3, args);
            OS.PtSetResources(this.handle, args.length / 3, args);
            int index = this.getSelectionIndex();
            if (index != -1) {
                TabItem item = this.items[index];
                Control control = item.control;
                if (control != null && !control.isDisposed()) {
                    control.setBounds(this.getClientArea());
                }
            }
        }
        return result;
    }

    public void setSelection(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.itemCount) {
            return;
        }
        this.setSelection(index, false);
    }

    void setSelection(int index, boolean notify) {
        int[] nArray = new int[3];
        nArray[0] = 64005;
        int[] args = nArray;
        OS.PtGetResources(this.handle, args.length / 3, args);
        int oldIndex = args[1];
        if (oldIndex != 65535) {
            TabItem item = this.items[oldIndex];
            Control control = item.control;
            if (control != null && !control.isDisposed()) {
                control.setVisible(false);
            }
        }
        if (index == -1) {
            index = 65535;
        }
        OS.PtSetResource(this.handle, 64005, index, 0);
        args[1] = 0;
        OS.PtGetResources(this.handle, args.length / 3, args);
        int newIndex = args[1];
        if (!OS.PtWidgetIsRealized(this.handle)) {
            newIndex = this.currentIndex = index;
        }
        if (newIndex != 65535) {
            TabItem item = this.items[newIndex];
            Control control = item.control;
            if (control != null && !control.isDisposed()) {
                control.setBounds(this.getClientArea());
                control.setVisible(true);
            }
            if (notify) {
                Event event = new Event();
                event.item = item;
                this.postEvent(13, event);
            }
        }
    }

    public void setSelection(TabItem item) {
        this.checkWidget();
        if (item == null) {
            TabFolder.error(4);
        }
        this.setSelection(new TabItem[]{item});
    }

    public void setSelection(TabItem[] items) {
        this.checkWidget();
        if (items == null) {
            TabFolder.error(4);
        }
        if (items.length == 0) {
            this.setSelection(-1, false);
        } else {
            int i = items.length - 1;
            while (i >= 0) {
                int index = this.indexOf(items[i]);
                if (index != -1) {
                    this.setSelection(index, false);
                }
                --i;
            }
        }
    }

    boolean traversePage(boolean next) {
        int count = this.getItemCount();
        if (count == 0) {
            return false;
        }
        int index = this.getSelectionIndex();
        if (index == -1) {
            index = 0;
        } else {
            int offset = next ? 1 : -1;
            index = (index + offset + count) % count;
        }
        this.setSelection(index, true);
        return true;
    }

    int topHandle() {
        return this.parentingHandle;
    }

    int widgetClass() {
        return OS.PtPanelGroup();
    }
}

