/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.photon.OS;
import org.eclipse.swt.internal.photon.PhArea_t;
import org.eclipse.swt.internal.photon.PtCallbackInfo_t;
import org.eclipse.swt.internal.photon.PtScrollbarCallback_t;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class ScrollBar
extends Widget {
    Scrollable parent;

    ScrollBar(Scrollable parent, int style, int handle) {
        super(parent, ScrollBar.checkStyle(style));
        this.parent = parent;
        this.handle = handle;
        this.state |= 8;
        this.createWidget(0);
    }

    ScrollBar(Scrollable parent, int style) {
        super(parent, ScrollBar.checkStyle(style));
        this.parent = parent;
        this.createWidget(0);
    }

    static int checkStyle(int style) {
        return ScrollBar.checkBits(style, 256, 512, 0, 0, 0, 0);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            ScrollBar.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    void createHandle(int index) {
        int basicFlags;
        int size;
        int sizeArg;
        int orientation;
        this.state |= 8;
        if (this.handle != 0) {
            return;
        }
        int parentHandle = this.parent.scrolledHandle;
        if ((this.style & 0x100) != 0) {
            orientation = 1;
            sizeArg = 1024;
            size = this.display.SCROLLBAR_HEIGHT;
            basicFlags = this.display.SCROLLBAR_HORIZONTAL_BASIC_FLAGS;
        } else {
            orientation = 0;
            sizeArg = 1023;
            size = this.display.SCROLLBAR_WIDTH;
            basicFlags = this.display.SCROLLBAR_VERTICAL_BASIC_FLAGS;
        }
        int[] nArray = new int[24];
        nArray[0] = sizeArg;
        nArray[1] = size;
        nArray[3] = 21003;
        nArray[4] = 99;
        nArray[6] = 29005;
        nArray[7] = 10;
        nArray[9] = 29007;
        nArray[10] = 10;
        nArray[12] = 2015;
        nArray[13] = basicFlags;
        nArray[14] = -1;
        nArray[15] = 21005;
        nArray[16] = orientation;
        nArray[18] = 1006;
        nArray[20] = 1024;
        nArray[21] = 1008;
        nArray[23] = 0x3F00000;
        int[] args = nArray;
        this.handle = OS.PtCreateWidget(OS.PtScrollbar(), parentHandle, args.length / 3, args);
        if (this.handle == 0) {
            ScrollBar.error(2);
        }
    }

    public boolean getEnabled() {
        this.checkWidget();
        int topHandle = this.topHandle();
        return (OS.PtWidgetFlags(topHandle) & 0x20000) == 0;
    }

    public int getIncrement() {
        this.checkWidget();
        int[] nArray = new int[3];
        nArray[0] = 29001;
        int[] args = nArray;
        OS.PtGetResources(this.handle, args.length / 3, args);
        return args[1];
    }

    public int getMinimum() {
        this.checkWidget();
        int[] nArray = new int[3];
        nArray[0] = 21002;
        int[] args = nArray;
        OS.PtGetResources(this.handle, args.length / 3, args);
        return args[1];
    }

    public int getMaximum() {
        this.checkWidget();
        int[] nArray = new int[3];
        nArray[0] = 21003;
        int[] args = nArray;
        OS.PtGetResources(this.handle, args.length / 3, args);
        return args[1] + 1;
    }

    public int getPageIncrement() {
        this.checkWidget();
        int[] nArray = new int[3];
        nArray[0] = 29005;
        int[] args = nArray;
        OS.PtGetResources(this.handle, args.length / 3, args);
        return args[1];
    }

    public Scrollable getParent() {
        this.checkWidget();
        return this.parent;
    }

    public int getSelection() {
        this.checkWidget();
        int[] nArray = new int[3];
        nArray[0] = 21004;
        int[] args = nArray;
        OS.PtGetResources(this.handle, args.length / 3, args);
        return args[1];
    }

    public Point getSize() {
        this.checkWidget();
        int[] nArray = new int[6];
        nArray[0] = 1023;
        nArray[3] = 1024;
        int[] args = nArray;
        OS.PtGetResources(this.handle, args.length / 3, args);
        return new Point(args[1], args[4]);
    }

    public int getThumb() {
        this.checkWidget();
        int[] nArray = new int[3];
        nArray[0] = 29007;
        int[] args = nArray;
        OS.PtGetResources(this.handle, args.length / 3, args);
        return args[1];
    }

    public boolean getVisible() {
        this.checkWidget();
        int topHandle = this.topHandle();
        return (OS.PtWidgetFlags(topHandle) & 0x40) == 0;
    }

    void hookEvents() {
        int windowProc = this.display.windowProc;
        OS.PtAddCallback(this.handle, 29010, windowProc, 29010);
    }

    public boolean isEnabled() {
        this.checkWidget();
        return this.getEnabled() && this.parent.isEnabled();
    }

    public boolean isVisible() {
        this.checkWidget();
        return OS.PtWidgetIsRealized(this.handle);
    }

    int Pt_CB_SCROLL_MOVE(int widget, int info) {
        if (info == 0) {
            return 0;
        }
        PtCallbackInfo_t cbinfo = new PtCallbackInfo_t();
        OS.memmove(cbinfo, info, 16);
        if (cbinfo.cbdata == 0) {
            return 0;
        }
        PtScrollbarCallback_t cb = new PtScrollbarCallback_t();
        OS.memmove(cb, cbinfo.cbdata, 8);
        Event event = new Event();
        switch (cb.action) {
            case 7: {
                event.detail = 1;
                break;
            }
            case 6: {
                event.detail = 0x1000007;
                break;
            }
            case 5: {
                event.detail = 0x1000008;
                break;
            }
            case 2: {
                event.detail = 0x1000002;
                break;
            }
            case 1: {
                event.detail = 0x1000001;
                break;
            }
            case 4: {
                event.detail = 0x1000005;
                break;
            }
            case 3: {
                event.detail = 0x1000006;
            }
        }
        this.sendEvent(13, event);
        return 0;
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            ScrollBar.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    void releaseParent() {
        super.releaseParent();
        if (this.parent.horizontalBar == this) {
            this.parent.horizontalBar = null;
        }
        if (this.parent.verticalBar == this) {
            this.parent.verticalBar = null;
        }
    }

    void setBounds(int x, int y, int width, int height) {
        PhArea_t area = new PhArea_t();
        area.pos_x = (short)x;
        area.pos_y = (short)y;
        area.size_w = (short)Math.max(width, 0);
        area.size_h = (short)Math.max(height, 0);
        int ptr = OS.malloc(8);
        OS.memmove(ptr, area, 8);
        OS.PtSetResource(this.handle, 1000, ptr, 0);
        OS.free(ptr);
    }

    public void setEnabled(boolean enabled) {
        this.checkWidget();
        int topHandle = this.topHandle();
        int flags = enabled ? 0 : 0x1020000;
        OS.PtSetResource(topHandle, 1006, flags, 0x1020000);
    }

    public void setIncrement(int value) {
        this.checkWidget();
        OS.PtSetResource(this.handle, 29001, value, 0);
    }

    public void setMaximum(int value) {
        this.checkWidget();
        int[] nArray = new int[12];
        nArray[0] = 21003;
        nArray[3] = 21002;
        nArray[6] = 29007;
        nArray[9] = 21004;
        int[] args = nArray;
        OS.PtGetResources(this.handle, args.length / 3, args);
        int minimum = args[4];
        if (value <= minimum) {
            return;
        }
        int thumb = args[7];
        thumb = Math.min(thumb, value - minimum);
        int selection = args[10];
        selection = Math.min(selection, value - thumb);
        args[1] = value - 1;
        args[7] = thumb;
        args[10] = selection;
        OS.PtSetResources(this.handle, args.length / 3, args);
    }

    public void setMinimum(int value) {
        this.checkWidget();
        if (value < 0) {
            return;
        }
        int[] nArray = new int[12];
        nArray[0] = 21003;
        nArray[3] = 21002;
        nArray[6] = 29007;
        nArray[9] = 21004;
        int[] args = nArray;
        OS.PtGetResources(this.handle, args.length / 3, args);
        int maximum = args[1] + 1;
        if (value >= maximum) {
            return;
        }
        int thumb = args[7];
        thumb = Math.min(thumb, maximum - value);
        int selection = args[10];
        selection = Math.max(selection, value);
        args[4] = value;
        args[7] = thumb;
        args[10] = selection;
        OS.PtSetResources(this.handle, args.length / 3, args);
    }

    public void setPageIncrement(int value) {
        this.checkWidget();
        OS.PtSetResource(this.handle, 29005, value, 0);
    }

    public void setSelection(int value) {
        this.checkWidget();
        OS.PtSetResource(this.handle, 21004, value, 0);
    }

    public void setThumb(int value) {
        this.checkWidget();
        if (value < 1) {
            return;
        }
        int[] nArray = new int[6];
        nArray[0] = 21002;
        nArray[3] = 21003;
        int[] args = nArray;
        OS.PtGetResources(this.handle, args.length / 3, args);
        int minimum = args[1];
        int maximum = args[4] + 1;
        value = Math.min(value, maximum - minimum);
        OS.PtSetResource(this.handle, 29007, value, 0);
    }

    public void setValues(int selection, int minimum, int maximum, int thumb, int increment, int pageIncrement) {
        this.checkWidget();
        if (minimum < 0) {
            return;
        }
        if (maximum < 0) {
            return;
        }
        if (thumb < 1) {
            return;
        }
        if (increment < 1) {
            return;
        }
        if (pageIncrement < 1) {
            return;
        }
        thumb = Math.min(thumb, maximum - minimum);
        int[] nArray = new int[18];
        nArray[0] = 21003;
        nArray[1] = maximum - 1;
        nArray[3] = 21002;
        nArray[4] = minimum;
        nArray[6] = 29007;
        nArray[7] = thumb;
        nArray[9] = 21004;
        nArray[10] = selection;
        nArray[12] = 29001;
        nArray[13] = increment;
        nArray[15] = 29005;
        nArray[16] = pageIncrement;
        int[] args = nArray;
        OS.PtSetResources(this.handle, args.length / 3, args);
    }

    public void setVisible(boolean visible) {
        this.checkWidget();
        int topHandle = this.topHandle();
        int oldFlags = OS.PtWidgetFlags(topHandle);
        int flags = visible ? 0 : 64;
        OS.PtSetResource(topHandle, 1006, flags, 64);
        if ((oldFlags & 0x40) == flags) {
            return;
        }
        this.parent.resizeClientArea();
        if (visible) {
            this.sendEvent(22);
            OS.PtRealizeWidget(topHandle);
        } else {
            OS.PtUnrealizeWidget(topHandle);
            this.sendEvent(23);
        }
    }
}

