/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.photon.OS;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Shell;

public class MessageBox
extends Dialog {
    String message = "";

    public MessageBox(Shell parent) {
        this(parent, 65570);
    }

    public MessageBox(Shell parent, int style) {
        super(parent, MessageBox.checkStyle(parent, MessageBox.checkStyle(style)));
        this.checkSubclass();
    }

    static int checkStyle(int style) {
        int mask = 4064;
        int bits = style & mask;
        if (bits == 32 || bits == 256 || bits == 288) {
            return style;
        }
        if (bits == 64 || bits == 128 || bits == 192 || bits == 448) {
            return style;
        }
        if (bits == 1280 || bits == 3584) {
            return style;
        }
        style = style & ~mask | 0x20;
        return style;
    }

    public String getMessage() {
        return this.message;
    }

    public int open() {
        String[] buttons = null;
        if ((this.style & 0x20) == 32) {
            buttons = new String[]{SWT.getMessage("SWT_OK")};
        }
        if ((this.style & 0x120) == 288) {
            buttons = new String[]{SWT.getMessage("SWT_OK"), SWT.getMessage("SWT_Cancel")};
        }
        if ((this.style & 0xC0) == 192) {
            buttons = new String[]{SWT.getMessage("SWT_Yes"), SWT.getMessage("SWT_No")};
        }
        if ((this.style & 0x1C0) == 448) {
            buttons = new String[]{SWT.getMessage("SWT_Yes"), SWT.getMessage("SWT_No"), SWT.getMessage("SWT_Cancel")};
        }
        if ((this.style & 0x500) == 1280) {
            buttons = new String[]{SWT.getMessage("SWT_Retry"), SWT.getMessage("SWT_Cancel")};
        }
        if ((this.style & 0xE00) == 3584) {
            buttons = new String[]{SWT.getMessage("SWT_Abort"), SWT.getMessage("SWT_Retry"), SWT.getMessage("SWT_Cancel")};
        }
        if (buttons == null) {
            buttons = new String[]{SWT.getMessage("SWT_OK")};
        }
        int phImage = 0;
        int parentHandle = 0;
        if (this.parent != null && OS.PtWidgetIsRealized(this.parent.shellHandle)) {
            parentHandle = this.parent.shellHandle;
        }
        byte[] title = null;
        if (this.title != null) {
            title = Converter.wcsToMbcs(null, this.title, true);
        }
        byte[] message = null;
        message = Converter.wcsToMbcs(null, this.message, true);
        int[] buttonsPtr = new int[buttons.length];
        int i = 0;
        while (i < buttons.length) {
            byte[] text = Converter.wcsToMbcs(null, buttons[i], true);
            int textPtr = OS.malloc(text.length);
            OS.memmove(textPtr, text, text.length);
            buttonsPtr[i] = textPtr;
            ++i;
        }
        int button = OS.PtAlert(parentHandle, null, title, phImage, message, null, buttons.length, buttonsPtr, null, 0, buttons.length, 132);
        int i2 = 0;
        while (i2 < buttons.length) {
            OS.free(buttonsPtr[i2]);
            ++i2;
        }
        if ((this.style & 0xE00) == 3584) {
            if (button == 1) {
                return 512;
            }
            if (button == 2) {
                return 1024;
            }
            return 2048;
        }
        if ((this.style & 0x500) == 1280) {
            return button == 1 ? 1024 : 256;
        }
        if ((this.style & 0x1C0) == 448) {
            if (button == 1) {
                return 64;
            }
            if (button == 2) {
                return 128;
            }
            return 256;
        }
        if ((this.style & 0xC0) == 192) {
            return button == 1 ? 64 : 128;
        }
        if ((this.style & 0x120) == 288) {
            return button == 1 ? 32 : 256;
        }
        if ((this.style & 0x20) == 32 && button == 1) {
            return 32;
        }
        return 256;
    }

    public void setMessage(String string) {
        if (string == null) {
            this.error(4);
        }
        this.message = string;
    }
}

