/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ArmListener;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.photon.OS;
import org.eclipse.swt.internal.photon.PhEvent_t;
import org.eclipse.swt.internal.photon.PhKeyEvent_t;
import org.eclipse.swt.internal.photon.PhPoint_t;
import org.eclipse.swt.internal.photon.PhPointerEvent_t;
import org.eclipse.swt.internal.photon.PtCallbackInfo_t;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TypedListener;

public class MenuItem
extends Item {
    Menu parent;
    Menu menu;
    int accelerator;

    public MenuItem(Menu parent, int style) {
        super(parent, MenuItem.checkStyle(style));
        this.parent = parent;
        this.createWidget(parent.getItemCount());
    }

    public MenuItem(Menu parent, int style, int index) {
        super(parent, MenuItem.checkStyle(style));
        this.parent = parent;
        this.createWidget(index);
    }

    void addAccelerator() {
        int key;
        int keyCode;
        if (this.accelerator == 0) {
            return;
        }
        int keyMods = 0;
        if ((this.accelerator & 0x10000) != 0) {
            keyMods |= 4;
        }
        if ((this.accelerator & 0x20000) != 0) {
            keyMods |= 1;
        }
        if ((this.accelerator & 0x40000) != 0) {
            keyMods |= 2;
        }
        key = (keyCode = Display.untranslateKey(key = this.accelerator & 0xFFF8FFFF)) != 0 ? keyCode : (int)Character.toLowerCase((char)key);
        Shell shell = this.parent.getShell();
        OS.PtAddHotkeyHandler(shell.shellHandle, key, keyMods, (short)0, this.handle, this.display.hotkeyProc);
    }

    public void addArmListener(ArmListener listener) {
        this.checkWidget();
        if (listener == null) {
            MenuItem.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(30, typedListener);
    }

    public void addHelpListener(HelpListener listener) {
        this.checkWidget();
        if (listener == null) {
            MenuItem.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(28, typedListener);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            MenuItem.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            MenuItem.error(43);
        }
    }

    static int checkStyle(int style) {
        return MenuItem.checkBits(style, 8, 32, 16, 2, 64, 0);
    }

    void createHandle(int index) {
        this.state |= 8;
        int count = this.parent.getItemCount();
        if (index < 0 || index > count) {
            MenuItem.error(6);
        }
        int parentHandle = this.parent.handle;
        if ((this.style & 2) != 0) {
            this.handle = OS.PtCreateWidget(OS.PtSeparator(), parentHandle, 0, null);
        } else if ((this.style & 0x30) != 0) {
            int[] nArray = new int[3];
            nArray[0] = 9002;
            nArray[1] = (this.style & 0x20) != 0 ? 0 : 1;
            int[] args = nArray;
            this.handle = OS.PtCreateWidget(OS.PtToggleButton(), parentHandle, args.length / 3, args);
        } else {
            this.handle = OS.PtCreateWidget(OS.PtMenuButton(), parentHandle, 0, null);
        }
        if (this.handle == 0) {
            MenuItem.error(2);
        }
        if (index != count) {
            int i = 0;
            int child = OS.PtWidgetChildBack(parentHandle);
            if (child != 0 && (this.parent.style & 2) != 0) {
                child = OS.PtWidgetChildBack(child);
            }
            while (i != index && child != 0) {
                child = OS.PtWidgetBrotherInFront(child);
                ++i;
            }
            OS.PtWidgetInsert(this.topHandle(), child, 1);
        }
        if (OS.PtWidgetIsRealized(parentHandle)) {
            OS.PtRealizeWidget(this.topHandle());
        }
    }

    public int getAccelerator() {
        this.checkWidget();
        return this.accelerator;
    }

    public boolean getEnabled() {
        this.checkWidget();
        return (this.state & 0x10) == 0;
    }

    public Menu getMenu() {
        this.checkWidget();
        return this.menu;
    }

    String getNameText() {
        if ((this.style & 2) != 0) {
            return "|";
        }
        return super.getNameText();
    }

    public Menu getParent() {
        this.checkWidget();
        return this.parent;
    }

    public boolean getSelection() {
        this.checkWidget();
        if ((this.style & 0x32) == 0) {
            return false;
        }
        return (OS.PtWidgetFlags(this.handle) & 2) != 0;
    }

    void hookEvents() {
        if ((this.style & 2) != 0) {
            return;
        }
        int windowProc = this.display.windowProc;
        if ((this.style & 0x40) != 0) {
            OS.PtAddCallback(this.handle, 2007, windowProc, 2007);
        }
        OS.PtAddCallback(this.handle, 2009, windowProc, 2009);
        if ((this.parent.style & 2) == 0) {
            OS.PtAddCallback(this.handle, 1012, windowProc, 1012);
        }
    }

    int hotkeyProc(int widget, int data, int info) {
        this.showMenu();
        return 0;
    }

    public boolean isEnabled() {
        return this.getEnabled() && this.parent.isEnabled();
    }

    int Pt_CB_ACTIVATE(int widget, int info) {
        if ((this.style & 0x40) != 0 && this.menu != null) {
            return 0;
        }
        Event event = new Event();
        if (info != 0) {
            PtCallbackInfo_t cbinfo = new PtCallbackInfo_t();
            OS.memmove(cbinfo, info, 16);
            if (cbinfo.event != 0) {
                PhEvent_t ev = new PhEvent_t();
                OS.memmove(ev, cbinfo.event, 40);
                int data = OS.PhGetData(cbinfo.event);
                if (data != 0) {
                    switch (ev.type) {
                        case 1: {
                            PhKeyEvent_t ke = new PhKeyEvent_t();
                            OS.memmove(ke, data, PhKeyEvent_t.sizeof);
                            this.setInputState(event, 13, ke.key_mods, ke.button_state);
                            break;
                        }
                        case 2: 
                        case 4: {
                            PhPointerEvent_t pe = new PhPointerEvent_t();
                            OS.memmove(pe, data, 20);
                            this.setInputState(event, 13, pe.key_mods, pe.button_state);
                        }
                    }
                }
            }
        }
        if ((this.style & 0x10) != 0 && (this.parent.getStyle() & 0x400000) == 0) {
            this.selectRadio();
        }
        this.postEvent(13, event);
        return 0;
    }

    int Pt_CB_ARM(int widget, int info) {
        this.sendEvent(30);
        this.showMenu();
        return 0;
    }

    int Pt_CB_REALIZED(int widget, int info) {
        int topHandle = this.topHandle();
        int flags = (this.state & 0x10) != 0 ? 0x1020000 : 0;
        OS.PtSetResource(topHandle, 1006, flags, 0x1020000);
        return 0;
    }

    void releaseChildren(boolean destroy) {
        if (this.menu != null && !this.menu.isDisposed()) {
            this.menu.release(false);
            this.menu = null;
        }
        super.releaseChildren(destroy);
    }

    void releaseParent() {
        super.releaseParent();
        if (this.menu != null) {
            this.menu.dispose();
        }
        this.menu = null;
    }

    void releaseWidget() {
        super.releaseWidget();
        if (this.accelerator != 0) {
            this.removeAccelerator();
        }
        this.accelerator = 0;
        this.parent = null;
    }

    public void removeArmListener(ArmListener listener) {
        this.checkWidget();
        if (listener == null) {
            MenuItem.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(30, listener);
    }

    public void removeHelpListener(HelpListener listener) {
        this.checkWidget();
        if (listener == null) {
            MenuItem.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(28, listener);
    }

    void removeAccelerator() {
        int key;
        int keyCode;
        if (this.accelerator == 0) {
            return;
        }
        int keyMods = 0;
        if ((this.accelerator & 0x10000) != 0) {
            keyMods |= 4;
        }
        if ((this.accelerator & 0x20000) != 0) {
            keyMods |= 1;
        }
        if ((this.accelerator & 0x40000) != 0) {
            keyMods |= 2;
        }
        key = (keyCode = Display.untranslateKey(key = this.accelerator & 0xFFF8FFFF)) != 0 ? keyCode : (int)Character.toLowerCase((char)key);
        Shell shell = this.parent.getShell();
        OS.PtRemoveHotkeyHandler(shell.shellHandle, key, keyMods, (short)0, this.handle, this.display.hotkeyProc);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            MenuItem.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    void selectRadio() {
        int index = 0;
        MenuItem[] items = this.parent.getItems();
        while (index < items.length && items[index] != this) {
            ++index;
        }
        int i = index - 1;
        while (i >= 0 && items[i].setRadioSelection(false)) {
            --i;
        }
        int j = index + 1;
        while (j < items.length && items[j].setRadioSelection(false)) {
            ++j;
        }
        this.setSelection(true);
    }

    public void setAccelerator(int accelerator) {
        this.checkWidget();
        if (this.accelerator == accelerator) {
            return;
        }
        this.removeAccelerator();
        this.accelerator = accelerator;
        this.addAccelerator();
    }

    public void setEnabled(boolean enabled) {
        this.checkWidget();
        this.state = enabled ? (this.state &= 0xFFFFFFEF) : (this.state |= 0x10);
        int topHandle = this.topHandle();
        int flags = (this.state & 0x10) != 0 ? 0x1020000 : 0;
        OS.PtSetResource(topHandle, 1006, flags, 0x1020000);
    }

    public void setImage(Image image) {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return;
        }
        if (this.image == image) {
            return;
        }
        super.setImage(image);
        if ((this.style & 0x30) != 0) {
            return;
        }
        int imageHandle = 0;
        int type = 1;
        if (image != null) {
            imageHandle = this.copyPhImage(image.handle);
            type = this.text.length() != 0 ? 8 : 4;
        } else {
            imageHandle = this.copyPhImage(this.display.nullImage);
        }
        int[] nArray = new int[6];
        nArray[0] = 3001;
        nArray[1] = imageHandle;
        nArray[3] = 3003;
        nArray[4] = type;
        int[] args = nArray;
        OS.PtSetResources(this.handle, args.length / 3, args);
        if (imageHandle != 0) {
            OS.free(imageHandle);
        }
        if (OS.PtWidgetIsRealized(this.handle)) {
            OS.PtExtentWidgetFamily(this.parent.handle);
        }
    }

    public void setMenu(Menu menu) {
        Menu oldMenu;
        this.checkWidget();
        if ((this.style & 0x40) == 0) {
            MenuItem.error(27);
        }
        if (menu != null) {
            if (menu.isDisposed()) {
                MenuItem.error(5);
            }
            if ((menu.style & 4) == 0) {
                MenuItem.error(21);
            }
            if (menu.parent != this.parent.parent) {
                MenuItem.error(32);
            }
        }
        if ((oldMenu = this.menu) == menu) {
            return;
        }
        this.menu = menu;
        if (oldMenu != null) {
            oldMenu.cascade = null;
            if ((this.parent.style & 2) == 0) {
                OS.PtSetResource(this.handle, 7002, 1, 0);
            }
        }
        if (menu != null) {
            menu.cascade = this;
            if ((this.parent.style & 2) == 0) {
                OS.PtSetResource(this.handle, 7002, 2, 0);
            }
        }
    }

    boolean setRadioSelection(boolean value) {
        if ((this.style & 0x10) == 0) {
            return false;
        }
        if (this.getSelection() != value) {
            this.setSelection(value);
            this.postEvent(13);
        }
        return true;
    }

    public void setSelection(boolean selected) {
        this.checkWidget();
        if ((this.style & 0x32) == 0) {
            return;
        }
        OS.PtSetResource(this.handle, 1006, selected ? 2 : 0, 2);
    }

    public void setText(String string) {
        int start;
        this.checkWidget();
        if (string == null) {
            MenuItem.error(4);
        }
        super.setText(string);
        char[] text = new char[string.length()];
        string.getChars(0, text.length, text, 0);
        boolean accel = false;
        int i = 0;
        int j = 0;
        char mnemonic = '\u0000';
        while (i < text.length) {
            if (text[i] == '\t') {
                accel = true;
                break;
            }
            if ((text[j++] = text[i++]) != '&' || i == text.length) continue;
            if (text[i] == '&') {
                ++i;
                continue;
            }
            if (mnemonic == '\u0000') {
                mnemonic = text[i];
            }
            --j;
        }
        int keyMods = 0;
        byte[] buffer2 = new byte[1];
        if (accel && ++i < text.length && (start = i) < text.length) {
            char[] accelText = new char[text.length - start];
            System.arraycopy(text, start, accelText, 0, accelText.length);
            buffer2 = Converter.wcsToMbcs(null, accelText, true);
        }
        while (j < text.length) {
            text[j++] = '\u0000';
        }
        byte[] buffer1 = Converter.wcsToMbcs(null, text, true);
        int ptr1 = OS.malloc(buffer1.length);
        OS.memmove(ptr1, buffer1, buffer1.length);
        int ptr2 = OS.malloc(buffer2.length);
        OS.memmove(ptr2, buffer2, buffer2.length);
        int ptr3 = 0;
        if (mnemonic != '\u0000') {
            byte[] buffer3 = Converter.wcsToMbcs(null, new char[]{mnemonic}, true);
            ptr3 = OS.malloc(buffer3.length);
            OS.memmove(ptr3, buffer3, buffer3.length);
        }
        if ((this.parent.style & 2) != 0) {
            this.replaceMnemonic(mnemonic, false, true);
        }
        int type = 1;
        if ((this.style & 8) != 0 && this.image != null) {
            type = 8;
        }
        int[] nArray = new int[15];
        nArray[0] = 3011;
        nArray[1] = ptr1;
        nArray[3] = 7000;
        nArray[4] = ptr2;
        nArray[6] = 7004;
        nArray[7] = keyMods;
        nArray[8] = keyMods;
        nArray[9] = 3018;
        nArray[10] = ptr3;
        nArray[12] = 3003;
        nArray[13] = type;
        int[] args = nArray;
        OS.PtSetResources(this.handle, args.length / 3, args);
        OS.free(ptr1);
        OS.free(ptr2);
        OS.free(ptr3);
        if (OS.PtWidgetIsRealized(this.handle)) {
            OS.PtExtentWidgetFamily(this.parent.handle);
        }
    }

    void showMenu() {
        if (this.menu == null) {
            return;
        }
        int menuHandle = this.menu.handle;
        if (!OS.PtWidgetIsRealized(menuHandle)) {
            if ((this.parent.style & 2) == 0) {
                OS.PtSetResource(menuHandle, 19000, 8, 8);
            }
            OS.PtReParentWidget(menuHandle, this.handle);
            if ((this.parent.style & 2) != 0) {
                PhPoint_t pt = new PhPoint_t();
                short[] x = new short[1];
                short[] y = new short[1];
                OS.PtGetAbsPosition(this.handle, x, y);
                pt.x = x[0];
                pt.y = y[0];
                int[] nArray = new int[3];
                nArray[0] = 1024;
                int[] args = nArray;
                OS.PtGetResources(this.handle, args.length / 3, args);
                pt.y = (short)(pt.y + args[1]);
                int ptr = OS.malloc(4);
                OS.memmove(ptr, pt, 4);
                OS.PtSetResource(menuHandle, 1007, ptr, 0);
                OS.free(ptr);
            } else {
                OS.PtPositionMenu(menuHandle, null);
            }
            this.menu.sendEvent(22);
            OS.PtRealizeWidget(menuHandle);
        }
    }
}

