/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.eventmgr;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class CopyOnWriteIdentityMap
implements Map {
    private static final Entry[] emptyArray = new Entry[0];
    private volatile Entry[] entries;

    public CopyOnWriteIdentityMap() {
        this.entries = emptyArray;
    }

    public CopyOnWriteIdentityMap(CopyOnWriteIdentityMap source) {
        this.entries = source.entries();
    }

    public synchronized Object put(Object key, Object value) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        int size = this.entries.length;
        int i = 0;
        while (i < size) {
            if (this.entries[i].key == key) {
                Object v = this.entries[i].value;
                if (v == value) {
                    return v;
                }
                Entry[] newEntries = new Entry[size];
                System.arraycopy(this.entries, 0, newEntries, 0, size);
                newEntries[i] = new Entry(key, value);
                this.entries = newEntries;
                return v;
            }
            ++i;
        }
        Entry[] newEntries = new Entry[size + 1];
        if (size > 0) {
            System.arraycopy(this.entries, 0, newEntries, 0, size);
        }
        newEntries[size] = new Entry(key, value);
        this.entries = newEntries;
        return null;
    }

    public void putAll(Map source) {
        int sourceSize = source.size();
        if (sourceSize == 0) {
            return;
        }
        if (source instanceof CopyOnWriteIdentityMap) {
            this.putAll(((CopyOnWriteIdentityMap)source).entries());
            return;
        }
        Entry[] toCopy = new Entry[sourceSize];
        Iterator iter = source.entrySet().iterator();
        int i = 0;
        while (i < sourceSize) {
            Map.Entry mapEntry = iter.next();
            toCopy[i] = new Entry(mapEntry.getKey(), mapEntry.getValue());
            ++i;
        }
        this.putAll(toCopy);
    }

    public void putAll(Object[] keys) {
        int sourceSize = keys.length;
        if (sourceSize == 0) {
            return;
        }
        Entry[] toCopy = new Entry[sourceSize];
        int i = 0;
        while (i < sourceSize) {
            toCopy[i] = new Entry(keys[i], null);
            ++i;
        }
        this.putAll(toCopy);
    }

    private synchronized void putAll(Entry[] toCopy) {
        int sourceSize = toCopy.length;
        int size = this.entries.length;
        Entry[] newEntries = new Entry[size + sourceSize];
        System.arraycopy(this.entries, 0, newEntries, 0, size);
        int n = 0;
        while (n < sourceSize) {
            block4: {
                Entry copy = toCopy[n];
                int i = 0;
                while (i < size) {
                    if (newEntries[i].key == copy.key) {
                        newEntries[i] = copy;
                        break block4;
                    }
                    ++i;
                }
                newEntries[size] = copy;
                ++size;
            }
            ++n;
        }
        if (size == newEntries.length) {
            this.entries = newEntries;
            return;
        }
        Entry[] e = new Entry[size];
        System.arraycopy(newEntries, 0, e, 0, size);
        this.entries = e;
    }

    public synchronized Object remove(Object key) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        int size = this.entries.length;
        int i = 0;
        while (i < size) {
            if (this.entries[i].key == key) {
                int next;
                Object v = this.entries[i].value;
                if (size == 1) {
                    this.entries = emptyArray;
                    return v;
                }
                Entry[] newEntries = new Entry[size - 1];
                if (i > 0) {
                    System.arraycopy(this.entries, 0, newEntries, 0, i);
                }
                if ((next = size - 1 - i) > 0) {
                    System.arraycopy(this.entries, i + 1, newEntries, i, next);
                }
                this.entries = newEntries;
                return v;
            }
            ++i;
        }
        return null;
    }

    public synchronized void clear() {
        this.entries = emptyArray;
    }

    private Entry[] entries() {
        return this.entries;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int size() {
        return this.entries().length;
    }

    public Object get(Object key) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        Entry[] e = this.entries();
        int i = 0;
        while (i < e.length) {
            if (e[i].key == key) {
                return e[i].value;
            }
            ++i;
        }
        return null;
    }

    public boolean containsKey(Object key) {
        if (key == null) {
            throw new IllegalArgumentException();
        }
        Entry[] e = this.entries();
        int i = 0;
        while (i < e.length) {
            if (e[i].key == key) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean containsValue(Object value) {
        Entry[] e = this.entries();
        int i = 0;
        while (i < e.length) {
            if (e[i].value == value) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public Set entrySet() {
        return new EntrySet(this.entries(), 1);
    }

    public Set keySet() {
        return new EntrySet(this.entries(), 2);
    }

    public Collection values() {
        return new EntrySet(this.entries(), 3);
    }

    private static class Entry
    implements Map.Entry {
        final Object key;
        final Object value;

        Entry(Object key, Object value) {
            this.key = key;
            this.value = value;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object value) {
            throw new UnsupportedOperationException();
        }
    }

    private static class EntryIterator
    implements Iterator {
        private final Entry[] entries;
        private final int returnType;
        private int cursor = 0;

        EntryIterator(Entry[] entries, int returnType) {
            this.entries = entries;
            this.returnType = returnType;
        }

        public boolean hasNext() {
            return this.cursor < this.entries.length;
        }

        public Object next() {
            if (this.cursor == this.entries.length) {
                throw new NoSuchElementException();
            }
            switch (this.returnType) {
                case 1: {
                    return this.entries[this.cursor++];
                }
                case 2: {
                    return this.entries[this.cursor++].key;
                }
                case 3: {
                    return this.entries[this.cursor++].value;
                }
            }
            throw new InternalError();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class EntrySet
    extends AbstractSet {
        private final Entry[] entries;
        private final int returnType;
        static final int ENTRY = 1;
        static final int KEY = 2;
        static final int VALUE = 3;

        EntrySet(Entry[] entries, int returnType) {
            this.entries = entries;
            this.returnType = returnType;
        }

        public Iterator iterator() {
            return new EntryIterator(this.entries, this.returnType);
        }

        public int size() {
            return this.entries.length;
        }
    }
}

