/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.usagedata.internal.recording.uploading;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.epp.usagedata.internal.gathering.events.UsageDataEvent;
import org.eclipse.epp.usagedata.internal.recording.UsageDataRecordingActivator;
import org.eclipse.epp.usagedata.internal.recording.settings.UploadSettings;
import org.eclipse.epp.usagedata.internal.recording.uploading.AbstractUploader;
import org.eclipse.epp.usagedata.internal.recording.uploading.BasicUploaderResponseListener;
import org.eclipse.epp.usagedata.internal.recording.uploading.BasicUploaderServerResponse;
import org.eclipse.epp.usagedata.internal.recording.uploading.UploadParameters;
import org.eclipse.epp.usagedata.internal.recording.uploading.UploadResult;
import org.eclipse.epp.usagedata.internal.recording.uploading.UsageDataFileReader;

public class BasicUploader
extends AbstractUploader {
    private static final String HTTP_USERID = "USERID";
    private static final String HTTP_WORKSPACEID = "WORKSPACEID";
    private static final String HTTP_TIME = "TIME";
    private static final String USER_AGENT = "User-Agent";
    private boolean uploadInProgress = false;
    private ListenerList responseListeners = new ListenerList();

    public BasicUploader(UploadParameters uploadParameters) {
        this.setUploadParameters(uploadParameters);
    }

    public synchronized void startUpload() {
        this.checkValues();
        if (this.uploadInProgress) {
            return;
        }
        this.uploadInProgress = true;
        Job job = new Job("Uploading usage data..."){

            protected IStatus run(IProgressMonitor monitor) {
                UploadResult result = BasicUploader.this.upload(monitor);
                BasicUploader.this.uploadInProgress = false;
                BasicUploader.this.fireUploadComplete(result);
                return Status.OK_STATUS;
            }
        };
        job.setPriority(30);
        job.schedule();
    }

    UploadResult upload(IProgressMonitor monitor) {
        UploadResult result = null;
        try {
            long start = System.currentTimeMillis();
            result = this.doUpload(monitor);
            long duration = System.currentTimeMillis() - start;
            if (result.isSuccess()) {
                UsageDataRecordingActivator.getDefault().log(1, "Usage data uploaded to %1$s in %2$s milliseconds.", this.getUploadUrl(), duration);
            } else {
                UsageDataRecordingActivator.getDefault().log(1, "Usage data upload to %1$s failed with error code %2$s.", this.getUploadUrl(), result.getReturnCode());
            }
        }
        catch (IllegalStateException e) {
            UsageDataRecordingActivator.getDefault().log(2, e, "The URL provided for usage data upload, %1$s, is invalid.", this.getUploadUrl());
        }
        catch (UnknownHostException e) {
            UsageDataRecordingActivator.getDefault().log(2, e, "The usage data upload server at %1$s could not be found.", this.getUploadUrl());
        }
        catch (ConnectException e) {
            UsageDataRecordingActivator.getDefault().log(2, e, "Could not connect to the usage data upload server at %1$s.", this.getUploadUrl());
        }
        catch (InterruptedIOException e) {
            UsageDataRecordingActivator.getDefault().log(2, e, "A socket timeout occurred while trying to upload usage data.");
        }
        catch (Exception e) {
            UsageDataRecordingActivator.getDefault().log(2, e, "An exception occurred while trying to upload usage data.");
        }
        return result;
    }

    private String getUploadUrl() {
        return this.getSettings().getUploadUrl();
    }

    UploadResult doUpload(IProgressMonitor monitor) throws Exception {
        monitor.beginTask("Upload", this.getUploadParameters().getFiles().length + 3);
        if (!this.hasUserAuthorizedUpload()) {
            throw new Exception("User has not authorized upload.");
        }
        PostMethod post = new PostMethod(this.getSettings().getUploadUrl());
        post.setRequestHeader(HTTP_USERID, this.getSettings().getUserId());
        post.setRequestHeader(HTTP_WORKSPACEID, this.getSettings().getWorkspaceId());
        post.setRequestHeader(HTTP_TIME, String.valueOf(System.currentTimeMillis()));
        post.setRequestHeader(USER_AGENT, this.getSettings().getUserAgent());
        boolean loggingServerActivity = this.getSettings().isLoggingServerActivity();
        if (loggingServerActivity) {
            post.setRequestHeader("LOGGING", "true");
        }
        post.setRequestEntity((RequestEntity)new MultipartRequestEntity(this.getFileParts(monitor), post.getParams()));
        HttpClientParams httpParameters = new HttpClientParams();
        httpParameters.setSoTimeout(this.getSocketTimeout());
        monitor.worked(1);
        int result = new HttpClient(httpParameters).executeMethod((HttpMethod)post);
        this.handleServerResponse(post);
        monitor.worked(1);
        post.releaseConnection();
        if (result == 200) {
            File[] fileArray = this.getUploadParameters().getFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.exists()) {
                    file.delete();
                }
                ++n2;
            }
        }
        monitor.worked(1);
        monitor.done();
        return new UploadResult(result);
    }

    int getSocketTimeout() {
        return this.getUploadParameters().getFiles().length * 60000;
    }

    void handleServerResponse(PostMethod post) {
        if (!this.shouldProcessServerResponse()) {
            return;
        }
        InputStream response = null;
        try {
            try {
                response = post.getResponseBodyAsStream();
                this.handleServerResponse(new BufferedReader(new InputStreamReader(response)));
            }
            catch (IOException e) {
                UsageDataRecordingActivator.getDefault().log(2, e, "Exception raised while parsing the server response");
                try {
                    response.close();
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                response.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private boolean shouldProcessServerResponse() {
        if (this.getSettings().isLoggingServerActivity()) {
            return true;
        }
        return !this.responseListeners.isEmpty();
    }

    void handleServerResponse(BufferedReader response) throws IOException {
        String line;
        while ((line = response.readLine()) != null) {
            int colon;
            if (this.getSettings().isLoggingServerActivity()) {
                UsageDataRecordingActivator.getDefault().log(1, line, new Object[0]);
            }
            if ((colon = line.indexOf(58)) != -1) {
                String key = line.substring(0, colon);
                String value = line.substring(colon + 1);
                this.handleServerResponse(key, value);
                continue;
            }
            this.handleServerResponse("", line);
        }
        return;
    }

    void handleServerResponse(String key, String value) {
        BasicUploaderServerResponse response = new BasicUploaderServerResponse(key, value);
        Object[] objectArray = this.responseListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((BasicUploaderResponseListener)listener).handleServerResponse(response);
            ++n2;
        }
    }

    boolean hasUserAuthorizedUpload() {
        if (!this.getSettings().isEnabled()) {
            return false;
        }
        return this.getSettings().hasUserAcceptedTermsOfUse();
    }

    private UploadSettings getSettings() {
        return this.getUploadParameters().getSettings();
    }

    Part[] getFileParts(IProgressMonitor monitor) {
        ArrayList<FilteredFilePart> fileParts = new ArrayList<FilteredFilePart>();
        File[] fileArray = this.getUploadParameters().getFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            try {
                fileParts.add(new FilteredFilePart(monitor, "uploads[]", file));
            }
            catch (FileNotFoundException fileNotFoundException) {}
            ++n2;
        }
        return fileParts.toArray(new Part[fileParts.size()]);
    }

    public synchronized boolean isUploadInProgress() {
        return this.uploadInProgress;
    }

    public void addResponseListener(BasicUploaderResponseListener listener) {
        this.responseListeners.add((Object)listener);
    }

    public void removeResponseListener(BasicUploaderResponseListener listener) {
        this.responseListeners.remove((Object)listener);
    }

    class FilteredFilePart
    extends FilePart {
        private final IProgressMonitor monitor;

        public FilteredFilePart(IProgressMonitor monitor, String name, File file) throws FileNotFoundException {
            super(name, file);
            this.monitor = monitor;
        }

        protected void sendData(OutputStream out) throws IOException {
            final BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out));
            InputStream input = null;
            try {
                try {
                    input = this.getSource().createInputStream();
                    new UsageDataFileReader(input).iterate(new UsageDataFileReader.Iterator(){

                        public void header(String header) throws Exception {
                            writer.append(header);
                            writer.append('\n');
                        }

                        public void event(String line, UsageDataEvent event) throws Exception {
                            if (BasicUploader.this.getUploadParameters().getFilter().includes(event)) {
                                writer.append(line);
                                writer.append('\n');
                            }
                        }
                    });
                    writer.flush();
                    this.monitor.worked(1);
                }
                catch (Exception e) {
                    if (e instanceof IOException) {
                        throw (IOException)e;
                    }
                    UsageDataRecordingActivator.getDefault().log(2, e, e.getMessage());
                    input.close();
                }
            }
            finally {
                input.close();
            }
        }

        public long length() throws IOException {
            return -1L;
        }
    }
}

