/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.usagedata.internal.recording.filtering;

import org.eclipse.epp.usagedata.internal.gathering.events.UsageDataEvent;
import org.eclipse.epp.usagedata.internal.recording.UsageDataRecordingActivator;
import org.eclipse.epp.usagedata.internal.recording.filtering.AbstractUsageDataEventFilter;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public class PreferencesBasedFilter
extends AbstractUsageDataEventFilter {
    public PreferencesBasedFilter() {
        this.hookListeners();
    }

    protected void hookListeners() {
        this.propertyChangeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (PreferencesBasedFilter.this.isFilterProperty(event.getProperty())) {
                    PreferencesBasedFilter.this.fireFilterChangedEvent();
                }
            }
        };
        this.getPreferenceStore().addPropertyChangeListener(this.propertyChangeListener);
    }

    public void dispose() {
        this.getPreferenceStore().removePropertyChangeListener(this.propertyChangeListener);
    }

    boolean isFilterProperty(String property) {
        if ("org.eclipse.epp.usagedata.recording.filter-eclipse-only".equals(property)) {
            return true;
        }
        return "org.eclipse.epp.usagedata.recording.filter-patterns".equals(property);
    }

    public boolean includes(UsageDataEvent event) {
        if (this.includeOnlyEclipseDotOrgBundles()) {
            return event.bundleId.startsWith("org.eclipse.");
        }
        String[] stringArray = this.getFilterPatterns();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String filter = stringArray[n2];
            if (this.matches(filter, event.bundleId)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public String[] getFilterPatterns() {
        String patternString = this.getPreferenceStore().getString("org.eclipse.epp.usagedata.recording.filter-patterns");
        if ("".equals(patternString)) {
            return new String[0];
        }
        return patternString.split("\n");
    }

    private boolean includeOnlyEclipseDotOrgBundles() {
        return this.getPreferenceStore().getBoolean("org.eclipse.epp.usagedata.recording.filter-eclipse-only");
    }

    IPreferenceStore getPreferenceStore() {
        return UsageDataRecordingActivator.getDefault().getPreferenceStore();
    }

    public void addPattern(String value) {
        String patternString = this.getPreferenceStore().getString("org.eclipse.epp.usagedata.recording.filter-patterns");
        patternString = patternString.trim().length() == 0 ? value : String.valueOf(patternString) + "\n" + value;
        this.getPreferenceStore().setValue("org.eclipse.epp.usagedata.recording.filter-patterns", patternString);
        UsageDataRecordingActivator.getDefault().savePluginPreferences();
    }

    public boolean includesPattern(String pattern) {
        String[] stringArray = this.getFilterPatterns();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String filter = stringArray[n2];
            if (pattern.equals(filter)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void removeFilterPatterns(Object[] toRemove) {
        String patternString = this.getPreferenceStore().getString("org.eclipse.epp.usagedata.recording.filter-patterns");
        String[] patterns = patternString.split("\n");
        StringBuilder builder = new StringBuilder();
        String separator = "";
        String[] stringArray = patterns;
        int n = patterns.length;
        int n2 = 0;
        while (n2 < n) {
            String pattern = stringArray[n2];
            if (!this.shouldRemovePattern(pattern, toRemove)) {
                builder.append(separator);
                builder.append(pattern);
                separator = "\n";
            }
            ++n2;
        }
        this.getPreferenceStore().setValue("org.eclipse.epp.usagedata.recording.filter-patterns", builder.toString());
        UsageDataRecordingActivator.getDefault().savePluginPreferences();
    }

    private boolean shouldRemovePattern(String pattern, Object[] toRemove) {
        Object[] objectArray = toRemove;
        int n = toRemove.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object.equals(pattern)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void setEclipseOnly(boolean value) {
        this.getPreferenceStore().setValue("org.eclipse.epp.usagedata.recording.filter-eclipse-only", value);
        UsageDataRecordingActivator.getDefault().savePluginPreferences();
    }

    public boolean isEclipseOnly() {
        return this.getPreferenceStore().getBoolean("org.eclipse.epp.usagedata.recording.filter-eclipse-only");
    }
}

