/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.weaving.hooks;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.equinox.service.weaving.ISupplementerRegistry;
import org.eclipse.equinox.weaving.hooks.AbstractAspectJHook;
import org.eclipse.equinox.weaving.hooks.IAdaptorProvider;
import org.eclipse.equinox.weaving.hooks.Supplementer;
import org.eclipse.osgi.util.ManifestElement;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.service.packageadmin.PackageAdmin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SupplementerRegistry
implements ISupplementerRegistry {
    public static final String SUPPLEMENT_BUNDLE = "Eclipse-SupplementBundle";
    public static final String SUPPLEMENT_EXPORTER = "Eclipse-SupplementExporter";
    public static final String SUPPLEMENT_IMPORTER = "Eclipse-SupplementImporter";
    private final IAdaptorProvider adaptorProvider;
    private BundleContext context;
    private final Set<String> dontWeaveTheseBundles;
    private PackageAdmin packageAdmin;
    private final Map<String, Supplementer> supplementers;
    private final Map<Long, Bundle[]> supplementersByBundle;

    public SupplementerRegistry(IAdaptorProvider iAdaptorProvider) {
        this.adaptorProvider = iAdaptorProvider;
        this.supplementers = new HashMap<String, Supplementer>();
        this.supplementersByBundle = new HashMap<Long, Bundle[]>();
        this.dontWeaveTheseBundles = new HashSet<String>();
        this.dontWeaveTheseBundles.add("org.eclipse.osgi");
        this.dontWeaveTheseBundles.add("org.eclipse.update.configurator");
        this.dontWeaveTheseBundles.add("org.eclipse.core.runtime");
        this.dontWeaveTheseBundles.add("org.eclipse.equinox.common");
        this.dontWeaveTheseBundles.add("org.eclipse.equinox.weaving.hook");
        this.dontWeaveTheseBundles.add("org.eclipse.equinox.weaving.aspectj");
        this.dontWeaveTheseBundles.add("org.eclipse.equinox.weaving.caching");
        this.dontWeaveTheseBundles.add("org.eclipse.equinox.weaving.caching.j9");
        this.dontWeaveTheseBundles.add("org.aspectj.runtime");
        this.dontWeaveTheseBundles.add("org.aspectj.weaver");
        this.dontWeaveTheseBundles.add("org.eclipse.equinox.simpleconfigurator");
    }

    @Override
    public void addBundle(Bundle bundle) {
        this.addSupplementedBundle(bundle);
        this.addSupplementer(bundle, true);
    }

    @Override
    public void addSupplementedBundle(Bundle bundle) {
        try {
            Dictionary dictionary = bundle.getHeaders();
            ManifestElement[] manifestElementArray = ManifestElement.parseHeader((String)"Import-Package", (String)((String)dictionary.get("Import-Package")));
            ManifestElement[] manifestElementArray2 = ManifestElement.parseHeader((String)"Export-Package", (String)((String)dictionary.get("Export-Package")));
            List<Bundle> list = this.getSupplementers(bundle.getSymbolicName(), manifestElementArray, manifestElementArray2);
            if (list.size() > 0) {
                this.addSupplementedBundle(bundle, list);
            }
            this.supplementersByBundle.put(bundle.getBundleId(), list.toArray(new Bundle[list.size()]));
        }
        catch (BundleException bundleException) {}
    }

    @Override
    public void addSupplementer(Bundle bundle, boolean bl) {
        try {
            Dictionary dictionary = bundle.getHeaders();
            ManifestElement[] manifestElementArray = ManifestElement.parseHeader((String)SUPPLEMENT_BUNDLE, (String)((String)dictionary.get(SUPPLEMENT_BUNDLE)));
            ManifestElement[] manifestElementArray2 = ManifestElement.parseHeader((String)SUPPLEMENT_IMPORTER, (String)((String)dictionary.get(SUPPLEMENT_IMPORTER)));
            ManifestElement[] manifestElementArray3 = ManifestElement.parseHeader((String)SUPPLEMENT_EXPORTER, (String)((String)dictionary.get(SUPPLEMENT_EXPORTER)));
            if (manifestElementArray != null || manifestElementArray2 != null || manifestElementArray3 != null) {
                Supplementer supplementer = new Supplementer(bundle, manifestElementArray, manifestElementArray2, manifestElementArray3);
                this.supplementers.put(bundle.getSymbolicName(), supplementer);
                if (bl) {
                    this.resupplementInstalledBundles(supplementer);
                }
            }
        }
        catch (BundleException bundleException) {}
    }

    @Override
    public PackageAdmin getPackageAdmin() {
        return this.packageAdmin;
    }

    @Override
    public Bundle[] getSupplementers(Bundle bundle) {
        return this.getSupplementers(bundle.getBundleId());
    }

    @Override
    public Bundle[] getSupplementers(long l) {
        if (this.supplementersByBundle.containsKey(l)) {
            return this.supplementersByBundle.get(l);
        }
        return new Bundle[0];
    }

    @Override
    public List<Bundle> getSupplementers(String string, ManifestElement[] manifestElementArray, ManifestElement[] manifestElementArray2) {
        List<Bundle> list = Collections.emptyList();
        if (this.supplementers.size() > 0 && !this.dontWeaveTheseBundles.contains(string)) {
            list = new LinkedList<Bundle>();
            for (Supplementer supplementer : this.supplementers.values()) {
                if (!this.isSupplementerMatching(string, manifestElementArray, manifestElementArray2, supplementer)) continue;
                list.add(supplementer.getSupplementerBundle());
            }
        }
        return list;
    }

    @Override
    public void refreshBundles(Bundle[] bundleArray) {
        if (this.packageAdmin != null) {
            this.packageAdmin.refreshPackages(bundleArray);
        }
    }

    @Override
    public void removeBundle(Bundle bundle) {
        this.removeSupplementedBundle(bundle);
        this.supplementersByBundle.remove(bundle.getBundleId());
        if (this.supplementers.containsKey(bundle.getSymbolicName())) {
            Bundle[] bundleArray;
            Supplementer supplementer = this.supplementers.get(bundle.getSymbolicName());
            this.supplementers.remove(bundle.getSymbolicName());
            if (AbstractAspectJHook.verbose) {
                System.err.println("[org.eclipse.equinox.weaving.hook] info removing supplementer " + bundle.getSymbolicName());
            }
            if ((bundleArray = supplementer.getSupplementedBundles()) != null && bundleArray.length > 0) {
                this.refreshBundles(bundleArray);
            }
            for (Long l : this.supplementersByBundle.keySet()) {
                ArrayList arrayList = new ArrayList(Arrays.asList(this.supplementersByBundle.get(l)));
                if (!arrayList.contains(bundle)) continue;
                arrayList.remove(bundle);
                this.supplementersByBundle.put(l, arrayList.toArray(new Bundle[0]));
            }
        }
    }

    @Override
    public void setBundleContext(BundleContext bundleContext) {
        this.context = bundleContext;
    }

    @Override
    public void setPackageAdmin(PackageAdmin packageAdmin) {
        this.packageAdmin = packageAdmin;
    }

    private void addSupplementedBundle(Bundle bundle, List<Bundle> list) {
        Iterator<Bundle> iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = iterator.next().getSymbolicName();
            if (!this.supplementers.containsKey(string)) continue;
            Supplementer supplementer = this.supplementers.get(string);
            supplementer.addSupplementedBundle(bundle);
        }
    }

    private boolean isSupplementerMatching(String string, ManifestElement[] manifestElementArray, ManifestElement[] manifestElementArray2, Supplementer supplementer) {
        String string2 = supplementer.getSymbolicName();
        return !string2.equals(string) && (supplementer.matchSupplementer(string) || manifestElementArray != null && supplementer.matchesSupplementImporter(manifestElementArray) || manifestElementArray2 != null && supplementer.matchesSupplementExporter(manifestElementArray2));
    }

    private void removeSupplementedBundle(Bundle bundle) {
        for (Supplementer supplementer : this.supplementers.values()) {
            supplementer.removeSupplementedBundle(bundle);
        }
    }

    private void resupplementInstalledBundles(Supplementer supplementer) {
        Bundle[] bundleArray = this.context.getBundles();
        ArrayList<Bundle> arrayList = new ArrayList<Bundle>();
        int n = 0;
        while (n < bundleArray.length) {
            try {
                Bundle bundle = bundleArray[n];
                if (!bundle.getSymbolicName().equals(supplementer.getSymbolicName()) && !this.dontWeaveTheseBundles.contains(bundle.getSymbolicName())) {
                    Dictionary dictionary = bundle.getHeaders();
                    ManifestElement[] manifestElementArray = ManifestElement.parseHeader((String)"Import-Package", (String)((String)dictionary.get("Import-Package")));
                    ManifestElement[] manifestElementArray2 = ManifestElement.parseHeader((String)"Export-Package", (String)((String)dictionary.get("Export-Package")));
                    if (this.isSupplementerMatching(bundle.getSymbolicName(), manifestElementArray, manifestElementArray2, supplementer)) {
                        if (this.adaptorProvider.getAdaptor(bundle.getBundleId()) != null) {
                            arrayList.add(bundle);
                        } else {
                            supplementer.addSupplementedBundle(bundle);
                            Bundle[] bundleArray2 = this.supplementersByBundle.get(bundle.getBundleId());
                            ArrayList<Object> arrayList2 = null;
                            arrayList2 = bundleArray2 != null ? new ArrayList(Arrays.asList(bundleArray2)) : new ArrayList<Bundle>();
                            if (!arrayList2.contains(supplementer.getSupplementerBundle())) {
                                arrayList2.add(supplementer.getSupplementerBundle());
                            }
                            this.supplementersByBundle.put(bundle.getBundleId(), arrayList2.toArray(new Bundle[0]));
                        }
                    }
                }
            }
            catch (BundleException bundleException) {
                bundleException.printStackTrace();
            }
            ++n;
        }
        if (arrayList.size() > 0) {
            Bundle[] bundleArray3 = arrayList.toArray(new Bundle[arrayList.size()]);
            if (AbstractAspectJHook.verbose) {
                int n2 = 0;
                while (n2 < bundleArray3.length) {
                    System.out.println("refresh bundle: " + bundleArray3[n2].getSymbolicName());
                    ++n2;
                }
            }
            this.refreshBundles(bundleArray3);
        }
    }
}

