/*******************************************************************************
 * Copyright (c) 2000, 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.update.search;

import org.eclipse.update.core.*;

/**
 * Search results are collected by implementing this interface
 * and passing it to the search request. If the implementation is
 * visual, it is recommended that the match is shown as soon
 * as it is collected (rather than kept in a list and presented
 * at the end of the search).
  * <p>
 * <b>Note:</b> This class/interface is part of an interim API that is still under development and expected to
 * change significantly before reaching stability. It is being made available at this early stage to solicit feedback
 * from pioneering adopters on the understanding that any code that uses this API will almost certainly be broken
 * (repeatedly) as the API evolves.
 * </p>
 * @since 3.0
 */
public interface IUpdateSearchResultCollector {
/**
 * Called when a matching feature has been found during
 * the search.
 * @param match the matching feature
 */
   void accept(IFeature match);
}
