/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.ui;

import org.eclipse.jdt.internal.junit.model.TestElement;
import org.eclipse.jdt.internal.junit.ui.CompareResultDialog;
import org.eclipse.jdt.internal.junit.ui.FailureTrace;
import org.eclipse.jdt.internal.junit.ui.JUnitMessages;
import org.eclipse.jdt.internal.junit.ui.JUnitPlugin;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;

public class CompareResultsAction
extends Action {
    private FailureTrace fView;
    private CompareResultDialog fOpenDialog;

    public CompareResultsAction(FailureTrace view) {
        super(JUnitMessages.CompareResultsAction_label);
        this.setDescription(JUnitMessages.CompareResultsAction_description);
        this.setToolTipText(JUnitMessages.CompareResultsAction_tooltip);
        this.setDisabledImageDescriptor(JUnitPlugin.getImageDescriptor("dlcl16/compare.gif"));
        this.setHoverImageDescriptor(JUnitPlugin.getImageDescriptor("elcl16/compare.gif"));
        this.setImageDescriptor(JUnitPlugin.getImageDescriptor("elcl16/compare.gif"));
        this.fView = view;
    }

    public void run() {
        TestElement failedTest = this.fView.getFailedTest();
        if (this.fOpenDialog != null) {
            this.fOpenDialog.setInput(failedTest);
            this.fOpenDialog.getShell().setActive();
        } else {
            this.fOpenDialog = new CompareResultDialog(this.fView.getShell(), failedTest);
            this.fOpenDialog.create();
            this.fOpenDialog.getShell().addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    CompareResultsAction.this.fOpenDialog = null;
                }
            });
            this.fOpenDialog.setBlockOnOpen(false);
            this.fOpenDialog.open();
        }
    }

    public void updateOpenDialog(TestElement failedTest) {
        if (this.fOpenDialog != null) {
            this.fOpenDialog.setInput(failedTest);
        }
    }
}

