/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.rmi.Naming;
import java.rmi.RMISecurityManager;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.HitCollector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Searchable;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.search.Weight;

public class RemoteSearchable
extends UnicastRemoteObject
implements Searchable {
    private Searchable local;

    public RemoteSearchable(Searchable local) throws RemoteException {
        this.local = local;
    }

    public void search(Query query, Filter filter, HitCollector results) throws IOException {
        this.local.search(query, filter, results);
    }

    public void search(Weight weight, Filter filter, HitCollector results) throws IOException {
        this.local.search(weight, filter, results);
    }

    public void close() throws IOException {
        this.local.close();
    }

    public int docFreq(Term term) throws IOException {
        return this.local.docFreq(term);
    }

    public int[] docFreqs(Term[] terms) throws IOException {
        return this.local.docFreqs(terms);
    }

    public int maxDoc() throws IOException {
        return this.local.maxDoc();
    }

    public TopDocs search(Query query, Filter filter, int n) throws IOException {
        return this.local.search(query, filter, n);
    }

    public TopDocs search(Weight weight, Filter filter, int n) throws IOException {
        return this.local.search(weight, filter, n);
    }

    public TopFieldDocs search(Query query, Filter filter, int n, Sort sort) throws IOException {
        return this.local.search(query, filter, n, sort);
    }

    public TopFieldDocs search(Weight weight, Filter filter, int n, Sort sort) throws IOException {
        return this.local.search(weight, filter, n, sort);
    }

    public Document doc(int i) throws IOException {
        return this.local.doc(i);
    }

    public Query rewrite(Query original) throws IOException {
        return this.local.rewrite(original);
    }

    public Explanation explain(Query query, int doc) throws IOException {
        return this.local.explain(query, doc);
    }

    public Explanation explain(Weight weight, int doc) throws IOException {
        return this.local.explain(weight, doc);
    }

    public static void main(String[] args) throws Exception {
        String indexName = null;
        if (args != null && args.length == 1) {
            indexName = args[0];
        }
        if (indexName == null) {
            System.out.println("Usage: org.apache.lucene.search.RemoteSearchable <index>");
            return;
        }
        if (System.getSecurityManager() == null) {
            System.setSecurityManager(new RMISecurityManager());
        }
        IndexSearcher local = new IndexSearcher(indexName);
        RemoteSearchable impl = new RemoteSearchable(local);
        Naming.rebind("//localhost/Searchable", impl);
    }
}

