/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.iks.r_osgi.impl;

import ch.ethz.iks.r_osgi.impl.CodeAnalyzer;
import ch.ethz.iks.r_osgi.impl.RemoteOSGiActivator;
import ch.ethz.iks.r_osgi.impl.RemoteOSGiServiceImpl;
import ch.ethz.iks.r_osgi.messages.DeliverServiceMessage;
import java.lang.reflect.Method;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import org.objectweb.asm.Type;
import org.osgi.framework.ServiceReference;

final class RemoteServiceRegistration {
    private final ServiceReference reference;
    private final long serviceID;
    private final String[] interfaceNames;
    private final Object serviceObject;
    private final HashMap methodTable;
    private DeliverServiceMessage deliverServiceMessage;

    RemoteServiceRegistration(ServiceReference ref, ServiceReference service) throws ClassNotFoundException {
        block5: {
            this.methodTable = new HashMap(0);
            this.reference = service;
            this.serviceID = (Long)service.getProperty("service.id");
            this.interfaceNames = (String[])service.getProperty("objectClass");
            this.serviceObject = RemoteOSGiActivator.context.getService(service);
            if (this.serviceObject == null) {
                throw new IllegalStateException("Service is not present.");
            }
            ClassLoader bundleLoader = this.serviceObject.getClass().getClassLoader();
            String[] interfaceNames = (String[])service.getProperty("objectClass");
            int interfaceCount = interfaceNames.length;
            Class[] serviceInterfaces = new Class[interfaceCount];
            int i = 0;
            while (i < interfaceCount) {
                serviceInterfaces[i] = bundleLoader.loadClass(interfaceNames[i]);
                Method[] methods = serviceInterfaces[i].getMethods();
                int j = 0;
                while (j < methods.length) {
                    this.methodTable.put(String.valueOf(methods[j].getName()) + Type.getMethodDescriptor((Method)methods[j]), methods[j]);
                    ++j;
                }
                ++i;
            }
            Dictionary headers = service.getBundle().getHeaders();
            CodeAnalyzer analyzer = new CodeAnalyzer(bundleLoader, (String)headers.get("Import-Package"), (String)headers.get("Export-Package"));
            try {
                this.deliverServiceMessage = analyzer.analyze(interfaceNames, (String)ref.getProperty("service.remote.smartproxy"), (String[])ref.getProperty("service.remote.injections"), (String)ref.getProperty("service.presentation"));
                this.deliverServiceMessage.setServiceID(((Long)ref.getProperty("service.id")).toString());
            }
            catch (Exception e) {
                if (RemoteOSGiServiceImpl.log == null) break block5;
                RemoteOSGiServiceImpl.log.log(1, "Error during remote service registration", (Throwable)e);
            }
        }
    }

    long getServiceID() {
        return this.serviceID;
    }

    ServiceReference getReference() {
        return this.reference;
    }

    Dictionary getProperties() {
        String[] keys = this.reference.getPropertyKeys();
        Hashtable<String, Object> props = new Hashtable<String, Object>(keys.length);
        int i = 0;
        while (i < keys.length) {
            ((Dictionary)props).put(keys[i], this.reference.getProperty(keys[i]));
            ++i;
        }
        return props;
    }

    String[] getInterfaceNames() {
        return this.interfaceNames;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ServiceReference) {
            ServiceReference ref = (ServiceReference)obj;
            return ref.equals(this.reference);
        }
        if (obj instanceof RemoteServiceRegistration) {
            return ((RemoteServiceRegistration)obj).equals(this.reference);
        }
        return false;
    }

    public int hashCode() {
        return (int)(this.serviceID ^ this.serviceID >>> 32);
    }

    Object getServiceObject() {
        return this.serviceObject;
    }

    Method getMethod(String signature) {
        return (Method)this.methodTable.get(signature);
    }

    DeliverServiceMessage getDeliverServiceMessage() {
        return this.deliverServiceMessage;
    }

    public String toString() {
        return "RemoteServiceRegistration{" + this.reference.toString() + "}";
    }
}

