/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.carbon.CGRect;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.widgets.Caret;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.IME;
import org.eclipse.swt.widgets.Shell;

public class Canvas
extends Composite {
    Caret caret;
    IME ime;

    Canvas() {
    }

    public Canvas(Composite parent, int style) {
        super(parent, style);
    }

    public void drawBackground(GC gc, int x, int y, int width, int height) {
        Control control;
        this.checkWidget();
        if (gc == null) {
            this.error(4);
        }
        if (gc.isDisposed()) {
            this.error(5);
        }
        if ((control = this.findBackgroundControl()) != null) {
            control.fillBackground(this.handle, gc.handle, new Rectangle(x, y, width, height));
        } else {
            gc.fillRectangle(x, y, width, height);
        }
    }

    void drawWidget(int control, int context, int damageRgn, int visibleRgn, int theEvent) {
        super.drawWidget(control, context, damageRgn, visibleRgn, theEvent);
        if (OS.VERSION >= 4160) {
            if (control != this.handle) {
                return;
            }
            if (this.caret == null) {
                return;
            }
            if (this.caret.isShowing) {
                OS.CGContextSaveGState(context);
                CGRect rect = new CGRect();
                rect.x = this.caret.x;
                rect.y = this.caret.y;
                Image image = this.caret.image;
                OS.CGContextSetBlendMode(context, 10);
                if (image != null) {
                    rect.width = OS.CGImageGetWidth(image.handle);
                    rect.height = OS.CGImageGetHeight(image.handle);
                    OS.CGContextScaleCTM(context, 1.0f, -1.0f);
                    OS.CGContextTranslateCTM(context, 0.0f, -(rect.height + 2.0f * rect.y));
                    OS.CGContextDrawImage(context, rect, image.handle);
                } else {
                    rect.width = this.caret.width != 0 ? this.caret.width : 1;
                    rect.height = this.caret.height;
                    OS.CGContextSetShouldAntialias(context, false);
                    int colorspace = OS.CGColorSpaceCreateDeviceRGB();
                    OS.CGContextSetFillColorSpace(context, colorspace);
                    OS.CGContextSetFillColor(context, new float[]{1.0f, 1.0f, 1.0f, 1.0f});
                    OS.CGColorSpaceRelease(colorspace);
                    OS.CGContextFillRect(context, rect);
                }
                OS.CGContextRestoreGState(context);
            }
        }
    }

    public Caret getCaret() {
        this.checkWidget();
        return this.caret;
    }

    public IME getIME() {
        this.checkWidget();
        return this.ime;
    }

    int kEventControlDraw(int nextHandler, int theEvent, int userData) {
        boolean isFocus;
        int[] theControl = new int[1];
        OS.GetEventParameter(theEvent, 0x2D2D2D2D, 1668575852, null, 4, null, theControl);
        boolean bl = isFocus = OS.VERSION < 4160 && theControl[0] == this.handle && this.caret != null && this.caret.isFocusCaret();
        if (isFocus) {
            this.caret.killFocus();
        }
        int result = super.kEventControlDraw(nextHandler, theEvent, userData);
        if (isFocus) {
            this.caret.setFocus();
        }
        return result;
    }

    int kEventControlSetFocusPart(int nextHandler, int theEvent, int userData) {
        int result = super.kEventControlSetFocusPart(nextHandler, theEvent, userData);
        if (result == 0 && !this.isDisposed()) {
            Shell shell = this.getShell();
            short[] part = new short[1];
            OS.GetEventParameter(theEvent, 1668313716, 1668313716, null, 2, null, part);
            if (part[0] != 0) {
                if (this.caret != null) {
                    this.caret.setFocus();
                }
                OS.ActivateTSMDocument(shell.imHandle);
            } else {
                if (this.caret != null) {
                    this.caret.killFocus();
                }
                OS.DeactivateTSMDocument(shell.imHandle);
            }
        }
        return result;
    }

    int kEventTextInputOffsetToPos(int nextHandler, int theEvent, int userData) {
        int result;
        if (this.ime != null && (result = this.ime.kEventTextInputOffsetToPos(nextHandler, theEvent, userData)) != -9874) {
            return result;
        }
        return super.kEventTextInputOffsetToPos(nextHandler, theEvent, userData);
    }

    int kEventTextInputPosToOffset(int nextHandler, int theEvent, int userData) {
        int result;
        if (this.ime != null && (result = this.ime.kEventTextInputPosToOffset(nextHandler, theEvent, userData)) != -9874) {
            return result;
        }
        return super.kEventTextInputPosToOffset(nextHandler, theEvent, userData);
    }

    int kEventTextInputUnicodeForKeyEvent(int nextHandler, int theEvent, int userData) {
        int result = super.kEventTextInputUnicodeForKeyEvent(nextHandler, theEvent, userData);
        if (result != 0 && this.caret != null) {
            OS.CGDisplayHideCursor(OS.CGMainDisplayID());
        }
        return result;
    }

    int kEventTextInputUpdateActiveInputArea(int nextHandler, int theEvent, int userData) {
        int result;
        if (this.ime != null && (result = this.ime.kEventTextInputUpdateActiveInputArea(nextHandler, theEvent, userData)) != -9874) {
            return result;
        }
        return super.kEventTextInputUpdateActiveInputArea(nextHandler, theEvent, userData);
    }

    int kEventTextInputGetSelectedText(int nextHandler, int theEvent, int userData) {
        int result;
        if (this.ime != null && (result = this.ime.kEventTextInputGetSelectedText(nextHandler, theEvent, userData)) != -9874) {
            return result;
        }
        return super.kEventTextInputGetSelectedText(nextHandler, theEvent, userData);
    }

    void redrawWidget(int control, boolean children) {
        boolean isFocus;
        boolean bl = isFocus = OS.VERSION < 4160 && this.caret != null && this.caret.isFocusCaret();
        if (isFocus) {
            this.caret.killFocus();
        }
        super.redrawWidget(control, children);
        if (isFocus) {
            this.caret.setFocus();
        }
    }

    void redrawWidget(int control, int x, int y, int width, int height, boolean all) {
        boolean isFocus;
        boolean bl = isFocus = OS.VERSION < 4160 && this.caret != null && this.caret.isFocusCaret();
        if (isFocus) {
            this.caret.killFocus();
        }
        super.redrawWidget(control, x, y, width, height, all);
        if (isFocus) {
            this.caret.setFocus();
        }
    }

    void releaseChildren(boolean destroy) {
        if (this.caret != null) {
            this.caret.release(false);
            this.caret = null;
        }
        if (this.ime != null) {
            this.ime.release(false);
            this.ime = null;
        }
        super.releaseChildren(destroy);
    }

    public void scroll(int destX, int destY, int x, int y, int width, int height, boolean all) {
        Control control;
        Rectangle clientRect;
        Rectangle sourceRect;
        boolean isFocus;
        this.checkWidget();
        if (width <= 0 || height <= 0) {
            return;
        }
        int deltaX = destX - x;
        int deltaY = destY - y;
        if (deltaX == 0 && deltaY == 0) {
            return;
        }
        if (!this.isDrawing(this.handle)) {
            return;
        }
        boolean bl = isFocus = this.caret != null && this.caret.isFocusCaret();
        if (isFocus) {
            this.caret.killFocus();
        }
        if ((sourceRect = new Rectangle(x, y, width, height)).intersects(clientRect = this.getClientArea())) {
            this.update(all);
        }
        if ((control = this.findBackgroundControl()) != null && control.backgroundImage != null) {
            this.redrawWidget(this.handle, x, y, width, height, false);
            this.redrawWidget(this.handle, destX, destY, width, height, false);
        } else {
            GC gc = new GC(this);
            gc.copyArea(x, y, width, height, destX, destY);
            gc.dispose();
        }
        if (all) {
            Control[] children = this._getChildren();
            int i = 0;
            while (i < children.length) {
                Control child = children[i];
                Rectangle rect = child.getBounds();
                if (Math.min(x + width, rect.x + rect.width) >= Math.max(x, rect.x) && Math.min(y + height, rect.y + rect.height) >= Math.max(y, rect.y)) {
                    child.setLocation(rect.x + deltaX, rect.y + deltaY);
                }
                ++i;
            }
        }
        if (isFocus) {
            this.caret.setFocus();
        }
    }

    public void setCaret(Caret caret) {
        this.checkWidget();
        Caret newCaret = caret;
        Caret oldCaret = this.caret;
        this.caret = newCaret;
        if (this.hasFocus()) {
            if (oldCaret != null) {
                oldCaret.killFocus();
            }
            if (newCaret != null) {
                if (newCaret.isDisposed()) {
                    this.error(5);
                }
                newCaret.setFocus();
            }
        }
    }

    public void setFont(Font font) {
        this.checkWidget();
        if (this.caret != null) {
            this.caret.setFont(font);
        }
        super.setFont(font);
    }

    public void setIME(IME ime) {
        this.checkWidget();
        if (ime != null && ime.isDisposed()) {
            this.error(5);
        }
        this.ime = ime;
    }
}

