/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.jres;

import java.io.File;
import java.net.URL;
import java.util.Iterator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.debug.ui.launchConfigurations.AbstractVMInstallPage;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.SWTFactory;
import org.eclipse.jdt.internal.debug.ui.jres.JREMessages;
import org.eclipse.jdt.internal.debug.ui.jres.LibraryContentProvider;
import org.eclipse.jdt.internal.debug.ui.jres.LibraryLabelProvider;
import org.eclipse.jdt.internal.debug.ui.jres.LibraryStandin;
import org.eclipse.jdt.internal.launching.EEVMType;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.LibraryLocation;
import org.eclipse.jdt.launching.VMStandin;
import org.eclipse.jdt.ui.wizards.BuildPathDialogAccess;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public class VMLibraryBlock
extends AbstractVMInstallPage
implements SelectionListener,
ISelectionChangedListener {
    protected static final String LAST_PATH_SETTING = "LAST_PATH_SETTING";
    protected static final String DIALOG_SETTINGS_PREFIX = "VMLibraryBlock";
    protected boolean fInCallback = false;
    protected VMStandin fVmInstall;
    protected LibraryContentProvider fLibraryContentProvider;
    protected TreeViewer fLibraryViewer;
    private Button fUpButton;
    private Button fDownButton;
    private Button fRemoveButton;
    private Button fAddButton;
    private Button fJavadocButton;
    private Button fSourceButton;
    protected Button fDefaultButton;
    private IStatus[] fLibStatus = new IStatus[]{Status.OK_STATUS};

    VMLibraryBlock() {
        super(JREMessages.VMLibraryBlock_2);
    }

    public void createControl(Composite parent) {
        Font font = parent.getFont();
        Composite comp = SWTFactory.createComposite(parent, font, 2, 1, 1808, 0, 0);
        this.fLibraryViewer = new TreeViewer(comp);
        GridData gd = new GridData(1808);
        gd.heightHint = 6;
        this.fLibraryViewer.getControl().setLayoutData((Object)gd);
        this.fLibraryContentProvider = new LibraryContentProvider();
        this.fLibraryViewer.setContentProvider((IContentProvider)this.fLibraryContentProvider);
        this.fLibraryViewer.setLabelProvider((IBaseLabelProvider)new LibraryLabelProvider());
        this.fLibraryViewer.setInput((Object)this);
        this.fLibraryViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        Composite pathButtonComp = SWTFactory.createComposite(comp, font, 1, 1, 258, 0, 0);
        this.fAddButton = SWTFactory.createPushButton(pathButtonComp, JREMessages.VMLibraryBlock_7, JREMessages.VMLibraryBlock_16, null);
        this.fAddButton.addSelectionListener((SelectionListener)this);
        this.fJavadocButton = SWTFactory.createPushButton(pathButtonComp, JREMessages.VMLibraryBlock_3, JREMessages.VMLibraryBlock_17, null);
        this.fJavadocButton.setEnabled(false);
        this.fJavadocButton.addSelectionListener((SelectionListener)this);
        this.fSourceButton = SWTFactory.createPushButton(pathButtonComp, JREMessages.VMLibraryBlock_11, JREMessages.VMLibraryBlock_18, null);
        this.fSourceButton.setEnabled(false);
        this.fSourceButton.addSelectionListener((SelectionListener)this);
        this.fLibraryViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection sel = (IStructuredSelection)event.getViewer().getSelection();
                Object obj = sel.getFirstElement();
                if (obj instanceof LibraryContentProvider.SubElement) {
                    VMLibraryBlock.this.edit(sel, ((LibraryContentProvider.SubElement)obj).getType());
                }
            }
        });
        this.fRemoveButton = SWTFactory.createPushButton(pathButtonComp, JREMessages.VMLibraryBlock_6, JREMessages.VMLibraryBlock_12, null);
        this.fRemoveButton.setEnabled(false);
        this.fRemoveButton.addSelectionListener((SelectionListener)this);
        this.fUpButton = SWTFactory.createPushButton(pathButtonComp, JREMessages.VMLibraryBlock_4, JREMessages.VMLibraryBlock_13, null);
        this.fUpButton.setEnabled(false);
        this.fUpButton.addSelectionListener((SelectionListener)this);
        this.fDownButton = SWTFactory.createPushButton(pathButtonComp, JREMessages.VMLibraryBlock_5, JREMessages.VMLibraryBlock_14, null);
        this.fDownButton.setEnabled(false);
        this.fDownButton.addSelectionListener((SelectionListener)this);
        this.fDefaultButton = SWTFactory.createPushButton(pathButtonComp, JREMessages.VMLibraryBlock_9, JREMessages.VMLibraryBlock_15, null);
        this.fDefaultButton.addSelectionListener((SelectionListener)this);
        this.setControl((Control)comp);
    }

    private void restoreDefaultLibraries() {
        LibraryLocation[] libs = null;
        File installLocation = null;
        if (this.fVmInstall != null) {
            File definitionFile;
            libs = "org.eclipse.jdt.launching.EEVMType".equals(this.fVmInstall.getVMInstallType().getId()) ? ((definitionFile = EEVMType.getDefinitionFile((IVMInstall)this.fVmInstall)) != null ? EEVMType.getLibraryLocations((File)definitionFile) : new LibraryLocation[]{}) : ((installLocation = this.fVmInstall.getInstallLocation()) == null ? new LibraryLocation[]{} : this.fVmInstall.getVMInstallType().getDefaultLibraryLocations(installLocation));
        }
        this.fLibraryContentProvider.setLibraries(libs);
        this.update();
    }

    private void update() {
        this.updateButtons();
        IStatus status = Status.OK_STATUS;
        if (this.fLibraryContentProvider.getLibraries().length == 0) {
            status = new Status(4, JDIDebugUIPlugin.getUniqueIdentifier(), 150, "Libraries cannot be empty.", null);
        }
        LibraryStandin[] standins = this.fLibraryContentProvider.getStandins();
        int i = 0;
        while (i < standins.length) {
            IStatus st = standins[i].validate();
            if (!st.isOK()) {
                status = st;
                break;
            }
            ++i;
        }
        this.fLibStatus[0] = status;
        if (status.isOK()) {
            this.setErrorMessage(null);
            this.setPageComplete(true);
        } else {
            this.setErrorMessage(status.getMessage());
            this.setPageComplete(false);
        }
        if (this.getContainer().getCurrentPage() != this) {
            this.getContainer().updateMessage();
            this.getContainer().updateButtons();
        }
    }

    protected boolean isDefaultLocations(IVMInstall vm) {
        LibraryLocation[] def;
        LibraryLocation[] libraryLocations = this.fLibraryContentProvider.getLibraries();
        if (vm == null || libraryLocations == null) {
            return true;
        }
        File installLocation = vm.getInstallLocation();
        if (installLocation != null && (def = vm.getVMInstallType().getDefaultLibraryLocations(installLocation)).length == libraryLocations.length) {
            int i = 0;
            while (i < def.length) {
                if (!def[i].equals((Object)libraryLocations[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public void widgetSelected(SelectionEvent e) {
        Object source = e.getSource();
        if (source == this.fUpButton) {
            this.fLibraryContentProvider.up((IStructuredSelection)this.fLibraryViewer.getSelection());
        } else if (source == this.fDownButton) {
            this.fLibraryContentProvider.down((IStructuredSelection)this.fLibraryViewer.getSelection());
        } else if (source == this.fRemoveButton) {
            this.fLibraryContentProvider.remove((IStructuredSelection)this.fLibraryViewer.getSelection());
        } else if (source == this.fAddButton) {
            this.add((IStructuredSelection)this.fLibraryViewer.getSelection());
        } else if (source == this.fJavadocButton) {
            this.edit((IStructuredSelection)this.fLibraryViewer.getSelection(), 1);
        } else if (source == this.fSourceButton) {
            this.edit((IStructuredSelection)this.fLibraryViewer.getSelection(), 2);
        } else if (source == this.fDefaultButton) {
            this.restoreDefaultLibraries();
        }
        this.update();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    private void add(IStructuredSelection selection) {
        IDialogSettings dialogSettings = JDIDebugUIPlugin.getDefault().getDialogSettings();
        String lastUsedPath = dialogSettings.get(LAST_PATH_SETTING);
        if (lastUsedPath == null) {
            lastUsedPath = "";
        }
        FileDialog dialog = new FileDialog(this.fLibraryViewer.getControl().getShell(), 2);
        dialog.setText(JREMessages.VMLibraryBlock_10);
        dialog.setFilterExtensions(new String[]{"*.jar;*.zip", "*.*"});
        dialog.setFilterPath(lastUsedPath);
        String res = dialog.open();
        if (res == null) {
            return;
        }
        String[] fileNames = dialog.getFileNames();
        int nChosen = fileNames.length;
        Path filterPath = new Path(dialog.getFilterPath());
        LibraryLocation[] libs = new LibraryLocation[nChosen];
        int i = 0;
        while (i < nChosen) {
            libs[i] = new LibraryLocation(filterPath.append(fileNames[i]).makeAbsolute(), (IPath)Path.EMPTY, (IPath)Path.EMPTY);
            ++i;
        }
        dialogSettings.put(LAST_PATH_SETTING, filterPath.toOSString());
        this.fLibraryContentProvider.add(libs, selection);
    }

    private void edit(IStructuredSelection selection, int type) {
        Object obj = selection.getFirstElement();
        LibraryStandin standin = null;
        if (obj instanceof LibraryStandin) {
            standin = (LibraryStandin)obj;
        } else if (obj instanceof LibraryContentProvider.SubElement) {
            LibraryContentProvider.SubElement sub = (LibraryContentProvider.SubElement)obj;
            standin = sub.getParent();
        }
        if (standin != null) {
            LibraryLocation library = standin.toLibraryLocation();
            if (type == 1) {
                URL[] urls = BuildPathDialogAccess.configureJavadocLocation((Shell)this.fLibraryViewer.getControl().getShell(), (String)library.getSystemLibraryPath().toOSString(), (URL)library.getJavadocLocation());
                if (urls != null) {
                    this.fLibraryContentProvider.setJavadoc(urls[0], selection);
                }
            } else if (type == 2) {
                IRuntimeClasspathEntry entry = JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)library.getSystemLibraryPath());
                entry.setSourceAttachmentPath(library.getSystemLibrarySourcePath());
                entry.setSourceAttachmentRootPath(library.getPackageRootPath());
                IClasspathEntry classpathEntry = BuildPathDialogAccess.configureSourceAttachment((Shell)this.fLibraryViewer.getControl().getShell(), (IClasspathEntry)entry.getClasspathEntry());
                if (classpathEntry != null) {
                    this.fLibraryContentProvider.setSourcePath(classpathEntry.getSourceAttachmentPath(), classpathEntry.getSourceAttachmentRootPath(), selection);
                }
            }
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.updateButtons();
    }

    private void updateButtons() {
        IStructuredSelection selection = (IStructuredSelection)this.fLibraryViewer.getSelection();
        this.fRemoveButton.setEnabled(!selection.isEmpty());
        boolean enableUp = true;
        boolean enableDown = true;
        boolean allSource = true;
        boolean allJavadoc = true;
        boolean allRoots = true;
        Object[] libraries = this.fLibraryContentProvider.getElements(null);
        if (selection.isEmpty() || libraries.length == 0) {
            enableUp = false;
            enableDown = false;
        } else {
            Object first = libraries[0];
            Object last = libraries[libraries.length - 1];
            Iterator iter = selection.iterator();
            while (iter.hasNext()) {
                Object lib;
                Object element = iter.next();
                if (element instanceof LibraryContentProvider.SubElement) {
                    allRoots = false;
                    LibraryContentProvider.SubElement subElement = (LibraryContentProvider.SubElement)element;
                    lib = subElement.getParent().toLibraryLocation();
                    if (subElement.getType() == 1) {
                        allSource = false;
                    } else {
                        allJavadoc = false;
                    }
                } else {
                    lib = element;
                    allSource = false;
                    allJavadoc = false;
                }
                if (lib == first) {
                    enableUp = false;
                }
                if (lib != last) continue;
                enableDown = false;
            }
        }
        this.fUpButton.setEnabled(enableUp);
        this.fDownButton.setEnabled(enableDown);
        this.fJavadocButton.setEnabled(!selection.isEmpty() && (allJavadoc || allRoots));
        this.fSourceButton.setEnabled(!selection.isEmpty() && (allSource || allRoots));
    }

    public boolean finish() {
        if (this.fVmInstall != null) {
            if (this.isDefaultLocations((IVMInstall)this.fVmInstall)) {
                this.fVmInstall.setLibraryLocations(null);
            } else {
                LibraryLocation[] libs = this.fLibraryContentProvider.getLibraries();
                this.fVmInstall.setLibraryLocations(libs);
            }
        }
        return true;
    }

    public VMStandin getSelection() {
        return this.fVmInstall;
    }

    public void setSelection(VMStandin vm) {
        super.setSelection(vm);
        LibraryLocation[] libraryLocations = null;
        libraryLocations = vm == null ? new LibraryLocation[]{} : JavaRuntime.getLibraryLocations((IVMInstall)vm);
        this.fVmInstall = vm;
        this.fLibraryContentProvider.setLibraries(libraryLocations);
    }

    protected IStatus[] getVMStatus() {
        return this.fLibStatus;
    }
}

