/*
 * Decompiled with CFR 0.152.
 */
package fr.esrf.TacoApi;

import fr.esrf.TacoApi.NethostConnection;
import fr.esrf.TacoApi.ServerConnection;
import fr.esrf.TacoApi.ServerListener;
import fr.esrf.TacoApi.TacoCommand;
import fr.esrf.TacoApi.TacoData;
import fr.esrf.TacoApi.TacoException;
import fr.esrf.TacoApi.xdr.XdrClientData;
import fr.esrf.TacoApi.xdr.XdrDCClientData;
import fr.esrf.TacoApi.xdr.XdrDCServerData;
import fr.esrf.TacoApi.xdr.XdrDevInfos;
import fr.esrf.TacoApi.xdr.XdrImportOut;
import fr.esrf.TacoApi.xdr.XdrServerData;
import fr.esrf.TacoApi.xdr.XdrVarArgument;
import fr.esrf.TacoApi.xdr.XdrVarArguments;
import java.util.HashMap;
import java.util.regex.Pattern;

public class TacoDevice
implements ServerListener {
    public static final int PROTOCOL_UDP = 0;
    public static final int PROTOCOL_TCP = 1;
    public static final int ACCESS_NO = -20;
    public static final int ACCESS_READ = -10;
    public static final int ACCESS_WRITE = 0;
    public static final int ACCESS_SI_WRITE = 10;
    public static final int ACCESS_SU_ACCESS = 20;
    public static final int ACCESS_SI_SU = 30;
    public static final int ACCESS_ADMIN = 99;
    public static final int SOURCE_DEVICE = 0;
    public static final int SOURCE_CACHE = 1;
    public static final int SOURCE_CACHE_DEVICE = 2;
    public final String apiRelease = "$Revision: 1.15.2.1 $".substring(11, 15);
    private static long dbImportTimeout = 30000L;
    private String deviceName;
    private String shortName;
    private int protocol;
    private int source;
    private HashMap commandList;
    private int timeout;
    private int access;
    private int deviceId;
    private String devType = "";
    private String devClass = "";
    private String devProcessName = "";
    private String dcType = "";
    private String dcClass = "";
    private String hostName = "";
    private int progNumber;
    private String hostDCReadName;
    private int progDCReadNumber;
    private String hostDCWriteName;
    private int progDCWriteNumber;
    private boolean firstImport;
    private long lastDevImportTime;
    private TacoException lastDevImportError;
    private long lastDcImportTime;
    private TacoException lastDcImportError;
    private ServerConnection dcHandle;
    private ServerConnection dsHandle;
    private NethostConnection nhHandle;
    private boolean noDB;

    public TacoDevice(String string, int n, int n2) throws TacoException {
        this.protocol = n;
        this.commandList = null;
        this.dsHandle = null;
        this.dcHandle = null;
        this.firstImport = true;
        this.lastDevImportTime = 0L;
        this.timeout = 3000;
        this.access = 0;
        this.devProcessName = "";
        this.lastDevImportError = null;
        this.lastDcImportError = null;
        this.source = n2;
        this.deviceName = string.startsWith("taco:") ? string.substring(5).toLowerCase() : string.toLowerCase();
        this.checkDeviceSyntax(this.deviceName);
        boolean bl = this.noDB = this.deviceName.indexOf(63) >= 0;
        if (this.noDB) {
            this.source = 0;
            int n3 = this.deviceName.indexOf(63);
            String string2 = this.deviceName.substring(n3 + 1);
            try {
                this.progNumber = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new TacoException("Invalid port number");
            }
            int n4 = this.deviceName.indexOf(47, 2);
            if (n4 < 0) {
                throw new TacoException("Wrong device name syntax");
            }
            this.shortName = this.deviceName.substring(n4 + 1, n3);
            this.hostName = this.deviceName.substring(2, n4);
        } else {
            String string3 = "";
            if (this.deviceName.startsWith("//")) {
                int n5 = this.deviceName.indexOf(47, 2);
                if (n5 < 0) {
                    throw new TacoException("Wrong device name syntax");
                }
                this.shortName = this.deviceName.substring(n5 + 1);
                string3 = this.deviceName.substring(2, n5);
            } else {
                this.shortName = this.deviceName;
            }
            this.nhHandle = NethostConnection.connectNethost(string3);
        }
    }

    public TacoDevice(String string) throws TacoException {
        this(string, 0, 0);
    }

    public TacoDevice(String string, int n) throws TacoException {
        this(string, n, 0);
    }

    public void setSecurityAccess(int n) {
        this.access = n;
    }

    public int getSecurityAccess() {
        return this.access;
    }

    public synchronized void setSource(int n) throws TacoException {
        if (this.noDB) {
            System.out.println("TacoDevice.setSource() has not effect for server without database (SOURCE_DEVICE forced)");
            return;
        }
        if (n != this.source) {
            this.source = n;
            this.free();
        }
    }

    public int getSource() {
        return this.source;
    }

    public String getName() {
        return this.deviceName;
    }

    public String getShortName() {
        return this.shortName;
    }

    public void setTimeout(int n) {
        this.timeout = n;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public synchronized void setProtocol(int n) throws TacoException {
        if (n != this.protocol) {
            this.protocol = n;
            this.free();
        }
    }

    public int getProtocol() {
        return this.protocol;
    }

    public int getCommandCode(String string) throws TacoException {
        TacoCommand[] tacoCommandArray = this.commandQuery();
        for (int i = 0; i < tacoCommandArray.length; ++i) {
            if (!tacoCommandArray[i].cmdName.equalsIgnoreCase(string)) continue;
            return tacoCommandArray[i].cmdCode;
        }
        if (this.source != 1) {
            throw new TacoException("Device command " + string + " not found for this device.");
        }
        throw new TacoException("DC command " + string + " not found for this device.");
    }

    public String getCommandString(int n) {
        if (this.noDB) {
            return "Cmd" + n;
        }
        return this.nhHandle.getCommandNames(new Integer[]{new Integer(n)})[0];
    }

    public synchronized String getInfo() {
        try {
            this.importDevice();
        }
        catch (TacoException tacoException) {
            return tacoException.getErrorString();
        }
        switch (this.source) {
            case 0: {
                if (this.noDB) {
                    return "Devname:   " + this.deviceName + "\n" + "DevType:   No database\n" + "DsName:    " + this.devProcessName + "\n" + "Host:      " + this.dsHandle.getHostName();
                }
                return "Devname:   " + this.deviceName + "\n" + "DevClass:  " + this.devClass + "\n" + "DevType:   " + this.devType + "\n" + "DsName:    " + this.devProcessName + "\n" + "Host:      " + this.dsHandle.getHostName() + "\n" + "Nethost:   " + this.nhHandle.getName();
            }
            case 2: {
                if (this.dcHandle != null) {
                    return "Devname:   " + this.deviceName + "\n" + "DevClass:  " + this.dcClass + "\n" + "DevType:   " + this.dcType + "\n" + "DsName:    " + this.devProcessName + "\n" + "Host:      " + this.dcHandle.getHostName() + "\n" + "Nethost:   " + this.nhHandle.getName();
                }
                return "Devname:   " + this.deviceName + "\n" + "DevClass:  " + this.dcClass + "\n" + "DevType:   " + this.dcType + "\n" + "DsName:    " + this.devProcessName + "\n" + "Host:      " + this.dsHandle.getHostName() + "\n" + "Nethost:   " + this.nhHandle.getName();
            }
            case 1: {
                return "Devname:   " + this.deviceName + "\n" + "DevClass:  " + this.dcClass + "\n" + "DevType:   " + this.dcType + "\n" + "DsName:    " + this.devProcessName + "\n" + "Host:      " + this.dcHandle.getHostName() + "\n" + "Nethost:   " + this.nhHandle.getName();
            }
        }
        return "No info";
    }

    public synchronized TacoCommand[] commandQuery() throws TacoException {
        this.importDevice();
        Object[] objectArray = this.commandList.values().toArray();
        TacoCommand[] tacoCommandArray = new TacoCommand[objectArray.length];
        for (int i = 0; i < this.commandList.size(); ++i) {
            tacoCommandArray[i] = (TacoCommand)objectArray[i];
        }
        return tacoCommandArray;
    }

    private TacoData devPutGet(TacoCommand tacoCommand, TacoData tacoData) throws TacoException {
        if (tacoData == null) {
            tacoData = new TacoData();
        }
        TacoData tacoData2 = new TacoData(tacoCommand.outType);
        XdrServerData xdrServerData = new XdrServerData();
        xdrServerData.dsId = this.deviceId;
        xdrServerData.cmdCode = tacoCommand.cmdCode;
        xdrServerData.arginType = tacoData.getType();
        xdrServerData.argoutType = tacoData2.getType();
        xdrServerData.argin = new XdrVarArgument(tacoData);
        xdrServerData.vArgs = new XdrVarArguments();
        xdrServerData.secAccessRight = this.access;
        xdrServerData.secClientId = 0;
        XdrClientData xdrClientData = this.dsHandle.putGet(xdrServerData, this.timeout);
        tacoData2.setXdrValue(xdrClientData.argout.vArg);
        return tacoData2;
    }

    private TacoData dcDevGet(TacoCommand tacoCommand) throws TacoException {
        TacoData tacoData = new TacoData(tacoCommand.outType);
        XdrDCServerData xdrDCServerData = new XdrDCServerData();
        xdrDCServerData.cmdCode = tacoCommand.cmdCode;
        xdrDCServerData.devName = this.shortName;
        xdrDCServerData.argoutType = tacoData.getType();
        XdrDCClientData xdrDCClientData = this.dcHandle.dcPutGet(xdrDCServerData, this.timeout);
        tacoData.setXdrValue(xdrDCClientData.argout);
        return tacoData;
    }

    public synchronized TacoData putGet(int n, TacoData tacoData) throws TacoException {
        this.importDevice();
        TacoCommand tacoCommand = (TacoCommand)this.commandList.get(new Integer(n));
        switch (this.source) {
            case 0: {
                if (tacoCommand == null) {
                    throw new TacoException("Device command not found " + n);
                }
                return this.devPutGet(tacoCommand, tacoData);
            }
            case 2: {
                if (tacoCommand == null) {
                    throw new TacoException("Device command not found " + n);
                }
                if (tacoCommand.hasCache && this.dcHandle != null) {
                    try {
                        TacoData tacoData2 = this.dcDevGet(tacoCommand);
                        return tacoData2;
                    }
                    catch (TacoException tacoException) {
                        if (this.dsHandle != null) {
                            return this.devPutGet(tacoCommand, tacoData);
                        }
                        throw tacoException;
                    }
                }
                if (this.dsHandle != null) {
                    return this.devPutGet(tacoCommand, tacoData);
                }
                throw new TacoException("Failed to execute " + tacoCommand.cmdName);
            }
            case 1: {
                if (tacoCommand == null) {
                    throw new TacoException("DC command not found " + n);
                }
                if (tacoCommand.hasCache) {
                    return this.dcDevGet(tacoCommand);
                }
                throw new TacoException("The command " + tacoCommand.cmdName + " is not polled by the DC");
            }
        }
        throw new TacoException("Wrong source parameter");
    }

    public void command(int n) throws TacoException {
        this.putGet(n, null);
    }

    public TacoData get(int n) throws TacoException {
        return this.putGet(n, null);
    }

    public void put(int n, TacoData tacoData) throws TacoException {
        this.putGet(n, tacoData);
    }

    public String[] getResource(String string) throws TacoException {
        if (this.noDB) {
            throw new TacoException("No database therefore the process cannot query it (hint: try running with database)");
        }
        String[] stringArray = new String[]{this.shortName + "/" + string.toLowerCase()};
        String string2 = this.nhHandle.dbGetResource(stringArray)[0];
        if (string2.equals("N_DEF")) {
            return new String[0];
        }
        if (string2.charAt(0) == '\u0005') {
            return this.nhHandle.extractResourceArray(string2);
        }
        return new String[]{string2};
    }

    public synchronized void free() throws TacoException {
        if (this.dsHandle != null) {
            this.dsHandle.freeDevice(this.deviceId, true, this.access, 0, this);
            this.dsHandle = null;
        }
        if (this.dcHandle != null) {
            this.dcHandle.destroy();
            this.dcHandle = null;
        }
        this.firstImport = true;
        this.lastDevImportTime = 0L;
    }

    private void dbImportDevice() throws TacoException {
        if (this.noDB) {
            return;
        }
        long l = System.currentTimeMillis();
        if (l - this.lastDevImportTime > dbImportTimeout) {
            this.lastDevImportTime = l;
            try {
                String[] stringArray = new String[]{this.shortName};
                XdrDevInfos xdrDevInfos = this.nhHandle.dbImportDevice(stringArray);
                this.devType = xdrDevInfos.value[0].devType;
                this.devClass = xdrDevInfos.value[0].devClass;
                this.hostName = xdrDevInfos.value[0].hostName;
                this.progNumber = xdrDevInfos.value[0].progNumber;
                this.lastDevImportError = null;
            }
            catch (TacoException tacoException) {
                this.lastDevImportError = tacoException;
            }
        }
        if (this.lastDevImportError != null) {
            throw this.lastDevImportError;
        }
    }

    private void dbImportDc() throws TacoException {
        long l = System.currentTimeMillis();
        if (l - this.lastDcImportTime > dbImportTimeout) {
            this.lastDcImportTime = l;
            try {
                String string = this.nhHandle.getDcServerWriteName();
                String string2 = this.nhHandle.getDcServerReadName();
                String[] stringArray = new String[]{string, string2};
                XdrDevInfos xdrDevInfos = this.nhHandle.dbImportDevice(stringArray);
                this.dcType = xdrDevInfos.value[1].devType;
                this.dcClass = xdrDevInfos.value[1].devClass;
                this.hostDCWriteName = xdrDevInfos.value[0].hostName;
                this.progDCWriteNumber = xdrDevInfos.value[0].progNumber;
                this.hostDCReadName = xdrDevInfos.value[1].hostName;
                this.progDCReadNumber = xdrDevInfos.value[1].progNumber;
                this.lastDcImportError = null;
            }
            catch (TacoException tacoException) {
                this.lastDcImportError = tacoException;
            }
        }
        if (this.lastDcImportError != null) {
            throw new TacoException("DC system import failed.\nHint: Use SOURCE_DEVICE to avoid this message\n" + this.lastDcImportError.getErrorString());
        }
    }

    private void initDc() throws TacoException {
        ServerConnection serverConnection;
        ServerConnection serverConnection2;
        try {
            serverConnection2 = ServerConnection.connectServer(this.nhHandle.getName(), this.hostDCWriteName, this.progDCWriteNumber, 1, 1, null);
        }
        catch (TacoException tacoException) {
            throw new TacoException("DC write server " + this.nhHandle.getDcServerWriteName() + " not responding");
        }
        TacoCommand[] tacoCommandArray = serverConnection2.commandQueryDC(this.shortName, this.nhHandle);
        serverConnection2.destroy();
        if (this.commandList == null) {
            this.commandList = new HashMap();
            for (int i = 0; i < tacoCommandArray.length; ++i) {
                this.commandList.put(new Integer(tacoCommandArray[i].cmdCode), tacoCommandArray[i]);
            }
        } else {
            for (int i = 0; i < tacoCommandArray.length; ++i) {
                TacoCommand tacoCommand = (TacoCommand)this.commandList.get(new Integer(tacoCommandArray[i].cmdCode));
                if (tacoCommand == null) continue;
                tacoCommand.hasCache = true;
            }
        }
        this.dcHandle = serverConnection = ServerConnection.connectServer(this.nhHandle.getName(), this.hostDCReadName, this.progDCReadNumber, 1, 1, this);
    }

    private void initDev() throws TacoException {
        TacoCommand[] tacoCommandArray;
        ServerConnection serverConnection;
        try {
            serverConnection = this.noDB ? ServerConnection.connectServer(this.hostName, this.hostName, this.progNumber, 4, this.protocol, this) : ServerConnection.connectServer(this.nhHandle.getName(), this.hostName, this.progNumber, 4, this.protocol, this);
            XdrImportOut xdrImportOut = serverConnection.importDevice(this.shortName, this.access, 0, 0);
            this.deviceId = xdrImportOut.dsId;
            this.devProcessName = xdrImportOut.serverMame;
            tacoCommandArray = serverConnection.commandQuery(this.deviceId, this.nhHandle);
        }
        catch (TacoException tacoException) {
            if (this.firstImport) {
                throw new TacoException(8);
            }
            throw tacoException;
        }
        this.commandList = new HashMap();
        for (int i = 0; i < tacoCommandArray.length; ++i) {
            this.commandList.put(new Integer(tacoCommandArray[i].cmdCode), tacoCommandArray[i]);
        }
        this.dsHandle = serverConnection;
        this.firstImport = false;
    }

    private void importDevice() throws TacoException {
        switch (this.source) {
            case 0: {
                if (this.dsHandle != null) {
                    return;
                }
                this.dbImportDevice();
                this.initDev();
                break;
            }
            case 1: {
                if (this.dcHandle != null) {
                    return;
                }
                this.dbImportDc();
                this.initDc();
                break;
            }
            case 2: {
                TacoException tacoException = null;
                if (this.dsHandle != null || this.dcHandle != null) {
                    return;
                }
                try {
                    this.dbImportDevice();
                    this.initDev();
                }
                catch (TacoException tacoException2) {
                    tacoException = tacoException2;
                }
                try {
                    this.dbImportDc();
                    this.initDc();
                }
                catch (TacoException tacoException3) {
                    // empty catch block
                }
                if (this.dsHandle != null || this.dcHandle != null) break;
                throw tacoException;
            }
        }
    }

    public synchronized void disconnectFromServer(ServerConnection serverConnection) {
        if (serverConnection == this.dsHandle) {
            this.dsHandle = null;
        }
        if (serverConnection == this.dcHandle) {
            this.dcHandle = null;
        }
    }

    private void checkDeviceSyntax(String string) throws TacoException {
        boolean bl = Pattern.matches("//[a-zA-Z_0-9]+/[a-zA-Z_0-9[-]]+/[a-zA-Z_0-9[-]]+/[a-zA-Z_0-9[-]]+", string);
        if (!bl) {
            bl = Pattern.matches("//[a-zA-Z_0-9]+\\.[a-zA-Z_0-9]+\\.[a-zA-Z_0-9]+/[a-zA-Z_0-9[-]]+/[a-zA-Z_0-9[-]]+/[a-zA-Z_0-9[-]]+", string);
        }
        if (!bl) {
            bl = Pattern.matches("//[0-9]+\\.[0-9]+\\.[0-9]+\\.[0-9]+/[a-zA-Z_0-9[-]]+/[a-zA-Z_0-9[-]]+/[a-zA-Z_0-9[-]]+", string);
        }
        if (!bl) {
            bl = Pattern.matches("[a-zA-Z_0-9[-]]+/[a-zA-Z_0-9[-]]+/[[a-zA-Z_0-9][-]]+", string);
        }
        if (!bl) {
            bl = Pattern.matches("//[a-zA-Z_0-9]+/[a-zA-Z_0-9[-]/]+\\?[0-9]+", string);
        }
        if (!bl) {
            bl = Pattern.matches("//[a-zA-Z_0-9]+\\.[a-zA-Z_0-9]+\\.[a-zA-Z_0-9]+/[a-zA-Z_0-9[-]/]+\\?[0-9]+", string);
        }
        if (!bl) {
            bl = Pattern.matches("//[0-9]+\\.[0-9]+\\.[0-9]+\\.[0-9]+/[a-zA-Z_0-9[-]/]+\\?[0-9]+", string);
        }
        if (!bl) {
            throw new TacoException("Wrong device name syntax for " + string);
        }
    }

    public static void main(String[] stringArray) {
        try {
            TacoDevice tacoDevice = new TacoDevice("//id11tmp1/linkam?12345");
            tacoDevice.setSource(2);
            tacoDevice.setProtocol(1);
            while (true) {
                long l = System.currentTimeMillis();
                try {
                    TacoData tacoData = tacoDevice.get(tacoDevice.getCommandCode("DevLinkamGetTemperature"));
                    System.out.println("Temp = " + tacoData.extractFloat());
                }
                catch (TacoException tacoException) {
                    System.out.println("TacoException: " + tacoException.getErrorString());
                }
                System.out.println("Time: " + (System.currentTimeMillis() - l) + " ms");
                try {
                    Thread.sleep(2000L);
                }
                catch (Exception exception) {}
            }
        }
        catch (TacoException tacoException) {
            System.out.println("TacoException: " + tacoException.getErrorString());
            System.out.println("\n-----------------------\n");
            tacoException.printStackTrace();
            return;
        }
    }
}

